<?php

    class UserFunctions{

        static function get_lang_code_list(){
            global $g;
            $temp = $g['db_db']->get_lang_list();
            return array_column($temp,'lang_code');
        }

        static function get_lang_list(){
            global $g;
            return $g['db_db']->get_lang_list();
        }

        static function get_texts($lang){
            global $g;
            return $g['db_db']->get_texts($lang);
        }

        public static function is_logged_in(){
            return isset($_SESSION['user']) && isset($_SESSION['user']['id']);
        }

        public static function logout(){
            if(isset($_SESSION['user'])){
                unset($_SESSION['user']);
            }
            $_SESSION = array();
            session_regenerate_id();
            session_destroy();
            session_unset();
        }

        public static function email(array $address, $subject, $content, array $attachments, $fromName){

            global $g;

            require_once GI_PATH_OTHER.'phpmailer/class.phpmailer.php';
            require_once GI_PATH_OTHER.'phpmailer/class.smtp.php';
            require_once GI_PATH_OTHER.'phpmailer/class.pop3.php';

            $mail = new \PHPMailer;
            $mail->CharSet = 'UTF-8';

            $mail->isSMTP();
            $mail->SMTPSecure = 'tls';
            $mail->Host = "smtp.elasticemail.com";
            $mail->Port = 2525;
            $mail->SMTPAuth = true;
            $mail->Username = "support@ceedback.com";
            $mail->Password = "A1EFBFB55A52998B60B2171E33C255D9B4ED";
            $mail->setFrom('support@ceedback.com', $fromName);

            if (!empty($attachments)) {
                foreach ($attachments as $att) {
                    $mail->AddAttachment($att);
                }
            }

            foreach($address as $to){
                $mail->addAddress($to);
            }

            $mail->Subject = $subject;
            $mail->Body = $content;
            $mail->msgHTML = $content;
            $mail->AltBody = $content;

            if(!$mail->send()){
                echo "Mailer Error: " . $mail->ErrorInfo;
                return false;
            }
            else{
                return true;
            }
        }

        public static function kezelheto_entitas_e($kezeloUserSn, $kezelendoEntitasNeve, $muveletElemiJog, $entitasSn) {
            return in_array(
                $entitasSn,
                \UserFunctions::kezelheto_entitasok_only_id($kezeloUserSn, $kezelendoEntitasNeve, $muveletElemiJog)
            );
        }

        public static function kezelheto_entitasok_only_id($kezeloUserSn, $kezelendoEntitasNeve, $muveletElemiJog) {
            return array_column(
                \UserFunctions::kezelheto_entitasok($kezeloUserSn, $kezelendoEntitasNeve, $muveletElemiJog),
                'id'
            );
        }

        public static function kezelheto_entitasok($kezeloUserSn, $kezelendoEntitasNeve, $muveletElemiJog, $inaktivPartnereketIs = false) {
            global $g;
            switch ($kezelendoEntitasNeve) {
                case 'felhasznalo':
                    $felhasznalok = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        $felhasznalok = $g['db_db']->admin_felhasznalok_sel();
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $felhasznalok = \UserFunctions::getUsersOfPartners($partnerekIdArray);
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $felhasznalok = \UserFunctions::getUsersOfPartners($partnerekIdArray);
                    }
                    return $felhasznalok;

                case 'partner':
                    $partnerek = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        if ($inaktivPartnereketIs) {
                            $partnerek = $g['db_db']->partnerek_sel_with_inaktiv();
                        } else {
                            $partnerek = $g['db_db']->partnerek_sel();
                        }
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                    }
                    return $partnerek;

                case 'regio':
                    $regiok = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        $regiok = $g['db_db']->admin_regiok_sel();
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $regiok = \UserFunctions::getRegiokOfPartners($partnerekIdArray);
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $regiok = \UserFunctions::getRegiokOfPartners($partnerekIdArray);
                    }
                    return $regiok;

                case 'telephely':
                    $telephelyek = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        $telephelyek = $g['db_db']->admin_telephelyek_sel();
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $telephelyek = \UserFunctions::getTelephelyekOfPartners($partnerekIdArray);
                        $hozzarendeltTelephelyek = $g['db_db']->get_telephelyek_of_felhasznalo($kezeloUserSn);
                        $hozzarendeltTelephelyekId = array_column($hozzarendeltTelephelyek, 'id');
                        foreach ($telephelyek as $k=>$telephely) {
                            if (!in_array($telephely['id'], $hozzarendeltTelephelyekId)) {
                                unset($telephelyek[$k]);
                            }
                        }
                        $telephelyek = array_values($telephelyek);
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $telephelyek = \UserFunctions::getTelephelyekOfPartners($partnerekIdArray);
                        $hozzarendeltTelephelyek = $g['db_db']->get_telephelyek_of_felhasznalo($kezeloUserSn);
                        $hozzarendeltTelephelyekId = array_column($hozzarendeltTelephelyek, 'id');
                        foreach ($telephelyek as $k=>$telephely) {
                            if (!in_array($telephely['id'], $hozzarendeltTelephelyekId)) {
                                unset($telephelyek[$k]);
                            }
                        }
                        $telephelyek = array_values($telephelyek);
                    }
                    return $telephelyek;

                case 'eszkoz':
                    $telephelyek = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        $eszkozok = $g['db_db']->admin_eszkozok_sel();
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $telephelyek = \UserFunctions::getTelephelyekOfPartners($partnerekIdArray);
                        $hozzarendeltTelephelyek = $g['db_db']->get_telephelyek_of_felhasznalo($kezeloUserSn);
                        $hozzarendeltTelephelyekId = array_column($hozzarendeltTelephelyek, 'id');
                        foreach ($telephelyek as $k=>$telephely) {
                            if (!in_array($telephely['id'], $hozzarendeltTelephelyekId)) {
                                unset($telephelyek[$k]);
                            }
                        }
                        $telephelyek = array_values($telephelyek);
                        $telephelyekIdArray = array_column($telephelyek, 'id');
                        $eszkozok = \UserFunctions::getEszkozokOfTelephelyek($telephelyekIdArray);
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $telephelyek = \UserFunctions::getTelephelyekOfPartners($partnerekIdArray);
                        $hozzarendeltTelephelyek = $g['db_db']->get_telephelyek_of_felhasznalo($kezeloUserSn);
                        $hozzarendeltTelephelyekId = array_column($hozzarendeltTelephelyek, 'id');
                        foreach ($telephelyek as $k=>$telephely) {
                            if (!in_array($telephely['id'], $hozzarendeltTelephelyekId)) {
                                unset($telephelyek[$k]);
                            }
                        }
                        $telephelyek = array_values($telephelyek);
                        $telephelyekIdArray = array_column($telephelyek, 'id');
                        $eszkozok = \UserFunctions::getEszkozokOfTelephelyek($telephelyekIdArray);
                    }
                    return $eszkozok;

                case 'kerdoiv':
                    $kerdoivek = [];
                    if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('admin'))
                    {
                        $kerdoivek = $g['db_db']->admin_kerdoivek_sel();
                    }
                    elseif (\UserFunctions::hasGlobalRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUser($kezeloUserSn);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $kerdoivek = \UserFunctions::getKerdoivekOfPartners($partnerekIdArray);
                        // TODO //
                        

                        $eszkozok = \UserFunctions::kezelheto_entitasok($kezeloUserSn, 'eszkoz', $muveletElemiJog);
                        $engedelyezettKerdoivek = array();
                        for ($i = 0; $i <= count($eszkozok); $i++) {
                            if (!empty($eszkozok[$i]['fk_kerdoivek']) && gettype($eszkozok[$i]['fk_kerdoivek']) === "string") array_push($engedelyezettKerdoivek, $eszkozok[$i]['fk_kerdoivek']);
                        }
                       $kerdoivekTemp = $kerdoivek;
                       $kerdoivek = array();
                        for ($i = 0; $i <= count($kerdoivekTemp); $i++) {
                            if (in_array($kerdoivekTemp[$i]['id'], $engedelyezettKerdoivek)) array_push($kerdoivek, $kerdoivekTemp[$i]);
                        }
                    }
                    elseif (\UserFunctions::hasPartnerRight($kezeloUserSn, $muveletElemiJog)) {
                        $partnerek = \UserFunctions::getPartnersOfUserWithRight($kezeloUserSn, $muveletElemiJog);
                        $partnerekIdArray = array_column($partnerek, 'id');
                        $kerdoivek = \UserFunctions::getKerdoivekOfPartners($partnerekIdArray);                        
                    }
                    return $kerdoivek;

                default:
                    return [];
            }
        }

        public static function getUsersOfPartners($partnerSnArray) {
            global $g;
            if (empty($partnerSnArray)) {
                return [];
            }
            $partnerSnArrayString = '('.implode(',',$partnerSnArray).')';
            return $g['db_db']->felhasznalok_sel_of_partnerek(['partnerek' => $partnerSnArrayString]);
        }

        public static function getRegiokOfPartners($partnerSnArray) {
            global $g;
            if (empty($partnerSnArray)) {
                return [];
            }
            $partnerSnArrayString = '('.implode(',',$partnerSnArray).')';
            return $g['db_db']->get_regiok_of_partner(['partnerek' => $partnerSnArrayString]);
        }

        public static function getTelephelyekOfPartners($partnerSnArray) {
            global $g;
            if (empty($partnerSnArray)) {
                return [];
            }
            $partnerSnArrayString = '('.implode(',',$partnerSnArray).')';
            return $g['db_db']->get_telephelyek_of_partner(['partnerek' => $partnerSnArrayString]);
        }

        public static function getKerdoivekOfPartners($partnerSnArray) {
            global $g;
            if (empty($partnerSnArray)) {
                return [];
            }
            $partnerSnArrayString = '('.implode(',',$partnerSnArray).')';
            return $g['db_db']->get_kerdoivek_of_partner(['partnerek' => $partnerSnArrayString]);
        }

        public static function getEszkozokOfTelephelyek($telephelySnArray) {
            global $g;
            if (empty($telephelySnArray)) {
                return [];
            }
            $telephelySnArrayString = '('.implode(',',$telephelySnArray).')';
            return $g['db_db']->get_eszkozok_of_telephelyek(['telephelyek' => $telephelySnArrayString]);
        }

        public static function getTelephelyekOfUser($userSn) {
            global $g;
            $partnerek = \UserFunctions::getPartnersOfUser($userSn);
            $partnerSnArray = array_column($partnerek, 'id');
            if (empty($partnerSnArray)) {
                return [];
            }
            $partnerSnArrayString = '('.implode(',',$partnerSnArray).')';
            return $g['db_db']->get_telephelyek_of_partner(['partnerek' => $partnerSnArrayString]);
        }

        public static function getPartnersOfUser($userSn) {
            global $g;
            return $g['db_db']->partnerek_of_user_sel($userSn);
        }

        public static function getPartnerOfTelephely($telephelySn) {
            global $g;
            return $g['db_db']->get_partner_of_telephely_2($telephelySn);
        }

        public static function getPartnersOfUserWithRight($userSn, $elemiJogKod) {
            global $g;
            return $g['db_db']->get_partners_with_rights_of_user($userSn, $elemiJogKod);
        }

        public static function hasGlobalOrPartnerRightAfterLogin($elemiJogKod){
            global $g;
            return in_array($elemiJogKod, $g['jogok']);
        }

        public static function hasGlobalRight($userSn, $elemiJogKod){
            global $g;
            return $g['db_db']->user_has_global_right($userSn, $elemiJogKod)[0]['cnt'] != '0';
        }

        public static function hasPartnerRight($userSn, $elemiJogKod){
            global $g;
            return $g['db_db']->user_has_partner_right($userSn, $elemiJogKod)[0]['cnt'] != '0';
        }

        public static function getKerdoivJson($kerdoivSn, $eszkoz_azonosito){
            global $g;

            if (is_null($eszkoz_azonosito)) {
                $eszkoz_id = 'null';
            } else {
                $eszkoz_id = $g['db_db']->get_eszkoz_sn_from_eszkoz_azonosito($eszkoz_azonosito)[0]['id'];
            }

            if (!file_exists($cache_file = GI_PATH_CACHE . 'kerdoiv_json_files/')) {
                mkdir($cache_file);
            }

            if (!file_exists($cache_file . $kerdoivSn . '_' . $eszkoz_id . '.txt')) {

                $kerdoiv = [];
                $kerdoiv['adatok'] = $g['db_db']->kerdoivek_json_kerdoiv_sel($kerdoivSn)[0];
                $kerdoiv['hatterkepek'] = $g['db_db']->kerdoivek_json_hatterkep_sel($kerdoivSn)[0];
                $kerdoiv['szinek'] = $g['db_db']->kerdoivek_json_szinek_sel($kerdoivSn);

                $kerdoiv['hozzakapcsolt_online_eszkoz'] = $g['db_db']->get_hozzakapcsolt_online_eszkoz(
                    $eszkoz_id
                );

                if ($eszkoz_id !== 'null') {
                    $kerdoiv['eszkoz'] = $g['db_db']->get_eszkoz($eszkoz_id);
                } else {
                    $kerdoiv['eszkoz'] = null;
                }
                

                if (!empty($kerdoiv['hozzakapcsolt_online_eszkoz'])) {
                    $kerdoiv['hozzakapcsolt_online_eszkoz'] = $kerdoiv['hozzakapcsolt_online_eszkoz'][0];
                }

                $kerdoiv['nyelvek'] = [];
                $nyelvek = $g['db_db']->kerdoivek_json_nyelvek_sel($kerdoivSn);
                foreach ($nyelvek as $nyelv) {
                    $nyelvkod = $nyelv['lang'];
                    $kerdoiv['nyelvek'][$nyelvkod] = [
                        'sorrend' => $nyelv['sorrend']
                    ];

                    $kerdoiv['nyelvek'][$nyelvkod]['szovegek'] = $g['db_db']->kerdoivek_json_szovegek_sel(
                        $kerdoivSn, $nyelvkod
                    );
                    $kerdoiv['nyelvek'][$nyelvkod]['szovegek'] = array_combine(
                        array_column($kerdoiv['nyelvek'][$nyelvkod]['szovegek'], 'szoveg_nev'),
                        array_column($kerdoiv['nyelvek'][$nyelvkod]['szovegek'], 'szoveg_ertek')
                    );

                    $kerdoiv['nyelvek'][$nyelvkod]['rendszerszintu_kerdesek'] = $g['db_db']->kerdoivek_json_kell_rendszerszintu_kerdesek_sel(
                        $kerdoivSn
                    );

                    foreach ($kerdoiv['nyelvek'][$nyelvkod]['rendszerszintu_kerdesek'] as &$rsz_kerdes) {

                        $rsz_kerdes['eredeti_kerdes_szoveg'] = $g['db_db']->kerdoivek_json_rsz_eredeti_kerdesek_szovegek(
                                $rsz_kerdes['id'], $nyelvkod
                        )[0]['kerdes_szovege'];

                        $rsz_kerdes['felulirt_kerdes_szoveg'] = $g['db_db']->kerdoivek_json_rsz_felulirt_kerdesek_szovegek(
                            $rsz_kerdes['id'], $kerdoivSn, $nyelvkod
                        )[0]['kerdes_szovege'];

                        $rsz_kerdes['valasz_tipus_extrak'] = $g['db_db']->kerdoivek_json_valasz_tipus_kieg_sel(
                            $rsz_kerdes['valasz_tipus_id']
                        );

                        $rsz_kerdes['kerdes_extrak'] = $g['db_db']->kerdoivek_json_kerdes_kieg_sel(
                            $rsz_kerdes['id']
                        );

                    }
                    unset($rsz_kerdes);

                    $kerdoiv['nyelvek'][$nyelvkod]['kerdesek'] = $g['db_db']->kerdoivek_json_kerdesek_sel(
                        $kerdoivSn
                    );

                    foreach ($kerdoiv['nyelvek'][$nyelvkod]['kerdesek'] as &$kerdes) {
                        $kerdes['kerdes_szoveg'] = $g['db_db']->kerdoivek_json_rsz_eredeti_kerdesek_szovegek(
                                $kerdes['id'], $nyelvkod
                        )[0]['kerdes_szovege'];

                        $kerdes['valasz_tipus_extrak'] = $g['db_db']->kerdoivek_json_valasz_tipus_kieg_sel(
                            $kerdes['valasz_tipus_id']
                        );

                        $kerdes['kerdes_extrak'] = $g['db_db']->kerdoivek_json_kerdes_kieg_sel(
                            $kerdes['id']
                        );

                        $kerdes['kerdes_valasz_tiltasok'] = [];
                        if (!is_null($eszkoz_azonosito)) {
                            $kerdes['kerdes_valasz_tiltasok'] = $g['db_db']->kerdoivek_json_kerdes_valasz_tiltasok_sel(
                                $kerdes['id'],
                                $eszkoz_id
                            );
                        }

                        $kerdes['alkerdesek'] = [];
                        if (in_array($kerdes['valasz_tipus_kod'], ['kerdes-csoport', 'kerdes-csoport-sorrend'])) {
                            $kerdes['alkerdesek'] = $g['db_db']->get_alkerdesek($kerdes['id']);
                            foreach ($kerdes['alkerdesek'] as &$alkerdes) {
                                $alkerdes['kerdes_szoveg'] = $g['db_db']->kerdoivek_json_rsz_eredeti_kerdesek_szovegek(
                                        $alkerdes['id'], $nyelvkod
                                )[0]['kerdes_szovege'];

                                $alkerdes['valasz_tipus_extrak'] = $g['db_db']->kerdoivek_json_valasz_tipus_kieg_sel(
                                    $alkerdes['valasz_tipus_id']
                                );

                                $alkerdes['kerdes_extrak'] = $g['db_db']->kerdoivek_json_kerdes_kieg_sel(
                                    $alkerdes['id']
                                );

                                $alkerdes['kerdes_valasz_tiltasok'] = [];
                            }
                            unset($alkerdes);
                        }
                    }
                    unset($kerdes);
                }

                file_put_contents($cache_file . $kerdoivSn . '_' . $eszkoz_id . '.txt', json_encode($kerdoiv));
            }

            $kerdoiv = json_decode(
                file_get_contents($cache_file . $kerdoivSn . '_' . $eszkoz_id . '.txt'),
                true
            );

            return $kerdoiv;

        }

        public static function get_jelentes_szurheto_adatok() {
            global $g;
            $adatok = [];
            $adatok['partnerek'] = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'partner', 'jelentesek_megtekintese');
            $adatok['eszkozok'] = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'eszkoz', 'jelentesek_megtekintese');

            $adatok['history'] = $g['db_db']->get_jelentes_history();
            $adatok['history_szetszorva'] = [
                "kerdoiv" => [],
                "eszkoz" => [],
                "telephely" => []
            ];
            foreach ($adatok['history'] as $row) {
                if (!isset($adatok['history_szetszorva']['kerdoiv'][$row['fk_kerdoivek']])) {
                    $adatok['history_szetszorva']['kerdoiv'][$row['fk_kerdoivek']] = [
                        "eszkoz" => [], "telephely" => []
                    ];
                }
                $adatok['history_szetszorva']['kerdoiv'][$row['fk_kerdoivek']]['eszkoz'] []= $row['fk_eszkozok'];
                $adatok['history_szetszorva']['kerdoiv'][$row['fk_kerdoivek']]['telephely'] []= $row['fk_telephelyek'];

                if (!isset($adatok['history_szetszorva']['eszkoz'][$row['fk_eszkozok']])) {
                    $adatok['history_szetszorva']['eszkoz'][$row['fk_eszkozok']] = [
                        "kerdoiv" => [], "telephely" => []
                    ];
                }
                $adatok['history_szetszorva']['eszkoz'][$row['fk_eszkozok']]['kerdoiv'] []= $row['fk_kerdoivek'];
                $adatok['history_szetszorva']['eszkoz'][$row['fk_eszkozok']]['telephely'] []= $row['fk_telephelyek'];

                if (!isset($adatok['history_szetszorva']['telephely'][$row['fk_telephelyek']])) {
                    $adatok['history_szetszorva']['telephely'][$row['fk_telephelyek']] = [
                        "kerdoiv" => [], "eszkoz" => []
                    ];
                }
                $adatok['history_szetszorva']['telephely'][$row['fk_telephelyek']]['kerdoiv'] []= $row['fk_kerdoivek'];
                $adatok['history_szetszorva']['telephely'][$row['fk_telephelyek']]['eszkoz'] []= $row['fk_eszkozok'];
            }

            $adatok['regiok'] = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'regio', 'jelentesek_megtekintese');
            $adatok['telephelyek'] = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'telephely', 'jelentesek_megtekintese');
            $adatok['kerdoivek'] = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'kerdoiv', 'jelentesek_megtekintese');

            $rosszKerdoivekIdjai = [];
            $joKerdoivekIdjai = [];
            $adatok['kerdesek'] = [];

            $adatok["texts"] = $g['db_db']->get_texts('hu');
            $adatok["textsew"] = "+sed";

            if (!empty($adatok['kerdoivek'])) {
                $kerdoivekIdjai = array_column($adatok['kerdoivek'], 'id');
                $kerdoivekIdjaiStr = '('.implode(',', $kerdoivekIdjai) . ')';
                $kerdoivNyelvek = $g['db_db']->get_kerdoiv_nyelvek(['kerdoivek' => $kerdoivekIdjaiStr]);

                foreach ($kerdoivekIdjai as $kid) {
                    foreach ($kerdoivNyelvek as $knyelv) {
                        if ($knyelv['fk_kerdoivek'] === $kid && $knyelv['lang'] === $g['lang']) {
                            $joKerdoivekIdjai []= $kid;
                            continue 2;
                        }
                    }
                    foreach ($kerdoivNyelvek as $knyelv) {
                        if ($knyelv['fk_kerdoivek'] === $kid) {
                            $rosszKerdoivekIdjai []= [$kid, $knyelv['lang']];
                            break;
                        }
                    }
                }

                $adatok['joKerdoivekIdja'] = $joKerdoivekIdjai;
                $adatok['rosszKerdoivekIdjai'] = $rosszKerdoivekIdjai;

                // kerdesek a kivalasztott nyelven
                if (empty($joKerdoivekIdjai)) {
                    $adatok['kerdesek'] = [];
                } else {
                    $adatok['kerdesek'] = $g['db_db']->get_kerdesek_of_kerdoivek($g['lang'], ['kerdoivek' => '('.implode(',', $joKerdoivekIdjai).')']);
                  /*  var_export($joKerdoivekIdjai);*/
                    $adatok['test0'] = $joKerdoivekIdjai;
                    $adatok['test1'] = $adatok['kerdesek'];
                }
                
                foreach ($adatok['kerdesek'] as &$kerdes) {
                    if (is_null($kerdes['fk_kerdoivek'])) {
                        $kerdes['fk_kerdoivek'] = array_column($g['db_db']->get_rendszerszintu_kerdes_kerdoivek($kerdes['id']), 'fk_kerdoivek');
                    }
                    $adatok['test2'] = true;
                }
                /*unset($kerdes);*/

                // maradek kerdoiv kerdesei
                foreach ($rosszKerdoivekIdjai as $rossz) {
                    $ujKerdesek = $g['db_db']->get_kerdesek_of_kerdoivek($rossz[1], ['kerdoivek' => '('.$rossz[0].')']);
                    $adatok['test3'] = $ujKerdesek;
                    foreach ($ujKerdesek as $k => &$kerdes) {
                        if (is_null($kerdes['fk_kerdoivek'])) {
                            unset($ujKerdesek[$k]);
                            continue;
                        }
                    }
                    unset($kerdes);
                    $adatok['kerdesek'] = array_merge($adatok['kerdesek'], $ujKerdesek);
                }
            }

            // kerdesek magyarul
            $adatok['kerdesek_hu'] = empty($adatok['kerdoivek']) ? [] : $g['db_db']->get_kerdesek_of_kerdoivek(GI_DEFAULT_LANG, ['kerdoivek' => '('.implode(',', array_column($adatok['kerdoivek'], 'id')).')']);
            foreach ($adatok['kerdesek_hu'] as &$kerdes) {
                if (is_null($kerdes['fk_kerdoivek'])) {
                    $kerdes['fk_kerdoivek'] = array_column($g['db_db']->get_rendszerszintu_kerdes_kerdoivek($kerdes['id']), 'fk_kerdoivek');
                }
            }
            unset($kerdes);

            // regioknal adni a telephelyeket amiket belerakunk
            foreach ($adatok['regiok'] as &$regio) {
                $regio['telephelyek'] = $g['db_db']->get_telephelyek_of_regio($regio['id']);
            }
            unset($regio);
            // kerdoiveknel adni minden adatot ami bennuk van
            foreach ($adatok['kerdoivek'] as &$kerdoiv) {
                $kerdoiv['json'] = \UserFunctions::getKerdoivJson($kerdoiv['id'], null);
            }
            unset($kerdoiv);

            // az indexek legyenek az idk
            foreach ($adatok as $key => &$adat) {
                if (in_array($key, ['history', 'history_szetszorva', 'texts'])) {
                    continue;
                }
                $adat = array_combine(array_column($adat, 'id'), array_values($adat));
            }
            unset($adat);

            return $adatok;
        }

        public static function partner_nev_mogeirasa($obj) {
            return array_map(function($var){
                if (isset($var['partner_nev'])) {
                    $var['nev'] = $var['nev'] . ' (' . $var['partner_nev'] . ')';
                }
                return $var;
            }, $obj);
        }

        public static function automata() {
            global $g;
            $auto = $g['db_db']->automata_sel();
            $het_napja = date('w');
            $het_napja = $het_napja == '0' ? '7' : $het_napja;
            foreach ($auto as $au) {
                if ($au['het_napja'] == $het_napja) {
                    $isset_automata = $g['db_db']->isset_eszkoz_vezerles_automata_history(
                        date('Y-m-d'),
                        $au['id']
                    )[0]['cnt'];
                    if ($isset_automata == 0) {
                        try {
                            $g['db_db']->add_eszkoz_vezerles_with_automata(
                                $au['eszkoz_azonosito'],
                                $au['action'],
                                $au['content'],
                                date('Y-m-d') . ' ' . $au['oraperc'] . ':00'
                            );

                            $g['db_db']->add_eszkoz_vezerles_automata_history(
                                date('Y-m-d'),
                                $au['id']
                            );
                        }
                        catch (\Exception $e) {
                            var_dump($e->getMessage());die;
                        }
                    }
                }
            }
        }
    }