<?php

	class DataBase{

		private $con = null;
		private $db = null;

		function __construct($db){
			$this->db = $db;
			try{
				$this->con = new PDO("mysql:dbname=".constant('GI_DB_'.strtoupper($db).'_DB').";host=".constant('GI_DB_'.strtoupper($db).'_HOST').";port=".constant('GI_DB_'.strtoupper($db).'_PORT'), constant('GI_DB_'.strtoupper($db).'_USER'), constant('GI_DB_'.strtoupper($db).'_PASS'),array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"));
				if(!$this->con){
					$e = oci_error();
					throw(new Exception($e['message']));
				}
			}
			catch(Exception $e){
				trigger_error(mb_convert_encoding($e->getMessage(),'UTF-8'));
			}
		}

		function __call($name,$arguments){

			try{
				require_once GI_PATH_UTIL.'procedures.php';
                $this->con->beginTransaction();
				$sql = \Procedures::$$name;
				if(count($arguments)!==0 && is_array($arguments[count($arguments)-1])){
					$replace = $arguments[count($arguments)-1];
					unset($arguments[count($arguments)-1]);
				}
				else{
					$replace = array();
				}
				foreach($replace as $k=>$rep){
					$sql = str_replace('[['.$k.']]',$rep,$sql);
				}
                $stmt = $this->con->prepare($sql);
                for($i=1;$i<count($arguments)+1;$i++){
                    if(is_int($arguments[$i-1])){
						$arguments[$i-1] = (int)$arguments[$i-1];
                        $stmt->bindParam($i, $arguments[$i-1],PDO::PARAM_INT);
                    }
                    else{
                        $stmt->bindParam($i, $arguments[$i-1],PDO::PARAM_STR);
                    }
                }
                if(!$stmt->execute()){
                    throw new Exception(print_r($stmt->errorInfo(), true));
                }
                $this->con->commit();
                return $stmt->fetchAll(PDO::FETCH_ASSOC);

            }
            catch(Exception $e){
                // echo "$name\n";
				// exit(print_r($stmt->errorInfo(),true));
                $this->con->rollBack();
                throw new Exception($e->getMessage());
            }
		}

		function direct_call($sql, $parameters){
			$stmt = $this->con->prepare($sql);

            if(!$stmt){
                exit(print_r($stmt->errorInfo(),true));
                return false;
            }
			if(!$stmt->execute($parameters)){
                exit(print_r($stmt->errorInfo(),true));
                return false;
			}

			return $stmt->fetchAll(PDO::FETCH_ASSOC);
		}

	}
