var kikuldes_fejek = null;
var kikuldes_tetelek = null;
const PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var ISMERV_CSOPORTOK = [];
var ONLINE_ESZKOZOK = filterArray(objectToArray(szurheto_adatok.eszkozok), 'online', '1');
var GRAFIKON_DATA = null;

download_xls = {
    inic_param: {
            id: 'xls_download',
            dataRight: 'tomeges_kikuldes',
            title: '[[$t.minta_xls_letoltese]]',
            cols: 2,
            rows: 2,
            position: 'bottom'
        },
        buttons: [
            {
                name:"[[$t.xls_letoltes]]",
                id: 'btn_download_xls',
                type: 'save',
                visibility: function() {return 1},
                callback: function(valid) {
                    if(valid) {
                        downloadXls();
                    }
                },
            },
            {
                name:"[[$t.vissza]]",
                id: 'btn_cancel_xls_letoltes',
                visibility: function() {return 1},
                callback: function() {
                    clearForm('xls_download');
                },
                addClasses: 'btn-alt',
                type: 'cancel',
                toggleId: 'xls_download'
            }
        ],
        inputs: [
            {"col": 0, "row": 0, "colspan": 2, "input": '<p>[[$t.html_kikuldes_ismerv_valasztas_info]]</p>'},
            {"col": 0, "row": 1, "input": filterSelectHtml({
                                            id: 'ismerv_csoport_input',
                                            label: '[[$t.ismerv_csoport]]',
                                            placeholder: '[[$t.mind]]',
                                            name: 'ismerv_csoport_input',
                                            maxOptions: '1',
                                            addclass: 'form',
                                            required: true
                                        },
                                        filterSelectValues(ISMERV_CSOPORTOK , 'nev', 'id')
                                    )},
            
        ],

};


$(document).ready(function() {
    var select = filterSelectHtml({
        id: 'partner_select_input',
        placeholder: '[[$t.partner]]',
        name: 'partner_select_input',
        maxOptions: 1,
        addclass: 'form'
    }, 
    filterSelectValues(PARTNEREK, 'nev', 'id')
    );

    $('#partner_valaszto_input').html(select);
    $('#partner_select_input').selectpicker();

    if(PARTNEREK.length > 0) {
        for(var i in PARTNEREK) {
            if(isDefined(PARTNEREK[i])) {
                defaultPartnerId = PARTNEREK[i].id;
                break;
            }
        }
        $('#partner_select_input').selectpicker('val', defaultPartnerId);

    }

    if(PARTNEREK.length > 0) {
        inic();
        var partnerId = $('#partner_select_input').val()[0];
        var loc_online_eszkozok = filterArray(objectToArray(szurheto_adatok.eszkozok), 'online', '1');
        ONLINE_ESZKOZOK = filterArray(loc_online_eszkozok, 'partner_id', partnerId);
    }

    /*Ha csak egy partner van, nem kell megmutatni a selectet*/
    if(PARTNEREK.filter(function(value) { return value !== undefined }).length == 1) {
        $('#partner_valaszto_input, .info').addClass('d-none');
    }
        


    $('#partner_select_input').on('change', function() {
        if(!isDefined($('#partner_select_input').val()[0]) || $('#partner_select_input').val()[0] == '') {
            $('#partner_select_input').selectpicker('val', defaultPartnerId);
        } else {
            inic();
        }
        var partnerId = $('#partner_select_input').val()[0];
        var loc_online_eszkozok = filterArray(objectToArray(szurheto_adatok.eszkozok), 'online', '1');
        ONLINE_ESZKOZOK = filterArray(loc_online_eszkozok, 'partner_id', partnerId);
    });

    kikuldes_statisztikak = dataTable($('#kikuldes_statisztikak'),{
        table:{
            name:'[[$t.statisztikak]]',
            right:'tomeges_kikuldes',
            hide: true
        },
        ajax:{
            name:'kikuldes_stat',
            data:{
                "echo": "1",
                "beolvasas_id": function() { return selectedRowId('#kikuldes_fejek'); }
            },
            onInicCall: false,
            transform: function(data){
                if(data[1] == 'no_stat') {
                    return [];
                } else {
                    GRAFIKON_DATA = data;
                    data.id = 1;
                    var ret = [];
                    ret.push(data);
                    initGrafikon(data);
                    return ret;
                }
            }
        },
        columns:[
            { headName:"[[$t.channel_id]]", colName:"channelid"},
            { headName:"[[$t.fogadottak_szama]]", colName:"sentcount"},
            { headName:"[[$t.sikeres_kezbesitesek_aranya]]", colName:"deliveredpercentage", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(cellData+'%');
            }},
            { headName:"[[$t.meghiusultak_szama]]", colName:"failedcount"},
            { headName:"[[$t.meghiusult_kezbesitesek_aranya]]", colName:"failedpercentage", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(cellData+'%');
            }},
            { headName:"[[$t.megnyitottak_szama]]", colName:"openedcount"},
            { headName:"[[$t.megnyitottak_aranya]]", colName:"openedpercentage", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(cellData+'%');
            }},
            { headName:"[[$t.link_kattintasok_szama]]", colName:"clickedcount"},
            { headName:"[[$t.link_kattintasok_aranya]]", colName:"clickedpercentage", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(cellData+'%');
            }},
            { headName:"[[$t.unsubscribe_szama]]", colName:"unsubscribedcount"},
            { headName:"[[$t.unsubscribe_aranya]]", colName:"unsubscribedpercentage", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(cellData+'%');
            }}
        ],
    });

    kikuldes_fejek = dataTable($('#kikuldes_fejek'),{
        table:{
            name:'[[$t.kikuldesek]]',
            right:'tomeges_kikuldes',
            addClass:"mt-4 hw",
            onRowSelect: function() {
                initTetelTable();
                statisztikaShow(false);
            },
            canSelect: true
        },
        ajax:{
            name:'beolvasas_sel',
            data:{
                "echo": "1",
                "partner_id": function () { return $('#partner_select_input').val()[0]; }
            },
            onInicCall: false
        },
        functions:{
            statisztika:{
                icon: "fas fa-chart-bar",
                right:"tomeges_kikuldes",
                callback: function(elem,data){
                    kikuldes_fejek.rows('#'+data.id).select();
                    if(data.kikuldve != null) {
                        statisztikaShow(true);
                    } else {
                        gi_alert('[[$t.meg_nincs_kikuldve]]');
                    }
                   
                },
                title:"[[$t.statisztikak]]"
            },
            ismervek:{
                icon: "fa fa-eye",
                right:"tomeges_kikuldes",
                callback: function(elem,data){
                   showIsmerv(elem, data);
                },
                title:"[[$t.ismervek_megtekintese]]"
            },
            eszkoz_kapcsolat:{
                icon: "fas fa-mobile-alt",
                right:"tomeges_kikuldes",
                callback: function(elem,data){
                    if(data.kikuldve == null) {
                        eszkozKapcsolForm(elem, data);
                    } else {
                        gi_alert('[[$t.mar_kikuldve]]');
                    }
                },
                title:"[[$t.eszkoz_hozzarendelese]]"
            },
            sablon_kapcsolasa: {
                icon: "fas fa-envelope-open-text",
                right:"tomeges_kikuldes",
                callback: function(elem,data){
                    if(data.kikuldve == null) {
                        sablonKapcsolForm(elem, data);
                    } else {
                        gi_alert('[[$t.mar_kikuldve]]');
                    }
                },
                title:"[[$t.sablon_kapcsolasa]]"
            },
            kikuldes:{
                icon: "fas fa-share",
                right:"tomeges_kikuldes",
                callback: function(elem,data){
                    if(data.eszkoz_id == null) {
                        gi_alert('[[$t.nincs_eszkoz_csatolva]]');
                    }
                    else if(data.kikuldve == null) {
                        kikuldes(elem, data);
                    } else {
                        gi_alert('[[$t.mar_kikuldve]]');
                    }
                   
                },
                title:"[[$t.kikuldes]]"
            },

            
        },
        columns:[
            { headName:"[[$t.kikuldes_azonosito]]", colName:"nev"},
            { headName:"[[$t.feltoltes_datuma]]", colName:"beolvasva", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            }},
            { headName:"[[$t.tetelek_szama]]", colName:"sorok_szama"},
            { headName:"[[$t.ismerv_csoport]]", colName:"ismerv_csoport_nev"},
            { headName:"[[$t.kapcsol_eszkoz]]", colName:"eszkoz_id", cellRender:function(td, cellData, rowData, row, col){
                if(cellData!= null) {
                    var eszkozok = objectToArray(szurheto_adatok.eszkozok);
                    var eszkoz = findInArray(eszkozok, 'id', cellData);
                    if(isDefined(eszkoz)) {
                        $(td).html(eszkoz.nev);
                    } else {
                        $(td).html('');
                    }
                }
            }},
            { headName:"[[$t.kapcsolt_sablon]]", colName:"sablon_nev"},
            { headName:"[[$t.kikuldes_datuma]]", colName:"kikuldve", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            }},
        ],
        /*detailTables:[
            {table: kikuldes_tetelek},
        ],*/
        forms: [download_xls],
        buttons: [
            {
                name: "[[$t.minta_xls_letoltese]]",
                id: 'download_xls_btn',
                dataRight: 'tomeges_kikuldes',
                visibility: function() {return 1;},
                callback: function() {
                },
                type: "view",
                toggleId: 'xls_download',
            },
            {
                name: "[[$t.beolvasas_xls_bol]]",
                id: 'upload_xls',
                dataRight: 'tomeges_kikuldes',
                visibility: function() {return 1;},
                callback: function() {
                    popupUplodoad({
                        id: 'file',
                        ajax: 'ajax/tomeges_import',
                        data: {
                            "ismerv_csoport_id": function () { return $('#beolvasas_ismerv_csoport').val()[0]},
                            "nev": function () { return $('#beolvasas_nev').val()},
                            "partner_id": function () { return $('#partner_select_input').val()[0]}
                        },
                        validator: function() {
                            var nincs_hiba = true;
                            if($('#beolvasas_ismerv_csoport').val().length < 1) {
                                nincs_hiba = false;
                                validationHandler($('#beolvasas_ismerv_csoport').parent(), false, '[[$t.valasztas_kotelezo]]');
                            }
        
                            if($('#beolvasas_nev').val().length < 1) {
                                nincs_hiba = false;
                                validationHandler($('#beolvasas_nev'), false, '[[$t.mezo_ures]]');
                            }

                            if(nincs_hiba) {
                                validationHandler($('#beolvasas_ismerv_csoport').parent(), true, '[[$t.valasztas_kotelezo]]');
                                validationHandler($('#beolvasas_nev'), true, '[[$t.mezo_ures]]');
                            }
        
                            return nincs_hiba;
                        },
                        onUploadSuccess: function(id, data){
                            data = JSON.parse(data);
                            if(data[0] == "OK"){
                                var text = '';
                                for(var i in data[1]){
                                    if(data[1][i] == '0'){
                                        text += (i*1+2) +', ';
                                    }
                                }                                
                                if(text == ''){                                    
                                    gi_alert("[[$t.sikeres_feltoltes]]",function(){
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                }else{
                                    text = text.substr(0,text.length - 2);
                                    gi_alert("[[$t.hibas_sorok]]"+'<br/>'+text,function(){
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                }
                                kikuldes_fejek.ajax.reload();
                                
                            }else if(data[1] == "nincs_fajl"){
                                gi_alert("[[$t.nincs_fajl]]");
                            }else if(data[1] == "hibas_feltoltes"){
                                gi_alert("[[$t.hibas_feltoltes]]");
                            }else{
                                gi_alert("[[$t.hibas_feltoltes]]");
                            }
                        }
                    });

                    $('#messageModal .select-holder').html(filterSelectHtml({
                                                            id: 'beolvasas_ismerv_csoport',
                                                            label: '[[$t.ismerv_csoport]]',
                                                            placeholder: '[[$t.mind]]',
                                                            name: 'beolvasas_ismerv_csoport',
                                                            maxOptions: '1',
                                                            addclass: 'form',
                                                            required: true
                                                        },
                                                        filterSelectValues(ISMERV_CSOPORTOK , 'nev', 'id')
                    ));
                    $('#messageModal .input-holder').html(inputHtml({
                                                            id: 'beolvasas_nev',
                                                            label: '[[$t.kikuldes_azonosito_nev]]',
                                                            placeholder: '[[$t.kikuldes_azonosito_nev]]',
                                                            required: true,
                                                            name: 'beolvasas_nev',
                                                            autofocus: false,
                                                            maxlength: 100
                                                        }));
                    $('#beolvasas_ismerv_csoport').selectpicker();
                },
            }
        ]
    });

});

function inic() {
    var data = {
        "echo": "1",
        "partner_id": $('#partner_select_input').val()[0]
    };

    var resultText = {
    };

    postApi('ismerv_csoportok_sel',data,$('#partner_select_input'),resultText,null,function(result){
        ISMERV_CSOPORTOK = result.data;
        if(kikuldes_fejek != null) {
            clearForm('xls_download');
            refillSelect('ismerv_csoport_input',filterSelectValues(ISMERV_CSOPORTOK , 'nev', 'id'));
            $('#ismerv_csoport_input').selectpicker('refresh');
            kikuldes_fejek.ajax.reload();
        }
    });
}

function initTetelTable() {

    var ajax_obj = {
        "echo": "1",
        "ismerv_csoport_id": selectedRowData('#kikuldes_fejek').ismerv_csoport_id
    };

    var resultText = {};

    postApi('ismervek_sel',ajax_obj,$('#kikuldes_tetelek'),resultText,null,function(result){

        var columns = [
            { headName:"[[$t.user_id]]", colName:"user_id"},
            { headName:"[[$t.user_email]]", colName:"user_email"}
        ];
        for(var i in result.data) {
            columns.push({ headName: result.data[i].nev, colName:"ismerv_"+result.data[i].id});
        }

        if(kikuldes_tetelek != null) {
            kikuldes_tetelek.destroy();
            $('#kikuldes_tetelek_wrapper h2.table_name').remove();
            kikuldes_tetelek = null;        
        }

        kikuldes_tetelek = dataTable($('#kikuldes_tetelek'),{
            table:{
                right:'tomeges_kikuldes'
            },
            data: function(callback, element) {
                getBeolvasasSorok(callback)
            },
            columns: columns,
        });

    });

}

function downloadXls() {
    var ismerv_csoport_id = $('#ismerv_csoport_input').val()[0];
    kikuldes_fejek.ajax.reload();
    window.open('/' + act_lang + '/tomeges-kikuldesek/'+ismerv_csoport_id,"_blank");
}

function eszkozKapcsolForm(elem, data) {
    popupForm({
        inic_param: {
                id: 'eszkoz_kapcsol_from',
                title: '[[$t.eszkoz_kikuldeshez_kapcsolasa]]',
                cols: 2,
                rows: 2,
            },
            buttons: [
                {
                    name:"[[$t.kapcsolas]]",
                    id: 'btn_kapcsol_eszkoz',
                    visibility: function() {return 1},
                    callback: function() {
                        var valid = validateForm($('#eszkoz_kapcsol_from'));
                        if(valid) {
                            eszkozKapcsol(elem, data);
                        }
                    },
                    type: 'save',
                },
                {
                    name:"[[$t.vissza]]",
                    id: 'btn_cancel_kapcsol_eszkoz',
                    visibility: function() {return 1},
                    callback: function() {
                        close_pop_up();
                    },
                    addClasses: 'btn-alt',
                    type: 'cancel',
                }

            ],
            inputs: [
                {"col": 0, "row": 0, "colspan": 2, "input": '<p>[[$t.html_kikuldes_eszkoz_info]]</p>'},
                {"col": 0, "row": 1, "input": filterSelectHtml({
                                                id: 'onilne_eszkoz_mod_input',
                                                placeholder: '[[$t.valassz]]',
                                                label: '[[$t.eszkoz]]',
                                                name: 'onilne_eszkoz_mod_input',
                                                maxOptions: 1,
                                                addclass: 'form',
                                                required: true,
                                            },
                                            filterSelectValues(ONLINE_ESZKOZOK, "nev" ,"id")
                                        )},
            ],
    });

    $('.selectpicker').selectpicker();
    if(data.eszkoz_id != null) {
        $('#onilne_eszkoz_mod_input').val(data.eszkoz_id);
        $('#onilne_eszkoz_mod_input').selectpicker('refresh');
    }
} 

function showIsmerv(elem, data) {
    var ajax_obj = {
        "echo": "1",
        "ismerv_csoport_id": data.ismerv_csoport_id
    };

    var resultText = {};

    postApi('ismervek_sel',ajax_obj,elem,resultText,null,function(result){
        var html = '<p>[[$t.kikuldott_ismervek_info]]</p>';
        html += '<ul>';
        for(var i in result.data) {
            html += '<li>'+result.data[i].nev+'</li>';
        }
        html += '</ul>';
        gi_alert(html);
    });
}

function eszkozKapcsol(elem, data) {
    var ajax_obj = {
        "echo": '1',
        "beolvasas_id": data.id,
        "eszkoz_id": $('#onilne_eszkoz_mod_input').val()[0]
    };

    var resultText = {};

    postApi('beolvasas_eszkoz_set',ajax_obj,elem,resultText,null,function(result){
        kikuldes_fejek.ajax.reload();
        close_pop_up();
    });
}

function kikuldes(elem, data) {
    console.log("data ",data);
    var obj = {
        header: '[[$t.confirm]]',
        content: '[[$t.kikuldes_megerosites]]',
        buttons: {
            'ok': {
                label: '[[$t.ok]]',
                css_class: 'btn-main',
                call_this: function(){
                    var ajax_obj = {
                        "beolvasas_id": data.id
                    };
                
                    var resultText = {};
                
                    postApi('kikuldes',ajax_obj,elem,resultText,null,function(result){
                        kikuldes_fejek.ajax.reload();
                        close_pop_up();
                        console.log({result});
                        if(result.EREDMENY == 'OK') {
                        } else {
                            close_pop_up();
                            setTimeout(function() {
                                if(result.KOD == "nincs_sablon") {
                                    gi_alert('[[$t.nincs_sablon_kapcsolva]]');
                                }
                                if(result.KOD == "sms_hiba") {
                                    gi_alert('[[$t.sms_hiba]]');
                                }
                            }, 10);
                        }
                        
                    });

                }
            },
            'cancel': {
                label: '[[$t.cancel]]',
                css_class: 'btn-alt',
                call_this: function(){
                    close_pop_up();
                }
            }
        }
    };
    g_pop(obj);
}

function initGrafikon(stats) {
    if(isDefined(stats)) {

        var height = 500;
        var width = window.innerWidth * 0.6;

        $('.grafikon-part-1').append('<div style="margin:auto;height:'+height+'px; width:'+width+'px"><canvas id="stat-chart" height="'+height+'" width="800"></canvas></div>');

        var ctx = document.getElementById("stat-chart");
        ctx.height = height;
 

        var lebontasok = [
            "[[$t.cimzettek_szama]]",
            "[[$t.fogadottak_szama]]",
            "[[$t.meghiusultak_szama]]",
            "[[$t.megnyitottak_szama]]",
            "[[$t.link_kattintasok_szama]]",
            "[[$t.unsubscribe_szama]]"
        ];

        new Chart(document.getElementById('stat-chart'), {
            type: "bar",
            data: {
                labels: lebontasok,
                datasets: [{
                    label: '',
                    barPercentage: 0.5,
                    barThickness: 6,
                    maxBarThickness: 8,
                    minBarLength: 2,
                    data: [stats.recipientcount, stats.sentcount, stats.failedcount, stats.openedcount, stats.clickedcount, stats.unsubscribedcount],
                    backgroundColor: ['#4bb0cf','#4bb0cf', '#4bb0cf', '#4bb0cf', '#4bb0cf', '#4bb0cf'],
                    datalabels: {
                        color: '#fff',
                        font: {
                            size: 20,
                          }
                    }
                }]
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                    display: false
                },
                tooltips: {
                    enabled: false
                },
                responsive: true,
                layout: {
                    padding: {
                        left: 10,
                        right: 10,
                        top: 0,
                        bottom: 0
                    }
                },
                scales: {
                    yAxes: [
                        {
                            gridLines: {
                                color: "rgba(0, 0, 0, 0)",
                            },
                            ticks: {
                                fontColor: 'transparent'
                            }
                        }
                    ],
                    xAxes: [
                        {
                            ticks: {
                                padding: 20,
                                fontSize: 14,
                                fontColor: "#000",
                                fontFamily: "'Ubuntu', sans-serif"
                            },
                            gridLines: {
                                color: "rgba(0, 0, 0, 0)",
                            }
                        },
                    ]
                }
            }
        });

        var height = 500;
        var width = window.innerWidth * 0.6;

        $('.grafikon-part-2').append('<div style="margin:auto;height:'+height+'px; width:'+width+'px"><canvas id="stat-chart-2" height="'+height+'" width="800"></canvas></div>');

        var ctx = document.getElementById("stat-chart-2");
        ctx.height = height;

        new Chart(document.getElementById('stat-chart-2'), {
            type: "bar",
            data: {
                labels: ['[[$t.kezbesitettek_aranya]]', '[[$t.megnyitottak_aranya]]'],
                datasets: [{
                    label: '',
                    barPercentage: 0.5,
                    barThickness: 6,
                    maxBarThickness: 8,
                    minBarLength: 2,
                    data: [stats.deliveredpercentage.toFixed(1), stats.openedpercentage.toFixed(1)],
                    backgroundColor: ['#4bb0cf', '#4bb0cf'],
                    datalabels: {
                        color: '#fff',
                        font: {
                            size: 20,
                          }
                    }
                }]
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                    display: false
                },
                responsive: true,
                layout: {
                    padding: {
                        left: 10,
                        right: 10,
                        top: 0,
                        bottom: 0
                    }
                },
                tooltips: {
                    enabled: false
                },
                plugins: {
                    datalabels: {
                        formatter: (value, ctx) => {
                            return value+'%';
                        },
                    }
                },
                scales: {
                    yAxes: [
                        {
                            gridLines: {
                                color: "rgba(0, 0, 0, 0)",
                            },
                            ticks: {
                                fontColor: 'transparent',
                                min: 0,
                                max: 100
                            }
                        }
                    ],
                    xAxes: [
                        {
                            barThickness: 100,
                            ticks: {
                                padding: 20,
                                fontSize: 14,
                                fontColor: "#000",
                                fontFamily: "'Ubuntu', sans-serif"
                            },
                            gridLines: {
                                color: "rgba(0, 0, 0, 0)",
                            }
                        },
                    ]
                }
            }
        });
    }
}

function statisztikaShow(show, statChannel) {
    $('.grafikon-part-1, .grafikon-part-2').html('');
    if(show) {
        $('#kikuldes_statisztikak').closest('.table-holder').removeClass('d-none');
        kikuldes_statisztikak.ajax.reload();
    } else {
        $('#kikuldes_statisztikak').closest('.table-holder').addClass('d-none');
    }
}

function getBeolvasasSorok(callback) {
    if(selectedRowId('#kikuldes_fejek')) {
        var kikuldesId = selectedRowId('#kikuldes_fejek');
        var data = {
            "echo": "1",
            "beolvasas_id":  function() { return kikuldesId; }
        };
    
        var resultText = {};
    
        postApi('beolvasas_sorok_sel',data,$('#kikuldes_fejek'),resultText,null,function(sorResult){
            var innerData = {
                "echo": "1",
                "beolvasas_idk":  function() { return JSON.stringify([kikuldesId]); }
            };
            postApi('beolvasas_tetel_ismervek_sel',innerData,$('#kikuldes_fejek'),resultText,null,function(ismervResult){
                var ret = [];
                for(var i in sorResult.data) {
                    var obj = {
                        "user_id": sorResult.data[i].user_id,
                        "user_email": sorResult.data[i].user_email
                    };

                    var ismervek = filterArray(ismervResult.data, 'beolvasas_sorok_id', sorResult.data[i].id);
                    for(var j in ismervek) {
                        obj['ismerv_'+ismervek[j].ismerv_id] = ismervek[j].beolvasott_ismerv;
                    }

                    ret.push(obj);
                }

                callback({
                    data: ret
                });

            });
        });
    }
    
}

function sablonKapcsolForm(elem, kapottData) {

    var data = {
        "csak_aktivakat": "1",
        "partner_id": function() { return $('#partner_select_input').val()[0] }
    };

    var resultText = {};

    postApi('email_sablonok_sel',data,elem,resultText,null,function(result){
        var sablonok = result;

        popupForm({
            inic_param: {
                    id: 'sablon_kapcsol_form',
                    title: '[[$t.email_sablon_kikuldeshez_kapcsolasa]]',
                    cols: 2,
                    rows: 2,
                },
                buttons: [
                    {
                        name:"[[$t.kapcsolas]]",
                        id: 'btn_kapcsol_sablon',
                        visibility: function() {return 1},
                        callback: function() {
                            var valid = validateForm($('#sablon_kapcsol_form'));
                            if(valid) {
                                sablonKapcsol(elem, kapottData);
                            }
                        },
                        type: 'save',
                    },
                    {
                        name:"[[$t.vissza]]",
                        id: 'btn_cancel_kapcsol_sablon',
                        visibility: function() {return 1},
                        callback: function() {
                            close_pop_up();
                        },
                        addClasses: 'btn-alt',
                        type: 'cancel',
                    }
    
                ],
                inputs: [
                    {"col": 0, "row": 0, "colspan": 2, "input": '<p>[[$t.html_kikuldes_sablon_info]]</p>'},
                    {"col": 0, "row": 1, "input": filterSelectHtml({
                                                    id: 'sablon_select_input',
                                                    placeholder: '[[$t.valassz]]',
                                                    label: '[[$t.email_sablon]]',
                                                    name: 'sablon_select_input',
                                                    maxOptions: 1,
                                                    addclass: 'form',
                                                    required: true,
                                                },
                                                filterSelectValues(sablonok, "nev" ,"id")
                                            )},
                ],
        });

        $('.selectpicker').selectpicker();
        if(data.sablon_id != null) {
            $('#sablon_select_input').val(data.sablon_id);
            $('#sablon_select_input').selectpicker('refresh');
        }

    });
}

function sablonKapcsol(elem, data) {
    var ajax_obj = {
        "beolvasas_id": data.id,
        "sablon_id": $('#sablon_select_input').val()[0]
    };

    var resultText = {};

    postApi('beolvasas_sablon_set',ajax_obj,elem,resultText,null,function(result){
        kikuldes_fejek.ajax.reload();
        close_pop_up();
    });
}
    