var editor;
var selected_text_id = -1;
var changed_ids = new Array();
$(document).ready(function(){

    editor = ckeditor_install('ta');

    $(window).bind('scroll.save_holder',function(){
        set_setting_save_holder();
    });

    $(window).bind('resize.save_holder',function(){
        set_setting_save_holder();
    });

    $('#language').change(function(){
        location.href = "/" + act_lang + "/admin-texts/"+$('#language').val()+"/";
    });

    $('.translate_area').bind('change input propertychange keyup',function(){
        $(this).parents('tr').addClass('js_translate_changed');
        set_setting_save_holder();
    });

    $('#filter').bind('input',function(){
        var text = $(this).val().toLowerCase();
        if(text.length > 2){
            $('#lang_table tbody tr').addClass('row_hidden_f');
            var found = false;
            $('#lang_table tbody td').each(function(index){
                if($(this).text().toLowerCase().indexOf(text) != -1 ||
                    ($(this).children('.translate_area').length > 0 &&
                        $(this).children('.translate_area').val().toLowerCase().indexOf(text) != -1)){
                    found = true;
                    $(this).parent().removeClass('row_hidden_f');
                }
            });
            for(var i in lang_array_json){
                if(i.toString().indexOf('html_') == 0 && (lang_array_json[i] != null && $('<textarea />').html(lang_array_json[i]).text().toLowerCase().indexOf(text) != -1)){
                    $('#text_id_'+i).parents('tr').removeClass('row_hidden_f');
                    found = true;
                }
            }
            if(found){
                $('#lang_table tfoot tr').addClass('row_hidden_f');
            }
            else{
                $('#lang_table tfoot tr').removeClass('row_hidden_f');
            }
        }
        else{
            $('#lang_table tbody tr').removeClass('row_hidden_f');
        }
        set_setting_save_holder();
    });

    $('#btn_save').click(function(){
        var datas = {};
        var ishtml = new Array();
        $('tr.js_translate_changed').each(function(){
            datas[$(this).children('td:first-child').children('.lang_labels').text()] = $(this).find('.translate_area').val();
            ishtml.push(0);
        });

        for(var i in changed_ids){
            datas[changed_ids[i]] = lang_array_json[changed_ids[i]];
            ishtml.push(1);
        }

        ishtml = ishtml.join('');
        gAjax('szovegek_mentes',{ lang: p_lang, texts : datas, ishtmls: ishtml},$(this),function(d){
            if(d[0] == 'OK'){
                location.reload();
            }
        },null,function(d){
            if(d[0] === 'OK'){

            }
        });
    });

    $('#btn_discard').click(function(){
        location.reload();
    });

    $('#new_only').bind('change', function(){
        if(!$(this).is(':checked')){
            $('#lang_table tbody tr').removeClass('row_hidden_n');
        }
        else{
            $('#lang_table tbody tr').addClass('row_hidden_n');
            $('.new_label').removeClass('row_hidden_n');
        }
        set_setting_save_holder();
    });

    $('#html_only').bind('change', function(){
        if(!$(this).is(':checked')){
            $('#lang_table tbody tr').removeClass('row_hidden_h');
        }
        else{
            $('#lang_table tbody tr').addClass('row_hidden_h');

            $('.text_label').each(function(index){
                if($(this).text().substr(0,5) === 'html_'){
                    $(this).parent().parent().removeClass('row_hidden_h');
                }
            });
        }

        set_setting_save_holder();
    });

    for(var i = 0; i < unused_labels.length; i++){
        $('tr .lang_labels').each(function( index ) {
            if($(this).text() == unused_labels[i]){
                $(this).parent().parent().addClass('table-danger');
                $(this).parent().parent().addClass('unused_label');
                $(this).parent().parent().addClass('new_label');
                $(this).parent().append('<button class="btn btn-danger float-right delete_label ajax" onclick="delete_label(this,\''+unused_labels[i]+'\')">[[$t.delete]]</div>');
            }
        });
    }

    for(var i in lang_array_json){
        if(i.toString().indexOf('html_') == 0 && (lang_array_json[i] == null || lang_array_json[i] == " ")){
            $('#text_id_'+i).parents('tr').addClass('new_label');
        }
    }

    $('.translate_area').each(function( index ) {
        if($(this).val().length == 0){
            $(this).parent().parent().addClass('new_label');
        }
    });

    set_setting_save_holder();

    if(csak_az_ujakat){
        $('#new_only')[0].checked = true;
        $('#new_only').trigger('change');
    }

    if($('.unused_label').length > 0){
        $('#btn_clear_trash').click(function(){
            var delete_labels = new Array();
            $('.unused_label td:first-child .lang_labels').each(function(){
                delete_labels.push($(this).text());
            });

            delete_label($(this),delete_labels.join(';'));
        });
    }
    else{
        $('#btn_clear_trash').remove();
    }

    handleCacheClear('szovegek_cache_del');

    $('#html_only').trigger('change');
    $('#new_only').trigger('change');

    $("#btn_export").click(function(){
		call_ajax_szovegek_export(this);
    });

    $("#btn_import").click(function(){
		var obj = {
			header: '[[$t.text_import]]',
			content: $('#export_import_part').html(),
			buttons: {
				'ok': {
					label: '[[$t.ok]]',
					css_class: 'btn-primary',
					call_this: function(){
						call_ajax_szovegek_import(this);
					}
				},
				'cancel': {
					label: '[[$t.cancel]]',
					call_this: function(){
						close_pop_up();
					}
				}
			},
			callback: function(){
				$('#messageModal .a_json').text('');
			}
		};
		g_pop(obj);
    });
});

function ck_edit(button){
    var text_id = $(button).attr('id').replace('text_id_','');
    selected_text_id = text_id;
    changed_ids.push(text_id);

    var text = lang_array_json[text_id];

    if(text == null){
        text = '';
    }

    show_ta(text);
}

function show_ta(text){
    $('#ckModalLabel').text(selected_text_id);
    CKEDITOR.instances['ta'].setData(text);
    $('#ckModal').modal('show');
}

function hide_ta(no_save){
    $('#ckModal').modal('hide');
    if(no_save != 0 && selected_text_id != -1){
        lang_array_json[selected_text_id] = editor.getData();
    }
    selected_text_id = -1;
}

function delete_label(elem,d_label){
    postApi('szovegek_label_del',{ label: d_label},elem,null,null,function(d){
        if(d.EREDMENY == 'OK'){
            if($(elem).hasClass('delete_label')){
                $(elem).parents('.unused_label').fadeOut('fast',function(){
                    $(this).remove();
                });
            }
            else{
                $(elem).hide();
                $('.delete_label').parents('.unused_label').each(function(){
                    $(this).fadeOut('fast',function(){
                        $(this).remove();
                    });
                });
            }
        }
    });
}

function set_setting_save_holder(){
    var padding = 0;
    var bottom = $(document).scrollTop() + $(window).height() - $('#admin_center').offset().top - $('#admin_center').outerHeight(true);
    var mh = bottom + $('#admin_center').outerHeight(true);

    bottom -= padding;
    if(bottom < -$('#save_holder').outerHeight() && mh > padding){
        if(!$('#save_holder').hasClass('save_holder_fixed')){
            $('#save_holder').addClass('save_holder_fixed');
            var pb = $('#admin_center').css('padding-bottom').replace('px','')*1 + $('#save_holder').outerHeight();
            $('#admin_center').css('padding-bottom',pb);
        }
    }
    else{
        $('#save_holder').removeClass('save_holder_fixed');
        $('#admin_center').css('padding-bottom','');
    }
    $('#save_holder').css('max-width',$('#admin_center').width());
}

function call_ajax_szovegek_export(elem){
    var ajax_data = {};

    postApi('szovegek_export',ajax_data,elem,null,null,function(d){
        if(d[0] === 'OK'){
			var obj = {
				header: '[[$t.text_export]]',
				content: $('#export_import_part').html(),
				buttons: {
					'copy': {
						label: '[[$t.copy]]',
						css_class: 'btn-primary',
						call_this: function(){
						}
					},
					'cancel': {
						label: '[[$t.cancel]]',
						call_this: function(){
							close_pop_up();
						}
					}
				},
				callback: function(){
					$('#messageModal .a_json').text(d[1]);
					$('#pop_btn_copy').attr('data-clipboard-target', '#messageModal .a_json');
					new ClipboardJS('#pop_btn_copy');
				}
			};
			g_pop(obj);
        }
        else{
            gi_alert('[[$t.incorrect_value]]');
        }
    });
}

function call_ajax_szovegek_import(elem){
    var ajax_data = {
        "json": $('#messageModal .a_json').val()
    };

    if(ajax_data.json.length > 0){
        postApi('szovegek_import',ajax_data,elem,null,null,function(d){
            if(d[0] === 'OK'){
                close_pop_up();
                page_reload();
            }
            else{
                gi_alert('[[$t.incorrect_value]]');
            }
        });
    }
    else{
        close_pop_up();
    }
}