<?php

    ini_set('max_execution_time', 180);

    if(!isset($g['parameters'][0])){
        \GI\Functions::go('szovegek/'.GI_DEFAULT_LANG);
    }

    $cache_file = GI_PATH_CACHE . 'texts_'.$g['parameters'][0].'_cache.txt';
    if (!file_exists($cache_file)) {

        //collect used text elements
        $files = array(
            GI_PATH_INDEX ."header.html",
            GI_PATH_INDEX ."body.html",
            GI_PATH_INDEX ."script.php.js",
        );
        $js_files = array_diff(scandir(GI_PATH_INDEX_JS),array('.','..'));
        foreach($js_files as $js_file){
            $files []= GI_PATH_INDEX_JS.'/'.$js_file;
        }
        $modules = array_diff(scandir(GI_PATH_SITE_MODULES),array('.','..'));
        foreach($modules as $module){
            $files []= GI_PATH_SITE_MODULES.$module.'/template.html';
            $files []= GI_PATH_SITE_MODULES.$module.'/script.js';
            $files []= GI_PATH_SITE_MODULES.$module.'/style.css';
            $files []= GI_PATH_SITE_MODULES.$module.'/script.php.js';
        }

        $texts = array();

        foreach($files as $file){
            $filecontent = file_get_contents($file);
            preg_match_all('/\[\[\$t\.([a-z0-9_]+)\]\]/',$filecontent,$matches);
            $texts = array_merge($texts,$matches[1]);
        }

        //other

        // rendszerparameterek szovegei
        $rparams = $g['db_db']->get_rendszerparameter_labels();

        foreach($rparams as $rparam){
            $texts[] = 'rendszerparameter_' . $rparam['name'];
        }

        // email kuldesek szovegei
        $texts[]='elf_email_targy';
        $texts[]='html_elf_email_uzenet';
        $texts[]='kapcs_email_targy';
        $texts[]='html_kapcs_email_uzenet';

        //other end

        $texts = array_values(array_unique($texts));

        sort($texts);

        $admin_lang_list = $g['db_db']->get_admin_lang_list();
        $tmp = array_column($admin_lang_list,'lang_code');
        foreach($tmp as $p_language){
            $szovegek = $g['db_db']->get_texts($p_language);
            $szovegek_labelek = array_column($szovegek, 'label');
            foreach($texts as $text){
                if (!in_array($text, $szovegek_labelek)) {
                    $g['db_db']->insert_text($p_language,$text);
                    if(substr($text,0,5)==='html_'){
                        $g['db_db']->set_texts('1','','1',' ',$text,$p_language);
                    }
                }
            }
        }

        file_put_contents($cache_file, json_encode($texts));
    } else {
        $texts = json_decode(file_get_contents($cache_file), true);
    }

    //get labels which are in the db, but not in the code
    $db_texts = \UserFunctions::get_texts($g['parameters'][0]);
    $db_texts_def = \UserFunctions::get_texts(GI_DEFAULT_LANG);
    $db_texts_def = array_combine(array_column($db_texts_def, 'label'), array_column($db_texts_def, 'text'));

    $texts_to_hide = [];

    //other
    if (in_array($g['srv'], ['test', 'prod'])) {
        $texts_to_hide = [
            'html_help_dev-ajax-tester',
            'dev',
            'dev_ajax_tester',
            'ajax_name',
            'ajax_result',
            'generalt_js_kod',
            'ajax_export'
        ];
    }

    //hide texts
    foreach ($db_texts as $k => $dbt) {
        if (in_array($dbt['label'], $texts_to_hide)) {
            unset($db_texts[$k]);
        } else {
            $db_texts[$k]['text_def'] = array_key_exists($dbt['label'], $db_texts_def) ? $db_texts_def[$dbt['label']] : '';
        }
    }
    $db_texts = array_values($db_texts);

    //hide texts 2
    foreach ($texts_to_hide as $k => $tth) {
        if (array_key_exists($tth, $db_texts_def)) {
            unset($db_texts_def[$tth]);
        }
    }

    $garbage = array_diff(array_column($db_texts,'label'),$texts);

    $html_only_on = $g['db_db']->get_one_rendszerparameter('html_only_on')[0]['ertek'];
    $g['te']->add('html_only_on', $html_only_on);

    $new_only_on = $g['db_db']->get_one_rendszerparameter('new_only_on')[0]['ertek'];
    $g['te']->add('new_only_on', $new_only_on);

    $g['te']->add('unused_labels',json_encode(array_values($garbage)));
    $g['te']->add('p_lang',$g['parameters'][0]);
    $g['te']->add('lang_array',$db_texts);
    $g['te']->add('csak_az_ujakat',isset($g['parameters'][1])?1:0);
    $g['te']->add('lang_array_json',json_encode(array_combine(array_column($db_texts,'label'),array_column($db_texts,'text_html'))));
