var telephelyek = null;
var regiok = null;
var valasszthato_telephelyek = null;
$(document).ready(function() {
	valasszthato_telephelyek = {
		table:{
			right:'telephelyek_hozzarendelese_regiokhoz',
			canSelect:true,
			selectType:'multiple',
			selectCol:'kivalasztva'
		},
		data: valasszthato_telephelyek_sel,
		columns:[
			{ headName:"", type:"details"},
			{ headName:"[[$t.nev]]", colName:"nev" },
			{ headName:"[[$t.email]]", colName:"email", inDetails:true },
			{ headName:"[[$t.telefon]]", colName:"telefon", inDetails:true },
			{ headName:"[[$t.orszag]]", colName:"orszag", inDetails:true },
			{ headName:"[[$t.iranyitoszam]]", colName:"iranyitoszam", inDetails:true },
			{ headName:"[[$t.telepules]]", colName:"telepules", inDetails:true },
			{ headName:"[[$t.cim]]", colName:"cim", inDetails:true },
			{ headName:"[[$t.partner_nev]]", colName:"partner_nev", inDetails:true },
		], 
	};

	telephelyek = dataTable($('#telephelyek'),{
		table:{
			hide:true,
			name:'[[$t.regiok_telephelyei]]',
			right:'regiok_telephelyeinek_megtekintese'
		},
		ajax:{
			name:'regiok_telephelyei_sel',
			data:{
				"echo": "1",
                "regio_sn": function() { return selectedRowId('#regiok'); }
			},
			onInicCall:false,
            transform: function(data){
                if(act_lang != 'hu'){
                    for(var i in data){
                       data[i].orszag = findInArray(orszagok,'id',data[i].fk_orszag)['nev_angol'];
                    }
                }
                return data;
            }
		},
		columns:[
			{ headName:"", type:"details"},
			{ headName:"[[$t.nev]]", colName:"nev" },
			{ headName:"[[$t.email]]", colName:"email" },
			{ headName:"[[$t.telefon]]", colName:"telefon" },
			{ headName:"[[$t.orszag]]", colName:"orszag", filterType:"select-orszagok" },
			{ headName:"[[$t.iranyitoszam]]", colName:"iranyitoszam" },
			{ headName:"[[$t.telepules]]", colName:"telepules" },
			{ headName:"[[$t.cim]]", colName:"cim" },
			{ headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma", inDetails:true, isDateFormat: true },
			{ headName:"[[$t.letrehozo]]", colName:"letrehozo", inDetails:true },
		],
		buttons: [
			{
				name: "[[$t.regiok_telephelyeinek_kezelese]]",
				id: 'add_telephely',
				dataRight: 'telephelyek_hozzarendelese_regiokhoz',
				type: "new",
				visibility: function() {return 1;},
				callback: function() {
					$(this).prop('disabled',true);
					$(this).addClass('remove_disable');
					popupTable(valasszthato_telephelyek,onSave,onCancel);
				},
			}
		]
	});


	/*Régiók*/
	regiok = dataTable($('#regiok'),{
		table:{
			name:'[[$t.regiok]]',
			right:'regiok_megtekintese'
		},
		ajax:{
			name:'regiok_sel',
			data:{
				"echo": "1"
			},
		},
		functions:{
			edit:{
				ajax:"regiok_modositasa",
				right:"regiok_modositasa",
				data:{
					'#id':'regio_sn',
					'#data':'regio_nev',
				},
				text:{

				}
			},
            delete:{
                ajax:"regiok_torlese",
                right:"regiok_torlese",
                data:{
                    '#id':'regio_sn'
                }
            }
		},
		columns:[
			{ headName:"[[$t.nev]]", colName:"nev", canEdit:true },
			{ headName:"[[$t.partner_nev]]", colName:"partner_nev" },
			{ headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            } },
			{ headName:"[[$t.letrehozo]]", colName:"letrehozo" },
		],
		detailTables:[
			{table:telephelyek}
		],
		forms: [
			{
				inic_param : {
					id: 'regiok_new',
					dataRight: 'regiok_letrehozasa',
					title: '[[$t.uj_regio]]',
					cols: 1,
					rows: 2,
					position: 'bottom'
				},
				buttons: [
							{
								name:"[[$t.mentes]]",
								id: 'btn_save',
								type: 'save',
								ajaxReload: true,
								visibility: function() {return 1},
								callback: function(valid) {
									if(valid) {
										ajax_call_regiok_letrehozasa($('#btn_save'));
									}
								},
								onCustomAjaxDone: function(event,result,trigger){
									if(result.EREDMENY=='OK'){
										clearForm('regiok_new');
										$('#new_regio_button').removeClass('disabled');
										$('#new_regio_button').prop('disabled',false);
									}
									else if(result.EREDMENY=='HI'){
										gi_alert(result.UZENET);
									}
								},
							},
							{
                                name:"[[$t.vissza]]",
								id: 'btn_cancel',
								addClasses: 'btn-alt',
								type: 'cancel',
								toggleId: 'regiok_new',
								visibility: function() {return 1},
								callback: function() {
									clearForm('regiok_new');
									$('#new_regio_button').removeClass('disabled');
									$('#new_regio_button').prop('disabled',false);
								},
							}
						],
				inputs: [
							{"col": 0, "row": 0, "input": inputHtml({
																id: 'name_input',
																label: '[[$t.nev]]',
																placeholder: '[[$t.nev]]',
																maxlength: 100,
																required: true,
																name: 'name_input',
																autofocus: false,
															})},
							{"col": 0, "row": 1, "input": filterSelectHtml({
                                                                id: 'partner_input',
                                                                name: 'partner_input',
                                                                placeholder: '[[$t.valassz]]',
                                                                label: '[[$t.partner]]',
                                                                maxOptions: '1',
                                                                addclass: 'form',
                                                                required: !hasRight('admin')
                                                            },
                                                            filterSelectValues(valaszthato_partnerek_regio_new, 'nev', 'id')
														  )}
						],

			}
		],
		buttons: [
			{
                name: "[[$t.uj_regio]]",
                id: 'new_regio_button',
                dataRight: 'regiok_letrehozasa',
                toggleId: 'regiok_new',
                type: "new",
                visibility: function() {return 1;},
                callback: function() {},
			}
		]
	});
});

function ajax_call_regiok_letrehozasa(element){
    var data = {
		"partner_sn":$('#partner_input').val()[0],
        "regio_nev": $('#name_input').val()
    };

    var resultText = {
    };
    postApi('regiok_letrehozasa',data,element,resultText);
}

function valasszthato_telephelyek_sel(callback,element){
    /*var length = telephelyek.rows()[0].length;
    for(var i in hozzarendelheto_telephelyek){
        hozzarendelheto_telephelyek[i].kivalasztva = 0;
        for(var j = 0; j < length; j++){
            if(hozzarendelheto_telephelyek[i].id == telephelyek.rows().data()[j].id){
                hozzarendelheto_telephelyek[i].kivalasztva = 1;
                break;
            }
        }
	}
	console.log(hozzarendelheto_telephelyek);*/
	var telephelyek_arr = [];
	var fk_partner = regiok.rows({selected: true}).data()[0].fk_partner;
	var length = telephelyek.rows()[0].length;

	for(var i in hozzarendelheto_telephelyek) {
		if(hozzarendelheto_telephelyek[i].fk_partner == fk_partner) {
			hozzarendelheto_telephelyek[i].kivalasztva = 0;
			for(var j = 0; j < length; j++){
				if(hozzarendelheto_telephelyek[i].id == telephelyek.rows().data()[j].id){
					hozzarendelheto_telephelyek[i].kivalasztva = 1;
					break;
				}
			}
			telephelyek_arr.push(hozzarendelheto_telephelyek[i]);
		}
	}
    callback({data: telephelyek_arr});
}

function onSave(){
	var telephelystruktura = [];
	$('#popup_table').DataTable().rows().every(function ( rowIdx, tableLoop, rowLoop ){
		telephelystruktura.push({telephely_sn: this.data().id*1, hozzaadas: this.data().kivalasztva == 1});
	});

	var data = {
		regio_sn : selectedRowId('#regiok'),
		telephelystruktura: JSON.stringify(telephelystruktura)
	};

	var text = {
		nem_ok_telephely_sn : "[[$t.telehely_nem_rendelheto_regiohoz]]",
	};

	postApi('telephelyek_hozzarendelese_regiokhoz',data,$('#pop_btn_ok'),text,null,function(result){
        if(result.EREDMENY == 'OK'){
            telephelyek.ajax.reload();
            close_pop_up();
        }
	});
}
function onCancel(){
	$('#add_telephely').prop('disabled',false);
	close_pop_up();
}