var kerdoivek = null;
var struct;
var sorrend = [];
var timeout;
var interval;
var innerTimer;

var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);

var VALASZTHATO_ESZKOZOK = [];



$(document).ready(function() {

    var globalTimer;
    kerdoivek = dataTable($('#kerdoivek'),{
        table:{
            name:'[[$t.kerdoivek]]',
            right:'kerdoivek_megtekintese',
            canSelect: true
        },
        ajax:{
            name:'kerdoivek_sel',
            data:{
                "echo": "1"
            },
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev" },
            { headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            } },
            { headName:"[[$t.letrehozo]]", colName:"letrehozo" },
            { headName:"[[$t.partner]]", colName:"partner_nev", },
            { headName:"[[$t.aktiv]]", colName:"aktiv", type:"checkbox", filterType:"checkbox"}
        ],

        forms: [
            {
                inic_param: {
                        id: 'kerdoiv_view',
                        dataRight: 'kerdoiv_megtekintese',
                        title: '[[$t.kerdoiv_megtekintese]]',
                        cols: 2,
                        rows: 1,
                        position: 'bottom'
                    },
                    buttons: [
                        {
                            name:"[[$t.megtekintes]]",
                            id: 'btn_view_kerdoiv',
                            visibility: function() {return 1},
                            callback: function(valid) {
                                if(valid) {
                                    var eszkoz_azon = $('#kerdoiv_eszkoz_select_input').val()[0];
                                    if(isDefined(eszkoz_azon)) {
                                        var eszkozLink = window.location.origin + '/' + act_lang + '/kerdoiv-elonezet/' + eszkoz_azon;
                                        window.open(eszkozLink, '_blank');
                                    }
                                }
                               
                            },
                            onCustomAjaxDone: function(event,result,trigger){
                                
                            },
                            type: 'save',
                        },
                        {
                            name:"[[$t.vissza]]",
                            id: 'btn_cancel_view_from',
                            visibility: function() {return 1},
                            callback: function() {
                                clearForm('kerdoiv_view');
                            },
                            addClasses: 'btn-alt',
                            type: 'cancel',
                            toggleId: 'kerdoiv_view'
                        }
        
                    ],
                    inputs: [
                        {"col": 0, "row": 0, "input": filterSelectHtml({
                                                            id: 'kerdoiv_eszkoz_select_input',
                                                            placeholder: '[[$t.valassz]]',
                                                            label: '[[$t.eszkoz]]',
                                                            name: 'kerdoiv_eszkoz_select_input',
                                                            maxOptions: 1,
                                                            addclass: 'form',
                                                            required: true
                                                        },
                                                        filterSelectValues(ESZKOZOK, "nev" ,"id")
                                                    )}
                    ],
            }
        ],

        buttons: [
            {
                name: "[[$t.kerdoiv_megtekintese]]",
                id: 'kerdoiv_megtekintese_button',
                dataRight: 'kerdoiv_megtekintese',
                visibility: 'onSelect',
                callback: function() {
                    valaszthatoEszkozSelectToltes();
                },
                type: "view",
                toggleId: 'kerdoiv_view',
			}
        ]
        
    });

    kerdoivek.on('select', function() {
        valaszthatoEszkozSelectToltes();
    });

    $(document).on('click', '#exit-view-form', function() {
        hideViewFormWindow();
        clearTimeout(timeout);
    });

   /*Kérdőíveknél következő oldalra lépés*/
   $(document).on('click', '.cf-next-button', function() {

        var kovetkezo = isDefined($(this).data('ugras')) ? $(this).data('ugras') : $(this).data('kovetkezo-sorrend');
        var valosKovetkezo = isDefined($(this).data('utolso')) ? $(this).data('utolso') : kovetkezo;
        /*TODO: utolsó oldal sorszáma ide*/
        
        var tobb_min = $(this).data('tobb-min'); 
        var tobb_max = $(this).data('tobb-max'); 
        
        if(isDefined(tobb_min) || isDefined(tobb_max)) {
            if($(this).data('tobb') >= tobb_min &&  $(this).data('tobb') <= tobb_max) {
                stepAnimation(valosKovetkezo,  $(this).data('lang'));
            }    
        } else {
            stepAnimation(valosKovetkezo,  $(this).data('lang'));
        }
        
    });

});
   


function valaszthatoEszkozSelectToltes() {
    if(kerdoivek != null) {
        var kivalasztottKerdoiv = kerdoivek.rows({selected: true}).data()[0];
        if(isDefined(kivalasztottKerdoiv) && kivalasztottKerdoiv != null) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kivalasztottKerdoiv.id);
            var eszkozok = ESZKOZOK.filter(function(elem){
                return elem.fk_kerdoivek == kerdoiv.id;
            });
            var ujSelectErtetek = filterSelectValues(eszkozok, 'nev', 'eszkoz_azonosito');
            refillSelect('kerdoiv_eszkoz_select_input',ujSelectErtetek);
        }
    }
}

