var jogcsoportok = null;
var jogok = null;

var ADHATO_JOGOK = [];
$.each(felhasznalo_jogai_szovegek, function(key, value) {
    ADHATO_JOGOK.push({
        kod: key,
        ertek: value
    });
});

ADHATO_JOGOK.sort(function(a, b) {
    var textA = a.ertek.toUpperCase();
    var textB = b.ertek.toUpperCase();
    return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
});

$(document).ready(function() {

    /*Új jogcsoport form*/
    var new_jogcsoport = {
        inic_param: {
            id: 'jogcsoportok_new',
            dataRight: 'jogcsoportok_kezelese',
            title: '[[$t.uj_jogcsoport]]',
            cols: 1,
            rows: 1,
            position: 'bottom'
        },
        buttons: [
            {
                name:"[[$t.mentes]]",
                id: 'btn_save_jogcsoport',
                type: 'save',
                ajaxReload: true,
                visibility: function() {return 1},
                callback: function(valid) {
                    if(valid){
                        ajax_call_jogcsoportok_new($('#btn_save_jogcsoport'));
                    }
                },
                onCustomAjaxDone: function(event,result,trigger){
                    if(result.EREDMENY=='OK'){
                        clearForm('jogcsoportok_new');
                    }
                    else if(result.EREDMENY=='HI'){
                        gi_alert(result.UZENET);
                    }
                },
            },
            {
                name:"[[$t.vissza]]",
                id: 'btn_cancel_jogcsoport',
                toggleId: 'jogcsoportok_new',
                addClasses: 'btn-alt',
                type: 'cancel',
                visibility: function() {return 1},
                callback: function() {
                    clearForm('jogcsoportok_new');
                },
            } 
        ],
        inputs: [
            {"col": 0, "row": 0, "input": inputHtml({
                                                id: 'jogcsoport_name_input',
                                                label: '[[$t.jogcsoport]]',
                                                placeholder: '[[$t.nev]]',
                                                maxlength: 50,
                                                required: true,
                                                name: 'jogcsoport_name_input',
                                                autofocus: false,
                                            })}
        ],
    };

    jogok = dataTable($('#jogok'),{
        table:{
            hide:true,
            name:'[[$t.jogcsoport_elemi_jogai]]',
            right:'jogcsoportok_kezelese'
        },
        ajax:{
            name:'jogcsoportok_jogok_sel',
            data:{
                "echo": "1",
                "jogcsoport_sn": function() { return selectedRowId('#jogcsoportok'); }
            },
            onInicCall:false
        },
        columns:[
            { headName:"[[$t.kod]]", colName:"kod" },
            { headName:"[[$t.nev]]", colName:"nev" },
            { headName:"[[$t.leiras]]", colName:"leiras" }
        ],
        buttons: [
            {
                name: "[[$t.jog_jogcsoport_rendeles]]",
                id: 'jog_jogcsoport_rendeles',
                dataRight: 'jogcsoportok_kezelese',
                type: "new",
                visibility: function() {return 1;},
                callback: function() {
                    $(this).prop('disabled',true);
					$(this).addClass('remove_disable');
                    jog_2_jogcsoport_rendeles();
                }
            }
        ]
    });

    jogcsoportok = dataTable($('#jogcsoportok'),{
        table:{
            name:'[[$t.jogcsoportjaim]]',
            right:'jogcsoportok_kezelese'
        },
        ajax:{
            name:'jogcsoportok_sel',
            data:{
                "echo": "1"
            },
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev" },
            { headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma" }
        ],
        detailTables:[
            {table:jogok}
        ],
        forms: [ new_jogcsoport ],
        buttons: [
            {
                name: "[[$t.uj_jogcsoport]]",
                id: 'new_jogcsoport_button',
                dataRight: 'jogcsoportok_kezelese',
                toggleId: 'jogcsoportok_new',
                type: "new",
                visibility: function() {return 1;},
                callback: function() {
                }               
            },
        ]
    });
});

function ajax_call_jogcsoportok_new(element){
    var data = {
        "jogcsoport_nev": $('#jogcsoport_name_input').val(),
    };

    var resultText = {
    };

    postApi('jogcsoportok_new',data,element,resultText);
}

function ajax_call_jogcsoportok_new_popup(element){
    var data = {
        "jogcsoport_nev": $('#jogcsoport_name_input_popup').val(),
    };

    var resultText = {
    };

    postApi('jogcsoportok_new',data,element,resultText);
}

/*Jogok hozzárendelése jogcsoporttokhoz - POPUP*/
function jog_2_jogcsoport_rendeles() {

    original_jogok = jogok.rows().data(); /*A kiválasztott felhasználó már létező jogai*/

    /*HTML előállítása*/
    var html = '<div>[[$t.jogcsoport_jog_kapcs_tip]]</div><div class="mb-3"></div>';

    for (var i in ADHATO_JOGOK) {
       /*Admin jogot és dev jogot nem lehet csoportba rendelni*/
        if(ADHATO_JOGOK[i].kod != 'admin' && ADHATO_JOGOK[i].kod != 'dev_funkciok') {
            var chk = checkboxHtml({
                id: 'gj-check-' + i,
                addClass: 'cf-jog-chk mr-2',
                checked: false,
                label: ADHATO_JOGOK[i].ertek
            });
            html += '<div class="cf-jog gj-' + ADHATO_JOGOK[i].kod + '" data-kod = ' + ADHATO_JOGOK[i].kod + '>' + chk + '</div>';    
        }
            

    }
    

    /*gi_alert(html);*/

    popupHtml(onSave,onCancel,{"content": html, is_modal_large: false});
    
    /*A kiválasztott felhasználó már meglévő jogait jelöljük meg*/

    for(var i in original_jogok){
        $('.gj-'+original_jogok[i].kod).find('label').find('input').prop('checked', true);
        $('.gj-'+original_jogok[i].kod).addClass('gj-orig');
    }

}

/*Hozzárenelés véglegesítése*/
function onSave() {
    var arr = get_jog_valtozasok(); /*az ajax bemenő paraméteréhez*/

    /*Ajax hívása*/
    var data = {
        "jogcsoport_sn": selectedRowId('#jogcsoportok'),
        "jogstruktura": JSON.stringify(arr)
    };

    var resultText = {
        nem_letezo_elemi_jog: '[[$t.nem_letezo_elemi_jog]'
    };

    postApi('jogcsoportok_jogok_hozzarendelese',data,$('#pop_btn_ok'),resultText,null,function(result){
        if(result.EREDMENY == 'OK'){
            jogok.ajax.reload();
            close_pop_up();
        } 
    });
}

function onCancel(){
    $('#jog_jogcsoport_rendeles').prop('disabled',false);
	close_pop_up();
}