/*2021.01.27. - Régiókat is szűrni kell jog alapján
  ezt csak telephelyeken keresztül lehet*/
  console.log(szurheto_adatok);
  szurheto_adatok.regiok = regioSzuresTelephelyekkel();
var REGIOK = objectToArray(szurheto_adatok.regiok);
var TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
var PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var KERDESEK = objectToArray(szurheto_adatok.kerdesek);
console.log("kerdesek: ",KERDESEK);

var GRAFIKON_ADATOK = [];

var jelentesek = null;

var validKerdesek = getValidKerdesek(KERDESEK, KERDOIVEK);
console.log("valid kerdesek: ",validKerdesek);

$(document).ready(function() {

    google.charts.load('current', {packages: ['corechart', 'bar']});

    var jelentes_szuro = {
        inic_param: {
                id: 'jelentes_szuro',
                cols: 4,
                rows: 3,
            },
            buttons: [
                {
                    name:"[[$t.szures]]",
                    id: 'btn_riport_szures',
                    type: 'filter',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            $('#jelentes-holder').html('');
                            $('#btn_riport_nyomtatas').removeClass('is-inactive');
                            $('#btn_riport_nyomtatas').prop('disabled', false);
                            $('.megjelenites-vezerles').removeClass('d-none');
                            $('.megjelenites-vezerles input').prop('checked', false);
                            GRAFIKON_ADATOK = [];
                            nyersAdatokLekeres();   
                        }
                        
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                },
                {
                    name:"[[$t.nyomtatas]]",
                    id: 'btn_riport_nyomtatas',
                    type: 'print',
                    addClass : 'mb-2',
                    visibility: function() {
                        return 0;
                    },
                    callback: function() {
                        var partnerId = $('#partner_select_input').val()[0];
                        var partner = findInArray(PARTNEREK, 'id', partnerId);
                        var reportData = {
                            type: 'line',
                            tipus: '[[$t.jelentesek_trend]]',
                            partner: partner
                        };
                        printData(reportData, 'line');
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                }
            ],
            inputs: [
                {"col": 2, "row": 0, "input": filterSelectHtml({
                                                                id: 'kerdoiv_select_input',
                                                                label: '[[$t.kerdoiv]]',
                                                                placeholder: '[[$t.mind]]',
                                                                name: 'kerdoiv_select_input',
                                                                maxOptions: 'inf',
                                                                addclass: 'form',
                                                            },
                                                            filterSelectValues(szurheto_adatok.kerdoivek, 'nev', 'id')
                                                        )
                 },
                 {"col": 0, "row": 0, "input": filterSelectHtml({
                                                    id: 'szuro_select_input',
                                                    label: '[[$t.lebontas]]',
                                                    placeholder: '[[$t.valassz]]',
                                                    name: 'szuro_select_input',
                                                    maxOptions: 1,
                                                    addclass: 'form',
                                                    required: true
                                                },
                                                [
                                                    {"name": '[[$t.het]]', "value": 'het'},
                                                    {"name": '[[$t.honap]]', "value": 'honap'},
                                                    {"name": '[[$t.negyedev]]', "value": 'negyedev'},
                                                    {"name": '[[$t.ev]]', "value": 'ev'}
                                                ]
                                            )
                                },
                {"col": 1, "row": 0, "input": filterSelectHtml({
                                    id: 'partner_select_input',
                                    label: '[[$t.partner]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'partner_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },
                {"col": 3, "row": 0, "input": filterSelectHtml({
                                                id: 'kerdes_select_input',
                                                label: '[[$t.kerdes]]',
                                                placeholder: '[[$t.mind]]',
                                                name: 'kerdes_select_input',
                                                maxOptions: 'inf',
                                                addclass: 'form',
                                            },
                                            filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false)
                                        )
                },
                {"col": 0, "row": 1, "input": filterSelectHtml({
                                    id: 'regio_select_input',
                                    label: '[[$t.regio]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'regio_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.regiok  , 'nev', 'id')
                            )
                },
                {"col": 1, "row": 1, "input": filterSelectHtml({
                                    id: 'telephely_select_input',
                                    label: '[[$t.telephely]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'telephely_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.telephelyek, 'nev', 'id')
                            )
                },
                {"col": 2, "row": 1, "input": filterSelectHtml({
                                    id: 'eszkoz_select_input',
                                    label: '[[$t.eszkoz]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'eszkoz_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.eszkozok, 'nev', 'id')
                            )
                },
                {"col": 0, "row": 2, "input": filterSelectHtml({
                                                    id: 'idoszak_select_input',
                                                    placeholder: '[[$t.mind]]',
                                                    label: '[[$t.idoszak]]',
                                                    name: 'idoszak_select_input',
                                                    maxOptions: '1',
                                                    addclass: 'form'
                                                },
                                                [
                                                    {name:'[[$t.ma]]', value:'ma'},
                                                    {name:'[[$t.elozo_nap]]', value:'tegnap'},
                                                    {name:'[[$t.utolso_het]]', value:'utolso_het'},
                                                    {name:'[[$t.utolso_honap]]', value:'utolso_honap'},
                                                    {name:'[[$t.ez_a_honap]]', value:'ez_a_honap'},
                                                    {name:'[[$t.elozo_honap]]', value:'elozo_honap'},
                                                    {name:'[[$t.ez_az_ev]]', value:'ez_az_ev'},
                                                    {name:'[[$t.egyeb]]', value:'sajat'}
                                                ]
                )},
                {"col": 1, "row": 2, "input": datepickerHtml({
                                                id: 'kezdo_datum_input',
                                                label: '[[$t.kezdo_datum]]',
                                                addClass: 'd-none'
                                            })
                },
                {"col": 2, "row": 2, "input": datepickerHtml({
                                    id: 'veg_datum_input',
                                    label: '[[$t.veg_datum]]',
                                    addClass: 'd-none'
                                })
                },
            ],
    };

    formHtml('#jelentes_szuro', jelentes_szuro.inic_param, jelentes_szuro.inputs, jelentes_szuro.buttons);

    /*Eseménykezelők*/
    /*Az egyedi datetimepicker csak akkor jelenik meg, ha az időszak választóban az Egyéb van kiválasztva*/
    $('#idoszak_select_input').on('change', function() {
        if($(this).val()[0] == 'sajat') {
            $('#kezdo_datum_input').parents('.dt-wrapper').removeClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').removeClass('d-none');
        } else {
            $('#kezdo_datum_input').parents('.dt-wrapper').addClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').addClass('d-none');
        }
    });

    $('.selectpicker').on('change', function() {
        selectUjraepites(this.id);
    });

    initDatepicker({id: 'kezdo_datum_input', dateOnly: true});
    initDatepicker({id: 'veg_datum_input', dateOnly: true});


    $('#szuro_select_input').selectpicker();
    $('#partner_select_input').selectpicker();
    $('#kerdoiv_select_input').selectpicker();
    $('#kerdes_select_input').selectpicker();
    $('#regio_select_input').selectpicker();
    $('#telephely_select_input').selectpicker();
    $('#eszkoz_select_input').selectpicker();
    $('#idoszak_select_input').selectpicker();

    initChartAndTableTogglers();

});

/*Nyers adatok lekérdezése*/
function nyersAdatokLekeres() {
    var kerdesek = $('#kerdes_select_input').val();
    
    if(kerdesek.length == 0) {
        kerdesek = [];
        $('#kerdes_select_input option').each(function() {
            /*kerdesek.push(findInArray(KERDESEK, 'id', $(this).val()));*/
            kerdesek.push($(this).val());
        });
    }

    var idoszak = $('#idoszak_select_input').val()[0];
    var telephelyIdk = $('#telephely_select_input').val();
    var regioIdk = $('#regio_select_input').val();

    var telephelyek = {};

    /*Ha telephely ki van választva, akkor a régió telephelyei nem kellenek*/
    if(telephelyIdk.length == 0) {
        for(var i in regioIdk) {
            var regio = szurheto_adatok.regiok[regioIdk[i]];
            for(var j in regio.telephelyek) {
                telephelyek[regio.telephelyek[j].id] = regio.telephelyek[j].id;
            }
        }
    }

    for(var i in telephelyIdk) {
        if(!isDefined(telephelyek[telephelyIdk[i]])) {
            telephelyek[telephelyIdk[i]] = telephelyIdk[i];
        }
    }

    var telephelyekTomb = [];
    $.each(telephelyek, function(kulcs, ertek) {
        telephelyekTomb.push(ertek);
    }); 


    var kerdoivek = $('#kerdoiv_select_input').val();
    if (kerdoivek.length == 0) {
        kerdoivek = [];
        $.each(szurheto_adatok.kerdoivek, function(index, kerdoiv){
            kerdoivek.push(kerdoiv.id);
        });
    }

    function call_jelentesek_sel_trend_szerint(ind) {
        var eszkoz_idk = $('#eszkoz_select_input').val();
        if (eszkoz_idk?.length === 0) {
            eszkoz_idk = Object.keys(szurheto_adatok.eszkozok);
        }
        var id = kerdesek[ind];
        var valosLebontas = $('#szuro_select_input').val()[0] == 'ev' ? 'negyedev' : $('#szuro_select_input').val()[0];
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "idopont_elott": computeDates(idoszak).most,
            "talalat_tol": "0",
            "talalat_darab": "100",
            "kerdoiv_idk": JSON.stringify(kerdoivek),
            "eszkoz_idk": JSON.stringify(eszkoz_idk),
            "telephely_idk": JSON.stringify(telephelyekTomb),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_idk": JSON.stringify([id]),
            "trend_tipus": valosLebontas
        };
    
        var resultText = {};
    
        postApi('jelentesek_sel_trend_szerint',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo)) {
                initDataTable(result.data,id);
                if(ind < kerdesek.length - 1) {
                    ind++;
                    call_jelentesek_sel_trend_szerint(ind);
                }
            }
        });
    }

    if(kerdesek.length > 0) {
        call_jelentesek_sel_trend_szerint(0);
    }

}

function adatFeldolgozas(kitoltesek, idopontTipus, kerdesId) {

    if(kitoltesek.length == 0) {
        return [];
    }

    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};
    var van_szarmaztatott = false;

    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var nps_e =  adatok['nps_e'];
    var ces_e = adatok['ces_e'];

    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;
    var realLength = tablaFejlec.reduce(x => x+1, 0);
    var osszegzoSor = tombokTombjeInic(realLength, 0);

    var tabla = [];

    /*CELLÁK*/
    for(var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var idopont = idopontTipus == 'ev' ? kitoltes['ev'] : kitoltes['ev']+'/'+kitoltes[idopontTipus];
        var korrigaltValaszSorszam = parseInt(kitoltes.valasz_sorszam) - 1;

        if(!isDefined(tabla[idopont])) {
            tabla[idopont] = tombokTombjeInic(tablaFejlec.length, "0");
        }

          /*CES modell*/
        if(ces_e){
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8)=="ikonok-5"){
                /*detractors*/
                if(kitoltes.valasz_sorszam == 1 || kitoltes.valasz_sorszam == 2 ) {    
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if( kitoltes.valasz_sorszam == 3) { 
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else if(kitoltes.valasz_sorszam==4 || kitoltes.valasz_sorszam==5) {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            }
        /*NPS esetén más a tábla modellje*/ 
        }else if(nps_e) {
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8) == "ikonok-4") {
                /*detractors*/
                if(kitoltes.valasz_sorszam == 1) {    
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(kitoltes.valasz_sorszam == 2) { 
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            } else {
                /*detractors*/
                if(korrigaltValaszSorszam < 7) {
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(korrigaltValaszSorszam < 9) {
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            }
            
        } else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
            tabla[idopont][tablaFejlec.length - 2 - korrigaltValaszSorszam] = kitoltes.elofordulas;
            osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
        } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
            tabla[idopont][korrigaltValaszSorszam] = kitoltes.elofordulas;
            osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
        } else {
            tabla[idopont][kitoltes.valasz_sorszam] = kitoltes.elofordulas;
            osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
        }

       
    }

    var osszes_valasz_szama = 0;
    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        if(isDefined(sor) && sor != null) {
            var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,nps_e,ces_e);

            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            osszes_valasz_szama += valaszok_szama;
            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }
            var ujSor = {
                metaadatok: {
                    idopont: toGlobalDateFormat(i),
                    idopont_id: i,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
        }
    }

    /*Összesítés*/
    /*Külön kell figyelni rá, hogy volt-e származtatott érték oszlop*/
    osszegzoSor.push("0");
    if(van_szarmaztatott) {
        osszegzoSor[osszegzoSor.length-1] = "\u200C"+szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,osszegzoSor,nps_e,ces_e);
        osszegzoSor[osszegzoSor.length-2] = osszes_valasz_szama;

    } else {
        osszegzoSor[osszegzoSor.length-1] = osszes_valasz_szama;
    }
    console.log('osszegzoSor',JSON.parse(JSON.stringify(osszegzoSor)));

    /*Idegen nyelvek miatt kell*/
    kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

    /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
    var kerdesSzoveg = '';
    var kerdoivIdk = $('#kerdoiv_select_input').val();

    
    console.log("kerdoividk ",kerdoivIdk);
  
    if(kerdes.id == "2" && kerdoivIdk.length == 1) {
        kerdesSzoveg = kerdes.kerdes_szoveg;
    } else {
        kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
    }

        /*rendszerszintű kérdés a megfelelő cég szövegével*/
  if(kerdoivIdk.length===0){
    kerdesSzoveg = kerdes.kerdes_szoveg;
    }
      console.log("kerdes szoveg", kerdesSzoveg);

      


    grafikonAdatok = {
        "szoveg":kerdesSzoveg,
        "tipus": kerdes.valasz_tipus_kod,
        "nps": nps_e,
        "ces":ces_e,
        "lehetseges_valaszok": lehetsegesValaszok,
        "lebontasok": [],
        "data": []
    };

    for(var i in tablaSorok) {
        var sor = tablaSorok[i];
         grafikonAdatok["lebontasok"].push(sor.metaadatok.idopont);
    }

    for(var i in lehetsegesValaszok) {
        var valaszSzoveg = lehetsegesValaszok[i];
        var data = [];
        for(var j in tablaSorok) {
            var szazalek = szazalekSzamitas(i, tablaSorok[j].sor_adat, kerdes, lehetsegesValaszok.length, nps_e,ces_e);
            data.push(szazalek);
        }

        var dataset = {
            label: valaszSzoveg,
            data: data,
        };
        grafikonAdatok["data"].push(dataset);
    }

    var data = [];
    /* Válaszok megoszlása*/
    /*for(var i in tablaSorok) {
        data.push(Math.round((tablaSorok[i].metaadatok.valaszok_szama / osszes_valasz_szama) * 100)+'%');
    }
    var dataset = {
        label: '[[$t.valaszok_megoszlasa]]',
        data: data,
    };

    if(van_szarmaztatott) {
        var tmp = grafikonAdatok["data"][grafikonAdatok["data"].length - 1];
        grafikonAdatok["data"][grafikonAdatok["data"].length - 1] = dataset;
        grafikonAdatok["data"].push(tmp);
    } else {
        grafikonAdatok["data"].push(dataset);
    }*/

    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        van_szarmaztatott: van_szarmaztatott,
        osszegzo_sor: osszegzoSor,
        kerdes_tipus:  kerdes.valasz_tipus_kod,
        nps: nps_e,
        ces: ces_e
    }
}

function szazalekSzamitas(i, sor, kerdes, length, nps_e,ces_e) {

    var osszeg = sorosszeg(sor, kerdes.valasz_tipus_kod, nps_e,ces_e);
    var szazalek = '';
    if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'igen_nem' || nps_e || ces_e || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
        if (i == (length - 1)) {
            szazalek = sor[sor.length - 1].replace('%','');
        } else {
            szazalek = ((parseInt(sor[i]) / osszeg)*100).toFixed(1);
        }
        
    } else {
        szazalek = ((parseInt(sor[i]) / osszeg) * 100).toFixed(2);
    }

    if(!$.isNumeric(szazalek)) { 
        szazalek = 'N/A'; 
    }

    return szazalek;
}


function initDataTable(idopontok, kerdesId) {
    var lebontas = $('#szuro_select_input').val()[0];
    var feldolgozottAdat = adatFeldolgozas(idopontok,lebontas,kerdesId);

    if(feldolgozottAdat.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];
    var metaadatok = tablaMetaadatok(kerdesId);

    var trendtNev = '';
    switch(lebontas) {
        case 'het':
            trendtNev = '[[$t.het]]';
        break;
        case 'honap':
            trendtNev = '[[$t.honap]]';
        break;
        case 'negyedev':
            trendtNev = '[[$t.negyedev]]';
        break;
        case 'ev':
            trendtNev = '[[$t.ev]]';
        break;
    }

    tablaFejlec.push({ headName:trendtNev, colName:"idopont",canOrder: false});
    tablaFejlec.push({ headName:"[[$t.partner]]", colName:"partner"});
    tablaFejlec.push({ headName:"[[$t.telephely]]", colName:"telephely"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true,canOrder: false});

    var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdat.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdat.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdat.fejlec[i],
                colName: 'valasz'+i,
                canOrder: false
            });
        }
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {
        tablaFejlec.push({
            headName: feldolgozottAdat.fejlec[(feldolgozottAdat.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdat.fejlec.length-offset),
            canOrder: false
        });
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdat.sorok) {
        var feldolgozottAdatSor = feldolgozottAdat.sorok[i];
        var idoszak = "";
        var ujSor = {
            "idopont": feldolgozottAdatSor.metaadatok.idopont,
            "partner": arrayToString(metaadatok.partnerek),
            "telephely": arrayToString(metaadatok.telephelyek),
            "id" : feldolgozottAdatSor.metaadatok.idopont_id
        };
        var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }

        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;

        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }

        tablaSorok.push(ujSor); 
        
    }

    var lathatosagSelect = filterSelectHtml({
            id: 'lathatosag_select_input-'+kerdesId,
            /*label: '[[$t.tabla_es_grafikon_megjelenites]]',*/
            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
            name: 'lathatosag_select_input-'+kerdesId,
            maxOptions: 'inf',
            addclass: 'form cf-report-visibility'
        },
        [
            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
        ]
    );

    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_'+kerdesId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }   
    });

    $('#jelentes-holder').append('<div id="tabla-blokk-'+kerdesId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.trend_szuresi_szoveg]]"; 

    $('#tabla-blokk-'+kerdesId).html('<h2 class="table_name">'+feldolgozottAdat.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+kerdesId+'"></div></div>');
    
    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'azonosito',kerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);    
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }
    
    szuresiAdatokOsszeallitas('#tabla-blokk-'+kerdesId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+kerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_trendek]]' + ' ' + formatDate(datumStr),
            sumFooter : {
                hasSumFooter: true,
                sumFooterLeftOffset: 2,
                exportSumFooter: feldolgozottAdat.osszegzo_sor,
                hasCalculatedCol: feldolgozottAdat.van_szarmaztatott,
                type: feldolgozottAdat.kerdes_tipus,
                isNPS: feldolgozottAdat.nps,
                isCES: feldolgozottAdat.ces
            }
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-'+kerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+kerdesId).selectpicker();
    $('#btn_riport_export_'+kerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    grafikonokInit(feldolgozottAdat.grafikon, kerdesId);

    
}

function grafikonokInit(grafikon, kerdesId) {

    $('#charts').html('');

    if(grafikon.lehetseges_valaszok.length > 30) { return; }

    if(grafikon.tipus == "szabad_szoveg") { return; }

    var lebontasokSzama = grafikon.lebontasok.length;

    if(lebontasokSzama > 0) {

        var height = lebontasokSzama * 80;
        var szinek = [];

        var width = parseInt($('#jelentes-holder').width()) * 0.6;

        /*$('#tabla-blokk-'+kerdesId).append('<div style="margin:auto;height:500px; width:'+width+'px"><canvas id="chart-'+kerdesId+'"></canvas></div>');*/
        $('#tabla-blokk-'+kerdesId).append('<div class="canvas-holder" style="margin:auto;height:600px;"><canvas id="chart-'+kerdesId+'" ></canvas></div>');

        if(grafikon.nps == "1") {
            szinek = szinGeneralas('NPS', grafikon.lehetseges_valaszok.length, 'line');
            drawLineChart('chart-'+kerdesId, grafikon.lebontasok, grafikon.data, szinek, true,false, grafikon.tipus);

        }else if(grafikon.ces=="1"){
            szinek = szinGeneralas('CES', grafikon.lehetseges_valaszok.length+1, 'line');
            console.log(szinek, grafikon.lehetseges_valaszok.length+1);
            drawLineChart('chart-'+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false,true, grafikon.tipus); 
        }else{
            szinek = szinGeneralas(grafikon.tipus, grafikon.lehetseges_valaszok.length+1, 'line');
            console.log(szinek, grafikon.lehetseges_valaszok.length+1);
            drawLineChart('chart-'+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false,false, grafikon.tipus);
        }

        /*Lehetséges nyomtatáshoz kellenek*/
        GRAFIKON_ADATOK.push({
            id:kerdesId,
            adat: grafikon
        });

       
    }

}



function honapok(honap) {
    var honap = honap.split('/')[1];
    switch(honap) {
        case '1':
            return "[[$t.januar]]";
        case '2':
            return "[[$t.februar]]";
        case '3':
            return "[[$t.marcius]]";
        case '4':
            return "[[$t.aprilis]]";
        case '5':
            return "[[$t.majus]]";
        case '6':
            return "[[$t.junius]]";
        case '7':
            return "[[$t.julius]]";
        case '8':
            return "[[$t.augusztus]]";
        case '9':
            return "[[$t.szeptember]]";
        case '10':
            return "[[$t.oktober]]";
        case '11':
            return "[[$t.november]]";
        case '12':
            return "[[$t.december]]";

    }
}

function selectUjraepites(selectId, force) {

    var selectTipus = selectId.split('_')[0];

    var selectErtekek = $('#'+selectId).val();

    switch(selectTipus) {
        case 'partner':
            if(selectErtekek.length == 0) {
                szuroNullazas();
            } else {
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('kerdes',selectTipus,selectErtekek);
            }
        break;
        case 'regio':
            if(selectErtekek.length == 0 && !force) {
                selectUjraepites('regio_select_input', 1);
            } else if(selectErtekek.length == 0 && $('#kerdoiv_select_input').val().length != 0) {
                selectUjraepites('kerdoiv_select_input');
            } else if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            } else {
                if(force) {
                    selectErtekek = [];
                    $("#regio_select_input option").each(function() {
                        selectErtekek.push($(this).val());
                    });
                }
                var szurtTelephelyek = selectSzures('telephely',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('telephely','kerdoiv',$('#kerdoiv_select_input').val(), szurtTelephelyek);
                }

                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }

        break;
        case 'telephely':
            if(selectErtekek.length == 0) {
                selectUjraepites('regio_select_input');
            } else {
                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#regio_select_input').val().length != 0) {
                    szurtEszkozok = selectSzures('eszkoz','regio',$('#regio_select_input').val(), szurtEszkozok);
                }
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }
        break;
        case 'kerdoiv':
            if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            }
            else {
                selectSzures('kerdes',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
            }
            
        break;

    }

    

}



function szuroNullazas() {
    refillSelect('partner_select_input',filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id'));
    refillSelect('kerdoiv_select_input',filterSelectValues(szurheto_adatok.kerdoivek , 'nev', 'id'));
    refillSelect('regio_select_input',filterSelectValues(szurheto_adatok.regiok , 'nev', 'id'));
    refillSelect('telephely_select_input',filterSelectValues(szurheto_adatok.telephelyek , 'nev', 'id'));
    refillSelect('eszkoz_select_input',filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id'));
    refillSelect('kerdes_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));
}

function szuresiAdatokOsszeallitas(id) {
    var szoveg = $(id).find('.cf-filter-string').html();

    var trend = $('#szuro_select_input').val()[0];

    switch(trend) {
        case 'het': trend = '[[$t.heti]]'; break;
        case 'honap': trend = '[[$t.havi]]'; break;
        case 'negyedev': trend = '[[$t.negyedeves]]'; break;
        case 'ev': trend = '[[$t.eves]]'; break;
    }

    var idoszak = $('#idoszak_select_input').val()[0];

    szoveg = szoveg.replace('#trend#', '<span class="font-weight-bold">'+trend+'</span>');
    szoveg = szoveg.replace('#kezdo_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).kezdet.split(' ')[0])+'</span>');
    szoveg = szoveg.replace('#veg_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).veg.split(' ')[0])+'</span>');


    $(id).find('.cf-filter-string').html(szoveg);

    
}