/*2021.01.27. - Régiókat is szűrni kell jog alapján
  ezt csak telephelyeken keresztül lehet*/
  szurheto_adatok.regiok = regioSzuresTelephelyekkel();
var REGIOK = objectToArray(szurheto_adatok.regiok);
var TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
var PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var KERDESEK = objectToArray(szurheto_adatok.kerdesek);

var validKerdesek = getValidKerdesek(KERDESEK, KERDOIVEK);

var GRAFIKON_ADATOK = [];

var jelentesek = null;

$(document).ready(function() {

    google.charts.load('current', {packages: ['corechart', 'bar']});

    var jelentes_szuro = {
        inic_param: {
                id: 'jelentes_szuro',
                cols: 4,
                rows: 3,
            },
            buttons: [
                {
                    name:"[[$t.szures]]",
                    id: 'btn_riport_szures',
                    type: 'filter',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            $('#jelentes-holder').html('');
                            $('#btn_riport_nyomtatas').removeClass('is-inactive');
                            $('#btn_riport_nyomtatas').prop('disabled', false);
                            $('.megjelenites-vezerles').removeClass('d-none');
                            $('.megjelenites-vezerles input').prop('checked', false);
                            GRAFIKON_ADATOK = [];
                            nyersAdatokLekeres();
                        }
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }
                },
                {
                    name:"[[$t.nyomtatas]]",
                    id: 'btn_riport_nyomtatas',
                    type: 'print',
                    addClass : 'mb-2',
                    visibility: function() {
                        return 0;
                    },
                    callback: function() {
                        var partnerId = $('#partner_select_input').val()[0];
                        var partner = findInArray(PARTNEREK, 'id', partnerId);
                        var reportData = {
                            tipus: '[[$t.jelentesek_szurokerdes]]',
                            partner: partner
                        };
                        printData(reportData);
                    },
                    onCustomAjaxDone: function(event,result,trigger){ 
                    }
                }
            ],
            inputs: [
                {"col": 1, "row": 0, "input": filterSelectHtml({
                                                                id: 'kerdoiv_select_input',
                                                                label: '[[$t.kerdoiv]]',
                                                                placeholder: '[[$t.mind]]',
                                                                name: 'kerdoiv_select_input',
                                                                maxOptions: 'inf',
                                                                addclass: 'form',
                                                                required: true
                                                            },
                                                            filterSelectValues(szurheto_adatok.kerdoivek, 'nev', 'id')
                                                        )
                 },
                 {"col": 2, "row": 0, "input": filterSelectHtml({
                                                    id: 'szuro_select_input',
                                                    label: '[[$t.lebontas]]',
                                                    placeholder: '[[$t.valassz]]',
                                                    name: 'szuro_select_input',
                                                    maxOptions: 1,
                                                    addclass: 'form',
                                                    required: true
                                                },
                                                filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false)
                                            )
                                },
                {"col": 0, "row": 0, "input": filterSelectHtml({
                                    id: 'partner_select_input',
                                    label: '[[$t.partner]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'partner_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },
                {"col": 3, "row": 0, "input": filterSelectHtml({
                                                id: 'kerdes_select_input',
                                                label: '[[$t.kerdes]]',
                                                placeholder: '[[$t.mind]]',
                                                name: 'kerdes_select_input',
                                                maxOptions: 'inf',
                                                addclass: 'form',
                                            },
                                            filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false)
                                        )
                },
                {"col": 0, "row": 1, "input": filterSelectHtml({
                                    id: 'regio_select_input',
                                    label: '[[$t.regio]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'regio_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.regiok  , 'nev', 'id')
                            )
                },
                {"col": 1, "row": 1, "input": filterSelectHtml({
                                    id: 'telephely_select_input',
                                    label: '[[$t.telephely]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'telephely_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.telephelyek, 'nev', 'id')
                            )
                },
                {"col": 2, "row": 1, "input": filterSelectHtml({
                                    id: 'eszkoz_select_input',
                                    label: '[[$t.eszkoz]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'eszkoz_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.eszkozok, 'nev', 'id')
                            )
                },
                {"col": 0, "row": 2, "input": filterSelectHtml({
                                                    id: 'idoszak_select_input',
                                                    placeholder: '[[$t.mind]]',
                                                    label: '[[$t.idoszak]]',
                                                    name: 'idoszak_select_input',
                                                    maxOptions: '1',
                                                    addclass: 'form'
                                                },
                                                [
                                                    {name:'[[$t.ma]]', value:'ma'},
                                                    {name:'[[$t.elozo_nap]]', value:'tegnap'},
                                                    {name:'[[$t.utolso_het]]', value:'utolso_het'},
                                                    {name:'[[$t.utolso_honap]]', value:'utolso_honap'},
                                                    {name:'[[$t.ez_a_honap]]', value:'ez_a_honap'},
                                                    {name:'[[$t.elozo_honap]]', value:'elozo_honap'},
                                                    {name:'[[$t.ez_az_ev]]', value:'ez_az_ev'},
                                                    {name:'[[$t.egyeb]]', value:'sajat'}
                                                ]
                )},
                {"col": 1, "row": 2, "input": datepickerHtml({
                                                id: 'kezdo_datum_input',
                                                label: '[[$t.kezdo_datum]]',
                                                addClass: 'd-none'
                                            })
                },
                {"col": 2, "row": 2, "input": datepickerHtml({
                                    id: 'veg_datum_input',
                                    label: '[[$t.veg_datum]]',
                                    addClass: 'd-none'
                                })
                },
            ],
    };

    formHtml('#jelentes_szuro', jelentes_szuro.inic_param, jelentes_szuro.inputs, jelentes_szuro.buttons);


    /*Eseménykezelők*/
    /*Az egyedi datetimepicker csak akkor jelenik meg, ha az időszak választóban az Egyéb van kiválasztva*/
    $('#idoszak_select_input').on('change', function() {
        if($(this).val()[0] == 'sajat') {
            $('#kezdo_datum_input').parents('.dt-wrapper').removeClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').removeClass('d-none');
        } else {
            $('#kezdo_datum_input').parents('.dt-wrapper').addClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').addClass('d-none');
        }
    });

    $('.selectpicker').on('change', function() {
        selectUjraepites(this.id);
    });

    initDatepicker({id: 'kezdo_datum_input', dateOnly: true});
    initDatepicker({id: 'veg_datum_input', dateOnly: true});

   $('#szuro_select_input').selectpicker();
   $('#partner_select_input').selectpicker();
   $('#kerdoiv_select_input').selectpicker();
   $('#kerdes_select_input').selectpicker();
   $('#regio_select_input').selectpicker();
   $('#telephely_select_input').selectpicker();
   $('#eszkoz_select_input').selectpicker();
   $('#idoszak_select_input').selectpicker();

   initChartAndTableTogglers();

});

/*Nyers adatok lekérdezése*/
function nyersAdatokLekeres() {

    var kerdesek = $('#kerdes_select_input').val();

    if(kerdesek.length == 0) {
        kerdesek = [];
        $('#kerdes_select_input option').each(function() {
            kerdesek.push($(this).val());
        });
    }

    var idoszak = $('#idoszak_select_input').val()[0];
    var telephelyIdk = $('#telephely_select_input').val();
    var regioIdk = $('#regio_select_input').val();

    var telephelyek = {};

    /*Ha telephely ki van választva, akkor a régió telephelyei nem kellenek*/
    if(telephelyIdk.length == 0) {
        for(var i in regioIdk) {
            var regio = szurheto_adatok.regiok[regioIdk[i]];
            for(var j in regio.telephelyek) {
                telephelyek[regio.telephelyek[j].id] = regio.telephelyek[j].id;
            }
        }
    }

    for(var i in telephelyIdk) {
        if(!isDefined(telephelyek[telephelyIdk[i]])) {
            telephelyek[telephelyIdk[i]] = telephelyIdk[i];
        }
    }

    var telephelyekTomb = [];
    $.each(telephelyek, function(kulcs, ertek) {
        telephelyekTomb.push(ertek);
    });


    var kerdoivek = $('#kerdoiv_select_input').val();
    if (kerdoivek.length == 0) {
        kerdoivek = [];
        $.each(szurheto_adatok.kerdoivek, function(index, kerdoiv){
            kerdoivek.push(kerdoiv.id);
        });
    }

    function call_jelentesek_sel_szurokerdes_szerint(ind) {
        var eszkoz_idk = $('#eszkoz_select_input').val();
        if (eszkoz_idk?.length === 0) {
            eszkoz_idk = Object.keys(szurheto_adatok.eszkozok);
        }
        var id = kerdesek[ind];
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "talalat_tol": "0",
            "talalat_darab": "100",
            "kerdoiv_idk": JSON.stringify(kerdoivek),
            "eszkoz_idk": JSON.stringify(eszkoz_idk),
            "telephely_idk": JSON.stringify(telephelyekTomb),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_id": id,
            "szurokerdes_id": $('#szuro_select_input').val()[0],
        };

        var resultText = {};

        postApi('jelentesek_sel_szurokerdes_szerint',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo)) {
                initDataTable(result.data, id);
                if(ind < kerdesek.length - 1) {
                    ind++;
                    call_jelentesek_sel_szurokerdes_szerint(ind);
                }
            }
        });
    }


    if(kerdesek.length > 0) {
        call_jelentesek_sel_szurokerdes_szerint(0);
    }


}

function adatFeldolgozas(kitoltesek, szurokerdesId, kerdesId) {

    if(kitoltesek.length == 0) {
        return [];
    }

    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};
    var van_szarmaztatott = false;


    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var nps_e =  adatok['nps_e'];
    var ces_e=adatok['ces_e'];
    var kerdoivId = adatok['kerdoiv_id'];

    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;

    var osszegzo_offset = kerdes.valasz_tipus_kod.slice(0,15) ==  "egyedi_valaszok"  || kerdes.valasz_tipus_kod == "dropdown"? 1 : 0;
    var realLength = tablaFejlec.reduce(x => x+1, 0);
    var osszegzoSor = tombokTombjeInic(realLength, 0);
    
    
    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, szurokerdesId, kerdoivId);
    var szurokerdes = adatok["kerdes"];
    var szuroValaszok = adatok["lehetsegesValaszok"];

    console.log("adatok ",adatok);

    if(adatok['van_szarmaztatott_ertek']) {
        szuroValaszok.pop();
    }


    var szuroNPS_e =  adatok['nps_e'];
    var szuroCes_e =adatok['ces_e'];
    var kerdoivId2 = adatok['kerdoiv_id'];

    if(!szuroNPS_e && !szuroCes_e) {
        if(
            szurokerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || 
            szurokerdes.valasz_tipus_kod == 'szamok-1-10' || 
            szurokerdes.valasz_tipus_kod == 'szamok-1-6' || 
            szurokerdes.valasz_tipus_kod == 'szamok-1-5'  
            
        ) {
         szuroValaszok.reverse();
        }
    }
    



    
    var tabla = [];
    for (var i in szuroValaszok) {
        tabla[i] = tombokTombjeInic(tablaFejlec.length, "0");
    }

    /*CELLÁK*/
    for(var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var szurokerdesValasz = parseInt(kitoltes["szurokerdes_valasz_sorszam"]);
        var korrigaltSzurokerdesValaszSorszam = szurokerdesValasz -1;
        var korrigaltValaszSorszam = parseInt(kitoltes.valasz_sorszam) - 1;
        console.log("kitoltes",kitoltes.elofordulas);
        console.log("szurokerdesValasz",szurokerdesValasz);

        /*NPS esetén más a tábla modellje
          Itt trükkös, mert lehet a szűrőkérdés is NPS*/
        if(szuroNPS_e) {
            var npsIndex = getNPSValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            

            var szuroNpsIndex = getNPSValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            var szuroCesIndex = getCESValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            if(nps_e) { 
                console.log("nps index, szurnps, ind,",npsIndex, szuroNpsIndex);
                tabla[szuroNpsIndex][npsIndex] = isDefined(tabla[szuroNpsIndex][npsIndex]) ? parseInt(tabla[szuroNpsIndex][npsIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
            }else if(ces_e){
                console.log("ces index, szuroces, ind,",cesIndex, szuroCesIndex);
                console.log("korrigalt valasz sorszam",korrigaltValaszSorszam);
                console.log("kitoltes valasz sorszam",kitoltes.valasz_sorszam);
                var cesIndex = getCESValue(kitoltes.valasz_sorszam, kerdes.valasz_tipus_kod);
                tabla[szuroNpsIndex][cesIndex] = isDefined(tabla[szuroNpsIndex][cesIndex]) ? parseInt(tabla[szuroNpsIndex][cesIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
              /*
                if(kitoltes.valasz_sorszam<3){
             }else if(kitoltes.valasz_sorszam==3){
                    tabla[szuroNpsIndex][1] = isDefined(tabla[szuroNpsIndex][1]) ? parseInt(tabla[szuroNpsIndex][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                }else{
                    tabla[szuroNpsIndex][0] = isDefined(tabla[szuroNpsIndex][0]) ? parseInt(tabla[szuroNpsIndex][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                }
                osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
               
                tabla[szuroNpsIndex][kitoltes.valasz_sorszam] = isDefined(tabla[szuroNpsIndex][kitoltes.valasz_sorszam]) ? parseInt(tabla[szuroNpsIndex][kitoltes.valasz_sorszam]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
                /*tabla[szuroNpsIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] = +tabla[szuroNpsIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] + parseInt(kitoltes.elofordulas);
              
                osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas); */
                osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
            } else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
                console.log("tablafejlec length",tablaFejlec.length,"korrigalt valsz",korrigaltValaszSorszam);
                tabla[szuroNpsIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] = +tabla[szuroNpsIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] + parseInt(kitoltes.elofordulas);
                osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
                tabla[szuroNpsIndex][korrigaltValaszSorszam] = kitoltes.elofordulas;
                osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            }else {
                tabla[szuroNpsIndex][kitoltes.valasz_sorszam] = isDefined(tabla[szuroNpsIndex][kitoltes.valasz_sorszam]) ? parseInt(tabla[szuroNpsIndex][kitoltes.valasz_sorszam]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
            }
        }else if(szuroCes_e){
            var cesIndex = getCESValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            var szuroCesIndex = getCESValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);   

            var npsIndex = getNPSValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            var szuroNpsIndex = getNPSValue(parseInt(szurokerdesValasz), szurokerdes.valasz_tipus_kod);
            if(ces_e) {
                console.log("szurokerdes valasz ",parseInt(szurokerdesValasz));
                console.log("ces index, szurces, ind,",cesIndex, szuroCesIndex);
                  tabla[szuroCesIndex][cesIndex] = isDefined(tabla[szuroCesIndex][cesIndex]) ? parseInt(tabla[szuroCesIndex][cesIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[cesIndex] += parseInt(kitoltes.elofordulas);
              console.log("tabla[szuroCesIndex][cesIndex] ",tabla[szuroCesIndex][cesIndex]);
            }else if(nps_e){

                var npsIndex = getNPSValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                console.log("NPSSS",npsIndex," korrigaltSzurokerdesValaszSorszam",korrigaltSzurokerdesValaszSorszam);
                tabla[szuroCesIndex][npsIndex]=isDefined(tabla[szuroCesIndex][npsIndex])?parseInt(tabla[szuroCesIndex][npsIndex])+ parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                /*tabla[korrigaltSzurokerdesValaszSorszam][npsIndex] = isDefined(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) ? parseInt(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
                /*
                tabla[szuroCesIndex][korrigaltValaszSorszam] = isDefined(tabla[szuroCesIndex][korrigaltValaszSorszam]) ? parseInt(tabla[szuroCesIndex][korrigaltValaszSorszam]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[cesIndex] += parseInt(kitoltes.elofordulas);
                var npsIndex = getNPSValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                tabla[korrigaltSzurokerdesValaszSorszam][npsIndex] = isDefined(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) ? parseInt(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
               */ 
              osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
            }else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
                tabla[szuroCesIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] = +tabla[szuroCesIndex][tablaFejlec.length - 2 - korrigaltValaszSorszam] + parseInt(kitoltes.elofordulas);
                osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
                tabla[szuroCesIndex][korrigaltValaszSorszam] = kitoltes.elofordulas;
                osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            }else {

               /* tabla[szuroCesIndex][kitoltes.valasz_sorszam] = isDefined(tabla[szuroCesIndex][kitoltes.valasz_sorszam]) ? parseInt(tabla[szuroCesIndex][kitoltes.valasz_sorszam]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);*/
            }

        }else if(szurokerdes.valasz_tipus_kod.slice(0,15) == 'egyedi_valaszok' || szurokerdes.valasz_tipus_kod == "dropdown" || szurokerdes.valasz_tipus_kod.slice(0,7) == 'ertekek') {
            if(isDefined(tabla[szurokerdesValasz])) {
                if(nps_e) {
                    var npsIndex = getNPSValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                    tabla[szurokerdesValasz][npsIndex] = isDefined(tabla[szurokerdesValasz][npsIndex]) ? parseInt(tabla[szurokerdesValasz][npsIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
                }else if(ces_e){
                    var cesIndex = getCESValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                    tabla[szurokerdesValasz][cesIndex] = isDefined(tabla[szurokerdesValasz][cesIndex]) ? parseInt(tabla[szurokerdesValasz][cesIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[cesIndex] += parseInt(kitoltes.elofordulas);
                }else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
                    tabla[szurokerdesValasz][tablaFejlec.length - 2 - korrigaltValaszSorszam] = kitoltes.elofordulas;
                    osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
                } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
                    tabla[szurokerdesValasz][korrigaltValaszSorszam] = kitoltes.elofordulas;
                    osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
                }
                 else {
                    tabla[szurokerdesValasz][kitoltes.valasz_sorszam] = kitoltes.elofordulas;
                    osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
                }
            }
            
        }else {
            if(nps_e) {
                console.log('kitoltes', kitoltes);
                var npsIndex = getNPSValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                tabla[korrigaltSzurokerdesValaszSorszam][npsIndex] = isDefined(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) ? parseInt(tabla[korrigaltSzurokerdesValaszSorszam][npsIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[npsIndex] += parseInt(kitoltes.elofordulas);
            }else if(ces_e){
                var cesIndex = getCESValue(parseInt(korrigaltValaszSorszam),kerdes.valasz_tipus_kod);
                tabla[korrigaltSzurokerdesValaszSorszam][cesIndex] = isDefined(tabla[korrigaltSzurokerdesValaszSorszam][cesIndex]) ? parseInt(tabla[korrigaltSzurokerdesValaszSorszam][cesIndex]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                osszegzoSor[cesIndex] += parseInt(kitoltes.elofordulas);
            }else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
                tabla[korrigaltSzurokerdesValaszSorszam][tablaFejlec.length - 2 - korrigaltValaszSorszam] = kitoltes.elofordulas;
                osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
                tabla[korrigaltSzurokerdesValaszSorszam][korrigaltValaszSorszam] = kitoltes.elofordulas;
                osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
            } else {
                tabla[korrigaltSzurokerdesValaszSorszam][kitoltes.valasz_sorszam] = kitoltes.elofordulas;
                osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas); 
            }
        }

    }
    var osszes_valasz_szama = 0;
    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        if(isDefined(sor) && sor != null) {
            var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,nps_e,ces_e);

            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            osszes_valasz_szama += valaszok_szama;
            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }
            var szurokerdesValaszSzoveg = szuroValaszok[i];
            var ujSor = {
                metaadatok: {
                    szurokerdes_valasz: szurokerdesValaszSzoveg,
                    szurokerdes_valasz_id: i,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
            console.log("tabla Sorok",tablaSorok);
        }
    }
    /*Összesítés*/
    /*Külön kell figyelni rá, hogy volt-e származtatott érték oszlop*/
    osszegzoSor.push("0");
    if(van_szarmaztatott) {
        osszegzoSor[osszegzoSor.length-1] = "\u200C"+szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,osszegzoSor.slice(0, -1),nps_e,ces_e);
        osszegzoSor[osszegzoSor.length-2] = osszes_valasz_szama;
    } else {
        osszegzoSor[osszegzoSor.length-1] = osszes_valasz_szama;
    }

        /*Grafikon adatok*/
        npsExtra = findInArray(kerdes.kerdes_extrak, 'adat_kod', 'nps');
        var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;


        cesExtra = findInArray(kerdes.kerdes_extrak, 'adat_kod', 'ces');
        var ces_e = isDefined(cesExtra) ?  cesExtra.adat_content : 0;
        csakNyers = true;
       
        lehetsegesValaszok = lehetsegesValaszokLegyujtes(kerdes.valasz_tipus_kod,kerdes.kerdes_extrak, kerdes.valasz_tipus_extrak, csakNyers, kerdes.azonosito);
        console.log("lehetsegesk ",lehetsegesValaszok);
        if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5' || nps_e || ces_e) {
            lehetsegesValaszok.reverse();
        }

         /*Idegen nyelvek miatt kell*/
        kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

        /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
        var kerdesSzoveg = '';
        var kerdoivIdk = $('#kerdoiv_select_input').val();

        if(kerdes.id == "2" && kerdoivIdk.length == 1) {
            kerdesSzoveg = kerdes.kerdes_szoveg;
        } else {
            kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
        }
    

        grafikonAdatok = {
            "szoveg":kerdesSzoveg,
            "tipus": kerdes.valasz_tipus_kod,
            "nps": nps_e,
            "ces":ces_e,
            "lehetseges_valaszok": lehetsegesValaszok,
            "lebontasok": [],
            "data": []
        };


        if(!ces_e){
        var reverse = szurokerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || szurokerdes.valasz_tipus_kod == 'igen_nem';
        }
       
        
        if(reverse) { grafikonAdatok["lebontasok"].push('[[$t.osszegzes]]'); }
           
        for(var i in tablaSorok) {
            var sor = tablaSorok[i];
            grafikonAdatok["lebontasok"].push(sor.metaadatok.szurokerdes_valasz);
        }
        console.log("sor metaadatok ",sor.metaadatok.szurokerdes_valasz);
        console.log("grafikon adatok lebontasok",grafikonAdatok["lebontasok"]);
        if(!reverse ) { grafikonAdatok["lebontasok"].push('[[$t.osszegzes]]');   }

        let ind = 0;
        for(var i in lehetsegesValaszok) {
            var valaszSzoveg = lehetsegesValaszok[i];
            var data = [];

            if(reverse) { data.push(osszegzoSor[ind]);  }
            
            for(var j in tablaSorok) {
                var sor = tablaSorok[j];
                var valaszokSzama = "";
                valaszokSzama = sor.sor_adat[i];
                data.push(valaszokSzama);
            }

            if(!reverse) { data.push(osszegzoSor[ind]);  }
            ++ind;

            var dataset = {
                label: valaszSzoveg,
                data: data,
            };
                console.log("dataset ",dataset);
            grafikonAdatok["data"].push(dataset);
        }

        /* Az üres sorokat csak ilyen körülményesen lehet kiírtani*/
        var grafikonLebontasok = [];
        var grafikonData = [];
        for(var i in grafikonAdatok["data"]) {
            grafikonData.push({
                label: grafikonAdatok["data"][i].label,
                data: []
            });
        }

        for(var i in grafikonAdatok["lebontasok"]) {
            var arr = [];
            var count = 0;
            for(var j in grafikonAdatok["data"]){
                count += parseInt(grafikonAdatok["data"][j].data[i]);
                arr.push(grafikonAdatok["data"][j].data[i]);
            }

            if(count != 0) {
                for(var j in grafikonAdatok["data"]){
                    grafikonData[j].data.push(grafikonAdatok["data"][j].data[i]);
                }
                grafikonLebontasok.push(grafikonAdatok["lebontasok"][i]);
            }

        }

        grafikonAdatok["lebontasok"] = grafikonLebontasok;
        grafikonAdatok["data"] = grafikonData;

        if((szurokerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || szurokerdes.valasz_tipus_kod == 'igen_nem') && !ces_e) {
            grafikonAdatok["lebontasok"].reverse();
            for(var i in grafikonAdatok["data"]) {
                grafikonAdatok["data"][i].data.reverse();
            }
        }         
        
        console.log("grafikon adatok",grafikonAdatok);
   
    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        van_szarmaztatott: van_szarmaztatott,
        osszegzo_sor: osszegzoSor,
        kerdes_tipus:  kerdes.valasz_tipus_kod,
        nps: nps_e,
        ces: ces_e
    }
}

function initDataTable(rekordok, kerdesId) {

    var lebontas = $('#szuro_select_input').val()[0];
    var feldolgozottAdat = adatFeldolgozas(rekordok, lebontas, kerdesId);
    console.log("feldolgozott adat: ",feldolgozottAdat);
    if(feldolgozottAdat.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];

    var metaadatok = tablaMetaadatok(kerdesId);

    tablaFejlec.push({ headName:"[[$t.szurokerdes_valasz]]", colName:"szurokerdes_valasz"});
    tablaFejlec.push({ headName:"[[$t.partner]]", colName:"partner"});
    tablaFejlec.push({ headName:"[[$t.telephely]]", colName:"telephely"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true});

    var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdat.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdat.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdat.fejlec[i],
                colName: 'valasz'+i
            });
        }
        
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {
        tablaFejlec.push({
            headName: feldolgozottAdat.fejlec[(feldolgozottAdat.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdat.fejlec.length-offset)
        });
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdat.sorok) {
        var feldolgozottAdatSor = feldolgozottAdat.sorok[i];
        var ujSor = {
            "szurokerdes_valasz": feldolgozottAdatSor.metaadatok.szurokerdes_valasz,
            "partner": arrayToString(metaadatok.partnerek),
            "telephely": arrayToString(metaadatok.telephelyek),
            "id" : feldolgozottAdatSor.metaadatok.szurokerdes_valasz_id
        };
        var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }

        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;
        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }
        tablaSorok.push(ujSor);
    }
    var lathatosagSelect = filterSelectHtml({
            id: 'lathatosag_select_input-'+kerdesId,
            /*label: '[[$t.tabla_es_grafikon_megjelenites]]',*/
            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
            name: 'lathatosag_select_input-'+kerdesId,
            maxOptions: 'inf',
            addclass: 'form cf-report-visibility'
        },
        [
            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
        ]
    );

    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_'+kerdesId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }
    });


    $('#jelentes-holder').append('<div id="tabla-blokk-'+kerdesId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.szurokerdes_szuresi_szoveg]]";

    $('#tabla-blokk-'+kerdesId).html('<h2 class="table_name">'+feldolgozottAdat.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+kerdesId+'"></div></div>');

    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'azonosito',kerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }
    console.log("tabla sorook : ",tablaSorok);
    szuresiAdatokOsszeallitas('#tabla-blokk-'+kerdesId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day;
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+kerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_szurokerdes]]' + ' ' +formatDate(datumStr),
            sumFooter : {
                hasSumFooter: true,
                sumFooterLeftOffset: 2,
                exportSumFooter: feldolgozottAdat.osszegzo_sor,
                hasCalculatedCol: feldolgozottAdat.van_szarmaztatott,
                type: feldolgozottAdat.kerdes_tipus,
                isNPS: feldolgozottAdat.nps,
                isCES: feldolgozottAdat.ces
            }
        },
        data:function(callback,element){
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    /*így 5-1 fogja kirajzolni*/
    jelentesek.order([0, "desc"]).draw();

    $('#jelentesek-'+kerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+kerdesId).selectpicker();
    $('#btn_riport_export_'+kerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    grafikonokInit(feldolgozottAdat.grafikon, kerdesId);


}

function grafikonokInit(grafikon, kerdesId) {

    $('#charts').html('');

    if(grafikon.lehetseges_valaszok.length > 30) { return; }

    if(grafikon.tipus == "szabad_szoveg") { return }

    var lebontasokSzama = grafikon.lebontasok.length;

    if(lebontasokSzama > 0) {

        var height = Math.max(lebontasokSzama * 50, 250);
        var width = 1000;
        var szinek = [];

        /*$('#tabla-blokk-'+kerdesId).append('<div style="margin:auto;height:'+height+'px; width:'+width+'px"><canvas id="chart-'+kerdesId+'" height="'+height+'" width="800"></canvas></div>');*/
        $('#tabla-blokk-'+kerdesId).append('<div class="canvas-holder" style="margin:auto;height:'+height+'px;"><canvas id="chart-'+kerdesId+'" ></canvas></div>');

        if(grafikon.nps == "1") {
            szinek = szinGeneralas('NPS', grafikon.lehetseges_valaszok.length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, true,false);

        }else if(grafikon.ces=="1") {
            szinek = szinGeneralas('CES', grafikon.lehetseges_valaszok.length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false, true,grafikon.tipus);
        }else{
            szinek = szinGeneralas(grafikon.tipus, grafikon.lehetseges_valaszok.length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false, false,grafikon.tipus);
        }

        /*Lehetséges nyomtatáshoz kellenek*/
        GRAFIKON_ADATOK.push({
            id:kerdesId,
            adat: grafikon
        });
    }
}



function selectUjraepites(selectId, force) {

    var selectTipus = selectId.split('_')[0];

    var selectErtekek = $('#'+selectId).val();

    switch(selectTipus) {
        case 'partner':
            if(selectErtekek.length == 0) {
                szuroNullazas();
            } else {
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('kerdes',selectTipus,selectErtekek);
                selectSzures('szuro',selectTipus,selectErtekek);
            }
        break;
        case 'kerdoiv':
            if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            }
            else {
                selectSzures('kerdes',selectTipus,selectErtekek);
                selectSzures('szuro',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
            }

        break;
        case 'kerdes':
            if(selectErtekek.length == 0) {
                selectUjraepites('kerdoiv_select_input');
            } /*else {
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
            }*/
        break;
        case 'regio':
        if(selectErtekek.length == 0 && !force) {
            selectUjraepites('regio_select_input', 1);
        } else {
            if(force) {
                selectErtekek = [];
                $("#regio_select_input option").each(function() {
                    selectErtekek.push($(this).val());
                });
            }
            var szurtTelephelyek = selectSzures('telephely',selectTipus,selectErtekek);
            if($('#kerdoiv_select_input').val().length != 0) {
                selectSzures('telephely','kerdoiv',$('#kerdoiv_select_input').val(), szurtTelephelyek);
            }

            var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
            if($('#kerdoiv_select_input').val().length != 0) {
                selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
            }
        }

        break;
        case 'telephely':
            if(selectErtekek.length == 0) {
                if($('#regio_select_input').val().length != 0) {
                    selectUjraepites('regio_select_input');
                } else {
                    selectSzures('telephely','partner',$('#partner_select_input').val());
                }
                
            } else {
                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#regio_select_input').val().length != 0) {
                    szurtEszkozok = selectSzures('eszkoz','regio',$('#regio_select_input').val(), szurtEszkozok);
                }
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }
        break;
        case 'szuro':
            var szurokerdesId = $('#szuro_select_input').val()[0];
            var kerdoivId = $('#kerdoiv_select_input').val()[0];
            /*var szurokerdes = KERDESEK.filter(function(val, ind){
                if(isDefined(val)) {
                    return val.id == szurokerdesId;
                }
                return false;
            });*/
            var szurokerdesek = filterArray(KERDESEK, 'azonosito', szurokerdesId);

            var szurokerdes = [];
            if(isDefined(kerdoivId)) {
                szurokerdes = szurokerdesek.find(function(val, ind){
                    if(isDefined(val)) {
                        return val.fk_kerdoivek == kerdoivId || ($.isArray(val.fk_kerdoivek) && $.inArray(kerdoivId, val.fk_kerdoivek) > -1);
                    }
                    return false;
                });
            } else {
                szurokerdes = szurokerdesek[0];
            }
            

            var kerdoivek = [];
            if(isDefined(szurokerdes)) {
                if($.isArray(szurokerdes.fk_kerdoivek)) {
                    kerdoivek = filterArray2(KERDOIVEK, 'id', szurokerdes.fk_kerdoivek);
                } else {
                    kerdoivek = [findInArray(KERDOIVEK, 'id', szurokerdes.fk_kerdoivek)];
                }

                var kerdoivSelectErtekek = $('#kerdoiv_select_input').val();
                var kerdoivIdk = [];
                if(isDefined(kerdoivSelectErtekek) && kerdoivSelectErtekek.length > 0) {
                    for(var i in kerdoivek) {
                        if($.inArray(kerdoivek[i].id, kerdoivSelectErtekek) > -1) {
                            kerdoivIdk.push(kerdoivek[i].id);
                        }
                    }
                } else {
                    kerdoivIdk = kerdoivek.map(function(elem){
                        return elem.id;
                    });
                }

            }

            if($('#kerdoiv_select_input').val().length == 0 ) {
                selectUjraepites('partner_select_input');
                $('#szuro_select_input').val(szurokerdesId);

            } else {
                selectSzures('kerdes','kerdoiv',kerdoivIdk);
            }
            
            disableInput($('#regio_select_input'), false);
            disableInput($('#telephely_select_input'), false);
            disableInput($('#eszkoz_select_input'), false);
            if(selectErtekek.length > 0) {
                var lebontas = selectErtekek[0];
                switch(lebontas) {
                    case 'regio':
                        disableInput($('#telephely_select_input'), true);
                        disableInput($('#eszkoz_select_input'), true);
                    break;
                    case 'telephely':
                        disableInput($('#eszkoz_select_input'), true);
                    break;
                }
            } else {
                selectUjraepites('kerdoiv_select_input');
            }
        break;
    }

}



function szuroNullazas() {
    refillSelect('partner_select_input',filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id'));
    refillSelect('kerdoiv_select_input',filterSelectValues(szurheto_adatok.kerdoivek , 'nev', 'id'));
    refillSelect('regio_select_input',filterSelectValues(szurheto_adatok.regiok , 'nev', 'id'));
    refillSelect('telephely_select_input',filterSelectValues(szurheto_adatok.telephelyek , 'nev', 'id'));
    refillSelect('eszkoz_select_input',filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id'));
    refillSelect('kerdes_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));
    refillSelect('szuro_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));
}


function szuresiAdatokOsszeallitas(id) {
    var szoveg = $(id).find('.cf-filter-string').html();

    var szurokerdesId = $('#szuro_select_input').val()[0];
    var szurokerdes = findInArray(KERDESEK, 'azonosito', szurokerdesId).kerdes_szovege;


    var idoszak = $('#idoszak_select_input').val()[0];

    console.log("idoszak",computeDates(idoszak));
    szoveg = szoveg.replace('#szurokerdes#', '<span class="font-weight-bold">'+szurokerdes+'</span>');
    szoveg = szoveg.replace('#kezdo_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).kezdet.split(' ')[0])+'</span>');
    szoveg = szoveg.replace('#veg_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).veg.split(' ')[0])+'</span>');


    $(id).find('.cf-filter-string').html(szoveg);


}
