
var REGIOK = objectToArray(szurheto_adatok.regiok);
var TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
var PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var KERDESEK = objectToArray(szurheto_adatok.kerdesek);

var GRAFIKON_ADATOK = [];

var validKerdesek = getValidKerdesek(KERDESEK, KERDOIVEK);

var jelentesek = null;

$(document).ready(function() {

    google.charts.load('current', {packages: ['corechart', 'line']});

    var jelentes_szuro = {
        inic_param: {
                id: 'jelentes_szuro',
                cols: 3,
                rows: 3,
            },
            buttons: [
                {
                    name:"[[$t.szures]]",
                    id: 'btn_riport_szures',
                    type: 'filter',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            $('#jelentes-holder').html('');
                            $('#btn_riport_nyomtatas').removeClass('is-inactive');
                            $('#btn_riport_nyomtatas').prop('disabled', false);
                            $('.megjelenites-vezerles').removeClass('d-none');
                            $('.megjelenites-vezerles input').prop('checked', false);
                            GRAFIKON_ADATOK = [];
                            nyersAdatokLekeres();    
                        }
                        
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }    
                },
                {
                    name:"[[$t.nyomtatas]]",
                    id: 'btn_riport_nyomtatas',
                    type: 'print',
                    addClass : 'mb-2',
                    visibility: function() {
                        return 0;
                    },
                    callback: function(e) {
                        var partnerId = $('#partner_select_input').val()[0];
                        var partner = findInArray(PARTNEREK, 'id', partnerId);

                        var reportData = {
                            tipus: '[[$t.jelentesek_osszevont]]',
                            partner: partner
                        };
                        printData(reportData, 'osszesitett');
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                }
            ],
            inputs: [
                {"col": 1, "row": 0, "input": filterSelectHtml({
                                                                id: 'kerdoiv_select_input',
                                                                label: '[[$t.kerdoiv]]',
                                                                placeholder: '[[$t.valassz]]',
                                                                name: 'kerdoiv_select_input',
                                                                maxOptions: '1',
                                                                addclass: 'form',
                                                                required: true
                                                            },
                                                            filterSelectValues(szurheto_adatok.kerdoivek, 'nev', 'id')
                                                        )
                 },
                {"col": 0, "row": 0, "input": filterSelectHtml({
                                    id: 'partner_select_input',
                                    label: '[[$t.partner]]',
                                    placeholder: '[[$t.valassz]]',
                                    name: 'partner_select_input',
                                    maxOptions: '1',
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },

                {"col": 0, "row": 1, "input": filterSelectHtml({
                                    id: 'regio_select_input',
                                    label: '[[$t.regio]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'regio_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.regiok  , 'nev', 'id')
                            )
                },
                {"col": 1, "row": 1, "input": filterSelectHtml({
                                    id: 'telephely_select_input',
                                    label: '[[$t.telephely]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'telephely_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                }, 
                                filterSelectValues(szurheto_adatok.telephelyek, 'nev', 'id')
                            )
                },
                {"col": 2, "row": 1, "input": filterSelectHtml({
                                    id: 'eszkoz_select_input',
                                    label: '[[$t.eszkoz]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'eszkoz_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.eszkozok, 'nev', 'id')
                            )
                },
                {"col": 0, "row": 2, "input": filterSelectHtml({
                                                    id: 'idoszak_select_input',
                                                    placeholder: '[[$t.mind]]',
                                                    label: '[[$t.idoszak]]',
                                                    name: 'idoszak_select_input',
                                                    maxOptions: '1',
                                                    addclass: 'form'
                                                },
                                                [
                                                    {name:'[[$t.ma]]', value:'ma'},
                                                    {name:'[[$t.elozo_nap]]', value:'tegnap'},
                                                    {name:'[[$t.utolso_het]]', value:'utolso_het'},
                                                    {name:'[[$t.utolso_honap]]', value:'utolso_honap'},
                                                    {name:'[[$t.ez_a_honap]]', value:'ez_a_honap'},
                                                    {name:'[[$t.elozo_honap]]', value:'elozo_honap'},
                                                    {name:'[[$t.ez_az_ev]]', value:'ez_az_ev'},
                                                    {name:'[[$t.egyeb]]', value:'sajat'}
                                                ]
                )},
                {"col": 1, "row": 2, "input": datepickerHtml({ 
                                                id: 'kezdo_datum_input',
                                                label: '[[$t.kezdo_datum]]',
                                                addClass: 'd-none',
                                                dateOnly: true
                                            })
                },
                {"col": 2, "row": 2, "input": datepickerHtml({
                                    id: 'veg_datum_input',
                                    label: '[[$t.veg_datum]]',
                                    addClass: 'd-none',
                                    dateOnly: true
                                })
                },
            ],
    };

    formHtml('#jelentes_szuro', jelentes_szuro.inic_param, jelentes_szuro.inputs, jelentes_szuro.buttons);

    /*Firefoxban enélkül nem jelennek meg a selectek*/
    $('#szuro_select_input').selectpicker();
    $('#partner_select_input').selectpicker();
    $('#kerdoiv_select_input').selectpicker();
    $('#kerdes_select_input').selectpicker();
    $('#regio_select_input').selectpicker();
    $('#telephely_select_input').selectpicker();
    $('#eszkoz_select_input').selectpicker();
    $('#idoszak_select_input').selectpicker();

    $('.selectpicker').on('change', function() {
        selectUjraepites(this.id);
    });

    initDatepicker({id: 'kezdo_datum_input', dateOnly: true});
    initDatepicker({id: 'veg_datum_input', dateOnly: true});

    initChartAndTableTogglers();

});

function selectUjraepites(selectId, force) {

    var selectTipus = selectId.split('_')[0];

    var selectErtekek = $('#'+selectId).val();

    switch(selectTipus) {
        case 'partner':
            if(selectErtekek.length == 0) {
                szuroNullazas();
            } else {
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('kerdes',selectTipus,selectErtekek);
            }
        break;
        case 'regio':
            if(selectErtekek.length == 0 && !force) {
                selectUjraepites('regio_select_input', 1);
            } else if(selectErtekek.length == 0 && $('#kerdoiv_select_input').val().length != 0) {
                selectUjraepites('kerdoiv_select_input');
            } else if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            } else {
                if(force) {
                    selectErtekek = [];
                    $("#regio_select_input option").each(function() {
                        selectErtekek.push($(this).val());
                    });
                }
                var szurtTelephelyek = selectSzures('telephely',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('telephely','kerdoiv',$('#kerdoiv_select_input').val(), szurtTelephelyek);
                }

                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }

        break;
        case 'telephely':
            if(selectErtekek.length == 0) {
                selectUjraepites('regio_select_input');
            } else {
                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#regio_select_input').val().length != 0) {
                    szurtEszkozok = selectSzures('eszkoz','regio',$('#regio_select_input').val(), szurtEszkozok);
                }
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }
        break;
        case 'kerdoiv':
            if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            }
            else {
                selectSzures('kerdes',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
            }
            
        break;

        case 'szuro':
            disableInput($('#regio_select_input'), false);
            disableInput($('#telephely_select_input'), false);
            disableInput($('#eszkoz_select_input'), false);
            if(selectErtekek.length > 0) {
                var lebontas = selectErtekek[0];
                switch(lebontas) {
                    case 'regio':
                        disableInput($('#telephely_select_input'), true);
                        disableInput($('#eszkoz_select_input'), true);
                    break;
                    case 'telephely':
                        disableInput($('#eszkoz_select_input'), true);
                    break;
                }
            } else {

            }
        break;
    }

    

}

function szuroNullazas() {
    refillSelect('partner_select_input',filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id'));
    refillSelect('kerdoiv_select_input',filterSelectValues(szurheto_adatok.kerdoivek , 'nev', 'id'));
    refillSelect('regio_select_input',filterSelectValues(szurheto_adatok.regiok , 'nev', 'id'));
    refillSelect('telephely_select_input',filterSelectValues(szurheto_adatok.telephelyek , 'nev', 'id'));
    refillSelect('eszkoz_select_input',filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id'));
    refillSelect('kerdes_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));
}

/*Nyers adatok lekérdezése*/
function nyersAdatokLekeres() {
    var idoszak = $('#idoszak_select_input').val()[0];
    var telephelyIdk = $('#telephely_select_input').val();
    var regioIdk = $('#regio_select_input').val();

    var telephelyek = {};

    /*Ha telephely ki van választva, akkor a régió telephelyei nem kellenek*/
    if(telephelyIdk.length == 0) {
        for(var i in regioIdk) {
            var regio = szurheto_adatok.regiok[regioIdk[i]];
            for(var j in regio.telephelyek) {
                telephelyek[regio.telephelyek[j].id] = regio.telephelyek[j].id;
            }
        }
    }

    for(var i in telephelyIdk) {
        if(!isDefined(telephelyek[telephelyIdk[i]])) {
            telephelyek[telephelyIdk[i]] = telephelyIdk[i];
        }
    }

    var telephelyekTomb = [];
    $.each(telephelyek, function(kulcs, ertek) {
        telephelyekTomb.push(ertek);
    }); 

   /* var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId);
    var ces_e = adatok['ces_e'];
    console.log("adatok ",adatok);
    if(ces_e){
        var cesKerdesek="vala;";
    }*/



    var kerdoivId = $('#kerdoiv_select_input').val()[0];
    var nyelv = act_lang;
    if(!isDefined(KERDOIVEK[kerdoivId].json.nyelvek[act_lang])) {
        nyelv = Object.keys(KERDOIVEK[kerdoivId].json.nyelvek)[0];
    }
    console.log("kerdoivek ",KERDOIVEK[kerdoivId].json.nyelvek[nyelv]);
   

    var npsKerdesek = KERDOIVEK[kerdoivId].json.nyelvek[nyelv].rendszerszintu_kerdesek;
    if(npsKerdesek.length > 0) {
        var npsKerdesId = KERDOIVEK[kerdoivId].json.nyelvek[nyelv].rendszerszintu_kerdesek[0].id;
        var eszkoz_idk = $('#eszkoz_select_input').val();
        if (eszkoz_idk?.length === 0) {
            eszkoz_idk = Object.keys(szurheto_adatok.eszkozok);
        }
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "kerdoiv_idk": JSON.stringify([kerdoivId]),
            "eszkoz_idk": JSON.stringify(eszkoz_idk),
            "telephely_idk": JSON.stringify(telephelyekTomb),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_id": npsKerdesId
        };
      
        var resultText = {};
        postApi('jelentesek_sel_osszevont_nps',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo) && result.data.length > 0) {
                
                initDataTable(result.data, kerdoivId, npsKerdesId);
            } else if(result.data.length == 0) {
                var telephelyek = $('#telephely_select_input').val();
                if (telephelyek.length === 0) {
                    $('#telephely_select_input option').each(function() {
                        telephelyek.push($(this).attr('value'));
                    });
                }   
                initTelephelyPart(telephelyek);
            }
        });
    } else {
        var telephelyek = $('#telephely_select_input').val();
        if (telephelyek.length === 0) {
            $('#telephely_select_input option').each(function() {
                telephelyek.push($(this).attr('value'));
            });
        }   
        initTelephelyPart(telephelyek); 
    }


    var cesKerdesek;
    var cesKerdesId;
    for(var i=0;i<KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek.length;i++){
        if(KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i].kerdes_extrak.length===0){
            console.log("ez 000");
        }else{
            for(var j in KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i].kerdes_extrak){
                if(KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i].kerdes_extrak[j].adat_kod==="ces"){
                    cesKerdesek=KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i];
                    cesKerdesId=KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i].id;
                    console.log("cesKerdesekId",cesKerdesId);
                }
            }
            console.log("kerdes extra ",KERDOIVEK[kerdoivId].json.nyelvek[nyelv].kerdesek[i].kerdes_extrak);

        }
    }
    if(cesKerdesId!==null){
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "kerdoiv_idk": JSON.stringify([kerdoivId]),
            "eszkoz_idk": JSON.stringify($('#eszkoz_select_input').val()),
            "telephely_idk": JSON.stringify(telephelyekTomb),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_id": cesKerdesId
        };
      console.log("data ",data);
       
      var resultText = {};
           postApi('jelentesek_sel_osszevont_nps',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo) && result.data.length > 0) {
     initDataTableCES(result.data, kerdoivId,cesKerdesId);
            } else if(result.data.length == 0) {
                var telephelyek = [];
                $('#telephely_select_input option').each(function() {
                    telephelyek.push($(this).attr('value'));
                });
                initTelephelyPart(telephelyek);
            }
        });
    } else {
        var telephelyek = [];
        $('#telephely_select_input option').each(function() {
            telephelyek.push($(this).attr('value'));
        });
        initTelephelyPart(telephelyek); 
    }
    
    
}

function initDataTableCES(kitoltesek, kerdoivId,cesKerdesId) {
    var feldolgozottAdatCES = adatFeldolgozasCES(kitoltesek,cesKerdesId);
    console.log("kitoltesek: ",kitoltesek);
    console.log("feldolgoztt adatt",feldolgozottAdatCES);
    if(feldolgozottAdatCES.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];
    console.log("ceskerdesid d ",cesKerdesId);
    var metaadatok=tablaMetaadatok(cesKerdesId);
    console.log("meta adatok",metaadatok);
    var trendtNev = '[[$t.honap]]';

    tablaFejlec.push({ headName:trendtNev, colName:"idopont",canOrder: false});
    tablaFejlec.push({ headName:"[[$t.partner]]", colName:"partner"});
    tablaFejlec.push({ headName:"[[$t.telephely]]", colName:"telephely"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true,canOrder: false});

    var offset = feldolgozottAdatCES.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdatCES.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdatCES.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdatCES.fejlec[i],
                colName: 'valasz'+i,
                canOrder: false
            });
        } 
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {
        tablaFejlec.push({
            headName: feldolgozottAdatCES.fejlec[(feldolgozottAdatCES.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdatCES.fejlec.length-offset)
        });
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdatCES.sorok) {
        var feldolgozottAdatSor = feldolgozottAdatCES.sorok[i];
        var ujSor = {
            "idopont": feldolgozottAdatSor.metaadatok.idopont,
            "partner": arrayToString(metaadatok.partnerek),
            "telephely": feldolgozottAdatSor.metaadatok.telephely,
            "id" : feldolgozottAdatSor.metaadatok.idopont_id
        };
        var offset = feldolgozottAdatCES.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }
        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;

        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }

        tablaSorok.push(ujSor);        
    }

    var lathatosagSelect = filterSelectHtml({
            id: 'lathatosag_select_input-'+cesKerdesId,
            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
            name: 'lathatosag_select_input-'+cesKerdesId,
            maxOptions: 'inf',
            addclass: 'form cf-report-visibility'
        },
        [
            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
        ]
    );

    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_'+cesKerdesId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }   
    });

    $('#jelentes-holder').append('<div id="tabla-blokk-'+cesKerdesId+'" class="mb-4"></div>');

    var szuresiAdatokCES = "[[$t.osszevont_szuresi_szoveg_ces]]"; 

    $('#tabla-blokk-'+cesKerdesId).html('<h2 class="table_name">'+feldolgozottAdatCES.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatokCES+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+cesKerdesId+'"></div></div>');
    
    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'id',cesKerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);    
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }
    
    szuresiAdatokOsszeallitas('#tabla-blokk-'+cesKerdesId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+cesKerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_osszevont]]' + ' ' + datumStr
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-'+cesKerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+cesKerdesId).selectpicker();
    $('#btn_riport_export_'+cesKerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });
    createGrafikon(feldolgozottAdatCES.grafikon, cesKerdesId, true);

    initTelephelyPart(feldolgozottAdatCES.telephelyek, feldolgozottAdatCES.telephely_nevek);
}



function initDataTable(kitoltesek, kerdoivId, npsKerdesId) {
    var feldolgozottAdat = adatFeldolgozas(kitoltesek, npsKerdesId);

    if(feldolgozottAdat.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];
    var metaadatok = tablaMetaadatok(npsKerdesId);
    var trendtNev = '[[$t.honap]]';

    tablaFejlec.push({ headName:trendtNev, colName:"idopont",canOrder: false});
    tablaFejlec.push({ headName:"[[$t.partner]]", colName:"partner"});
    tablaFejlec.push({ headName:"[[$t.telephely]]", colName:"telephely"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true,canOrder: false});

    var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdat.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdat.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdat.fejlec[i],
                colName: 'valasz'+i,
                canOrder: false
            });
        } 
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {
        tablaFejlec.push({
            headName: feldolgozottAdat.fejlec[(feldolgozottAdat.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdat.fejlec.length-offset)
        });
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdat.sorok) {
        var feldolgozottAdatSor = feldolgozottAdat.sorok[i];
        var ujSor = {
            "idopont": feldolgozottAdatSor.metaadatok.idopont,
            "partner": arrayToString(metaadatok.partnerek),
            "telephely": feldolgozottAdatSor.metaadatok.telephely,
            "id" : feldolgozottAdatSor.metaadatok.idopont_id
        };
        var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }
        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;

        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }

        tablaSorok.push(ujSor);        
    }

    var lathatosagSelect = filterSelectHtml({
            id: 'lathatosag_select_input-'+npsKerdesId,
            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
            name: 'lathatosag_select_input-'+npsKerdesId,
            maxOptions: 'inf',
            addclass: 'form cf-report-visibility'
        },
        [
            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
        ]
    );

    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_'+npsKerdesId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }   
    });

    $('#jelentes-holder').append('<div id="tabla-blokk-'+npsKerdesId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.osszevont_szuresi_szoveg]]"; 

    $('#tabla-blokk-'+npsKerdesId).html('<h2 class="table_name">'+feldolgozottAdat.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+npsKerdesId+'"></div></div>');
    
    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'id',npsKerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);    
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }
    
    szuresiAdatokOsszeallitas('#tabla-blokk-'+npsKerdesId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+npsKerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_osszevont]]' + ' ' + datumStr
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-'+npsKerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+npsKerdesId).selectpicker();
    $('#btn_riport_export_'+npsKerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });
    createGrafikon(feldolgozottAdat.grafikon, npsKerdesId, true);

    initTelephelyPart(feldolgozottAdat.telephelyek, feldolgozottAdat.telephely_nevek);
}

function adatFeldolgozas(kitoltesek, npsKerdesId) {

    if(kitoltesek.length == 0) {
        return [];
    }

    var van_szarmaztatott = false;

    var telephelyLista = [];

    /*Előzetes feldolgozás, itt a db nem összevonva adja az adatokat*/
    var osszevontKitoltesek = {};
    for(var i in kitoltesek) {
        var ev = kitoltesek[i].ev;
        var honap = kitoltesek[i].honap;
        var telephelyId = kitoltesek[i].telephely_id;

        if($.inArray(telephelyId,telephelyLista) < 0) {
            telephelyLista.push(telephelyId);
        }
        if(osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId] == undefined) {
            osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId] = {
                ev: ev,
                honap: honap,
                telephely_id: telephelyId,
                valasz_sorszam: {}
            };

            osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] = 1;
            
        } else {
            if(osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] == undefined) {
                osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] = 1;
            } else {
                osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam]++;
            }
        }
    }

    osszevontKitoltesek = objectToArray(osszevontKitoltesek);

    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};

    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, npsKerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var nps_e =  1;

    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;

    var tabla = [];

    /*CELLÁK*/

    for(var i in osszevontKitoltesek) {
        var kitoltes = osszevontKitoltesek[i];
        var idopont = kitoltes['ev']+'/'+kitoltes['honap'];
        var telephelyId = kitoltes.telephely_id;

        for(var j in kitoltes.valasz_sorszam) {

            var korrigaltValaszSorszam = parseInt(j) - 1;

            var sorAzon = idopont+'#'+telephelyId;
            if(!isDefined(tabla[sorAzon])) {
                tabla[sorAzon] = tombokTombjeInic(tablaFejlec.length, "0");
            }

            /*Itt csak NPS-kérdés lehet*/
            /*detractors*/
            if(korrigaltValaszSorszam < 7) {
                tabla[sorAzon][2] = isDefined(tabla[sorAzon][2]) ? parseInt(tabla[sorAzon][2]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
            /*neutrals*/ 
            else if(korrigaltValaszSorszam < 9) {
                tabla[sorAzon][1] = isDefined(tabla[sorAzon][1]) ? parseInt(tabla[sorAzon][1]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
            /*promoters*/
            else {
                tabla[sorAzon][0] = isDefined(tabla[sorAzon][0]) ? parseInt(tabla[sorAzon][0]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
        }
        
    }

    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        if(isDefined(sor) && sor != null) {
            var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,nps_e);

            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }

            var idopont = i.split('#')[0];
            var telephelyId = i.split('#')[1];
            var ujSor = {
                metaadatok: {
                    idopont: idopont,
                    idopont_id: idopont,
                    telephely_id: telephelyId,
                    telephely: findInArray(TELEPHELYEK, 'id', telephelyId).nev,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
        }
    }

    /*Idegen nyelvek miatt kell*/
    kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

    /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
    var kerdesSzoveg = '';
    var kerdoivIdk = $('#kerdoiv_select_input').val();

    if(kerdes.id == "2" && kerdoivIdk.length == 1) {
        kerdesSzoveg = kerdes.kerdes_szoveg;
    } else {
        kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
    }


    var telephelyNevLista = [];

    for(var i in telephelyLista) {
        telephelyNevLista.push(findInArray(TELEPHELYEK, 'id', telephelyLista[i]).nev);
    }

    grafikonAdatok = {
        "szoveg":kerdesSzoveg,
        "tipus": kerdes.valasz_tipus_kod,
        "nps": 0,
        "lehetseges_valaszok": telephelyNevLista,
        "lebontasok": [],
        "data": []
    };

    for(var i in tablaSorok) {
        var sor = tablaSorok[i];
        if($.inArray(sor.metaadatok.idopont, grafikonAdatok["lebontasok"]) < 0) {
            grafikonAdatok["lebontasok"].push(sor.metaadatok.idopont);
        }
    }

    for(var i in telephelyLista) {
        var telephelyNev = telephelyNevLista[i];
        var data = [];
        for(var j in grafikonAdatok["lebontasok"]) {
            data[grafikonAdatok["lebontasok"][j]] = 0;
        }
        for(var j in tablaSorok) {
            var sor = tablaSorok[j];
            if(sor.metaadatok.telephely_id == telephelyLista[i]) {
                data[sor.metaadatok.idopont] = sor.sor_adat[sor.sor_adat.length - 1].replace(/%/g, '')
            }
        }

        var reorgData = [];
        for(var j in data) {
            reorgData.push(data[j]);
        }

        var dataset = {
            label: telephelyNev,
            data: reorgData
        };
        grafikonAdatok["data"].push(dataset);
        
    }

    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        telephelyek: telephelyLista,
        telephely_nevek: telephelyNevLista,
        van_szarmaztatott: van_szarmaztatott
    }
}
function adatFeldolgozasCES(kitoltesek, cesKerdesId) {

    if(kitoltesek.length == 0) {
        return [];
    }

    var van_szarmaztatott = false;

    var telephelyLista = [];

    /*Előzetes feldolgozás, itt a db nem összevonva adja az adatokat*/
    var osszevontKitoltesek = {};
    for(var i in kitoltesek) {
        var ev = kitoltesek[i].ev;
        var honap = kitoltesek[i].honap;
        var telephelyId = kitoltesek[i].telephely_id;

        if($.inArray(telephelyId,telephelyLista) < 0) {
            telephelyLista.push(telephelyId);
        }
        if(osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId] == undefined) {
            osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId] = {
                ev: ev,
                honap: honap,
                telephely_id: telephelyId,
                valasz_sorszam: {}
            };

            osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] = 1;
            
        } else {
            if(osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] == undefined) {
                osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam] = 1;
            } else {
                osszevontKitoltesek[ev +'/'+honap+'/'+telephelyId].valasz_sorszam[kitoltesek[i].valasz_sorszam]++;
            }
        }
    }

    osszevontKitoltesek = objectToArray(osszevontKitoltesek);

    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};

    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, cesKerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var ces_e =  1;

    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;

    var tabla = [];

    /*CELLÁK*/

    for(var i in osszevontKitoltesek) {
        var kitoltes = osszevontKitoltesek[i];
        var idopont = kitoltes['ev']+'/'+kitoltes['honap'];
        var telephelyId = kitoltes.telephely_id;

        for(var j in kitoltes.valasz_sorszam) {
            var ValaszSorszam=parseInt(j);
            var korrigaltValaszSorszam = parseInt(j) - 1;

            var sorAzon = idopont+'#'+telephelyId;
            if(!isDefined(tabla[sorAzon])) {
                tabla[sorAzon] = tombokTombjeInic(tablaFejlec.length, "0");
            }

            /*Itt csak ces-kérdés lehet*/
            /*detractors*/
            if(ValaszSorszam== 1 || ValaszSorszam==2) {
                tabla[sorAzon][2] = isDefined(tabla[sorAzon][2]) ? parseInt(tabla[sorAzon][2]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
            /*neutrals*/ 
            else if(ValaszSorszam ==3) {
                tabla[sorAzon][1] = isDefined(tabla[sorAzon][1]) ? parseInt(tabla[sorAzon][1]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
            /*promoters*/
            else if(ValaszSorszam==4 || ValaszSorszam==5) {
                tabla[sorAzon][0] = isDefined(tabla[sorAzon][0]) ? parseInt(tabla[sorAzon][0]) + parseInt(kitoltes.valasz_sorszam[j]) : kitoltes.valasz_sorszam[j];
            }
        }
        
    }

    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        if(isDefined(sor) && sor != null) {
            var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,false,ces_e);

            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }

            var idopont = i.split('#')[0];
            var telephelyId = i.split('#')[1];
            var ujSor = {
                metaadatok: {
                    idopont: idopont,
                    idopont_id: idopont,
                    telephely_id: telephelyId,
                    telephely: findInArray(TELEPHELYEK, 'id', telephelyId).nev,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
        }
    }

    /*Idegen nyelvek miatt kell*/
    kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

    /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
    var kerdesSzoveg = '';
    var kerdoivIdk = $('#kerdoiv_select_input').val();

    if(kerdes.id == "2" && kerdoivIdk.length == 1) {
        kerdesSzoveg = kerdes.kerdes_szoveg;
    } else {
        kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
    }


    var telephelyNevLista = [];

    for(var i in telephelyLista) {
        telephelyNevLista.push(findInArray(TELEPHELYEK, 'id', telephelyLista[i]).nev);
    }

    grafikonAdatok = {
        "szoveg":kerdesSzoveg,
        "tipus": kerdes.valasz_tipus_kod,
        "nps": 0,
        "ces":0,
        "lehetseges_valaszok": telephelyNevLista,
        "lebontasok": [],
        "data": []
    };

    for(var i in tablaSorok) {
        var sor = tablaSorok[i];
        if($.inArray(sor.metaadatok.idopont, grafikonAdatok["lebontasok"]) < 0) {
            grafikonAdatok["lebontasok"].push(sor.metaadatok.idopont);
        }
    }

    for(var i in telephelyLista) {
        var telephelyNev = telephelyNevLista[i];
        var data = [];
        for(var j in grafikonAdatok["lebontasok"]) {
            data[grafikonAdatok["lebontasok"][j]] = 0;
        }
        for(var j in tablaSorok) {
            var sor = tablaSorok[j];
            if(sor.metaadatok.telephely_id == telephelyLista[i]) {
                data[sor.metaadatok.idopont] = sor.sor_adat[sor.sor_adat.length - 1].replace(/%/g, '')
            }
        }

        var reorgData = [];
        for(var j in data) {
            reorgData.push(data[j]);
        }

        var dataset = {
            label: telephelyNev,
            data: reorgData
        };
        grafikonAdatok["data"].push(dataset);
        
    }

    console.log("tabla sorok",tablaSorok);
    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        telephelyek: telephelyLista,
        telephely_nevek: telephelyNevLista,
        van_szarmaztatott: van_szarmaztatott
    }
}

function szuresiAdatokOsszeallitas(id) {
    var szoveg = $(id).find('.cf-filter-string').html();
    var idoszak = $('#idoszak_select_input').val()[0];

    szoveg = szoveg.replace('#kezdo_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).kezdet.split(' ')[0])+'</span>');
    szoveg = szoveg.replace('#veg_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).veg.split(' ')[0])+'</span>');


    $(id).find('.cf-filter-string').html(szoveg);

}

function createGrafikon(grafikon, id, falseNps) {

    $('#charts').html('');

    if(grafikon.tipus == "szabad_szoveg") { return; }

    var lebontasokSzama = grafikon.lebontasok.length;

    if(lebontasokSzama > 0) {

        var szinek = [];

        var width = parseInt($('#jelentes-holder').width()) * 0.6;

        /*$('#tabla-blokk-'+id).append('<div style="margin:auto;height:500px; width:'+width+'px"><canvas id="chart-'+id+'"></canvas></div>');*/
        $('#tabla-blokk-'+id).append('<div class="canvas-holder" style="margin:auto;height:500px"><canvas id="chart-'+id+'" ></canvas></div>');

        if(grafikon.nps == "1") {
            szinek = szinGeneralas('NPS', grafikon.lehetseges_valaszok.length, 'line');
            drawLineChart('chart-'+id, grafikon.lebontasok, grafikon.data, szinek, true, grafikon.tipus);

        }else if(grafikon.ces=="1"){
            szinek = szinGeneralas('CES', grafikon.lehetseges_valaszok.length, 'line');
            drawLineChart('chart-'+id, grafikon.lebontasok, grafikon.data, szinek, false,true, grafikon.tipus);

        }else {
            szinek = szinGeneralas(grafikon.tipus, grafikon.lehetseges_valaszok.length, 'line');
            drawLineChart('chart-'+id, grafikon.lebontasok, grafikon.data, szinek, false,false,falseNps ? 'oszzevont_nps' : grafikon.tipus);
        }

        /*Lehetséges nyomtatáshoz kellenek*/
        GRAFIKON_ADATOK.push({
            id:id,
            adat: grafikon
        });

       
    }

}

/*Telephelyenkénti jelentések inicializálása*/
function initTelephelyPart(telephelyLista, telephelyNevLista) {
    console.log(telephelyLista);
    var kerdoivId = $('#kerdoiv_select_input').val()[0];
    var idoszak = $('#idoszak_select_input').val()[0];

    function call_jelentesek_sel_osszevont_telephely(ind) {
        var telephelyId = telephelyLista[ind];
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "kerdoiv_id": kerdoivId,
            "telephely_id": telephelyId
        };
    
        var resultText = {};
    
        postApi('jelentesek_sel_osszevont_telephely',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo)) {
                telephelyStats(result.data,telephelyId);
                if(ind < telephelyLista.length - 1) {
                    ind++;
                    call_jelentesek_sel_osszevont_telephely(ind);
                }
            }
        });
    }

    if(telephelyLista.length > 0) {
        call_jelentesek_sel_osszevont_telephely(0);
    }

}

function telephelyStats(kitoltesek, telephelyId) {
    /*Adat feldolgozas*/
    var feldolgozottAdat = [];
    var kerdesCsoportok = [];
    for(var i in kitoltesek) {
        var kitoltes = kitoltesek[i];

        var kerdesAzon = findInArray(KERDESEK, 'id', kitoltes.kerdes_id)['azonosito'];
        var kerdesAdatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesAzon);

        if(!kerdesAdatok.van_szarmaztatott_ertek) {
            continue;
        }

        var kerdesCsoport = null;
        var sorAzonosito = kitoltes.ev +'/'+kitoltes.honap+'#'+kitoltes.kerdes_id;

        /*Kérdéscsoportokat összevontan, egy kérdésként kell kezelni*/
        if(kerdesAdatok.kerdes.kerdes_csoport_id != null) {
            sorAzonosito = kitoltes.ev +'/'+kitoltes.honap+'#cs'+kerdesAdatok.kerdes.kerdes_csoport_id;
            var kerdesCsoportAzon = findInArray(KERDESEK, 'id', kerdesAdatok.kerdes.kerdes_csoport_id)['azonosito'];
            kerdesCsoport = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesCsoportAzon);
            if($.inArray(kerdesAdatok.kerdes.kerdes_csoport_id, kerdesCsoportok) < 0) {
                kerdesCsoportok.push(kerdesAdatok.kerdes.kerdes_csoport_id);
            }  
        }

        if(!isDefined(feldolgozottAdat[sorAzonosito])) {

            var valaszokSzama = 0;
            var max = 0;
            if(kerdesAdatok.kerdes.valasz_tipus_kod == 'igen_nem') {
                valaszokSzama = 2;
            } else if(kerdesAdatok.kerdes.valasz_tipus_kod.slice(0,8) == 'ikonok-5') { 
                max = 5;
                valaszokSzama = 5;
            } else if(kerdesAdatok.kerdes.valasz_tipus_kod == 'szamok-1-10'){
                max = 10;
                valaszokSzama = 10;
            } else if(kerdesAdatok.kerdes.valasz_tipus_kod == 'szamok-1-6') {
                max = 6;
                valaszokSzama = 6;
            } else if(kerdesAdatok.kerdes.valasz_tipus_kod == 'szamok-1-5') {
                max = 5;
                valaszokSzama = 5;
            }

            feldolgozottAdat[sorAzonosito] = {
                idopont: kitoltes.ev+'/'+kitoltes.honap,
                kerdes: kerdesCsoport != null ? kerdesCsoport.kerdes : kerdesAdatok.kerdes,
                kerdes_id: kerdesCsoport != null ? kerdesCsoport.kerdes.id : kitoltes.kerdes_id,
                valasz_sorszamok: tombInic(kerdesAdatok.lehetsegesValaszok.length, 0),
                is_csoport: kerdesCsoport != null
            };

            feldolgozottAdat[sorAzonosito].valasz_sorszamok[kitoltes.valasz_sorszam] = 1;
        }
        else {
            if(!isDefined(feldolgozottAdat[sorAzonosito].valasz_sorszamok[kitoltes.valasz_sorszam])) {
                feldolgozottAdat[sorAzonosito].valasz_sorszamok[kitoltes.valasz_sorszam] = 1;
            } else {
                feldolgozottAdat[sorAzonosito].valasz_sorszamok[kitoltes.valasz_sorszam] += 1;
            }
        }
    }

    /*FEJLÉC*/
    var tablaFejlec = [];
    tablaFejlec.push({ headName:'[[$t.honap]]', colName:"idopont"});
    tablaFejlec.push({ headName:'[[$t.kerdes]]', colName:"kerdes"});
    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});
    tablaFejlec.push({ headName:'[[$t.eredmeny]]', colName:"eredmeny"});

    /*Telephely neve*/
    var telephely = findInArray(TELEPHELYEK, 'id', telephelyId);
    var telephelyNev = telephely['nev'];

    /*SOROK*/
    var tablaSorok = [];
    var seged = [];
    for(var i in feldolgozottAdat) {
        var feldolgozottAdatSor = feldolgozottAdat[i];


        /*Csoport esetén nem a csoport típusa számít, hanem az alkérdéseké*/
        var kerdesTipusKod = feldolgozottAdatSor.kerdes.valasz_tipus_kod;
        if(feldolgozottAdatSor.is_csoport) {
            kerdesTipusKod = feldolgozottAdatSor.kerdes.alkerdesek[0].valasz_tipus_kod;
        }

        var valaszok_szama = 0;
        for(var i in feldolgozottAdatSor.valasz_sorszamok) {
            valaszok_szama += +feldolgozottAdatSor.valasz_sorszamok[i];
        }

        var eredmeny;
        if (kerdesTipusKod !== 'igen_nem') {
            eredmeny = szarmaztatottErtekSzamitas(kerdesTipusKod,feldolgozottAdatSor.valasz_sorszamok.reverse(),kerdesAdatok.nps_e,kerdesAdatok.ces_e);
        } else {
            eredmeny = szarmaztatottErtekSzamitas(kerdesTipusKod,feldolgozottAdatSor.valasz_sorszamok,kerdesAdatok.nps_e,kerdesAdatok.ces_e);
        }


        var ujSor = {
            "idopont": feldolgozottAdatSor.idopont,
            "kerdes_id": feldolgozottAdatSor.kerdes ? feldolgozottAdatSor.kerdes.id : '',
            "kerdes": feldolgozottAdatSor.kerdes ? feldolgozottAdatSor.kerdes['kerdes_szoveg'] : '',
            "eredmeny": eredmeny,
            "valaszok_szama": valaszok_szama
        };

        tablaSorok.push(ujSor);
        
    }

    var lathatosagSelect = filterSelectHtml({
        id: 'lathatosag_select_input-t-'+telephelyId,
        /*label: '[[$t.tabla_es_grafikon_megjelenites]]',*/
        placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
        name: 'lathatosag_select_input-t-'+telephelyId,
        maxOptions: 'inf',
        addclass: 'form cf-report-visibility'
    },
    [
        {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
        {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
    ]
);

    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_t-'+telephelyId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }   
    });

    $('#jelentes-holder').append('<div id="tabla-blokk-t-'+telephelyId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.osszevont_telephely_szuresi_szoveg]]"; 

    $('#tabla-blokk-t-'+telephelyId).html('<h2 class="table_name">'+telephelyNev+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-t-'+telephelyId+'"></div></div>');

    var partnerNev = telephely.partner_nev;


    szuresiAdatokOsszeallitas('#tabla-blokk-t-'+telephelyId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-t-'+telephelyId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_trendek]]' + ' ' + formatDate(datumStr)
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-t-'+telephelyId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-t-'+telephelyId).selectpicker();
    $('#btn_riport_export_t-'+telephelyId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    /*GRAFIKON ADATOK*/

    var lebontasok = [];
    var valaszok = [];
    var grafikonData = [];
    for(var i in tablaSorok) {
        if($.inArray(tablaSorok[i].idopont, lebontasok) < 0) {
            lebontasok.push(tablaSorok[i].idopont);
        }

        if($.inArray(tablaSorok[i].kerdes, valaszok) < 0) {
            valaszok.push(tablaSorok[i].kerdes);
        }
    }

    var seged = [];
    for(var i in tablaSorok) {
        var idopontInd = $.inArray(tablaSorok[i].idopont,lebontasok);
        if(!isDefined(seged[tablaSorok[i].kerdes_id])) {
            grafikonData.push({
                label: tablaSorok[i].kerdes,
                data: tombInic(lebontasok.length, 0)
            });
            ind = grafikonData.length - 1;
            seged[tablaSorok[i].kerdes_id] = ind;

            grafikonData[ind].data[idopontInd] = tablaSorok[i].eredmeny.replace(/%/g, '');
        } else {
            grafikonData[seged[tablaSorok[i].kerdes_id]].data[idopontInd] = tablaSorok[i].eredmeny.replace(/%/g, '');
        }
    }

    var grafikon = {
        "szoveg": telephelyNev,
        "tipus": 'szamok0-10',
        "nps": 0,
        "ces":0,
        "lehetseges_valaszok": valaszok,
        "lebontasok": lebontasok,
        "data": grafikonData
    };

    createGrafikon(grafikon, 't-'+telephelyId);

}