/*Fontos tömbök inicializálása*/

/*2021.01.27. - Régiókat is szűrni kell jog alapján
  ezt csak telephelyeken keresztül lehet*/
  szurheto_adatok.regiok = regioSzuresTelephelyekkel();
var REGIOK = objectToArray(szurheto_adatok.regiok);
var TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
var PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var KERDESEK = objectToArray(szurheto_adatok.kerdesek);

var jelentesek = null;

var validKerdesek = getValidKerdesek(KERDESEK, KERDOIVEK);

var GRAFIKON_ADATOK = [];

$(document).ready(function() {

    /*charts.js behívása*/
    google.charts.load('current', {packages: ['corechart', 'bar']});

    var jelentes_szuro = {
        inic_param: {
                id: 'jelentes_szuro',
                cols: 4,
                rows: 3,
            },
            buttons: [
                {
                    name:"[[$t.szures]]",
                    id: 'btn_riport_szures',
                    type: 'filter',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            $('#jelentes-holder').html('');
                            $('#btn_riport_nyomtatas').removeClass('is-inactive');
                            $('#btn_riport_nyomtatas').prop('disabled', false);
                            
                            $('.megjelenites-vezerles').removeClass('d-none');
                            $('.megjelenites-vezerles input').prop('checked', false);
                            GRAFIKON_ADATOK = [];
                            nyersAdatokLekeres();
                        }
                        
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                },
                {
                    name:"[[$t.nyomtatas]]",
                    id: 'btn_riport_nyomtatas',
                    type: 'print',
                    addClass : 'mb-2',
                    visibility: function() {
                        return 0;
                    },
                    callback: function() {
                        var partnerId = $('#partner_select_input').val()[0];
                        var partner = findInArray(PARTNEREK, 'id', partnerId);

                        var reportData = {
                            tipus: '[[$t.jelentesek_ido]]',
                            partner: partner
                        };
                        console.log({reportData});
                        printData(reportData, 'column');
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                },
                
                
            ],
            inputs: [
                {"col": 2, "row": 0, "input": filterSelectHtml({
                                                                id: 'kerdoiv_select_input',
                                                                label: '[[$t.kerdoiv]]',
                                                                placeholder: '[[$t.mind]]',
                                                                name: 'kerdoiv_select_input',
                                                                maxOptions: 'inf',
                                                                addclass: 'form',
                                                            },
                                                            filterSelectValues(szurheto_adatok.kerdoivek, 'nev', 'id')
                                                        )
                 },
                 {"col": 0, "row": 0, "input": filterSelectHtml({
                                                    id: 'szuro_select_input',
                                                    label: '[[$t.lebontas]]',
                                                    placeholder: '[[$t.valassz]]',
                                                    name: 'szuro_select_input',
                                                    maxOptions: 1,
                                                    addclass: 'form',
                                                    required: true
                                                },
                                                [
                                                    {"name": '[[$t.nap_orai]]', "value": 'nap_orai'},
                                                    {"name": '[[$t.het_napjai]]', "value": 'het_napjai'}
                                                ]
                                            )
                                },
                {"col": 1, "row": 0, "input": filterSelectHtml({
                                    id: 'partner_select_input',
                                    label: '[[$t.partner]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'partner_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },
                {"col": 3, "row": 0, "input": filterSelectHtml({
                                                id: 'kerdes_select_input',
                                                label: '[[$t.kerdes]]',
                                                placeholder: '[[$t.mind]]',
                                                name: 'kerdes_select_input',
                                                maxOptions: 'inf',
                                                addclass: 'form',
                                            },
                                            filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false)
                                        )
                },
                {"col": 0, "row": 1, "input": filterSelectHtml({
                                    id: 'regio_select_input',
                                    label: '[[$t.regio]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'regio_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.regiok  , 'nev', 'id')
                            )
                },
                {"col": 1, "row": 1, "input": filterSelectHtml({
                                    id: 'telephely_select_input',
                                    label: '[[$t.telephely]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'telephely_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.telephelyek, 'nev', 'id')
                            )
                },
                {"col": 2, "row": 1, "input": filterSelectHtml({
                                    id: 'eszkoz_select_input',
                                    label: '[[$t.eszkoz]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'eszkoz_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.eszkozok, 'nev', 'id')
                            )
                },
                {"col": 0, "row": 2, "input": filterSelectHtml({
                                                    id: 'idoszak_select_input',
                                                    placeholder: '[[$t.mind]]',
                                                    label: '[[$t.idoszak]]',
                                                    name: 'idoszak_select_input',
                                                    maxOptions: '1',
                                                    addclass: 'form'
                                                },
                                                [
                                                    {name:'[[$t.ma]]', value:'ma'},
                                                    {name:'[[$t.elozo_nap]]', value:'tegnap'},
                                                    {name:'[[$t.utolso_het]]', value:'utolso_het'},
                                                    {name:'[[$t.utolso_honap]]', value:'utolso_honap'},
                                                    {name:'[[$t.ez_a_honap]]', value:'ez_a_honap'},
                                                    {name:'[[$t.elozo_honap]]', value:'elozo_honap'},
                                                    {name:'[[$t.ez_az_ev]]', value:'ez_az_ev'},
                                                    {name:'[[$t.egyeb]]', value:'sajat'}
                                                ]
                )},
                {"col": 1, "row": 2, "input": datepickerHtml({
                                                id: 'kezdo_datum_input',
                                                label: '[[$t.kezdo_datum]]',
                                                addClass: 'd-none'
                                            })
                },
                {"col": 2, "row": 2, "input": datepickerHtml({
                                    id: 'veg_datum_input',
                                    label: '[[$t.veg_datum]]',
                                    addClass: 'd-none'
                                })
                },
            ],
    };

    formHtml('#jelentes_szuro', jelentes_szuro.inic_param, jelentes_szuro.inputs, jelentes_szuro.buttons);


    /*Eseménykezelők*/
    /*Az egyedi datetimepicker csak akkor jelenik meg, ha az időszak választóban az Egyéb van kiválasztva*/
    $('#idoszak_select_input').on('change', function() {
        if($(this).val()[0] == 'sajat') {
            $('#kezdo_datum_input').parents('.dt-wrapper').removeClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').removeClass('d-none');
        } else {
            $('#kezdo_datum_input').parents('.dt-wrapper').addClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').addClass('d-none');
        }
    });

    $('.selectpicker').on('change', function() {
        selectUjraepites(this.id);
    });

    initDatepicker({id: 'kezdo_datum_input', dateOnly: true});
    initDatepicker({id: 'veg_datum_input', dateOnly: true});

   $('#szuro_select_input').selectpicker();
   $('#partner_select_input').selectpicker();
   $('#kerdoiv_select_input').selectpicker();
   $('#kerdes_select_input').selectpicker();
   $('#regio_select_input').selectpicker();
   $('#telephely_select_input').selectpicker();
   $('#eszkoz_select_input').selectpicker();
   $('#idoszak_select_input').selectpicker();
   
   initChartAndTableTogglers();

});

/*Nyers adatok lekérdezése*/
function nyersAdatokLekeres() {
    var kerdesek = $('#kerdes_select_input').val();
    /*Ha nincs kérdés kiválasztva, akkor mindre keresünk*/
    if(kerdesek.length == 0) {
        kerdesek = [];
        $('#kerdes_select_input option').each(function() {
            kerdesek.push($(this).val());
        });
    }

    var idoszak = $('#idoszak_select_input').val()[0];
    var telephelyIdk = $('#telephely_select_input').val();
    var regioIdk = $('#regio_select_input').val();

    var telephelyek = {};

    /*Ha telephely ki van választva, akkor a régió telephelyei nem kellenek*/
    if(telephelyIdk.length == 0) {
        for(var i in regioIdk) {
            var regio = szurheto_adatok.regiok[regioIdk[i]];
            for(var j in regio.telephelyek) {
                telephelyek[regio.telephelyek[j].id] = regio.telephelyek[j].id;
            }
        }
    }

    for(var i in telephelyIdk) {
        if(!isDefined(telephelyek[telephelyIdk[i]])) {
            telephelyek[telephelyIdk[i]] = telephelyIdk[i];
        }
    }

    var telephelyekTomb = [];
    $.each(telephelyek, function(kulcs, ertek) {
        telephelyekTomb.push(ertek);
    }); 


    var kerdoivek = $('#kerdoiv_select_input').val();
    /*Ha nincs kiválasztva a kérdőív, akkor az adott kérdést minden kérdőívben keressük*/
    if (kerdoivek.length == 0) {
        kerdoivek = [];
        $.each(szurheto_adatok.kerdoivek, function(index, kerdoiv){
            kerdoivek.push(kerdoiv.id);
        });
    }

        function call_jelentesek_sel_ido_szerint(ind) {
            var eszkoz_idk = $('#eszkoz_select_input').val();
            if (eszkoz_idk?.length === 0) {
                eszkoz_idk = Object.keys(szurheto_adatok.eszkozok);
            }
            var id = kerdesek[ind];
            var data = {
                "echo": "1",
                "idopont_tol": computeDates(idoszak).kezdet,
                "idopont_ig": computeDates(idoszak).veg,
                "idopont_elott": computeDates(idoszak).most,
                "talalat_tol": "0",
                "talalat_darab": "100",
                "kerdoiv_idk": JSON.stringify(kerdoivek),
                "eszkoz_idk": JSON.stringify(eszkoz_idk),
                "telephely_idk": JSON.stringify(telephelyekTomb),
                "partner_idk": JSON.stringify($('#partner_select_input').val()),
                "kerdes_id": id,
                "ido_tipus": $('#szuro_select_input').val()[0],
            };
        
            var resultText = {};
        
            postApi('jelentesek_sel_ido_szerint',data,$('#btn_riport_szures'),resultText,null,function(result){
                if(isDefined(result.echo)) {
                    initDataTable(result.data, id);
                    if(ind < kerdesek.length - 1) {
                        ind++;
                        call_jelentesek_sel_ido_szerint(ind);
                    }
                }
            });
        }

        if(kerdesek.length > 0) {
            call_jelentesek_sel_ido_szerint(0);
        }
     

}

function adatFeldolgozas(kitoltesek, idopontTipus, kerdesId) {
    /*Ha nincs adat, akkor nem kell dolgozni a semmivel*/
    if(kitoltesek.length == 0) {
        return [];
    }

    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};
    var van_szarmaztatott = false;

    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var nps_e =  adatok['nps_e'];
    var ces_e = adatok['ces_e'];

    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;

    var realLength = tablaFejlec.reduce(x => x+1, 0);
    var osszegzoSor = tombokTombjeInic(realLength, 0);

    var idopontIndMin;
    var idopontIndMax;
    var idopontIndNev;
    switch(idopontTipus) {
        case 'nap_orai':
            idopontIndNev = "nap_oraja";
            idopontIndMin = 0;
            idopontIndMax = 23;
        break;
        case 'het_napjai':
            idopontIndNev = "het_napja";
            idopontIndMin = 1;
            idopontIndMax = 7;
        break;
    }

    var tabla = [];
    for (var i = idopontIndMin; i <= idopontIndMax; ++i) {
        tabla[i] = tombokTombjeInic(tablaFejlec.length, "0");
    }

    /*CELLÁK*/
    for(var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var idopont = parseInt(kitoltes[idopontIndNev]);
        var korrigaltValaszSorszam = parseInt(kitoltes.valasz_sorszam) - 1;

        /*CES modell*/
        if(ces_e){
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8)=="ikonok-5"){
                /*detractors*/
                if(kitoltes.valasz_sorszam == 1 || kitoltes.valasz_sorszam == 2 ) {    
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if( kitoltes.valasz_sorszam == 3) { 
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else if(kitoltes.valasz_sorszam==4 || kitoltes.valasz_sorszam==5) {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            }
        /*NPS esetén más a tábla modellje*/ 
        }else if(nps_e) {
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8) == "ikonok-4") {
                if(kitoltes.valasz_sorszam == 1) {    
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(kitoltes.valasz_sorszam == 2) { 
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            } else {
                /*detractors*/
                if(korrigaltValaszSorszam < 7) {
                    tabla[idopont][2] = isDefined(tabla[idopont][2]) ? parseInt(tabla[idopont][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(korrigaltValaszSorszam < 9) {
                    tabla[idopont][1] = isDefined(tabla[idopont][1]) ? parseInt(tabla[idopont][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else {
                    tabla[idopont][0] = isDefined(tabla[idopont][0]) ? parseInt(tabla[idopont][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
                            }
            
        } else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
            tabla[idopont][tablaFejlec.length - 2 - korrigaltValaszSorszam] = kitoltes.elofordulas;
            osszegzoSor[tablaFejlec.length - 2 - korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
        } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
            tabla[idopont][korrigaltValaszSorszam] = kitoltes.elofordulas;
            osszegzoSor[korrigaltValaszSorszam] += parseInt(kitoltes.elofordulas);
        } else {
            tabla[idopont][kitoltes.valasz_sorszam] = kitoltes.elofordulas;
            osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
        }

       
    }

    var osszes_valasz_szama = 0;
    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        if(isDefined(sor) && sor != null) {
            var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,nps_e,ces_e);

            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            osszes_valasz_szama += valaszok_szama;
            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }
            var ujSor = {
                metaadatok: {
                    idopont: i,
                    idopont_id: i,
                    szarmaztatott_ertek : szarmaztatottErtek,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
        }
    }

        /*Összesítés*/
        /*Külön kell figyelni rá, hogy volt-e származtatott érték oszlop*/
        console.log(osszegzoSor);
        osszegzoSor.push("0");
        if(van_szarmaztatott) {
            osszegzoSor[osszegzoSor.length-1] = "\u200C"+szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,osszegzoSor,nps_e,ces_e);
            osszegzoSor[osszegzoSor.length-2] = osszes_valasz_szama;
        } else {
            osszegzoSor[osszegzoSor.length-1] = osszes_valasz_szama;
        }

        /*Grafikon adatok*/
        var npsExtra = kerdes.kerdes_extrak.find(extra => extra.adat_kod == 'nps');
        var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;
        var cesExtra = kerdes.kerdes_extrak.find(extra => extra.adat_kod == 'ces');
        var ces_e = isDefined(cesExtra) ?  cesExtra.adat_content : 0;
    
        csakNyers = true;
        lehetsegesValaszok = lehetsegesValaszokLegyujtes(kerdes.valasz_tipus_kod,kerdes.kerdes_extrak,kerdes.valasz_tipus_extrak, csakNyers, kerdes.azonosito);
    
        if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5' || nps_e || ces_e) {
            lehetsegesValaszok.reverse();
        }

        /*Idegen nyelvek miatt kell*/
        kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

        /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
        var kerdesSzoveg = '';
        var kerdoivIdk = $('#kerdoiv_select_input').val();
        if(kerdes.id == "2" && kerdoivIdk.length == 1) {
            kerdesSzoveg = kerdes.kerdes_szoveg;
        } else {
            kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
        }
    
        grafikonAdatok = {
            "szoveg":kerdesSzoveg,
            "tipus": kerdes.valasz_tipus_kod,
            "nps": nps_e,
            "ces":ces_e,
            "lehetseges_valaszok": lehetsegesValaszok,
            "lebontasok": [],
            "data": []
        };
    
        for(var i in tablaSorok) {
            var sor = tablaSorok[i];
            grafikonAdatok["lebontasok"].push(sor.metaadatok.idopont);
        }
        grafikonAdatok["lebontasok"].push('[[$t.osszegzes]]');
        
        var ind = 0;
        for(var i in lehetsegesValaszok) {
            var valaszSzoveg = lehetsegesValaszok[i];
            var data = [];
            for(var j in tablaSorok) {
                var sor = tablaSorok[j];
                var valaszokSzama = "";
                valaszokSzama = sor.sor_adat[i];
                data.push(valaszokSzama);
            }
            data.push(osszegzoSor[ind]);
            ++ind;

            var dataset = {
                label: valaszSzoveg,
                data: data,
            };
            grafikonAdatok["data"].push(dataset);
        }
    
        
console.log({
    kerdes: kerdesSzoveg,
    fejlec: tablaFejlec,
    sorok: tablaSorok,
    grafikon: grafikonAdatok,
    van_szarmaztatott: van_szarmaztatott,
    osszegzo_sor: osszegzoSor,
    kerdes_tipus:  kerdes.valasz_tipus_kod,
    nps: nps_e,
    ces: ces_e
});
    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        van_szarmaztatott: van_szarmaztatott,
        osszegzo_sor: osszegzoSor,
        kerdes_tipus:  kerdes.valasz_tipus_kod,
        nps: nps_e,
        ces: ces_e
    }
}

function initDataTable(idopontok, kerdesId) {
    var lebontas = $('#szuro_select_input').val()[0];
    var feldolgozottAdat = adatFeldolgozas(idopontok,lebontas,kerdesId);

    if(feldolgozottAdat.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];

    var metaadatok = tablaMetaadatok(kerdesId);

    var idopontNev = '';
    switch(lebontas) {
        case 'nap_orai':
            idopontNev = '[[$t.nap_orai]]';
        break;
        case 'het_napjai':
            idopontNev = '[[$t.het_napjai]]';
        break;
    }

    tablaFejlec.push({ headName:idopontNev, colName:"idopont",canOrder: false});
    tablaFejlec.push({ headName:"[[$t.partner]]", colName:"partner"});
    tablaFejlec.push({ headName:"[[$t.telephely]]", colName:"telephely"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true});

    var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdat.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdat.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdat.fejlec[i],
                colName: 'valasz'+i,
                canOrder: false
            });
        }
        
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {

        tablaFejlec.push({
            headName: feldolgozottAdat.fejlec[(feldolgozottAdat.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdat.fejlec.length-offset)
        }); 
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdat.sorok) {
        var feldolgozottAdatSor = feldolgozottAdat.sorok[i];
        var ujSor = {
            "idopont": (lebontas == 'nap_orai') ? feldolgozottAdatSor.metaadatok.idopont : hetNapjai(parseInt(feldolgozottAdatSor.metaadatok.idopont)),
            "partner": arrayToString(metaadatok.partnerek),
            "telephely": arrayToString(metaadatok.telephelyek),
            "id" : feldolgozottAdatSor.metaadatok.idopont_id
        };
        var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }

        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;

        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }

        tablaSorok.push(ujSor);        
    }

    var lathatosagSelect = filterSelectHtml({
            id: 'lathatosag_select_input-'+kerdesId,
            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
            name: 'lathatosag_select_input-'+kerdesId,
            maxOptions: 'inf',
            addclass: 'form cf-report-visibility'
        },
        [
            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
        ]
    );

    
    var exportBtn = buttonHtml({
        name:"[[$t.export]]",
        id: 'btn_riport_export_'+kerdesId,
        type: 'print',
        addClasses : 'btn-main ml-2 export-btn',
        visibility: function() {
            return 1;
        },
        callback: null,
        onCustomAjaxDone: function(event,result,trigger){
        }   
    });

    $('#jelentes-holder').append('<div id="tabla-blokk-'+kerdesId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.ido_szuresi_szoveg]]"; 

    $('#tabla-blokk-'+kerdesId).html('<h2 class="table_name">'+feldolgozottAdat.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-5">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+kerdesId+'"></div></div>');
    $('#lathatosag_select_input-'+kerdesId).selectpicker();

    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'azonosito',kerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);    
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }

    szuresiAdatokOsszeallitas('#tabla-blokk-'+kerdesId);
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    console.log('tablaSorok',tablaSorok,tablaFejlec);
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+kerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_ido]]' + " " + formatDate(datumStr),
            sumFooter : {
                hasSumFooter: true,
                sumFooterLeftOffset: 2,
                exportSumFooter: feldolgozottAdat.osszegzo_sor,
                hasCalculatedCol: feldolgozottAdat.van_szarmaztatott,
                type: feldolgozottAdat.kerdes_tipus,
                isNPS: feldolgozottAdat.nps,
                isCES: feldolgozottAdat.ces
            }
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-'+kerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+kerdesId).selectpicker();
    $('#btn_riport_export_'+kerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    grafikonokInit(feldolgozottAdat.grafikon,kerdesId);

    
}

function grafikonokInit(grafikon,kerdesId) {

    $('#charts').html('');

    if(grafikon.lehetseges_valaszok.length > 30) { return; }

    if(grafikon.tipus == "szabad_szoveg") { return }

    var lebontasokSzama = grafikon.lebontasok.length;
    var nyelvesitettLebontasok = grafikon.lebontasok;

    if($('#szuro_select_input').val() == 'het_napjai') {
        var nyelvesitettLebontasok = grafikon.lebontasok.map(function(val, i) {
            return hetNapjai(parseInt(val));
        });
    }

    /*Kell az összegző oszlop is*/
    if(!isDefined(nyelvesitettLebontasok[nyelvesitettLebontasok.length-1])) {
        nyelvesitettLebontasok[nyelvesitettLebontasok.length-1] = '[[$t.osszegzes]]';
    }
    
 
    if(lebontasokSzama > 0) {

        var windowWidth = $('#jelentes-holder').width();
        var width = Math.min(windowWidth * 0.6, 1000);
        var szinek = [];

        /*$('#tabla-blokk-'+kerdesId).append('<div style="margin:auto;height:500px; width:'+width+'px"><canvas id="chart-'+kerdesId+'"></canvas></div>');*/
        if (grafikon.nps == "1") {
            $('#tabla-blokk-'+kerdesId).append(`<div class="canvas-holder" style="margin:auto;height:600px;contain:initial!important">
            <div class="vonalak" style="
                position: absolute;
                top: 0;
                width: calc(100% + 100px);
                line-height: 30px;
                margin-top: 0px;
                font-size: 12px;
                margin-left: -100px;
            ">
<div style="
    color: #e95d0f; 
">Hátráltatók</div>
<div style="
    color: #36a8ca;
">Semlegesek</div><div style="
    color: #91be00;
">Támogatók</div><div style="">Válaszok száma</div><div style="">Net Promoter Score</div></div>

<canvas id="chart-${kerdesId}" ></canvas></div>`);
        } else {
            $('#tabla-blokk-'+kerdesId).append('<div class="canvas-holder" style="margin:auto;height:600px"><canvas id="chart-'+kerdesId+'" ></canvas></div>');
        }


        var real_length =  grafikon.lehetseges_valaszok.reduce(x => x+1, 0);
        if(grafikon.nps == "1") {
            szinek = szinGeneralas('NPS', real_length);
            drawColumnChart("chart-"+kerdesId, nyelvesitettLebontasok, grafikon.data, szinek, true,false);

        }else if(grafikon.ces=="1"){
            szinek = szinGeneralas('CES', real_length);
            drawColumnChart("chart-"+kerdesId, nyelvesitettLebontasok, grafikon.data, szinek, false,true, grafikon.tipus);
        }else{
            szinek = szinGeneralas(grafikon.tipus, real_length);
            drawColumnChart("chart-"+kerdesId, nyelvesitettLebontasok, grafikon.data, szinek, false,false,grafikon.tipus);
        }

        /*Lehetséges nyomtatáshoz kellenek*/
        GRAFIKON_ADATOK.push({
            id:kerdesId,
            adat: grafikon
        });

       
    }

}

function tablaMetaadatok(kerdesId) {

    var partnerIdk = $('#partner_select_input').val();
    var kerdoivIdk = $('#kerdoiv_select_input').val();
    var regioIdk = $('#regio_select_input').val();
    var telephelyIdk = $('#telephely_select_input').val();
    var eszkozIdk = $('#eszkoz_select_input').val();

    /*Partnerek kikeresése*/
    var partnerek = {};
    if(partnerIdk.length > 0) {
        for(var i in partnerIdk) {
            var partner = findInArray(PARTNEREK, 'id', partnerIdk[i]);
            /*partnerek += (partnerek.length == 0)  ? partner.nev : " ;" + partner.nev ;*/
            partnerek[partner.id] = partner.nev;
        }
    } else if(kerdoivIdk.length > 0) {
        for(var i in kerdoivIdk) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdoivIdk[i]);
            var partner = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerek[partner.id] = partner.nev;
        }
    } else if(telephelyIdk.length > 0) {
        for(var i in telephelyIdk) {
            var telephely = findInArray(TELEPHELYEK, 'id', telephelyIdk[i]);
            var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
            partnerek[partner.id] = partner.nev;
        }

    } else if(regioIdk.length > 0) {
        for(var i in regioIdk) {
            var regio = findInArray(REGIOK, 'id', regioIdk[i]);
            for(var j in regio.telephelyek) {
                var telephely = regio.telephelyek[j];
                var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
                partnerek[partner.id] = partner.nev;
            }
        }
    } else if(eszkozIdk.length > 0) {
        for(var i in eszkozIdk) {
            var eszkoz = findInArray(ESZKOZOK, 'id', eszkozIdk[i]);
            var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
            var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
             partnerek[partner.id] = partner.nev;

        }
    }

    /*Telephelyek*/
    var telephelyek = {};
    if(telephelyIdk.length > 0) {
        for(var i in telephelyIdk) {
            var telephely = findInArray(TELEPHELYEK, 'id', telephelyIdk[i]);
            telephelyek[telephely.id] = telephely.nev;
        }
    } else if(eszkozIdk.length > 0) {
        for(var i in eszkozIdk) {
            var eszkoz = findInArray(ESZKOZOK, 'id', eszkozIdk[i]);
            var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
            telephelyek[telephely.id] = telephely.nev;
        }
    } else if(regioIdk.length > 0) {
        for(var i in regioIdk) {
            var regio = findInArray(REGIOK, 'id', regioIdk[i]);
            for(var j in regio.telephelyek) {
                var telephely = regio.telephelyek[j];
                telephelyek[telephely.id] = telephely.nev;
            }
        }
    } else if(partnerIdk.length > 0) {
        for(var i in partnerIdk) {
            var partner = findInArray(PARTNEREK, 'id', partnerIdk[i]);
            var _telephelyek = TELEPHELYEK.filter(function(telephely) {
                return telephely.fk_partner ==  partner.id;
            });
            for(var j in _telephelyek) {
                telephelyek[_telephelyek[j].id] = _telephelyek[j].nev;
            }
        }
    }
    else if(kerdoivIdk.length > 0) {
        for(var i in kerdoivIdk) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdoivIdk[i]);
            var eszkozok = ESZKOZOK.filter(function(eszkoz) {
                return eszkoz.fk_kerdoivek == kerdoiv.id;
            });
            for(var j in eszkozok) {
                var eszkoz = eszkozok[j];
                var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
                telephelyek[telephely.id] = telephely.nev;
            }
        }
    } 
    
    var partnerArr = objectToArray(partnerek);
    var telephelyArr = objectToArray(telephelyek);
    var retPartnerek = [];
    var retTelephelyek = [];
    
    for(var i in partnerArr) {
        retPartnerek.push(partnerArr[i]);
    }

    for(var i in telephelyArr) {
        retTelephelyek.push(telephelyArr[i]);
    }

    return {
        "partnerek": retPartnerek,
        "telephelyek": retTelephelyek
    };
}

function hetNapjai(ind) {
    switch(ind) {
        case 1:
           return '[[$t.hetfo]]';
        case 2:
           return '[[$t.kedd]]';
        case 3:
           return '[[$t.szerda]]';
        case 4:
           return '[[$t.csutortok]]';
        case 5:
           return '[[$t.pentek]]';
        case 6:
           return '[[$t.szombat]]';
        case 7:
           return '[[$t.vasarnap]]';
    }
}

function selectUjraepites(selectId, force) {

    var selectTipus = selectId.split('_')[0];

    var selectErtekek = $('#'+selectId).val();

    switch(selectTipus) {
        case 'partner': 
            if(selectErtekek.length == 0) {
                szuroNullazas();
            } else {
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('kerdoiv',selectTipus,selectErtekek);
                selectSzures('kerdes',selectTipus,selectErtekek);
            }
        break;
        case 'kerdoiv':
            if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            }
            else {
                selectSzures('kerdes',selectTipus,selectErtekek);
                selectSzures('eszkoz',selectTipus,selectErtekek);
                selectSzures('telephely',selectTipus,selectErtekek);
                selectSzures('regio',selectTipus,selectErtekek);
            }
            
        break;
        case 'kerdes':
            if(selectErtekek.length == 0) {
                selectUjraepites('kerdoiv_select_input');
            } 
        break;
        case 'regio':
            if(selectErtekek.length == 0 && !force) {
                selectUjraepites('regio_select_input', 1);
            } else if(selectErtekek.length == 0 && $('#kerdoiv_select_input').val().length != 0) {
                selectUjraepites('kerdoiv_select_input');
            } else if(selectErtekek.length == 0) {
                selectUjraepites('partner_select_input');
            } else {
                if(force) {
                    selectErtekek = [];
                    $("#regio_select_input option").each(function() {
                        selectErtekek.push($(this).val());
                    });
                }
                var szurtTelephelyek = selectSzures('telephely',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('telephely','kerdoiv',$('#kerdoiv_select_input').val(), szurtTelephelyek);
                }

                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }
            
        break;
        case 'telephely':
            if(selectErtekek.length == 0) {
                selectUjraepites('regio_select_input');
            } else {
                var szurtEszkozok = selectSzures('eszkoz',selectTipus,selectErtekek);
                if($('#regio_select_input').val().length != 0) {
                    szurtEszkozok = selectSzures('eszkoz','regio',$('#regio_select_input').val(), szurtEszkozok);
                }
                if($('#kerdoiv_select_input').val().length != 0) {
                    selectSzures('eszkoz','kerdoiv',$('#kerdoiv_select_input').val(), szurtEszkozok);
                }
            }
        break;
        case 'szuro':
            disableInput($('#regio_select_input'), false);
            disableInput($('#telephely_select_input'), false);
            disableInput($('#eszkoz_select_input'), false);
        break;
    }

}

function szuroNullazas() {
    refillSelect('partner_select_input',filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id'));
    refillSelect('kerdoiv_select_input',filterSelectValues(szurheto_adatok.kerdoivek , 'nev', 'id'));
    refillSelect('regio_select_input',filterSelectValues(szurheto_adatok.regiok , 'nev', 'id'));
    refillSelect('telephely_select_input',filterSelectValues(szurheto_adatok.telephelyek , 'nev', 'id'));
    refillSelect('eszkoz_select_input',filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id'));
    refillSelect('kerdes_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));
}

function szuresiAdatokOsszeallitas(id) {
    var szoveg = $(id).find('.cf-filter-string').html();


    var ido = $('#szuro_select_input').val()[0];

    switch(ido) {
        case 'nap_orai': ido = '[[$t.nap_orai]]'; break;
        case 'het_napjai': ido = '[[$t.het_napjai]]'; break;
    }

    var idoszak = $('#idoszak_select_input').val()[0];

    szoveg = szoveg.replace('#ido#', '<span class="font-weight-bold">'+ido+'</span>');
    szoveg = szoveg.replace('#kezdo_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).kezdet.split(' ')[0])+'</span>');
    szoveg = szoveg.replace('#veg_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).veg.split(' ')[0])+'</span>');


    $(id).find('.cf-filter-string').html(szoveg);

    
}