

var ISMERV_ERTEKEK = [];
var ISMERVEK = [];
var KIKULDESEK = [];

var kikuldes_sel_progress = false;

$(document).ready(function(){
    $(document).on('change', '.selectpicker.cf-report-visibility', function() {
        var split = $(this)[0].id.split('-');
        var jelentesId = split[1] == 't' ? split[2] : split[1];
        var selectErtekek = $(this).val();

        if($.inArray('tabla_eltuntet', selectErtekek) > -1) {
            $('#tabla-blokk-'+jelentesId+' .table-recreate, #tabla-blokk-t-'+jelentesId+' .table-recreate').addClass('d-none');
        } else {
            $('#tabla-blokk-'+jelentesId+' .table-recreate, #tabla-blokk-t-'+jelentesId+' .table-recreate').removeClass('d-none');
        }

        if($.inArray('grafikon_eltuntet', selectErtekek) > -1) {
            $('#tabla-blokk-'+jelentesId+' canvas, #tabla-blokk-t-'+jelentesId+' canvas').parent().addClass('d-none');
        } else {
            $('#tabla-blokk-'+jelentesId+' canvas, #tabla-blokk-t-'+jelentesId+' canvas').parent().removeClass('d-none');
        }

    });

    /*Eseménykezelők*/
    /*Az egyedi datetimepicker csak akkor jelenik meg, ha az időszak választóban az Egyéb van kiválasztva*/
    $(document).on('change', '#idoszak_select_input', function() {
        if($(this).val()[0] == 'sajat') {
            $('#kezdo_datum_input').parents('.dt-wrapper').removeClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').removeClass('d-none');
        } else {
            $('#kezdo_datum_input').parents('.dt-wrapper').addClass('d-none');
            $('#veg_datum_input').parents('.dt-wrapper').addClass('d-none');
        }
    });

});

/*Egységes működések ide kiemelve, hogy karbantarthatóbb legyen a dolog*/
function getValidKerdesek(kerdesek, kerdoivek){
    /*A kérdések, amik a kérdés selectbe kerülnek*/
    var validKerdesekObj = {};
    for(var i in kerdesek) {
        /*Rendszerkérdés jelenleg a 2-ik id-jű*/
        if(kerdesek[i].id == '2') {
            validKerdesekObj[kerdesek[i].azonosito] = kerdesek[i];
        }
        else if(kerdesek[i].valasz_tipus_kod.slice(0,15) == "egyedi_valaszok" || kerdesek[i].valasz_tipus_kod.slice(0,7) == 'ertekek' || kerdesek[i].valasz_tipus_kod == "dropdown") {
            var kerdes = kerdesek[i];
            var kerdesKerdoive = findInArray(kerdoivek, 'id', kerdes.fk_kerdoivek);
            kerdes.kerdes_szovege += ' ('+ kerdesKerdoive.nev +')';
            validKerdesekObj[kerdesek[i].azonosito] = kerdes;
        }
        else if(kerdesek[i].valasz_tipus_kod != 'szabad_szoveg' && kerdesek[i].valasz_tipus_kod.slice(0,14) != 'kerdes-csoport') {
            if(!isDefined(validKerdesekObj[kerdesek[i].azonosito])){
                validKerdesekObj[kerdesek[i].azonosito] = kerdesek[i];
            }
        }  else {
            validKerdesekObj[kerdesek[i].azonosito] = kerdesek[i];
        }
    }
    return objectToArray(validKerdesekObj);
}

function initChartAndTableTogglers(){
    var tablaMegjelenites = checkboxHtml({
        id: 'tabla_megjelenites',
        name: 'tabla_megjelenites',
        label: '[[$t.tablak_elrejtese]]',
       }
    );
    
    var grafikonMegjelenites = checkboxHtml({
        id: 'grafikon_megjelenites',
        name: 'grafikon_megjelenites',
        label: '[[$t.grafikonok_elrejtese]]',
       }
    );

    var nyomtatasiNezetCim = checkboxHtml({
        id: 'nyomtatasi_nezet_cim',
        name: 'nyomtatasi_nezet_cim',
        label: '[[$t.egyedi_cim_megadasa]]',
       }
    );
   
   $('.megjelenites-vezerles').append(tablaMegjelenites);
   $('.megjelenites-vezerles').append(grafikonMegjelenites);
   $('.megjelenites-vezerles').append(nyomtatasiNezetCim);
   
    $('#tabla_megjelenites').on('change', function() {
        if($(this).is(':checked')) {
            $('select.cf-report-visibility').each(function(ind, val){
                var vals = $(this).val();
                if(vals.indexOf('tabla_eltuntet') == -1) {
                    vals.push('tabla_eltuntet');
                    $(this).selectpicker('val', vals);
                }
            });
        } else {
            $('select.cf-report-visibility').each(function(ind, val){
                var vals = $(this).val();
                vals  = jQuery.grep(vals, function(value) {
                    return value != 'tabla_eltuntet';
                });
                $(this).selectpicker('val', vals);
            });
        }
    });

    $('#grafikon_megjelenites').on('change', function() {
        if($(this).is(':checked')) {
            $('select.cf-report-visibility').each(function(ind, val){
                var vals = $(this).val();
                if(vals.indexOf('grafikon_eltuntet') == -1) {
                    vals.push('grafikon_eltuntet');
                    $(this).selectpicker('val', vals);
                }
            });
        } else {
            $('select.cf-report-visibility').each(function(ind, val){
                var vals = $(this).val();
                vals  = jQuery.grep(vals, function(value) {
                    return value != 'grafikon_eltuntet';
                });
                $(this).selectpicker('val', vals);
            });
        }
    });
}

function getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId, forceKerdoivId) {
    /*A szóban forgó kérdésnek megkeressük a hozzá tartozó kérdőívét
    Jó esetben csak egy ilyen van*/
    var szurtKerdesId = parseInt(kerdesId);
    var szurtKerdoivId = null;

    /*Ha több kérdőívhez is lenne a kérdés - jellemzően a rendszerkérdés ilyen -
    akkor az első olyan kérdőívet vesszük az összes közül, ami van az oldal nyelvén.
    Ha nincs ilyen, akkor az elsőt. */
    var nyelv = act_lang;
      
    if($.isArray(KERDESEK[szurtKerdesId].fk_kerdoivek)) {
        var kerdoivIdk = KERDESEK[szurtKerdesId].fk_kerdoivek;
        /*Ha a forceKerdoivId paraméter töltve van (ez a szűrőkérdéses eset)
        akkor, ha lehet, abból a kérdőívből kell megtalálni a kérdés*/
        if(isDefined(forceKerdoivId) && $.inArray(forceKerdoivId, kerdoivIdk) > -1) {
            szurtKerdoivId = forceKerdoivId;
            if(!isDefined(KERDOIVEK[forceKerdoivId].json.nyelvek[act_lang])) {
                nyelv = Object.keys(KERDOIVEK[szurtKerdoivId].json.nyelvek)[0];
            }
        } else {
            for(var i in kerdoivIdk) {
                if(isDefined(KERDOIVEK[kerdoivIdk[i]]) && isDefined(KERDOIVEK[kerdoivIdk[i]].json.nyelvek[act_lang])) {
                    szurtKerdoivId = kerdoivIdk[i];
                    break;
                }
            }
            if(szurtKerdoivId == null) {
                for(var i in KERDESEK[szurtKerdesId].fk_kerdoivek) {
                    szurtKerdoivId = KERDESEK[szurtKerdesId].fk_kerdoivek[i];
                    if(isDefined(KERDOIVEK[szurtKerdoivId])) {
                        nyelv = Object.keys(KERDOIVEK[szurtKerdoivId].json.nyelvek)[0];
                        break;
                    }
                }
                
            }
        }
    } else {
        if(isDefined(forceKerdoivId)) {
            var forceEgyezesLehet = filterArray(KERDESEK, 'azonosito', szurtKerdesId);
            var forceEgyezesLehet2;
            if(forceEgyezesLehet != null) {
                forceEgyezesLehet2 = findInArray(forceEgyezesLehet, 'fk_kerdoivek', forceKerdoivId);
            }
            
            if(isDefined(forceEgyezesLehet2)) {
                szurtKerdoivId = forceKerdoivId;
            } else {
                szurtKerdoivId = KERDESEK[szurtKerdesId].fk_kerdoivek;
            }
        } else {
            szurtKerdoivId = KERDESEK[szurtKerdesId].fk_kerdoivek;
        }

        if(!isDefined(KERDOIVEK[szurtKerdoivId].json.nyelvek[act_lang])) {
            nyelv = Object.keys(KERDOIVEK[szurtKerdoivId].json.nyelvek)[0];
        }

    }
      /*A kérdés lehet rendszerkérdés, sima kérdés, vagy akár kérdéscsoport is*/
      var lehetRendszerkerdes = KERDOIVEK[szurtKerdoivId].json.nyelvek[nyelv].rendszerszintu_kerdesek.find(function(kerdes){ return kerdes.azonosito == szurtKerdesId});
      var lehetKerdes = KERDOIVEK[szurtKerdoivId].json.nyelvek[nyelv].kerdesek.find(function(kerdes){ return kerdes.azonosito == szurtKerdesId});
  
      var lehetAlkerdes;
      var kerdesCsoportId = KERDESEK[kerdesId].fk_kerdoivek_kerdesek_csoport;
      if(isDefined(kerdesCsoportId) && kerdesCsoportId != null) {
          var kerdesCsoport = findInArray(KERDOIVEK[szurtKerdoivId].json.nyelvek[nyelv].kerdesek, 'id',kerdesCsoportId);
          lehetAlkerdes = findInArray(kerdesCsoport.alkerdesek, 'id', szurtKerdesId);
      }
  
      /*El kell dönteni milyen típusú a kérdés, mert máshogy kell kezelni*/
      var kerdes = null;
  
      if(isDefined(lehetRendszerkerdes)) {
          kerdes = lehetRendszerkerdes;
      } else if(isDefined(lehetKerdes)) {
          kerdes = lehetKerdes;
      } else if(isDefined(lehetAlkerdes)) {
          kerdes = lehetAlkerdes;
      }

      var csakNyers = true;
      var lehetsegesValaszok = lehetsegesValaszokLegyujtes(kerdes.valasz_tipus_kod,kerdes.kerdes_extrak, kerdes.valasz_tipus_extrak,csakNyers, kerdes.azonosito);
      var npsExtra = kerdes.kerdes_extrak.find(function(extra){return extra.adat_kod == 'nps'});
      var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;    

      var cesExtra=kerdes.kerdes_extrak.find(function(extra){return extra.adat_kod=='ces'});
      var ces_e = isDefined(cesExtra) ? cesExtra.adat_content:0;
      
      if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5' ) {
          lehetsegesValaszok.reverse();
      }
  
      var vanSzarmaztatottErtek = false;

     




      /*Származtatott értékek esetén kell egy oszlop nekik a táblázatban*/
        if(nps_e) {
            lehetsegesValaszok.push('[[$t.nps_ertek]]');
            vanSzarmaztatottErtek = true;
        } else if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok') {
             if(ces_e){
        lehetsegesValaszok.push('[[$t.ces_ertek]]');
        vanSzarmaztatottErtek=true;
      }else{
         lehetsegesValaszok.push('[[$t.ikonok_ertek]]');
          vanSzarmaztatottErtek = true;
      }
        } else if(kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') {
            lehetsegesValaszok.push('[[$t.szamok_aranya]]');
            vanSzarmaztatottErtek = true;
        } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
            lehetsegesValaszok.push('[[$t.igenek_aranya]]');
            vanSzarmaztatottErtek = true;
        } else if(kerdes.valasz_tipus_kod == 'ertekek-5') {
            lehetsegesValaszok.push('[[$t.valasz_ertekek]]');
            vanSzarmaztatottErtek = true;
        }

      /*A hézagos tömb elkerülése miatt
      var tmp = [];
      for(var i in lehetsegesValaszok) {
          if(isDefined(lehetsegesValaszok[i])) {
            tmp.push(lehetsegesValaszok[i]);
          }
      }*/

      return {
          'kerdes': kerdes,
          'lehetsegesValaszok': lehetsegesValaszok,
          'nps_e': nps_e,
          'ces_e':ces_e,
          'kerdoiv_id': szurtKerdoivId,
          'van_szarmaztatott_ertek': vanSzarmaztatottErtek
      };
}

/*Dátumok stringes formátumba konvertálása*/
function getDate(date) {
    var ret =  {
        year : date.getFullYear(),
        month : date.getMonth()+1,
        day : date.getDate(),
        hour : date.getHours(),
        minute : date.getMinutes(),
        second : date.getSeconds(),
    };

    ret.now =  ret.year + '.' + (ret.month<10 ? '0' : '') + ret.month + '.' +(ret.day<10 ? '0' : '') + ret.day + ' ' + (ret.hour<10 ? '0' : '') + ret.hour +':'+ (ret.minute<10 ? '0' : '')+ret.minute+':'+(ret.second<10 ? '0' : '')+ret.second;

    return ret;
}

/*Kiszámolja a megadott fogalmakhoz a dátumokat*/
function computeDates(type) {
    var date = new Date();
    var ma = getDate(date);

    var ret = {};

    switch(type) {
        case 'ma':
            ret.kezdet = ma.year + '.' + (ma.month<10 ? '0' : '') + ma.month + '.' +(ma.day<10 ? '0' : '') + ma.day + ' 00:00:00';
            ret.veg = ma.now;
            /*ret.most = ma.now;*/
        break;
        case 'tegnap':
            var ydate = new Date();
            ydate.setDate(date.getDate() - 1);

            var tegnap = getDate(ydate);

            ret.kezdet = tegnap.year + '.' + (tegnap.month<10 ? '0' : '') + tegnap.month + '.' +(tegnap.day<10 ? '0' : '') + tegnap.day + ' 00:00:00';
            ret.veg = tegnap.year + '.' + (tegnap.month<10 ? '0' : '') + tegnap.month + '.' +(tegnap.day<10 ? '0' : '') + tegnap.day + ' 23:59:59';
            /*ret.most = ma.now;*/
        break;
        case 'het':
            var first = date.getDate() - date.getDay() + 1;
            var last = first + 6;

            var firstday = new Date(date.setDate(first));
            var lastday = new Date(date.setDate(last));

            var hetfo = getDate(firstday);
            var vasarnap = getDate(lastday);

            ret.kezdet = hetfo.year + '.' + (hetfo.month<10 ? '0' : '') + hetfo.month + '.' +(hetfo.day<10 ? '0' : '') + hetfo.day + ' 00:00:00';
            if(lastday > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = vasarnap.year + '.' + (vasarnap.month<10 ? '0' : '') + vasarnap.month + '.' +(vasarnap.day<10 ? '0' : '') + vasarnap.day + ' 23:59:59';
            }
            ret.most = ma.now;

        break;
        case 'utolso_het':
            var first = date.getDate() - 7;

            var firstday = new Date(date.setDate(first));

            var fd = getDate(firstday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            ret.veg = ma.now;
            ret.most = ma.now;
        break;
        case 'utolso_honap':
            var first = date.getDate() - 30;

            var firstday = new Date(date.setDate(first));

            var fd = getDate(firstday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            ret.veg = ma.now;
            ret.most = ma.now;
        break;
        case 'elozo_honap':
            var first = date.setMonth(date.getMonth() - 1, 1);
            var last = date.setMonth(date.getMonth()+1, 0);

            var firstday = new Date(first);
            var lastday = new Date(last);

            var fd = getDate(firstday);
            var ld = getDate(lastday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            if(lastday > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = ld.year + '.' + (ld.month<10 ? '0' : '') + ld.month + '.' +(ld.day<10 ? '0' : '') + ld.day + ' 23:59:59';
         }
            ret.most = ma.now;
        break;
        case 'ez_a_honap':

            var first = date.setMonth(date.getMonth(), 1);
           var last = date.setMonth(date.getMonth()+1, -1);

            var firstday = new Date(first);
            var lastday = new Date(last);

            var fd = getDate(firstday);
            var ld = getDate(lastday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            if(lastday > date) {
                ret.veg = ma.now;
            } else {
                ret.lastday=lastday;
                ret.date=date;
                ret.veg = ld.year + '.' + (ld.month<10 ? '0' : '') + ld.month + '.' +(ld.day<10 ? '0' : '') + ld.day + ' 23:59:59';
             }
             ret.veg=ma.now;
            ret.most = ma.now;

        break;
        case 'elozo_nyolc_honap':
            var first = date.setMonth(date.getMonth() - 8, 1);
            var last = date.setMonth(date.getMonth()+9, -1);

            var firstday = new Date(first);
            var lastday = new Date(last);

            var fd = getDate(firstday);
            var ld = getDate(lastday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            if(lastday > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = ld.year + '.' + (ld.month<10 ? '0' : '') + ld.month + '.' +(ld.day<10 ? '0' : '') + ld.day + ' 23:59:59';
            }
            ret.most = ma.now;
        break;
        case 'elozo_harom_honap':
            var first = date.setMonth(date.getMonth() - 2, 1);
            var last = date.setMonth(date.getMonth() + 3, -1);

            var firstday = new Date(first);
            var lastday = new Date(last);

            var fd = getDate(firstday);
            var ld = getDate(lastday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            if(lastday > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = ld.year + '.' + (ld.month<10 ? '0' : '') + ld.month + '.' +(ld.day<10 ? '0' : '') + ld.day + ' 23:59:59';
            }
            ret.most = ma.now;
        break;
        case 'ez_az_ev':
            var first = new Date(new Date().getFullYear(), 0, 1,0,0,0);

            var firstday = new Date(first);

            var fd = getDate(firstday);

            ret.kezdet = fd.year + '.' + (fd.month<10 ? '0' : '') + fd.month + '.' +(fd.day<10 ? '0' : '') + fd.day + ' 00:00:00';
            ret.veg = ma.now;
            ret.most = ma.now;

        break;
        case 'sajat':
            var kezdet = getDate($("#kezdo_datum_input").datetimepicker('viewDate')._d);
            var vegDatum = $("#veg_datum_input").datetimepicker('viewDate')._d;
            var veg = getDate(vegDatum);

            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet.day + ' ' + '00:' +/*(kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute +*/'00'+ ':' + '00';
            if(vegDatum > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg.day<10 ? '0' : '') + veg.day + ' ' + '23:' + /*(veg.hour<10 ? '0' : '') + veg.hour + ':' + (veg.minute<10 ? '0' : '') + veg.minute*/'59' + ':' + '59';
            }
            ret.most = ma.now;
        break;
        case 'sajat+':
            var kezdet = getDate($("#kezdo_datum_input").datetimepicker('viewDate')._d);
            var veg = getDate($("#veg_datum_input").datetimepicker('viewDate')._d);
            console.log(kezdet);
            kezdet_elso = moment().startOf('month', kezdet.month).date();
            veg_utolso = moment().endOf('month', kezdet.month).date();
            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet_elso + ' ' + (kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute + ':' + (kezdet.second<10 ? '0' : '') + kezdet.second;
            ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg_utolso<10 ? '0' : '') + veg_utolso + ' ' + '23:59:59';
            ret.most = ma.now;
        break;
        default:
            var kezdet = isDefined(global_kezdo_datum) && moment(global_kezdo_datum, 'YYYY.MM.DD').isValid() ?  getDate(new Date(global_kezdo_datum.replace(/\./g, '-'))) : getDate(new Date(1,0));
            var vegDatum = new Date(3000,0);
            var veg = getDate(vegDatum);
            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet.day + ' ' + (kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute + ':' + (kezdet.second<10 ? '0' : '') + kezdet.second;
            if(vegDatum > date) {
                ret.veg = ma.now;
            } else {
                ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg.day<10 ? '0' : '') + veg.day + ' ' + (veg.hour<10 ? '0' : '') + veg.hour + ':' + (veg.minute<10 ? '0' : '') + veg.minute + ':' + (veg.second<10 ? '0' : '') + veg.second;
            }
            ret.most = ma.now;
        break;
    }

    return ret;
}



/*objektumból tömböt csinál, de ujrakezdi az indexelést*/
function objectToArrayReorg(obj) {
    var ret = [];
    for(var i in obj) {
         ret.push(obj[i]);
    }

    return ret;
}

function sortByIndex(arr) {
    for(var i in arr) {

    }
}

/*Visszaadja annak a tömbelemnek az indexét (ami lehet 0,1,2), amihez hozzá kell adni az NPS értéket*/
function getNPSValue(num, kerdes_tipus = "szamok-0-10") {
    if(kerdes_tipus.slice(0,8) == "ikonok-4") {
        if(num == 1) {
            return 2;
        } else if (num == 2 && num == 3) {
            return 1;
        } else {
            return 0;
        }
    } else {
        if(num < 7) {
            return 2;
        } else if (num == 7 || num == 8) {
            return 1;
        } else {
            return 0;
        }
    }
    
}

function getCESValue(num,kerdes_tipus){
    if(kerdes_tipus.slice(0,8) == "ikonok-5") {
        if(num == 1 || num==2) {
            return 2;
        } else if ( num == 3) {
            return 1;
        } else if(num==4 || num==5) {
            return 0;
        }
    }
}






function tombokTombjeInic(hossz, alapErtek) {
    var arr = Array.apply(null, Array(hossz));
    return arr.map(function (x, i) { return isDefined(alapErtek) ? alapErtek : ''; });
}

function tombInic(hossz, alapErtek) {
    var arr = Array(hossz);
    for(var i=0; i < hossz; i++) {
        arr[i] = isDefined(alapErtek) ? alapErtek : '';
    }

    return arr;
}

function lehetsegesValaszokLegyujtes(tipus, kerdesExtrak, valaszTipusExtra, csakCimkek, kerdesAzon) {

    if(tipus.slice(0,8) == 'ikonok-5') {

        var cesExtra=findInArray(kerdesExtrak,'adat_kod','ces');
        var ces_e=isDefined(cesExtra)? cesExtra.adat_content:0;
        if(ces_e){
            if(csakCimkek) {
                return ["[[$t.difficult]]","[[$t.neutral]]","[[$t.easy]]"];
            } else {
                return ["[[$t.fej]]","[[$t.difficult]]","[[$t.neutral]]","[[$t.easy]]"];
            }


        }else if(csakCimkek) {
            return ["1","2","3","4","5"];
        } else {
            return ["[[$t.fej]]","1","2","3","4","5"];
        }
    } else if(tipus.slice(0,8) == 'ikonok-4') {
        var npsExtra = findInArray(kerdesExtrak, 'adat_kod', 'nps');
        var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;


        if(nps_e) {
            if(csakCimkek) {
                return ["[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
            } else {
                return ["[[$t.fej]]","[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
            }
        } else if(csakCimkek) {
            return ["1","2","3","4"];
        } else {
            return ["[[$t.fej]]","1","2","3","4"];
        }
    }
    else if(tipus.slice(0,6) == 'szamok') {
        var npsExtra = findInArray(kerdesExtrak, 'adat_kod', 'nps');
        var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;
        
        var cesExtra=findInArray(kerdesExtrak,'adat_kod','ces');
        var ces_e=isDefined(cesExtra)? cesExtra.adat_content:0;

        var min = findInArray(valaszTipusExtra, 'adat_kod', 'min');
        var max = findInArray(valaszTipusExtra, 'adat_kod', 'max');

        if(nps_e) {
            if(csakCimkek) {
                return ["[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
            } else {
                return ["[[$t.fej]]","[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
            }
        }else if (ces_e){
            if(csakCimkek) {
                return ["[[$t.difficult]]","[[$t.neutral]]","[[$t.easy]]"];
            } else {
                return ["[[$t.fej]]","[[$t.difficult]]","[[$t.neutral]]","[[$t.easy]]"];
            }
        } else {
            var ret = [];
            if(!csakCimkek) {
                ret[0] = "[[$t.fej]]"
            }

            for(var i = parseInt(min.adat_content); i <= parseInt(max.adat_content); ++i) {
                ret.push(""+i);
            }
            return ret;

        }

    } else {
        switch(tipus) {
            case 'szamok10':
                var npsExtra = findInArray(kerdesExtrak, 'adat_kod', 'nps');
                var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;

                if(nps_e) {
                    if(csakCimkek) {
                        return ["[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
                    } else {
                        return ["[[$t.fej]]","[[$t.detractors]]","[[$t.neutrals]]","[[$t.promoters]]"];
                    }
                } else {
                    if(csakCimkek) {
                        return ["0","1","2","3","4","5","6","7","8","9","10"];
                    } else {
                        return ["[[$t.fej]]","0","1","2","3","4","5","6","7","8","9","10"];
                    }
                }
            case 'szamok110':
                if(csakCimkek) {
                    return ["1","2","3","4","5","6","7","8","9","10"];
                } else {
                    return ["[[$t.fej]]","1","2","3","4","5","6","7","8","9","10"];
                }
            case 'igen_nem':
                if(csakCimkek) {
                    return ["[[$t.igen]]", "[[$t.nem]]"];
                } else {
                    return ["[[$t.fej]]","[[$t.igen]]", "[[$t.nem]]"];
                }
            case 'egyedi_valaszok': case 'ertekek-5': case 'dropdown': case 'egyedi_valaszok_kepekkel':
                /*Az összevonások miatt az összes lehetséges válasszal kell dolgozni*/

                /*var valaszHalmaz = filterArray(azonosito_valaszok, 'azonosito', kerdesAzon);*/
                var valaszHalmaz = [];
                for(var i in kerdesExtrak) {
                    if(kerdesExtrak[i].adat_kod.substring(0,6) == 'valasz') {
                        valaszHalmaz.push(kerdesExtrak[i]);
                    }

                }
                var lehetsegetsValaszok = csakCimkek ? new Array(valaszHalmaz.length) : new Array(valaszHalmaz.length+1);

                if(!csakCimkek) {
                    lehetsegetsValaszok[0] = ("[[$t.fej]]");
                }


                for(var i in valaszHalmaz) {

                    var extra = valaszHalmaz[i];
                    if(extra.adat_kod.slice(-2) == 'hu') {
                        var sorrend = extra.adat_kod.replace('valasz', '').replace('_hu','');
                        lehetsegetsValaszok[sorrend] = extra.adat_content;
                        /*lehetsegetsValaszok.push(extra.adat_content);*/
                    }

                    
                }
                return lehetsegetsValaszok;
        }
    }

}

function selectKikapcsolas(id,kikapcsol) {
    $('#'+id).prop('disabled', kikapcsol);
}

function szinGeneralas(tipus,szamossag, diagramTipus) {
    var alap = [
        {color: '#fff', background_color: 'rgba(87,2,33, 0.6)', border_color: 'rgba(87,2,33,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42, 0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(208,0,0, 0.6)', border_color: 'rgba(208,0,0,1)'},
        {color: '#000', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'},
        {color: '#000', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'},
        {color: '#000', background_color: 'rgba(255,197,0, 0.6)', border_color: 'rgba(255,197,0,1)'},
        {color: '#000', background_color: 'rgba(255,228,1, 0.6)', border_color: 'rgba(255,228,1,1)'},
        {color: '#000', background_color: 'rgba(221,214,1, 0.6)', border_color: 'rgba(221,214,1,1)'},
        {color: '#fff', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'},
        {color: '#fff', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'},
    ];
    var bovitettAlap = [

        {color: '#fff', background_color: 'rgba(55,168,202,0.6)', border_color: 'rgba(55,168,202,1)'},
        {color: '#fff', background_color: 'rgba(109,99,160,0.6)', border_color: 'rgba(109,99,160,1)'},
        {color: '#fff', background_color: 'rgba(46,165,163,0.6)', border_color: 'rgba(46,165,163,1)'},
        {color: '#fff', background_color: 'rgba(159,168,163,0.6)', border_color: 'rgba(159,168,163,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42,0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(73,73,73,0.6)', border_color: 'rgba(73,73,73,1)'},
        {color: '#fff', background_color: 'rgba(204,157,103,0.6)', border_color: 'rgba(204,157,103,1)'},
        {color: '#000', background_color: 'rgba(154,217,235,0.6)', border_color: 'rgba(154,217,235,1)'},
        {color: '#fff', background_color: 'rgba(220,130,130,0.6)', border_color: 'rgba(220,130,130,1)'},
        {color: '#000', background_color: 'rgba(200,185,204,0.6)', border_color: 'rgba(200,185,204,1)'},
        {color: '#000', background_color: 'rgba(146,101,59,0.6)', border_color: 'rgba(146,101,59,1)'},

        {color: '#fff', background_color: 'rgba(55,168,202,0.6)', border_color: 'rgba(55,168,202,1)'},
        {color: '#fff', background_color: 'rgba(109,99,160,0.6)', border_color: 'rgba(109,99,160,1)'},
        {color: '#fff', background_color: 'rgba(46,165,163,0.6)', border_color: 'rgba(46,165,163,1)'},
        {color: '#fff', background_color: 'rgba(159,168,163,0.6)', border_color: 'rgba(159,168,163,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42,0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(73,73,73,0.6)', border_color: 'rgba(73,73,73,1)'},
        {color: '#fff', background_color: 'rgba(204,157,103,0.6)', border_color: 'rgba(204,157,103,1)'},
        {color: '#000', background_color: 'rgba(154,217,235,0.6)', border_color: 'rgba(154,217,235,1)'},
        {color: '#fff', background_color: 'rgba(220,130,130,0.6)', border_color: 'rgba(220,130,130,1)'},
        {color: '#000', background_color: 'rgba(200,185,204,0.6)', border_color: 'rgba(200,185,204,1)'},
        {color: '#000', background_color: 'rgba(146,101,59,0.6)', border_color: 'rgba(146,101,59,1)'},

        {color: '#fff', background_color: 'rgba(87,2,33, 0.6)', border_color: 'rgba(87,2,33,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42, 0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(208,0,0, 0.6)', border_color: 'rgba(208,0,0,1)'},
        {color: '#000', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'},
        {color: '#000', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'},
        {color: '#000', background_color: 'rgba(255,197,0, 0.6)', border_color: 'rgba(255,197,0,1)'},
        {color: '#000', background_color: 'rgba(255,228,1, 0.6)', border_color: 'rgba(255,228,1,1)'},
        {color: '#000', background_color: 'rgba(221,214,1, 0.6)', border_color: 'rgba(221,214,1,1)'},
        {color: '#fff', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'},
        {color: '#fff', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'},

        {color: '#fff', background_color: 'rgba(87,2,33, 0.6)', border_color: 'rgba(87,2,33,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42, 0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(208,0,0, 0.6)', border_color: 'rgba(208,0,0,1)'},
        {color: '#000', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'},
        {color: '#000', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'},
        {color: '#000', background_color: 'rgba(255,197,0, 0.6)', border_color: 'rgba(255,197,0,1)'},
        {color: '#000', background_color: 'rgba(255,228,1, 0.6)', border_color: 'rgba(255,228,1,1)'},
        {color: '#000', background_color: 'rgba(221,214,1, 0.6)', border_color: 'rgba(221,214,1,1)'},
        {color: '#fff', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'},
        {color: '#fff', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'},

        {color: '#fff', background_color: 'rgba(87,2,33, 0.6)', border_color: 'rgba(87,2,33,1)'},
        {color: '#fff', background_color: 'rgba(165,55,42, 0.6)', border_color: 'rgba(165,55,42,1)'},
        {color: '#fff', background_color: 'rgba(208,0,0, 0.6)', border_color: 'rgba(208,0,0,1)'},
        {color: '#000', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'},
        {color: '#000', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'},
        {color: '#000', background_color: 'rgba(255,197,0, 0.6)', border_color: 'rgba(255,197,0,1)'},
        {color: '#000', background_color: 'rgba(255,228,1, 0.6)', border_color: 'rgba(255,228,1,1)'},
        {color: '#000', background_color: 'rgba(221,214,1, 0.6)', border_color: 'rgba(221,214,1,1)'},
        {color: '#fff', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'},
        {color: '#fff', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'},

    ];

    if(tipus.slice(0,8) == 'ikonok-5') {
        console.log("otos");
        var ret = [];
        ret.push({color: '#000', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'});
        ret.push({color: '#000', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'});
        ret.push({color: '#000', background_color: 'rgba(255,228,1, 0.6)', border_color: 'rgba(255,228,1,1)'});
        ret.push({color: '#fff', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'});
        ret.push({color: '#fff', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'});
        if(diagramTipus == 'line') {
            ret.push({color: '#fff', background_color: 'rgba(142,188,2,0.3)'});
            ret.push({color: '#fff', background_color: 'rgba(59,154,212,0.5)'});
        }
        return ret;
    } if(tipus.slice(0,8) == 'ikonok-4') {
        var ret = [];
        ret.push({color: '#000', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'});
        ret.push({color: '#000', background_color: 'rgba(145,190,3, 0.6)', border_color: 'rgba(145,190,3,1)'});
        ret.push({color: '#fff', background_color: 'rgba(252,151,21, 0.6)', border_color: 'rgba(252,151,21,1)'});
        ret.push({color: '#fff', background_color: 'rgba(233,93,14, 0.6)', border_color: 'rgba(233,93,14,1)'});
        if(diagramTipus == 'line') {
            ret.push({color: '#fff', background_color: 'rgba(142,188,2,0.3)'});
            ret.push({color: '#fff', background_color: 'rgba(59,154,212,0.5)'});
        }
        return ret;
    } else if(tipus.slice(0,6) == 'szamok') {
        console.log("nps kiirás");
        var ret;

        if(szamossag <= 10) {
            ret = alap.reverse().slice(0,szamossag);
        } else {
            ret = bovitettAlap.reverse().slice(0,szamossag);
        }
        
        if(diagramTipus == 'line') {            
            ret[szamossag -1 ] = ({color: '#fff', background_color: 'rgba(59,154,212,0.5)'});
        }
        return ret;

    }else {
        switch(tipus) {
            case 'egyedi_valaszok': case 'ertekek-5': case 'dropdown': case 'egyedi_valaszok_kepekkel':
                if(szamossag <= 10) {
                    /*return alap.sort(function() { return 0.5 - Math.random() }).slice(0,szamossag);*/
                    return alap.reverse().slice(0,szamossag);
                } else if(szamossag <= 30) {
                    return bovitettAlap.reverse().slice(0,szamossag);
                } else {
                    var ret = [];
                    for(var i = 0; i < szamossag; ++i) {
                            ret.push({color: '#000', background_color: 'rgba(58,149,69, 0.6)', border_color: 'rgba(58,149,69,1)'});
                    }
                    return ret;
                }

            case 'NPS':
                var ret = [];

                ret.push({color: '#fff', background_color: '#91be03'});
                ret.push({color: '#fff', background_color: '#37a8ca'});
                ret.push({color: '#fff', background_color: '#e95d0e'});
                if(diagramTipus == 'line') {
                    ret.push({color: '#fff', background_color: '#d4cbcd'});
                    ret.push({color: '#fff', background_color: 'rgba(59,154,212,0.5)'});
                    
                }
                return ret;

            case 'CES':
                console.log(" ces-be megy");
                var ret=[];
                ret.push({color: '#fff', background_color: '#91be03'});
                ret.push({color: '#fff', background_color: '#37a8ca'});
                ret.push({color: '#fff', background_color: '#e95d0e'});
                if(diagramTipus == 'line') {
                    ret.push({color: '#fff', background_color: '#d4cbcd'});
                    ret.push({color: '#fff', background_color: 'rgba(59,154,212,0.5)'});
                    
                }
                return ret;
            case 'igen_nem':
                var ret = [];
                ret.push({color: '#fff', background_color: '#91be03'});
                ret.push({color: '#fff', background_color: '#e95d0e'});
                if(diagramTipus == 'line') {
                    ret.push({color: '#fff', background_color: '#d4cbcd'});
                    ret.push({color: '#fff', background_color: 'rgba(142,188,2,0.3)'});
                }
                return ret;
            case 'dashboradColumn':
                var ret = [];

                ret.push({color: '#fff', background_color: '#E44A0C'});
                ret.push({color: '#fff', background_color: 'rgb(46,154,193)'});
                ret.push({color: '#000', background_color: 'rgb(229,229,229)'});

                return ret;

        }
    }

}

function kerdoivPartnere(kerdoivId) {
    var kerdoiv = KERDOIVEK.find(function(val, ind) {
        if(isDefined(val)) {
            return val.id == kerdoivId
        } return false;
    });

    var partner = PARTNEREK.find(function(val, ind) {
        if(isDefined(val)) {
            return val.id == kerdoiv.fk_partner
        } return false;
    });

    return partner;
}

function kerdesKerdoive(kerdesID) {
    var kerdes = KERDESEK.find(function(val, ind) {
        if(isDefined(val)) {
            return val.id == kerdesID
        } return false;
    });

    var kerdoiv = KERDOIVEK.find(function(val, ind) {
        if(isDefined(val)) {
            return val.id == kerdes.fk_kerdoivek
        } return false;
    });

    return kerdoiv;

}

/*Összefüggő selectek egymásra ható szűrése*/
function selectSzures(szurendoSelectTipus, szuroSelectTipus, szuroSelectErtekek, eloreSzurtAdatok) {
    var regiokTelephelyei = {};
    if(szuroSelectTipus == 'regio') {
        for(var i in szuroSelectErtekek) {
            var regio = szurheto_adatok.regiok[szuroSelectErtekek[i]];
            for(var j in regio.telephelyek) {
                regiokTelephelyei[regio.telephelyek[j].id] = regio.telephelyek[j].id;
            }
        }
    }

    var szurtAdatok = [];
    switch(szurendoSelectTipus){
        case 'kerdoiv':
            szurtAdatok = filterArray2(KERDOIVEK, 'fk_partner', szuroSelectErtekek);
        break;
        case 'kerdes': case 'szuro':
            if(szuroSelectTipus == 'partner') {
                var szurtKerdoivIdk = filterArray2(KERDOIVEK, 'fk_partner', szuroSelectErtekek);
                szurtKerdoivIdk = szurtKerdoivIdk.map(function(elem, index){ return elem.id; });
                /*Van-e rendszerszintű kérdés, mert sajnos nem mindig van*/
                szurtAdatok = filterArray2_2(KERDESEK, 'fk_kerdoivek', szurtKerdoivIdk);
            } else if(szuroSelectTipus == 'kerdoiv') {
                szurtAdatok = filterArray2_2(KERDESEK, 'fk_kerdoivek', szuroSelectErtekek);
                /*Rendszerkérdés szövegek partnerek szerint*/
            } else if(szuroSelectTipus == 'kikuldes') {

                /*Kiküldés -> eszköz -> (kérdőív) -> kérdés*/
                var fk_kerdoivek = [];
                for(var i in szuroSelectErtekek) {
                    var eszkozId = isDefined(szuroSelectErtekek[i].value) ? szuroSelectErtekek[i].value.split('#')[1] : szuroSelectErtekek[i].split('#')[1];
                    var eszkoz = findInArray(ESZKOZOK, 'id', eszkozId);
                    if(!isDefined(eszkoz)) {
                        return [];
                    }

                    fk_kerdoivek.push(""+eszkoz.fk_kerdoivek);
                }

                szurtAdatok = filterArray2_2(KERDESEK, 'fk_kerdoivek', fk_kerdoivek);


                /*var eszkozId = szuroSelectErtekek[0].split('#')[1];
                var eszkoz = findInArray(ESZKOZOK, 'id', eszkozId);
                if(!isDefined(eszkoz)) {
                    return [];
                }
                szurtAdatok = filterArray2_2(KERDESEK, 'fk_kerdoivek', [""+eszkoz.fk_kerdoivek]);*/

            }
        break;
        case 'regio':
            if(szuroSelectTipus == 'partner') {
                szurtAdatok = filterArray2(REGIOK, 'fk_partner', szuroSelectErtekek);
            } else if (szuroSelectTipus == 'kerdoiv') {
                szurtTelephelyIdk = {};
                $.each(szuroSelectErtekek, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivTelephelyei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].telephely;
                        for(var j in kerdoivTelephelyei) {
                            var telephelyId = kerdoivTelephelyei[j];
                            if(!isDefined(szurtTelephelyIdk[telephelyId])) {
                                szurtTelephelyIdk[telephelyId] = telephelyId;
                            }
                        }
                    }
                });
                szurtTelephelyIdk = objectToArray(szurtTelephelyIdk);
                var szurtAdatok = [];
                for(var i in REGIOK) {
                    var regio = REGIOK[i];
                    if(isDefined(regio)) {
                        var metszet = $.map(regio.telephelyek,function(a){return $.inArray(a.id, szurtTelephelyIdk) < 0 ? null : a.id;});
                        if(isDefined(metszet) && metszet.length > 0) {
                            szurtAdatok.push(regio);
                        }
                    }
                }
            } else if(szuroSelectTipus == 'kerdes') {
                var szurtKerdesIdk = filterArray2(KERDESEK, 'id', szuroSelectErtekek);
                var szurtKerdoivIdk = szurtKerdesIdk.map(function(elem, index){ return elem.fk_kerdoivek; });

                szurtTelephelyIdk = {};
                $.each(szuroSelectErtekek, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivTelephelyei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].telephely;

                        for(var j in kerdoivTelephelyei) {
                            var telephelyId = kerdoivTelephelyei[j];
                            if(!isDefined(szurtTelephelyIdk[telephelyId])) {
                                szurtTelephelyIdk[telephelyId] = telephelyId;
                            }
                        }
                    }
                });
                szurtTelephelyIdk = objectToArray(szurtTelephelyIdk);
                var szurtAdatok = [];
                for(var i in REGIOK) {
                    var regio = REGIOK[i];
                    if(isDefined(regio)) {
                        var metszet = $.map(regio.telephelyek,function(a){return $.inArray(a.id, szurtTelephelyIdk) < 0 ? null : a.id;});
                        if(isDefined(metszet) && metszet.length > 0) {
                            szurtAdatok.push(regio);
                        }
                    }
                }
            }

        break;
        case 'telephely':
            eloreSzurtAdatok = isDefined(eloreSzurtAdatok) ? eloreSzurtAdatok : TELEPHELYEK;
            if(szuroSelectTipus == 'partner') {
                szurtAdatok = filterArray2(TELEPHELYEK, 'fk_partner', szuroSelectErtekek);
            }  else if(szuroSelectTipus == 'kerdoiv') {
                szurtAdatok = {};
                $.each(szuroSelectErtekek, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivTelephelyei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].telephely;
                        for(var j in kerdoivTelephelyei) {
                            var telephelyId = kerdoivTelephelyei[j];
                            if(!isDefined(szurtAdatok[telephelyId])) {
                                szurtAdatok[telephelyId] = findInArray(eloreSzurtAdatok, 'id', telephelyId);
                            }
                        }
                    }
                });
                szurtAdatok = objectToArray(szurtAdatok);
            } else if(szuroSelectTipus == 'kerdes') {
                var szurtKerdesIdk = filterArray2(KERDESEK, 'id', szuroSelectErtekek);
                var szurtKerdoivIdk = szurtKerdesIdk.map(function(elem, index){ return elem.fk_kerdoivek; });

                szurtAdatok = {};
                $.each(szurtKerdoivIdk, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivTelephelyei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].telephely;
                        for(var j in kerdoivTelephelyei) {
                            var telephelyId = kerdoivTelephelyei[j];
                            if(!isDefined(szurtAdatok[telephelyId])) {
                                szurtAdatok[telephelyId] = findInArray(eloreSzurtAdatok, 'id', telephelyId);
                            }
                        }
                    }
                });
                szurtAdatok = objectToArray(szurtAdatok);

            } else {

                var szurtTelephelyIdk = [];
                $.each(regiokTelephelyei, function(kulcs, ertek) {
                    szurtTelephelyIdk.push(ertek);
                });
                szurtAdatok = filterArray2(eloreSzurtAdatok, 'id', szurtTelephelyIdk);
            }
        break;
        case 'eszkoz':
            eloreSzurtAdatok = isDefined(eloreSzurtAdatok) ? eloreSzurtAdatok : ESZKOZOK;
            if(szuroSelectTipus == 'partner') {
                var szurtTelephelyIdk = filterArray2(TELEPHELYEK, 'fk_partner', szuroSelectErtekek);
                szurtTelephelyIdk = szurtTelephelyIdk.map(function(elem, index){ return elem.id; });
                szurtAdatok = filterArray2(eloreSzurtAdatok, 'fk_telephelyek', szurtTelephelyIdk);
            } else if(szuroSelectTipus == 'telephely') {
                szurtAdatok = filterArray2(eloreSzurtAdatok, 'fk_telephelyek', szuroSelectErtekek);
            } else if(szuroSelectTipus == 'kerdoiv') {
                szurtAdatok = {};
                $.each(szuroSelectErtekek, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivEszkozei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].eszkoz;
                        for(var j in kerdoivEszkozei) {
                            var eszkozId = kerdoivEszkozei[j];
                            if(!isDefined(szurtAdatok[eszkozId])) {
                                szurtAdatok[eszkozId] = findInArray(eloreSzurtAdatok, 'id', eszkozId);
                            }
                        }
                    }
                });
                szurtAdatok = objectToArray(szurtAdatok);
                console.log({szurtAdatok});
            } else if (szuroSelectTipus == 'kerdes') {
                var szurtKerdesIdk = filterArray2(KERDESEK, 'id', szuroSelectErtekek);
                var szurtKerdoivIdk = szurtKerdesIdk.map(function(elem, index){ return elem.fk_kerdoivek; });
                szurtAdatok = {};
                $.each(szurtKerdoivIdk, function(kulcs, ertek){
                    if(isDefined(szurheto_adatok.history_szetszorva.kerdoiv[ertek])) {
                        var kerdoivEszkozei = szurheto_adatok.history_szetszorva.kerdoiv[ertek].eszkoz;
                        for(var j in kerdoivEszkozei) {
                            var eszkozId = kerdoivEszkozei[j];
                            if(!isDefined(szurtAdatok[eszkozId])) {
                                szurtAdatok[eszkozId] = findInArray(eloreSzurtAdatok, 'id', eszkozId);
                            }
                        }
                    }
                });
                szurtAdatok = objectToArray(szurtAdatok);
                console.log({szurtAdatok});
            } else {
                var szurtTelephelyIdk = [];
                $.each(regiokTelephelyei, function(kulcs, ertek) {
                    szurtTelephelyIdk.push(ertek);
                });
                szurtAdatok = filterArray2(eloreSzurtAdatok, 'fk_telephelyek', szurtTelephelyIdk);
            }
        break;
        case 'kikuldes':
            if(szuroSelectTipus == 'eszkoz') {
                startLoader();
                getKikuldesek(szurendoSelectTipus + '_select_input', szuroSelectErtekek);
                
                /*Itt ajaxos megoldás van, úgyhogy visszatérünk*/
                return [];
            }
        break;
        case 'ismerv':
            if(szuroSelectTipus == 'kikuldes') {
                getIsmervek(szurendoSelectTipus + '_select_input', szuroSelectErtekek[0]);
                /*Itt ajaxos megoldás van, úgyhogy visszatérünk*/
                return [];
            }
        break;
        case 'ismervertek':
            if(szuroSelectTipus == 'ismerv') {
                getIsmervErtekek(szurendoSelectTipus + '_select_input', szuroSelectErtekek);
                /*Itt ajaxos megoldás van, úgyhogy visszatérünk*/
                return [];
            }
        break;
    }


    var id = '#'+szurendoSelectTipus+'_select_input';

    var ujSelectErtetek = [];
    if(szurtAdatok.length > 0) {
        if(szurendoSelectTipus == 'kerdes' || szurendoSelectTipus == 'szuro') {

            var validKerdesekObj = {};
            
            for(var i in szurtAdatok) {
                console.log({szuroSelectErtekek, t: szurtAdatok[i], szurendoSelectTipus});
                /*Ha csak egy szűrő van, és rendszerszintű kérdésről van szó, akkor vegyük a felülírt szöveget*/
                if(szuroSelectTipus == 'kerdoiv' && $.isArray(szurtAdatok[i].fk_kerdoivek) == 1 && szuroSelectErtekek.length == 1) {
                    console.log({szuroSelectErtekek});
                    var kerdoivId = szuroSelectErtekek[0];
                    szurtAdatok[i].kerdes_szovege = kerdesKeerdoivAlapjan(szurtAdatok[i], kerdoivId);
                } else if(szuroSelectTipus == 'kikuldes' && $.isArray(szurtAdatok[i].fk_kerdoivek) == 1) {
                    var eszkozId = $('#eszkoz_select_input').val();
                    console.log({eszkozId});
                    var eszkoz = findInArray(ESZKOZOK, 'id', typeof eszkozId === "number" ? eszkozId : eszkozId[0]);
                    console.log({eszkoz});
                    szurtAdatok[i].kerdes_szovege = kerdesKeerdoivAlapjan(szurtAdatok[i], eszkoz.fk_kerdoivek);
                }
                if(szurtAdatok[i].valasz_tipus_kod != 'szabad_szoveg' && szurtAdatok[i].valasz_tipus_kod.slice(0,14) != 'kerdes-csoport') {
                    if(!isDefined(validKerdesekObj[szurtAdatok[i].azonosito])){
                        validKerdesekObj[szurtAdatok[i].azonosito] = szurtAdatok[i];
                    }

                }
            }
            var validKerdesek = objectToArray(validKerdesekObj);
            ujSelectErtetek = filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false);

        } else {
            ujSelectErtetek = filterSelectValues(szurtAdatok, 'nev', 'id');
        }
    }

    refillSelect(szurendoSelectTipus+'_select_input',ujSelectErtetek);

    return szurtAdatok;

}
/*2021.09.07 - Mostantól több csatornát (eszközt) is meg lehet adni a jelentésnél*/
function getKikuldesek(szurendoSelectId, eszkozIdk) {
    var eszkozId = eszkozIdk[0];
    var peldaEszkoz = findInArray(ESZKOZOK, 'id', eszkozId);
    var ajax_obj = {
        "echo": "1", 
        "partner_id": peldaEszkoz.partner_id
    };

    var resultText = {};

    postApi('beolvasas_sel',ajax_obj,$('body'),resultText,null,function(result){
        stopLoader();
        var kikuldesek = [];
        var ismerv_csoport = null;
        $('#btn_riport_szures').removeClass('is-inactive');
        $('#btn_riport_szures').prop('disabled', false);
        $('.error-holder').addClass('d-none');
        for(var i in result.data) {
            if(result.data[i].kikuldve != null && $.inArray(result.data[i].eszkoz_id, eszkozIdk) > -1) {

                if(ismerv_csoport == null) {
                    ismerv_csoport = result.data[i].ismerv_csoport_id;
                } else if(result.data[i].ismerv_csoport_id != ismerv_csoport) {
                    $('#btn_riport_szures').addClass('is-inactive');
                    $('#btn_riport_szures').prop('disabled', true);
                    $('.error-holder').removeClass('d-none');
                    return;
                }
                
                kikuldesek.push({
                    /*Formátum: kikuldes_id#eszkoz_id#ismerv_csoport_id*/
                    value: result.data[i].id+'#'+result.data[i].eszkoz_id+'#'+result.data[i].ismerv_csoport_id,
                    name: result.data[i].nev
                });
            }
            
        }
        KIKULDESEK = kikuldesek;
        refillSelect(szurendoSelectId,kikuldesek);
        $('#'+szurendoSelectId).prop('disabled', false);
        $(".btn[data-id='"+szurendoSelectId+"']").removeClass("disabled");
        if(kikuldesek.length > 0) {
            getIsmervek('ismerv_select_input', kikuldesek[0].value);
            var tmp = selectSzures('kerdes','kikuldes',kikuldesek);
            if(tmp.length > 0) {
                $('#kerdes_select_input').prop('disabled', false);
                $(".btn[data-id='kerdes_select_input']").removeClass("disabled");
            }
        }

    });
}

function getIsmervek(szurendoSelectId, selectValue) {

    var ismervCsoportId = selectValue.split('#')[2];

    var ajax_obj = {
        "echo": "1",
        "ismerv_csoport_id": ismervCsoportId
    };

    var resultText = {};

    postApi('ismervek_sel',ajax_obj,$('body'),resultText,null,function(result){
        var ismervek = [];
        for(var i in result.data) {
            ismervek.push({
                value: result.data[i].id,
                name: result.data[i].nev
            });
        }
        ISMERVEK = ismervek;
        refillSelect(szurendoSelectId,ismervek);
        $('#'+szurendoSelectId).prop('disabled', false);
        $(".btn[data-id='"+szurendoSelectId+"']").removeClass("disabled");
    });
}

function getIsmervErtekek(szurendoSelectId, selectValues) {

    console.log('selectValue', selectValues);
    var kikuldesIdk = [];
    for(var i in selectValues) {
        var val = selectValues[i].value != undefined ? selectValues[i].value : selectValues[i];
        var kikuldesId = val.split('#')[0];
        kikuldesIdk.push(kikuldesId);
    }

    var ajax_obj = {
        "echo": "1",
        "beolvasas_idk": JSON.stringify(kikuldesIdk)
    };

    var resultText = {};

    startLoader();
    postApi('beolvasas_ismervek_sel',ajax_obj,$('body'),resultText,null,function(result){
        stopLoader();
        var ismervErtekek = [];
        var ismervId = $('#ismerv_select_input').val()[0];
        for(var i in result.data) {
            if(!isDefined(findInArray(ismervErtekek, 'value', result.data[i].beolvasott_ismerv)) && (ismervId == undefined || result.data[i].ismerv_id == ismervId)) {
                ismervErtekek.push({
                    value: result.data[i].beolvasott_ismerv,
                    name: result.data[i].beolvasott_ismerv
                });
            }
        }
        ISMERV_ERTEKEK = ismervErtekek;
        refillSelect(szurendoSelectId,ismervErtekek);
        $('#'+szurendoSelectId).prop('disabled', false);
        $(".btn[data-id='"+szurendoSelectId+"']").removeClass("disabled");
    });
}

function kerdesKeerdoivAlapjan(kerdes, kerdoivId) {
    var kerdoiv = findInArray(KERDOIVEK, 'id', kerdoivId);
    var szoveg = kerdes.kerdes_szoveg;
    var lang = act_lang;
    if(!isDefined(KERDOIVEK[kerdoivId].json.nyelvek[lang])) {
        lang = Object.keys(KERDOIVEK[kerdoivId].json.nyelvek)[0];
    }
    var kerdesKerdoivbol = findInArray(kerdoiv.json.nyelvek[lang].rendszerszintu_kerdesek, 'id', kerdes.id);
    if(isDefined(kerdesKerdoivbol) && isDefined(kerdesKerdoivbol.felulirt_kerdes_szoveg) && kerdesKerdoivbol.felulirt_kerdes_szoveg.length > 0) {
        szoveg = kerdesKerdoivbol.felulirt_kerdes_szoveg;
    }
    return szoveg;
}

function tablaMetaadatok(kerdesId) {

    var partnerIdk = $('#partner_select_input').val();
    var kerdoivIdk = $('#kerdoiv_select_input').val();
    var regioIdk = $('#regio_select_input').val();
    var telephelyIdk = $('#telephely_select_input').val();
    var eszkozIdk = $('#eszkoz_select_input').val();

    /*Partnerek kikeresése*/
    var partnerek = {};
    if(partnerIdk.length > 0) {
        for(var i in partnerIdk) {
            var partner = findInArray(PARTNEREK, 'id', partnerIdk[i]);
            /*partnerek += (partnerek.length == 0)  ? partner.nev : " ;" + partner.nev ;*/
            partnerek[partner.id] = partner.nev;
        }
    } else if(kerdoivIdk.length > 0) {
        for(var i in kerdoivIdk) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdoivIdk[i]);
            var partner = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerek[partner.id] = partner.nev;
        }
    } else if(telephelyIdk.length > 0) {
        for(var i in telephelyIdk) {
            var telephely = findInArray(TELEPHELYEK, 'id', telephelyIdk[i]);
            var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
            partnerek[partner.id] = partner.nev;
        }

    } else if(regioIdk.length > 0) {
        for(var i in regioIdk) {
            var regio = findInArray(REGIOK, 'id', regioIdk[i]);
            for(var j in regio.telephelyek) {
                var telephely = regio.telephelyek[j];
                var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
                partnerek[partner.id] = partner.nev;
            }
        }
    } else if(eszkozIdk.length > 0) {
        for(var i in eszkozIdk) {
            var eszkoz = findInArray(ESZKOZOK, 'id', eszkozIdk[i]);
            var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
            var partner = findInArray(PARTNEREK, 'id', telephely.fk_partner);
             partnerek[partner.id] = partner.nev;

        }
    }

    /*Telephelyek*/
    var telephelyek = {};
    if(telephelyIdk.length > 0) {
        for(var i in telephelyIdk) {
            var telephely = findInArray(TELEPHELYEK, 'id', telephelyIdk[i]);
            telephelyek[telephely.id] = telephely.nev;
        }
    } else if(eszkozIdk.length > 0) {
        for(var i in eszkozIdk) {
            var eszkoz = findInArray(ESZKOZOK, 'id', eszkozIdk[i]);
            var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
            telephelyek[telephely.id] = telephely.nev;
        }
    } else if(regioIdk.length > 0) {
        for(var i in regioIdk) {
            var regio = findInArray(REGIOK, 'id', regioIdk[i]);
            for(var j in regio.telephelyek) {
                var telephely = regio.telephelyek[j];
                telephelyek[telephely.id] = telephely.nev;
            }
        }
    } else if(partnerIdk.length > 0) {
        for(var i in partnerIdk) {
            var partner = findInArray(PARTNEREK, 'id', partnerIdk[i]);
            var _telephelyek = TELEPHELYEK.filter(function(telephely) {
                return telephely.fk_partner ==  partner.id;
            });
            for(var j in _telephelyek) {
                telephelyek[_telephelyek[j].id] = _telephelyek[j].nev;
            }
        }
    } else if(kerdoivIdk.length > 0) {
        for(var i in kerdoivIdk) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdoivIdk[i]);
            var eszkozok = ESZKOZOK.filter(function(eszkoz) {
                return eszkoz.fk_kerdoivek == kerdoiv.id;
            });
            for(var j in eszkozok) {
                var eszkoz = eszkozok[j];
                var telephely = findInArray(TELEPHELYEK, 'id', eszkoz.fk_telephelyek);
                telephelyek[telephely.id] = telephely.nev;
            }
        }
    }

    var partnerArr = objectToArray(partnerek);
    var telephelyArr = objectToArray(telephelyek);
    var retPartnerek = [];
    var retTelephelyek = [];

    for(var i in partnerArr) {
        retPartnerek.push(partnerArr[i]);
    }

    for(var i in telephelyArr) {
        retTelephelyek.push(telephelyArr[i]);
    }

    return {
        "partnerek": retPartnerek,
        "telephelyek": retTelephelyek
    };
}

/*Jelentések kinyomtatása (nyomtatási kép előállítása)
Csak azok a táblák és grafikonok jelennek meg a nyomtatásban, amiket nem tűntettek el az oldalon*/
function printData(reportData, type) {
    var has_popup = $('#nyomtatasi_nezet_cim').is(':checked');
    if(has_popup) {
        popupForm({
            inic_param: {
                title:"[[$t.nyomtatas_cimek_megadasa]]",
                id: 'nyomtatas_cim_form',
                cols: 1,
                rows: 2,
            },
            buttons: [
                {
                    id: 'btn_nyomtatas',
                    type: 'save',
                    name: "[[$t.nyomtatas]]",
                    visibility: function() {return 1},
                    callback: function(valid) {
                        reportData.focim = $('#focim').val();
                        reportData.alcim = $('#alcim').val();
                        localStorage.setItem('nyomtat_focim', reportData.focim);
                        localStorage.setItem('nyomtat_alcim', reportData.alcim);
                        initPrint(reportData, type);
                        close_pop_up();
                    },
                },
                {
                    id: 'btn_vissza_nyomtatas',
                    type: 'cancel',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        close_pop_up();
                    },
                },
            ],
            inputs: [
                {"col": 0, "row": 0, "input": inputHtml({
                                                        id: 'focim',
                                                        label: '[[$t.nyomtatas_fo_cim]]',
                                                        placeholder: '[[$t.nyomtatas_fo_cim]]',
                                                        name: 'focim',
                                                        addclass: 'form required',
                                                        required: true
                                                    })
                 },
                 {"col": 0, "row": 1, "input": inputHtml({
                                                        id: 'alcim',
                                                        label: '[[$t.nyomtatas_alcimcim]]',
                                                        placeholder: '[[$t.nyomtatas_alcimcim]]',
                                                        name: 'alcim',
                                                        addclass: 'form required',
                                                    })
                },

            ],
        });

        var focim = localStorage.getItem('nyomtat_focim');
        var alcim = localStorage.getItem('nyomtat_alcim');

        $('#focim').val(focim);
        $('#alcim').val(alcim);
    } else {
        initPrint(reportData, type);
    }
}

function initPrint(reportData, type) {

    var pageWidth = 1000;

    var toPrint = '';
    var hasPageHeading = false;
    var tdWidths = [];

    $('#jelentes-holder').children().each(function(ind, value) {
        pageWidth = 900;
        var hasTitle = false;
        var innerContent = '';

        if(!$(value).children('.table-recreate').hasClass('d-none')) {
            var id = $(value).children('.table-recreate').find('table')[0].id;
            var divToPrint = document.getElementById(""+id);
            innerContent += '<div style="margin-bottom: 30px">'+divToPrint.outerHTML+'</div>';
            var colCount = $('#'+id).DataTable().columns().header().length;
            var width = Math.floor(pageWidth / parseInt(colCount));
            tdWidths.push({id: id, w: width});
            hasTitle = true;
        } 

        if(!$(value).find('canvas').parent().hasClass('d-none')) {
            if(isDefined($(value).find('canvas')[0])) {
                var domId = $(value).find('canvas')[0].id;
                console.log("domId",domId);
                var chartId = domId.replace(/chart-/g, '');
                var grafikon = findInArray(GRAFIKON_ADATOK, 'id', chartId);
                if(isDefined(grafikon)) {
                    var height = Math.max(grafikon.adat.lebontasok.length * 50, 180);
                    console.log("lebontas",grafikon.adat.lebontasok.length * 50);
                    var typeClass = isDefined(type) ? 'type-'+type : '';
                    innerContent += '<div class="canvas-holder '+typeClass+'" style="height:'+height+'px; width: 1000px"><canvas id="'+domId+'"></canvas></div>';
                }
                hasTitle = true;
            }

        }

        var title = hasTitle ? '<h2>'+ $(value).find('.table_name').html() +'</h2>' : '';
        var filterString = hasTitle ? '<div style="margin-bottom: 20px">'+$(value).find('.cf-filter-string').html()+'</div>' : '';

        var heading = "";
        if(!hasPageHeading) {
            if(reportData.focim != undefined && reportData.focim.length > 0) {
                heading += '<h1 style="text-align: center; margin-top: 20px;">'+reportData.focim+'</h1>';
            }
            if(reportData.alcim != undefined && reportData.alcim.length > 0) {
                heading += '<h2 class="break-after" style="margin-bottom: 40px; text-align: center">'+reportData.alcim+'</h2>';
            }
            hasPageHeading = true;
        }
        

        toPrint += '<div class="print-holder">'+ heading + title + filterString  + innerContent+'</div>';

    });

    var jquery = act_domain+ '/includables/jquery-3.3.1.min.js';
    var printcss = act_domain + 'out/css/index_' + 'print_' + act_lang + '_' + act_version + '.css';
    var chartcss = act_domain+ '/includables/Chart/Chart.min.css';
    var chartjs = act_domain+ '/includables/Chart/Chart.min.js';
    var chartjs2 = act_domain+ '/includables/Chart/chartjs-plugin-datalabels.min.js';
    var chartjs3 = act_domain+ '/includables/Chart/chartjs-plugin-stacked100.js';
    var js1 = act_domain + 'out/js/index_' + '01-common_' + act_lang + '_' + act_version + '.js';
    var js5 = act_domain + 'out/js/index_' + '05-script_' + act_lang + '_' + act_version + '.js';
    var js6 = act_domain + 'out/js/index_' + '06-template_' + act_lang + '_' + act_version + '.js';
    var js9 = act_domain + 'out/js/index_' + '09-jelentesek_' + act_lang + '_' + act_version + '.js';

    var title =  reportData.tipus;

    newWin = window.open('x', '_blank');
    $(newWin.document).find('.print-holder').remove();
    var partnerNev = (isDefined(reportData.partner) && isDefined(reportData.partner.nev)) ? ' | ' + reportData.partner.nev : '' ;
    newWin.document.write('<html><head><title>'+'CEedback '+title+partnerNev+'</title>');
    newWin.document.write('<link rel="stylesheet" href="'+chartcss+'">');
    newWin.document.write('<link rel="stylesheet" href="'+printcss+'">');
    newWin.document.write('<script src="'+jquery+'"></script>');
    newWin.document.write('<script src="'+chartjs+'"></script>');
    newWin.document.write('<script src="'+chartjs2+'"></script>');
    newWin.document.write('<script src="'+chartjs3+'"></script>');
    newWin.document.write('<script src="'+jquery+'"></script>');
    newWin.document.write('<script src="'+js9+'"></script>');
    newWin.document.write('<script src="'+js1+'"></script>');
    newWin.document.write('<script src="'+js5+'"></script>');
    newWin.document.write('<script src="'+js6+'"></script>');
    newWin.document.write('<script src="'+js6+'"></script>');
    newWin.document.write('<script src="'+js9+'"></script>');
    newWin.document.write('</head><body class="print" style="overflow: auto;">');

    var grafikonok = JSON.stringify({type: type, data: GRAFIKON_ADATOK});
    localStorage.setItem('printChatData',grafikonok);


    newWin.document.write(toPrint);
    newWin.document.write('</body></html>');

    setTimeout(function() {
        $.each(tdWidths, function(ind, val){
            $(newWin.document).find('#'+val.id).css('width', pageWidth);
            $(newWin.document).find('#'+val.id).find('th,td').css('font-size', '13px');
            $(newWin.document).find('#'+val.id).find('th,td').css('max-width', val.w);
            $(newWin.document).find('#'+val.id).find('th,td').css('word-break', 'break-word');
            $(newWin.document).find('#'+val.id).find('th,td').css('padding', '5px');
            $(newWin.document).find('tfoot.d-none').remove();
            $(newWin.document).find('tfoot th').css('text-align', 'end');
            $(newWin.document).find('tfoot th').css('padding', '5px');
        });
        /*newWin.print();*/
        newWin.afterPrintInit();
    }, 1000);

}

function tombSum(tomb) {
    var ret = 0;
    for (var i in tomb) {
        ret += parseInt(tomb[i]);
    }
    return ret;
}

function arrayToString(arr) {
    var ret = '';
    for(var i in arr) {
        if(ret != '') {
            ret += ', ';
        }
        ret += arr[i];

    }
    return ret;
}

function regioSzuresTelephelyekkel() {
    var telephelyIdk = [];
    var telephelyek = objectToArray(szurheto_adatok.telephelyek);
    for(var i in telephelyek) {
        var telephelyId = telephelyek[i].id;
        if($.inArray(telephelyIdk, telephelyId) < 0) {
            telephelyIdk.push(telephelyId);
        }
    }


    var ujRegiok = {};
    $.each(szurheto_adatok.regiok, function(key, regio){

        if(isDefined(findInArray2(regio.telephelyek, 'id', telephelyIdk))) {
            ujRegiok[key] = regio;
        }
    });

    return ujRegiok;
}

function sorosszeg(sor, tipus, nps_e,ces_e) {
    var ret = 0;
    var len = sor.length;
    if(tipus.slice(0,6) == 'ikonok' || tipus == 'igen_nem' || nps_e || ces_e || tipus == 'szamok-1-10' || tipus == 'szamok-0-10' || tipus == 'szamok-1-6' || tipus == 'szamok-1-5') {
        len = len - 1;
    }
    for(var i = 0; i < len; i++) {
        if(!$.isNumeric(sor[i])) {
           ret += 0;
        } else {
            ret += parseInt(sor[i]);
        }
    }

    return ret;
}

function isErtekesKerdes(kerdes) {
    return kerdes.valasz_tipus_kod.slice(0,15) !=  'egyedi_valaszok' && kerdes.valasz_tipus_kod != "szabad_szoveg" && kerdes.valasz_tipus_kod != 'dropdown';
}
 


function afterPrintInit() {
    setTimeout(function() {
        var grafikonok = localStorage.getItem('printChatData');
        if(isDefined(grafikonok)) {
            grafikonok = JSON.parse(grafikonok);

            for(var i in grafikonok.data) {
                var t = (grafikonok.data[i].adat.nps == "1") ? 'NPS' : grafikonok.data[i].adat.tipus;
                console.log(grafikonok);
                if(isDefined(grafikonok.type)) {
                    if(grafikonok.type == 'column') {
                        szinek = szinGeneralas(t, grafikonok.data[i].adat.lehetseges_valaszok.length);
                        drawColumnChart("chart-"+grafikonok.data[i].id, grafikonok.data[i].adat.lebontasok, grafikonok.data[i].adat.data, szinek, true,grafikonok.data[i].adat.ces == "1", grafikonok.data[i].adat.tipus, true);
                    } else if(grafikonok.type == 'line') {
                        console.log("test");
                        let l = (grafikonok.data[i].adat.nps == "1") ? grafikonok.data[i].adat.lehetseges_valaszok.length :  +grafikonok.data[i].adat.lehetseges_valaszok.length+1;
                        szinek = szinGeneralas(t, l,'line');
                        drawLineChart("chart-"+grafikonok.data[i].id, grafikonok.data[i].adat.lebontasok, grafikonok.data[i].adat.data, szinek, grafikonok.data[i].adat.nps == "1",grafikonok.data[i].adat.ces == "1", grafikonok.data[i].adat.tipus, false, true);
                    } else if(grafikonok.type == 'osszesitett') {
                        console.log("test2");
                        szinek = szinGeneralas(t, grafikonok.data[i].adat.lehetseges_valaszok.length,'line');
                        drawLineChart("chart-"+grafikonok.data[i].id, grafikonok.data[i].adat.lebontasok, grafikonok.data[i].adat.data, szinek, true,grafikonok.data[i].adat.ces == "1", 'oszzevont_nps', false, true);
                    }
                } else {
                    console.log("test3");
                    szinek = szinGeneralas(t, grafikonok.data[i].adat.lehetseges_valaszok.length);
                    var nps = (grafikonok.data[i].adat.nps == "1") ? true : false;
                    var ces= (grafikonok.data[i].adat.ces == "1") ? true : false;
                    drawBarChart("chart-"+grafikonok.data[i].id, grafikonok.data[i].adat.lebontasok, grafikonok.data[i].adat.data, szinek, nps,ces, grafikonok.data[i].adat.tipus, true,false);
                }
                
            }

        }
        setTimeout(function() {window.print();}, 1000);
        
    }, 1000);
    
}


