var figyelesek = null;
$(document).ready(function() {

    figyelesek = dataTable($('#figyelesek'),{
		table:{
            name: "[[$t.gyanus_figyelesek]]",
			right:'figyelesek_manage',
		},
		ajax:{
            name:'figyelesek_sel',
            data:{
                "echo": "1",
            },
        },
		columns:[
			{ headName:"[[$t.kerdoiv]]", colName:"kerdoiv_nev" },
            { headName:"[[$t.masodperc]]", colName:"masodperc", canEdit:true},
            { headName:"[[$t.utolso_jelentes_megnezve]]", colName:"utolso_jelentes_megnezve", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            }},
        ],
        forms: [
            {
                inic_param: {
                        id: 'new_figyeles_form',
                        dataRight: 'figyelesek_manage',
                        title: '[[$t.uj_figyeles]]',
                        cols: 1,
                        rows: 2,
                        position: 'bottom'
                    },
                    buttons: [
                        {
                            name:"[[$t.uj_figyeles]]",
                            id: 'btn_new_figyeles',
                            visibility: function() {return 1},
                            callback: function(valid) {
                                if(valid) {
                                    ajax_call_figyeles_new($(this));
                                }
                               
                            },
                            onCustomAjaxDone: function(event,result,trigger){
                                
                            },
                            type: 'save',
                        },
                        {
                            name:"[[$t.vissza]]",
                            id: 'btn_cancel_new_figyeles',
                            visibility: function() {return 1},
                            callback: function() {
                                clearForm('new_figyeles_form');
                            },
                            addClasses: 'btn-alt',
                            type: 'cancel',
                            toggleId: 'new_figyeles_form'
                        }
        
                    ],
                    inputs: [
                        {"col": 0, "row": 0, "input": filterSelectHtml({
                                                            id: 'kerdoiv_select_input',
                                                            placeholder: '[[$t.valassz]]',
                                                            label: '[[$t.figyelt_kerdoiv]]',
                                                            name: 'kerdoiv_select_input',
                                                            maxOptions: 1,
                                                            addclass: 'form',
                                                            required: true
                                                        },
                                                        filterSelectValues(kezelheto_kerdoivek, "nev" ,"id")
                                                    )},
                        {"col": 0, "row": 1, "input": inputHtml({
                                                        id: 'figyeles_mp_input',
                                                        label: '[[$t.figyeles_mp]]',
                                                        placeholder: '[[$t.figyeles_mp]]',
                                                        required: true,
                                                        name: 'figyeles_mp_input',
                                                        autofocus: false,
                                                        maxlength: 5,
                                                        type: "number",
                                                        min: 1
                                                    })},
                                                
                    ],
                    
            },
        ],
        buttons: [
            {
                name: "[[$t.uj_figyeles]]",
                id: 'news_figyeles_toggle_btn',
                dataRight: 'figyelesek_manage',
                type: "new",
                toggleId: 'new_figyeles_form',
			}
        ],
        functions:{
            edit:{
                ajax:"figyelesek_mod",
                right:"figyelesek_manage",
                data:{
                    '#name':'parameter_nev',
                    '#id':'kerdoiv_id',
                    '#data':'masodperc',
                },
                text:{
 
                } 
            },
            delete:{
                ajax:"figyelesek_del",
                right:"figyelesek_manage",
                data:{
                    '#id':'id'
                }
            }
        }
	});

});

function ajax_call_figyeles_new (elem) {
    var data = {
        "kerdoiv_id": $('#kerdoiv_select_input').val()[0],
        "masodperc": $('#figyeles_mp_input').val(),
    };

    var resultText = {
        email: '[[$t.foglalt_email]]'
    };

    postApi('figyelesek_new',data,elem,resultText,null,function(result){
        if(result[0] == 'OK'){
            figyelesek.ajax.reload();
        }
    });
}