var eszkozok = null;
var telephely_select = '';
var valaszthato_kerdoivek = null;

var PARTNEREK = [];
$.each(adhato_partnerek_telephelyek, function (key, value) {
    PARTNEREK.push({ "nev": value.partner_nev, "id": key, "telephelyek": value.telephelyek });
});

var TELEPHELYEK = adhato_telephelyek_uj;

$(document).ready(function () {
    if (isAdmin()) {
        $('#download').removeClass("d-none");
        $('#download').click(function () {
            window.open('/' + act_lang + '/apk/' + srv + '/');
        });
    }

    valaszthato_kerdoivek = {
        table: {
            right: 'eszkozok_kerdoiv_hozzarendeles',
            canSelect: true,
            /*selectCol:'kivalasztva',*/
        },
        data: hozzarendelheto_kerdoiv_sel,
        columns: [
            { headName: "", type: "details" },
            { headName: "[[$t.kerdoiv]]", colName: "nev" },
            { headName: "[[$t.partner]]", colName: "partner_nev" },
            { headName: "[[$t.letrehozo]]", colName: "letrehozo", inDetails: true },
            { headName: "[[$t.letrehozas_datuma]]", colName: "letrehozas_datuma", inDetails: true, isDateFormat: true },
            { headName: "[[$t.aktiv]]", colName: "aktiv", type: "checkbox", filterType: "checkbox", inDetails: true }
        ],
    };


    telephely_select = editSelectHtml(adhato_telephelyek_uj, 'nev', 'id');

    var eszkoz_partner_mod = {
        inic_param: {
            id: 'eszkoz_partner_mod',
            dataRight: 'eszkozok_letrehozasa',
            title: '[[$t.partner_telephely_mod]]',
            cols: 1,
            rows: 2,
        },
        buttons: [
            {
                name: "[[$t.mentes]]",
                id: 'btn_mod_eszkoz',
                visibility: function () { return 1 },
                callback: function () {
                    var valid = validateForm($('#eszkoz_partner_mod'));
                    if (valid) {
                        ajax_call_eszkozok_mod($('#btn_mod_eszkoz'));
                    }
                },
                onCustomAjaxDone: function (event, result, trigger) {
                    close_pop_up();
                    if (result.EREDMENY == 'OK') {
                        eszkozok.ajax.reload();
                    }
                    else if (result.EREDMENY == 'HI') {
                        gi_alert(result.UZENET);
                    }
                },
                type: 'save',
            },
            {
                name: "[[$t.vissza]]",
                id: 'btn_cancel_mod_eszkoz',
                visibility: function () { return 1 },
                callback: function () {
                    close_pop_up();
                },
                addClasses: 'btn-alt',
                type: 'cancel',
            }

        ],
        inputs: [
            {
                "col": 0, "row": 0, "input": filterSelectHtml({
                    id: 'eszkoz_mod_partner_input',
                    placeholder: '[[$t.partner]]',
                    label: '[[$t.partner]]',
                    name: 'eszkoz_mod_partner_input',
                    maxOptions: 1,
                    addclass: 'form'
                },
                    filterSelectValues(PARTNEREK, "nev", "id")
                )
            },
            {
                "col": 0, "row": 1, "input": filterSelectHtml({
                    id: 'eszkoz_mod_telephely_input',
                    placeholder: '[[$t.telephely]]',
                    name: 'eszkoz_mod_telephely_input',
                    label: '[[$t.telephely]]',
                    required: true,
                    maxOptions: 1,
                    addclass: 'form'
                },
                    filterSelectValues(TELEPHELYEK, "nev", "id")
                )
            },
        ],
    };

    $(document).on('change', '#eszkoz_mod_partner_input', function () {
        var fk_partner = $(this).val();
        if (fk_partner.length > 0) {
            TELEPHELYEK = filterArray(adhato_telephelyek_uj, 'fk_partner', fk_partner[0]);
        } else {
            TELEPHELYEK = adhato_telephelyek_uj;
        }

        refillSelect('eszkoz_mod_telephely_input', filterSelectValues(TELEPHELYEK, "nev", "id"));

    });

    var new_eszkoz = {
        inic_param: {
            id: 'eszkozok_new',
            dataRight: 'eszkozok_letrehozasa',
            title: '[[$t.uj_eszkoz]]',
            cols: 2,
            rows: 5,
            position: 'bottom'
        },
        buttons: [
            {
                name: "[[$t.mentes]]",
                id: 'btn_save_eszkoz',
                visibility: function () { return 1 },
                callback: function (valid) {

                    if (valid) {
                        ajax_call_eszkozok_new($('#btn_save_eszkoz'));
                    }
                },
                onCustomAjaxDone: function (event, result, trigger) {
                    if (result.EREDMENY == 'OK') {
                        clearForm('eszkozok_new');
                    }
                    else if (result.EREDMENY == 'HI') {
                        gi_alert(result.UZENET);
                    }
                },
                type: 'save',
                ajaxReload: true,
            },
            {
                name: "[[$t.vissza]]",
                id: 'btn_cancel_eszkoz',
                visibility: function () { return 1 },
                callback: function () {
                    clearForm('eszkozok_new');
                },
                addClasses: 'btn-alt',
                type: 'cancel',
                toggleId: 'eszkozok_new'
            }

        ],
        inputs: [
            {
                "col": 0, "row": 0, "colspan": 2, "input": inputHtml({
                    id: 'eszkoz_name_input',
                    label: '[[$t.nev]]',
                    placeholder: '[[$t.nev]]',
                    required: true,
                    name: 'eszkoz_name_input',
                    autofocus: false,
                    maxlength: 100
                })
            },
            {
                "col": 0, "row": 1, "colspan": 2, "input": filterSelectHtml({
                    id: 'eszkoz_partner_input',
                    placeholder: '[[$t.szures]]',
                    label: '[[$t.partner]]',
                    name: 'eszkoz_partner_input',
                    maxOptions: 1,
                    addclass: 'form'
                },
                    filterSelectValues(PARTNEREK, "nev", "id")
                )
            },
            {
                "col": 0, "row": 2, "colspan": 2, "input": filterSelectHtml({
                    id: 'eszkoz_telephely_input',
                    placeholder: '[[$t.valassz]]',
                    name: 'eszkoz_telephely_input',
                    label: '[[$t.telephely]]',
                    required: true,
                    maxOptions: 1,
                    addclass: 'form'
                },
                    filterSelectValues(adhato_telephelyek_uj, "nev", "id")
                )
            },
            {
                "col": 0, "row": 3, "colspan": 2, "input": selectHtml({
                    id: 'eszkoz_tipus_input',
                    placeholder: '[[$t.valassz]]',
                    name: '[[$t.eszkoz_tipus]]',
                    required: true
                },
                    [{ "key": '[[$t.online_eszkoz]]', "value": '1' }, { "key": '[[$t.offline_eszkoz]]', "value": '0' }]
                )
            },
        ],
    };

    var new_esemeny = {
        inic_param: {
            id: 'new_esemeny',
            dataRight: 'eszkoz_vezerlese',
            title: '[[$t.uj_esemeny]]',
            cols: 1,
            rows: 3,
            position: 'bottom'
        },
        buttons: [
            {
                name: "[[$t.mentes]]",
                id: 'btn_save_esemeny',
                visibility: function () { return 1 },
                callback: function (valid) {
                    if (valid) {
                        ajax_call_eszkoz_nyitvatartas_new($('#btn_save_esemeny'));
                    }
                },
                onCustomAjaxDone: function (event, result, trigger) {
                    if (result.EREDMENY == 'OK') {
                        clearForm('new_esemeny');
                    }
                    else if (result.EREDMENY == 'HI') {
                        gi_alert(result.UZENET);
                    }
                },
                type: 'save',
                ajaxReload: true,
            },
            {
                name: "[[$t.vissza]]",
                id: 'btn_cancel_esemeny',
                visibility: function () { return 1 },
                callback: function () {
                    clearForm('new_esemeny');
                },
                addClasses: 'btn-alt',
                type: 'cancel',
                toggleId: 'new_esemeny'
            }

        ],
        inputs: [
            {
                "col": 0, "row": 0, "input": filterSelectHtml({
                    id: 'esemeny_nap_input',
                    placeholder: '[[$t.valassz]]',
                    label: '[[$t.nap]]',
                    name: 'esemeny_nap_input',
                    maxOptions: 'inf',
                    addclass: 'form',
                    required: true
                },
                    [
                        { "name": '[[$t.hetfo]]', "value": 1 },
                        { "name": '[[$t.kedd]]', "value": 2 },
                        { "name": '[[$t.szerda]]', "value": 3 },
                        { "name": '[[$t.csutortok]]', "value": 4 },
                        { "name": '[[$t.pentek]]', "value": 5 },
                        { "name": '[[$t.szombat]]', "value": 6 },
                        { "name": '[[$t.vasarnap]]', "value": 7 }
                    ]
                )
            },
            {
                "col": 0, "row": 1, "input": datepickerHtml({
                    id: 'esemeny_idopont_input',
                    label: '[[$t.idopont]]',
                    timeOnly: true,
                    required: true
                })
            },
            {
                "col": 0, "row": 2, "input": filterSelectHtml({
                    id: 'esemeny_tipus_input',
                    placeholder: '[[$t.valassz]]',
                    label: '[[$t.esemeny]]',
                    name: 'esemeny_tipus_input',
                    maxOptions: 1,
                    addclass: 'form',
                    required: true
                },
                    [
                        { "name": '[[$t.kijelzo_be]]', "value": 'screen_on' },
                        { "name": '[[$t.kijelzo_ki]]', "value": 'screen_off' },
                        { "name": '[[$t.dolgozok_beallitasa]]', "value": 'set_worker' },
                    ]
                )
            },
        ],
    };

    nyitvatartas = dataTable($('#nyitvatartas'), {
        table: {
            name: '[[$t.nyitvatartas]]',
            right: 'eszkoz_vezerlese',
            hide: true,
        },
        ajax: {
            name: 'eszkoz_nyitvatartas_sel',
            data: {
                "echo": "1",
                "eszkoz_id": function () { return selectedRowId('#eszkozok'); }
            },
            onInicCall: false
        },
        functions: {
            edit: {
                ajax: "eszkoz_nyitvatartas_mod",
                right: "eszkoz_vezerlese",
                data: {
                    '#name': 'parameter_nev',
                    '#id': 'vezerles_sn',
                    '#data': 'parameter_ertek',
                    'eszkoz_sn': function () { return selectedRowId('#eszkozok'); }
                },
                text: {

                }
            },
            delete: {
                ajax: "eszkoz_nyitvatartas_del",
                right: "eszkoz_vezerlese",
                data: {
                    '#id': 'id',
                    'eszkoz_id': function () { return selectedRowId('#eszkozok'); }
                }
            }
        },
        columns: [
            { headName: "[[$t.idopont]]", colName: "oraperc" },
            {
                headName: "[[$t.het_napja]]", colName: "het_napja", cellRender: function (td, cellData, rowData, row, col) {
                    switch (rowData.het_napja) {
                        case '1':
                            $(td).html('[[$t.hetfo]]');
                            break;
                        case '2':
                            $(td).html('[[$t.kedd]]');
                            break;
                        case '3':
                            $(td).html('[[$t.szerda]]');
                            break;
                        case '4':
                            $(td).html('[[$t.csutortok]]');
                            console.log("rowdata", rowData);
                            break;
                        case '5':
                            $(td).html('[[$t.pentek]]');
                            break;
                        case '6':
                            $(td).html('[[$t.szombat]]');
                            break;
                        case '7':
                            $(td).html('[[$t.vasarnap]]');
                            break;
                    }
                }
            },
            {
                headName: "[[$t.esemeny]]", colName: "action", cellRender: function (td, cellData, rowData, row, col) {

                    if (rowData.action == 'screen') {
                        rowData.content === '0' ? $(td).html('[[$t.kijelzo_ki]]') : $(td).html('[[$t.kijelzo_be]]');
                    } else if (rowData.action == 'set_worker') {
                        $(td).html('[[$t.dolgozok_beallitasa]]');
                    }


                    /* if(rowData.action == 'screen') {
                         $(td).html('[[$t.kijelzo_be]]');
                     } else if(rowData.action == 'screen_off') {
                         $(td).html('[[$t.kijelzo_ki]]');
                     } else if(rowData.action == 'set_worker') {
                         $(td).html('[[$t.dolgozok_beallitasa]]');
                     }*/
                }
            },
        ],

        forms: [new_esemeny],

        buttons: [
            {
                name: "[[$t.generalas]]",
                id: 'generalas_button',
                dataRight: 'eszkoz_vezerlese',
                visibility: function () { return 1; },
                callback: function () {
                    postApi('automata', {}, null, {}, null, function (result) {
                        if (result[0] == 'OK') {
                            gi_alert('[[$t.sikeres_lefutas]]');
                        }
                    },
                        'webservice');
                },
                type: "new",
            },
            {
                name: "[[$t.uj_esemeny]]",
                id: 'new_esemeny_button',
                dataRight: 'eszkoz_vezerlese',
                visibility: function () { return 1; },
                callback: function () { },
                type: "new",
                toggleId: 'new_esemeny',
            }
        ]

    });


    eszkozok = dataTable($('#eszkozok'), {
        table: {
            name: '[[$t.eszkozok]]',
            right: 'eszkozok_megtekintese',
            canSelect: true,
            hasExport: true,
            exportTitle: '[[$t.ceedback_eszkoz_export]]',
        },
        ajax: {
            name: 'eszkozok_sel',
            data: {
                "echo": "1",
            },
        },
        functions: {
            edit: {
                ajax: "eszkozok_mod",
                right: "eszkozok_modositasa",
                data: {
                    '#name': 'parameter_nev',
                    '#id': 'eszkoz_sn',
                    '#data': 'parameter_ertek',
                },
                text: {

                }
            },
            activate: {
                ajax: "eszkozok_akt",
                right: "eszkozok_aktivalasa",
                data: {
                    '#id': 'eszkoz_sn',
                    'aktiv': 1
                },
                dataCol: 'aktiv'
            },
            inactivate: {
                ajax: "eszkozok_akt",
                right: "eszkozok_aktivalasa",
                data: {
                    '#id': 'eszkoz_sn',
                    'aktiv': 0
                },
                dataCol: 'aktiv'
            },
            wake: {
                icon: "fa-sun",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "screen", "255");
                },
                title: "[[$t.kijelzo_be]]"
            },
            sleep: {
                icon: "fa-moon",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "screen", "0");
                },
                title: "[[$t.kijelzo_ki]]"
            },
            install: {
                icon: "fa-upload",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "pushsurvey", "");
                },
                title: "[[$t.kerdoiv_telepites]]"
            },
            on: {
                icon: "fa-play",
                right: "admin",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "foreground", "true");
                },
                title: "[[$t.eloterbe]]"
            },
            off: {
                icon: "fa-stop",
                right: "admin",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "foreground", "false");
                },
                title: "[[$t.nem_eloterbe]]"
            },
            worker: {
                icon: "fa-user-edit",
                right: "admin",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "set_worker", "");
                },
                title: "[[$t.dolgozok_beallitasa]]"
            },
            teamviewer: {
                icon: "fa-chalkboard-teacher",
                right: "admin",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "teamviewer", "");
                },
                title: "[[$t.teamviewer]]"
            },
            info: {
                icon: "fa-info",
                right: "admin",
                callback: function (elem, data) {
                    eszkozvezerles(elem, data.id, "showinfo", "");
                },
                title: "[[$t.eszkoz_info]]"
            },
            online: {
                icon: "fa-globe",
                right: "admin",
                callback: function (elem, data) {
                    var ajax_obj = {
                        "parameter_nev": 'online',
                        "eszkoz_sn": data.id,
                        "parameter_ertek": data.online == '0' ? 1 : 0

                    };

                    var resultText = {};

                    postApi('eszkozok_mod', ajax_obj, elem, resultText, null, function (result) {
                        if (result['EREDMENY'] === 'OK') {
                            eszkozok.ajax.reload();
                        }
                        else if (result['EREDMENY'] === 'HI') {
                            gi_alert('[[$t.hiba_tortent]]');
                        }

                    });
                },
                title: "[[$t.online_vagy_fizikai]]"
            },
            /*database:{
                right:"dev_funkciok",				
                icon: "fa-database",		
                callback: function(elem,data){
                   eszkozvezerles(elem,data.id,"database","");
                },
                title:"[[$t.eszkoz_adatbazis]]"
            }*/
        },
        columns: [
            { headName: "", type: "details" },
            { headName: "[[$t.nev]]", colName: "nev", canEdit: true },
            { headName: "[[$t.eszkoz_azonosito]]", colName: "eszkoz_azonosito" },
            { headName: "[[$t.model_neve]]", colName: "modell", inDetails: true },
            { headName: "[[$t.sorozatszam]]", colName: "sorozatszam", canEdit: true, inDetails: true },
            { headName: "[[$t.felbontas]]", colName: "felbontas", canEdit: true, inDetails: true },
            { headName: "[[$t.dpi]]", colName: "dpi", canEdit: true, inDetails: true },
            { headName: "[[$t.api_verzio]]", colName: "api_verzio", canEdit: true, inDetails: true },
            { headName: "[[$t.regisztracio_idopontja]]", colName: "regisztracio_idopontja", inDetails: true, isDateFormat: true },
            { headName: "[[$t.telephely_nev]]", colName: "fk_telephelyek", renderCol: "telephely_nev", type: 'select', canEdit: true, editContent: function () { return telephely_select; }, editName: 'telephely_sn' },
            { headName: "[[$t.partner]]", colName: "partner_nev" },
            { headName: "[[$t.hozzarendelt_kerdoiv]]", colName: "kerdoiv_nev" },
            { headName: "[[$t.hozzarendelt_online_eszkoz]]", colName: "hozzakapcsolt_online_eszkoz_nev" },
            { headName: "[[$t.letrehozas_datuma]]", colName: "creation_date", inDetails: true, isDateFormat: true },
            { headName: "[[$t.letrehozo_neve]]", colName: "creator_nev", inDetails: true },
            { headName: "[[$t.aktiv]]", colName: "aktiv", type: "checkbox", filterType: "checkbox" },
            { headName: "[[$t.online]]", colName: "online", type: "checkbox", filterType: "checkbox" },
            {
                headName: "[[$t.aktivitas]]", colName: "utolso_aktivitas_idopontja", cellRender: function (td, cellData, rowData, row, col) {
                    if (rowData.online == '0') {
                        var date = formatDate(cellData);
                        if (cellData != null && (new Date().getTime() - new Date(date).getTime() < 120000)) {
                            $(td).html(date + '<i title="[[$t.aktiv]]" class="ml-2 active fas fa-circle fa-fw d-inline"></i>');
                        } else {
                            $(td).html(date + '<i title="[[$t.inaktiv]]" class="ml-2 inactive fas fa-circle fa-fw d-inline"></i>');
                        }
                    } else {
                        $(td).html('');
                    }

                }
            }
        ],
        detailTables: [
            { table: nyitvatartas },
        ],

        forms: [new_eszkoz],

        buttons: [
            {
                name: "[[$t.uj_eszkoz]]",
                id: 'new_eszkoz_button',
                dataRight: 'eszkozok_letrehozasa',
                visibility: function () { return 1; },
                callback: function () { },
                type: "new",
                toggleId: 'eszkozok_new',
            },
            {
                name: "[[$t.kerdoiv_hozzarendelese]]",
                id: 'kerdoiv_hozzarendelese_button',
                dataRight: 'eszkozok_kerdoiv_hozzarendeles',
                type: "new",
                visibility: 'onSelect',
                callback: function () {
                    $(this).prop('disabled', true);
                    $(this).addClass('remove_disable');
                    popupTable(valaszthato_kerdoivek, onSave, onCancel);
                },

                onCustomAjaxDone: function (event, result, trigger) {

                }
            },
            {
                name: "[[$t.kerdoiv_link_osszerakas]]",
                id: 'kerdoiv_link_osszerakas_button',
                dataRight: 'kerdoiv_megtekintese',
                type: "view",
                visibility: 'onOnlineSelect',
                callback: function () {
                    var kivalasztottEszkoz = eszkozok.rows({ selected: true }).data()[0];
                    if (isDefined(kivalasztottEszkoz) && kivalasztottEszkoz.online == '1') {
                        var eszkozLink = window.location.origin + '/' + act_lang + '/kerdoiv/' + kivalasztottEszkoz.eszkoz_azonosito;
                        gi_alert('[[$t.online_eszkoz_link]] </br>' + eszkozLink);
                    }
                },

            },
            {
                name: "[[$t.onilne_eszkoz_hozzarendelese]]",
                id: 'onilne_eszkoz_hozzarendelese_button',
                dataRight: 'eszkozok_eszkoz_hozzarendeles',
                type: "view",
                visibility: function () { return selectedRowData('#eszkozok') && selectedRowData('#eszkozok').online == '0' ? 1 : 0; },
                callback: function () {

                    var filteredData = eszkozok
                        .data()
                        .filter(function (value, index) {
                            return value.online == '1' && value.partner_id == selectedRowData('#eszkozok').partner_id;
                        });

                    popupForm({
                        inic_param: {
                            id: 'onilne_eszkoz_mod',
                            title: '[[$t.onilne_eszkoz_hozzarendelese]]',
                            cols: 1,
                            rows: 1,
                        },
                        buttons: [
                            {
                                name: "[[$t.mentes]]",
                                id: 'btn_mod_eszkoz',
                                visibility: function () { return 1 },
                                callback: function () {
                                    var valid = validateForm($('#onilne_eszkoz_mod'));
                                    if (valid) {
                                        ajax_call_eszkozok_eszkoz_hozzarendeles($('#onilne_eszkoz_mod'));
                                    }
                                },
                                type: 'save',
                            },
                            {
                                name: "[[$t.vissza]]",
                                id: 'btn_cancel_mod_eszkoz',
                                visibility: function () { return 1 },
                                callback: function () {
                                    close_pop_up();
                                },
                                addClasses: 'btn-alt',
                                type: 'cancel',
                            }

                        ],
                        inputs: [
                            {
                                "col": 0, "row": 0, "input": filterSelectHtml({
                                    id: 'onilne_eszkoz_mod_input',
                                    placeholder: '[[$t.eszkoz]]',
                                    label: '[[$t.eszkoz]]',
                                    name: 'onilne_eszkoz_mod_input',
                                    maxOptions: 1,
                                    addclass: 'form',
                                    required: true,
                                },
                                    filterSelectValues(filteredData.toArray(), "nev", "id")
                                )
                            },
                        ],
                    });

                    $('.selectpicker').selectpicker();

                    $('#onilne_eszkoz_mod_input').val(selectedRowData('#eszkozok').hozzakapcsolt_online_eszkoz_id);
                    $('#onilne_eszkoz_mod_input').selectpicker('refresh');
                },

            },
            {
                name: "[[$t.partner_telephely_mod]]",
                id: 'mod_partner_adat_button',
                dataRight: 'eszkozok_letrehozasa',
                visibility: function () { return selectedRowId('#eszkozok'); },
                callback: function () {

                    popupForm(eszkoz_partner_mod);


                    var eszkozData = eszkozok.rows({ selected: true }).data()[0];
                    $('.selectpicker').selectpicker();
                    $('#eszkoz_mod_partner_input').val(eszkozData['partner_id']);
                    $('#eszkoz_mod_partner_input').selectpicker('refresh');


                    $('#eszkoz_mod_partner_input').trigger('change');

                    $('#eszkoz_mod_telephely_input').val(eszkozData['fk_telephelyek']);
                    $('#eszkoz_mod_telephely_input').selectpicker('refresh');

                },
                type: "new",
            },
            {
                name: "[[$t.minta_xls]]",
                id: 'download_xls',
                dataRight: 'eszkoz_import',
                visibility: function () { return 1; },
                callback: function () {
                    window.open('/' + act_lang + '/eszkozok/download-excel', "_blank");
                },
            },
            {
                name: "[[$t.beolvasas_xls_bol]]",
                id: 'upload_xls',
                dataRight: 'eszkoz_import',
                visibility: function () { return 1; },
                callback: function () {
                    popupUplodoad({
                        id: 'file',
                        ajax: 'ajax/eszkozok_import',
                        onUploadSuccess: function (id, data) {
                            data = JSON.parse(data);
                            if (data[0] == "OK") {
                                var text = '';
                                for (var i in data[1]) {
                                    if (data[1][i] == '0') {
                                        text += (i * 1 + 2) + ', ';
                                    }
                                }
                                if (text == '') {
                                    gi_alert("[[$t.sikeres_feltoltes]]", function () {
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                } else {
                                    text = text.substr(0, text.length - 2);
                                    gi_alert("[[$t.hibas_sorok]]" + '<br/>' + text, function () {
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                }
                                eszkozok.ajax.reload();

                            } else if (data[1] == "nincs_fajl") {
                                gi_alert("[[$t.nincs_fajl]]");
                            } else if (data[1] == "hibas_feltoltes") {
                                gi_alert("[[$t.hibas_feltoltes]]");
                            } else {
                                gi_alert("[[$t.hibas_feltoltes]]");
                            }
                        }
                    });
                },
            }

            /*{
                name: "[[$t.kerdoiv_link_megtekint]]",
                id: 'kerdoiv_link_megtekint_button',
                dataRight: 'kerdoiv_megtekintese',
                type: "view",
                visibility: 'onOnlineSelect',
                callback: function() {
                    var kivalasztottEszkoz = eszkozok.rows({selected: true}).data()[0];
                    if(isDefined(kivalasztottEszkoz) &&  kivalasztottEszkoz.online == '1') {
                        var eszkozLink = window.location.origin + '/' + act_lang + '/kerdoiv/' + kivalasztottEszkoz.eszkoz_azonosito;
                        window.location.href = eszkozLink;
                    }
                },

            }*/
        ],

    });

    eszkozok.on('blur', 'tbody tr[role=row] td.edit-input.editing select:not(:disabled)', function () {
        eszkozok.ajax.reload();
    });
    /*buta de gyors megoldas*/
    $('#eszkozok .tr-filter th:eq(6) .selectpicker').selectpicker('val', '1').selectpicker('render');

    $('#eszkoz_partner_input').on('change', function () {
        var szurtAdatok = [];
        if ($(this).val().length == 0) {
            szurtAdatok = adhato_telephelyek_uj;
        } else {
            var partnerId = $('#eszkoz_partner_input').val()[0];
            if (isDefined(partnerId)) {
                var partner = findInArray(PARTNEREK, 'id', partnerId);
                szurtAdatok = partner.telephelyek;
            }



        }
        var ujSelectErtetek = [];
        /*if(szurtAdatok.length > 0) {*/
        ujSelectErtetek = filterSelectValues(szurtAdatok, 'nev', 'id');
        /*}*/

        refillSelect('eszkoz_telephely_input', ujSelectErtetek);
    });

    /*Firefoxban enélkül nem jelennek meg a selectek*/
    $('#esemeny_nap_input').selectpicker();
    $('#esemeny_tipus_input').selectpicker();


    initDatepicker({ id: 'esemeny_idopont_input', timeOnly: true });


});

function ajax_call_eszkozok_new(element) {

    var data = {
        "nev": $('#eszkoz_name_input').val(),
        "telephely_sn": $('#eszkoz_telephely_input').val()[0],
        "online": isDefined($('#eszkoz_tipus_input').data('key')) ? $('#eszkoz_tipus_input').data('key') : '0'

    };

    var resultText = {};

    postApi('eszkozok_new', data, element, resultText);
}

function ajax_call_eszkozok_mod(element) {
    var data = {
        "parameter_nev": 'telephely_sn',
        "eszkoz_sn": selectedRowId('#eszkozok'),
        "parameter_ertek": $('#eszkoz_mod_telephely_input').val()[0]

    };

    var resultText = {};

    postApi('eszkozok_mod', data, element, resultText, null, function (result) {
        if (result[0] === 'OK') {
            eszkozok.ajax.reload();
        }
        else if (d[0] === 'HI') {
            gi_alert('[[$t.hiba_tortent]]');
        }

    });
}

function ajax_call_eszkozok_eszkoz_hozzarendeles(element) {
    var data = {
        "eszkoz_sn": selectedRowId('#eszkozok'),
        "hozzarendelendo_eszkoz_sn": $('#onilne_eszkoz_mod_input').val()[0]
    };

    var resultText = {};

    postApi('eszkozok_eszkoz_hozzarendeles', data, element, resultText, null, function (result) {
        if (result.EREDMENY == 'OK') {
            close_pop_up();
            eszkozok.ajax.reload();
        } else if (result.EREDMENY === 'HI') {
            gi_alert('[[$t.hiba_tortent]]');
        }

    });
}

function ajax_call_eszkoz_nyitvatartas_new(element) {
    var date = getDate($("#esemeny_idopont_input").datetimepicker('viewDate')._d);
    var content = '';
    var action = '';
    if ($('#esemeny_tipus_input').val()[0] == 'set_worker') {
        action = 'set_worker';
        content = '1';
    } else {
        action = 'screen';
        content = $('#esemeny_tipus_input').val()[0] == 'screen_off' ? '0' : '100';
    }
    var napok = '';
    for (var i in $('#esemeny_nap_input').val()) {
        napok += '' + $('#esemeny_nap_input').val()[i];
    }
    var data = {
        "eszkoz_id": selectedRowId('#eszkozok'),
        "het_napjai": napok,
        "oraperc": (date.hour < 10 ? '0' : '') + date.hour + ':' + (date.minute < 10 ? '0' : '') + date.minute,
        "action": action,
        "content": content

    };

    var resultText = {};

    postApi('eszkoz_nyitvatartas_new', data, element, resultText);
}

function onSave() {

    if (selectedRowId('#popup_table')) {
        var data = {
            eszkoz_sn: selectedRowId('#eszkozok'),
            kerdoiv_sn: selectedRowId('#popup_table'),
        };

        var text = {
            nem_azonos_partner: "[[$t.nem_azonos_partner]]",
        };

        postApi('eszkozok_kerdoiv_hozzarendeles', data, $('#pop_btn_ok'), text, null, function (result) {
            if (selectedRowData('#eszkozok').regisztracio_idopontja != null) {
                eszkozvezerles(null, selectedRowId('#eszkozok'), "pushsurvey", "");
            }
            if (result.EREDMENY == 'OK') {
                eszkozok.ajax.reload();
                close_pop_up();
            }
        });
    }
}

function onCancel() {
    $('#kerdoiv_hozzarendelese_button').prop('disabled', false);
    close_pop_up();
}

function hozzarendelheto_kerdoiv_sel(callback, element) {

    var kerdoivek = [];
    var fk_telephely = eszkozok.rows({ selected: true }).data()[0].fk_telephelyek;
    var telephely = findInArray(adhato_telephelyek_hozza, 'id', fk_telephely);
    var fk_partner = isDefined(telephely) ? telephely.fk_partner : -1;

    for (var i in hozzarendelheto_kerdoivek) {
        if (hozzarendelheto_kerdoivek[i].fk_partner == fk_partner) {

            kerdoivek.push(hozzarendelheto_kerdoivek[i]);
        }
    }

    callback({ data: kerdoivek });
}
function eszkozvezerles(element, eszkoz_id, action, content) {
    var data = {
        eszkoz_id: eszkoz_id,
        action: action,
        content: content
    };
    postApi('eszkoz_vezerlese', data, element, {});
}