const PARTNEREK = objectToArray(szurheto_adatok.partnerek);
const REGIOK = objectToArray(szurheto_adatok.regiok);
const TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
const KERDESEK = objectToArray(szurheto_adatok.kerdesek);
const KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
const ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var OSSZESITES = [];
var NPS_KERDESEK = [];

var ERTEKES_KERDESEK = [];

var ERTEKEK = [];
var REGIO_ERTEKEK = [];
var TELEPHELY_ERTEKEK = [];

var HONAPOK = [];
var GRAF_REGIOK = [];

var PARTNER = null;

var GRAFIKON_ADATOK = [];

var FELHASZNALO_TELEPHELYEK_IDS = [];
for (var i in TELEPHELYEK) {
    if (isDefined(TELEPHELYEK[i])) {
        FELHASZNALO_TELEPHELYEK_IDS.push(TELEPHELYEK[i].id);
    }
}

window.modositva = true;

var KITOLTESEK = null;

var defaultPartnerId = -1;
var osszegzes = null;


$(document).ready(function () {

    var select = filterSelectHtml({
        id: 'partner_select_input',
        placeholder: '[[$t.partner]]',
        name: 'partner_select_input',
        maxOptions: 1,
        addclass: 'form'
    },
        filterSelectValues(PARTNEREK, 'nev', 'id')
    );

    $('#partner_valaszto_input').html(select);
    $('#partner_select_input').selectpicker();

    if (PARTNEREK.length > 0) {
        for (var i in PARTNEREK) {
            if (isDefined(PARTNEREK[i])) {
                defaultPartnerId = PARTNEREK[i].id;
                break;
            }
        }
        $('#partner_select_input').selectpicker('val', defaultPartnerId);

    }

    if (PARTNEREK.length > 0) {
        inic();
    }


    $('.selectpicker').on('change', function () {
        if (!isDefined($('#partner_select_input').val()[0]) || $('#partner_select_input').val()[0] == '') {
            $('#partner_select_input').selectpicker('val', defaultPartnerId);
        } else {
            inic();
        }

    });

    $(document).on('click', '#tabla-blokk-osszesites .cf-checkbox', function () {
        if (!$(this).find('input').is(':checked') && $('#tabla-blokk-osszesites .cf-checkbox input:checked').length == 0) {
            $(this).find('input').prop('checked', true);
            gi_alert('[[$t.legalabb_egy_oszlop_kell]]');
        } else {
            call_ajax_jelentesek_sel_kikuldes_statisztika();
        }

    });

});

function filterNPSKerdesek() {
    var partnerId = $('#partner_select_input').val()[0];
    var partnerKerdoivei = KERDOIVEK.filter(function (kerdoiv) {
        return kerdoiv.fk_partner == partnerId;
    });
    console.log(partnerKerdoivei);

    var npsKerdesek = new Set();
    for (var i in partnerKerdoivei) {
        var kerdoiv = partnerKerdoivei[i];
        if (kerdoiv['json']['nyelvek'] != undefined) {
            var nyelv = Object.keys(kerdoiv['json']['nyelvek'])[0];
            for (var j in kerdoiv['json']['nyelvek'][nyelv]['rendszerszintu_kerdesek']) {
                var kerdes = kerdoiv['json']['nyelvek'][nyelv]['rendszerszintu_kerdesek'][j];
                var isNPS = kerdes.kerdes_extrak.filter(function (extra) {
                    return extra.adat_kod == 'nps' && extra.adat_content == '1';
                });

                if (isDefined(isNPS) && isNPS.length > 0) {
                    npsKerdesek.add(kerdes["azonosito"]);
                }
            }

            for (var j in kerdoiv['json']['nyelvek'][nyelv]['kerdesek']) {
                var kerdes = kerdoiv['json']['nyelvek'][nyelv]['kerdesek'][j];
                var isNPS = kerdes.kerdes_extrak.filter(function (extra) {
                    return extra.adat_kod == 'nps' && extra.adat_content == '1';
                });

                if (isDefined(isNPS) && isNPS.length > 0) {
                    npsKerdesek.add(kerdes["azonosito"]);
                }
            }
        }
    }

    return npsKerdesek;
}

function inic() {
    disableInput($('#partner_select_input'), true);
    var partnerId = $('#partner_select_input').val()[0];
    var partner = findInArray(PARTNEREK, 'id', partnerId);
    PARTNER = partner;

    FELHASZNALO_TELEPHELYEK_IDS = [];
    for (var i in TELEPHELYEK) {
        if (isDefined(TELEPHELYEK[i]) && TELEPHELYEK[i].fk_partner == partnerId) {
            FELHASZNALO_TELEPHELYEK_IDS.push(TELEPHELYEK[i].id);
        }
    }

    ERTEKES_KERDESEK = [];
    ERTEKEK = [];
    REGIO_ERTEKEK = [];
    TELEPHELY_ERTEKEK = [];
    HONAPOK = [];
    GRAF_REGIOK = [];

    $('#nps_holder').html('');
    $('#visszajelzesek_blokk').html('');
    $('#kitoltes_holder').html('');

    grafikonok_keret(partner);

}

/* Függvényhívások sorrendje:
1. inic()
2. partnerNPSAdatFeldolgozas() -> NPS trend grafikon
3. telephelyNPSAdatFeldolgozas() -> NPS telephely oszlop grafikon
4. partnerErtekek() -> partner értékek grafikon
5. regioErtekek() -> régió teljesítmányek grafikon
6. telephelyErtekek() -> régióhoz tartozó telephely értékek
7. kitoltesekPartnerFeldolgozas() -> partner kitöltések trend grafikon
8. kitoltesekTelephelyFeldolgozas() -> telephely kitöltések grafikon
9. osszesitoTablazat() -> összesítő grafikon kiküldésekre (csak tomeges_kikuldes joggal)

*/

/*A fix grafikonok keretét előállítja, majd elkezdi a grafikonok generálását*/
function grafikonok_keret(partner) {

    $('#nps_holder').append(`
        <div class="holder-row" style="height: 60px">
            <div class="holder-50-header"></div>
            <div class="holder-50-header"></div>
        </div>`);
    $('#nps_holder').append(`
        <div class="holder-row" style="margin-bottom: 50px;display:flex;justify-content: center;flex-wrap:wrap">
            <div ><h3 id="nps_cim">[[$t.nps_dashboard_cim]]</h3><div id="nps_trend_holder" class="holder-50"></div></div>
            <div><h3 id="nps_partner_cim" class="mt-4">[[$t.nps_partner_dashboard_cim]]</h3><div id="nps_column_holder" class="holder-50"></div></div>
        </div>`);
    $('#nps_holder').append('<h3 id="eredmenyek_cim" class="text-center" style="margin-bottom: 20px">[[$t.partner_eredmenyek_cim]]</h3>');
    $('#nps_holder').append('<div id="partner_eredmenyek_holder" class="holder-100" style="margin-bottom: 50px"></div>');

    if (TELEPHELYEK.length == 0 && !isAdmin()) {
        $('#nps_partner_cim').html('');
    }

    /*Grafikonok*/
    var width50 = $('#nps_trend_holder').width();
    var width100 = $('#partner_eredmenyek_holder').width();
    var height = $('#nps_trend_holder').height();
    /*height = Math.ceil(height*0.75);*/

    $('#nps_trend_holder').html('<div style="padding-top: 30px;margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="nps_trend_chart" height="' + height + '" width="' + (width50 - 100) + '"></canvas></div>');
    $('#nps_column_holder').html('<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="nps_column_chart" height="' + height + '" width="' + width50 + '"></canvas></div>');


    $('#partner_eredmenyek_holder').html('<div style="margin:auto;height:' + height + 'px; width:' + width100 + 'px"><canvas id="nps_partner_column_chart" height="' + height + '" width="' + width100 + '"></canvas></div>');

    var nps_cim = $('#nps_cim').html().replace('#partner#', partner.nev);
    $('#nps_cim').html(nps_cim);

    var partner_eredmeny_cim = $('#eredmenyek_cim').html().replace('#partner#', partner.nev);
    $('#eredmenyek_cim').html(partner_eredmeny_cim);

    var nps_partner_cim = $('#nps_partner_cim').html().replace('#partner#', partner.nev);
    $('#nps_partner_cim').html(nps_partner_cim);



    grafikonok('partner');
}

/*Grafikonok generálása*/
function grafikonok(tipus) {

    var telephelyIdk = $.map(TELEPHELYEK, function (index, elem) {
        return elem.id;
    });

    var npsSet = filterNPSKerdesek();
    var npsKerdesek = Array.from(npsSet);
    console.log(npsKerdesek);
    var NPSKerdesId = npsKerdesek[0];


    if (tipus == 'telephelyek') {
        /*Nyers adatok lekérése - TELEPHELY bontás*/

        var data = {
            "echo": "1",
            "idopont_tol": computeDates('ez_a_honap').kezdet,
            "idopont_ig": computeDates('ez_a_honap').veg,
            "kerdoiv_idk": JSON.stringify([]),
            "eszkoz_idk": JSON.stringify([]),
            "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_idk": JSON.stringify(npsKerdesek),
            "helyszin_tipus": 'telephely',
        };

        var kitoltesek = null;

        /*Vannak a felhasználóhoz rendelt telephelyek*/
        if (TELEPHELYEK.length > 0 || isAdmin()) {
            var resultText = {};
            postApi('jelentesek_sel_helyszin_szerint', data, null, resultText, null, function (result) {
                if (isDefined(result.echo)) {
                    telephelyNPSAdatFeldolgozas(result.data);
                    teljesitmenyGrafikonok();
                }
            });
        } else {
            teljesitmenyGrafikonok();
        }
    } else if (tipus == 'partner') {
        /*var data = {
            "echo": "1",
            "idopont_tol": computeDates('ez_a_honap').kezdet,
            "idopont_ig": computeDates('ez_a_honap').veg,
            "kerdoiv_idk": JSON.stringify([]),
            "eszkoz_idk": JSON.stringify([]),
            "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_id": NPSKerdesId,
            "helyszin_tipus": 'telephely',
        };*/

        var data = {
            "echo": "1",
            "idopont_tol": computeDates('elozo_nyolc_honap').kezdet,
            "idopont_ig": computeDates('elozo_nyolc_honap').veg,
            "idopont_elott": computeDates('elozo_nyolc_honap').most,
            "kerdoiv_idk": JSON.stringify([]),
            "eszkoz_idk": JSON.stringify([]),
            "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS),
            "partner_idk": JSON.stringify($('#partner_select_input').val()),
            "kerdes_idk": JSON.stringify(npsKerdesek),
            "trend_tipus": 'honap'
        };

        var kitoltesek = null;

        var resultText = {};
        postApi('jelentesek_sel_trend_szerint', data, null, resultText, null, function (result) {
            if (isDefined(result.echo)) {
                partnerNPSAdatFeldolgozas(result.data);
                grafikonok('telephelyek');
            }
        });
    }
}

/*Telephelyek NPS adatai az előző 8 hónapban*/
function telephelyNPSAdatFeldolgozas(kitoltesek) {
    /*Adatok feldolgozása*/
    var telephelySzerintiAdatok = {};

    var partnerId = $('#partner_select_input').val()[0];
    var partnerTelephelyei = filterArray(TELEPHELYEK, 'fk_partner', partnerId);


    if (!$.isArray(partnerTelephelyei)) {
        partnerTelephelyei = [partnerTelephelyei];
    }

    for (var i in partnerTelephelyei) {
        var telephely = partnerTelephelyei[i];
        telephelySzerintiAdatok[telephely.id] = {
            osszes: 0,
            promoter: 0,
            detractor: 0
        }
    }
    console.log("telephelyei", partnerTelephelyei.length);

    if (partnerTelephelyei.length > 0) {
        console.log("hello");
        console.log("kitoltes", kitoltesek);
        /*Ilyenkor vagy nincs telephely, vagy nincs joga a telephelyekhez*/
        for (var i in kitoltesek) {
            var kitoltes = kitoltesek[i];
            console.log("kitoltes", kitoltes);
            var telephelyId = kitoltes.fk_telephelyek;
            /*var korrigaltSorrend = kitoltes.valasz_sorszam - 1;

            if(korrigaltSorrend < 7) {
                telephelySzerintiAdatok[telephelyId]['detractor'] += parseInt(kitoltes.elofordulas);
            } else if(korrigaltSorrend > 8) {
                telephelySzerintiAdatok[telephelyId]['promoter'] += parseInt(kitoltes.elofordulas);
            }*/

            var kerdes = findInArray(KERDESEK, 'id', kitoltes.kerdes_azonosito);
            console.log("kerdes ", kerdes);
            if (kerdes && kerdes.valasz_tipus_kod.slice(0, 8) == "ikonok-4") {
                var korrigaltSorszam = parseInt(kitoltes.valasz_sorszam);
                if (korrigaltSorszam < 2) {
                    telephelySzerintiAdatok[telephelyId]['detractor'] += parseInt(kitoltes.elofordulas);
                } else if (korrigaltSorszam >= 3) {
                    telephelySzerintiAdatok[telephelyId]['promoter'] += parseInt(kitoltes.elofordulas);
                }
            } else {
                var korrigaltSorszam = parseInt(kitoltes.valasz_sorszam) - 1;
                if (korrigaltSorszam < 7) {
                    telephelySzerintiAdatok[telephelyId]['detractor'] += parseInt(kitoltes.elofordulas);
                } else if (korrigaltSorszam > 8) {
                    telephelySzerintiAdatok[telephelyId]['promoter'] += parseInt(kitoltes.elofordulas);
                }
            }

            telephelySzerintiAdatok[telephelyId]['osszes'] += parseInt(kitoltes.elofordulas);
        }

        console.log("telephelyszerinti adatok", telephelySzerintiAdatok);
        grafikonAdatok = {
            "szoveg": '',
            "tipus": 'szamok-0-10',
            "nps": true,
            "lehetseges_valaszok": ['0', '1', '-1'],
            "lebontasok": [],
            "data": []
        };

        /*NPS értékek kiszámolása*/

        grafikonAdatok["data"] = [
            { label: '-1', data: [] },
            { label: '1', data: [] },
            { label: '0', data: [] }
        ];


        $.each(telephelySzerintiAdatok, function (index, adat) {
            var telephely = findInArray(TELEPHELYEK, 'id', index);
            grafikonAdatok["lebontasok"].push(telephely.nev);
            if (!adat.osszes == 0) {
                var negativ = false;

                var promoterScore = parseInt(adat.promoter) / parseInt(adat.osszes);
                var detractorScore = parseInt(adat.detractor) / parseInt(adat.osszes);
                var NPS = ((promoterScore - detractorScore) * 100);
                var inverzNPS = 0;
                var inverzErtek = 100 - NPS;

                /*Csalás*/
                if (NPS < 0) {
                    negativ = true;
                    inverzNPS = Math.abs(NPS);
                    NPS = 0,
                        inverzErtek = 100 - inverzNPS;
                }

                inverzErtek = inverzErtek.toFixed(1);
                NPS = Math.round(NPS).toFixed(1);
                inverzNPS = Math.round(inverzNPS).toFixed(1);

                grafikonAdatok["data"][0].data.push(inverzNPS);
                grafikonAdatok["data"][1].data.push(NPS);
                grafikonAdatok["data"][2].data.push(inverzErtek);
            } else {
                grafikonAdatok["data"][0].data.push(0);
                grafikonAdatok["data"][1].data.push(0);
                grafikonAdatok["data"][2].data.push(100);
            }
        });

        var lebontasokSzama = grafikonAdatok.lebontasok.length;

        console.log("grafikonadatok", grafikonAdatok);
        var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
        drawDasboardColumnChart("nps_column_chart", grafikonAdatok.lebontasok, grafikonAdatok.data, szinek, true, true);
    }
}

/*Partner NPS adatai az előző 8 hónapban*/
function partnerNPSAdatFeldolgozas(kitoltesek) {
    var partnerSzerintiAdatok = {};

    for (var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var honap = kitoltes.ev + '/' + kitoltes.honap;

        if (!isDefined(partnerSzerintiAdatok[honap])) {
            partnerSzerintiAdatok[honap] = {
                honap: honap,
                osszes: 0,
                promoter: 0,
                detractor: 0
            };
        }

        var kerdes = findInArray(KERDESEK, 'id', kitoltes.kerdes_azonosito);

        if (kerdes && kerdes.valasz_tipus_kod.slice(0, 8) == "ikonok-4") {
            var korrigaltSorszam = parseInt(kitoltes.valasz_sorszam);

            if (korrigaltSorszam < 2) {
                partnerSzerintiAdatok[honap]['detractor'] += parseInt(kitoltes.elofordulas);
            } else if (korrigaltSorszam >= 3) {
                partnerSzerintiAdatok[honap]['promoter'] += parseInt(kitoltes.elofordulas);
            }
        } else {
            var korrigaltSorszam = parseInt(kitoltes.valasz_sorszam) - 1;
            if (korrigaltSorszam < 7) {
                partnerSzerintiAdatok[honap]['detractor'] += parseInt(kitoltes.elofordulas);
            } else if (korrigaltSorszam > 8) {
                partnerSzerintiAdatok[honap]['promoter'] += parseInt(kitoltes.elofordulas);
            }
        }



        partnerSzerintiAdatok[honap]['osszes'] += parseInt(kitoltes.elofordulas);
    }


    grafikonAdatok = {
        "szoveg": '',
        "tipus": 'szamok-0-10',
        "nps": true,
        "lehetseges_valaszok": ['1'],
        "lebontasok": [],
        "data": [{ label: '1', data: [] }]
    };



    $.each(partnerSzerintiAdatok, function (index, adat) {
        grafikonAdatok["lebontasok"].push(toGlobalDateFormat(adat.honap));
        /*Itt töltjük az éveket is, amire később szükség van*/
        HONAPOK.push(toGlobalDateFormat(adat.honap));

        if (!adat.osszes == 0) {
            var negativ = false;
            var promoterScore = parseInt(adat.promoter) / parseInt(adat.osszes);
            var detractorScore = parseInt(adat.detractor) / parseInt(adat.osszes);
            var NPS = (promoterScore - detractorScore) * 100;
            NPS = Math.round(NPS).toFixed(1);

            grafikonAdatok["data"][0].data.push(NPS);
        } else {
            grafikonAdatok["data"][0].data.push(0);
        }
    });



    var lebontasokSzama = grafikonAdatok.lebontasok.length;
    szinek = [{ color: '#fff', background_color: 'rgba(142,188,2,0.3)' }];
    drawLineChart('nps_trend_chart', grafikonAdatok.lebontasok, grafikonAdatok.data, szinek, false, false, 'dashboard_trend', true, false, false);
}


/*Partner teljesítménye grafikon adat lekérdezés*/
function teljesitmenyGrafikonok() {
    var partnerId = $('#partner_select_input').val()[0];

    var data = {
        "idopont_tol": computeDates('elozo_nyolc_honap').kezdet,
        "idopont_ig": computeDates('elozo_nyolc_honap').veg,
        "partner_id": parseInt($('#partner_select_input').val()[0]),
        "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS)
    };

    var resultText = {};

    postApi('jelentesek_ertekes_sel', data, null, resultText, null, function (result) {

        ertekesKerdesekAdatFeldolgozas(result);
        partnerErtekek(result);
    });
}

/*Partner teljesítménye grafikon*/
function ertekesKerdesekAdatFeldolgozas(kitoltesek) {
    var partnerSzerintiAdatokNyers = {};
    for (var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var kerdesId = kitoltes.kerdes_id;
        var kerdes = findInArray(KERDESEK, 'id', kitoltes.kerdes_id);

        var honap = kitoltes.ev + '.' + (parseInt(kitoltes.honap) < 10 ? '0' + kitoltes.honap : kitoltes.honap);
        if (act_lang_formatum != 'YYYY.mm.dd') {
            honap = (parseInt(kitoltes.honap) < 10 ? '0' + kitoltes.honap : kitoltes.honap) + '.' + kitoltes.ev;
        }

        var valaszokSzama = 0;
        var max = 0;
        if (kitoltes.valasz_tipus_kod == 'igen_nem') {
            valaszokSzama = 2;
        } else if (kitoltes.valasz_tipus_kod.slice(0, 8) == 'ikonok-5') {
            max = 5;
            valaszokSzama = 5;
        } else if (kitoltes.valasz_tipus_kod.slice(0, 8) == 'ikonok-4') {
            max = 4;
            valaszokSzama = 4;
        } else if (kitoltes.valasz_tipus_kod == 'szamok-1-10') {
            max = 10;
            valaszokSzama = 10;
        } else if (kitoltes.valasz_tipus_kod == 'szamok-1-6') {
            max = 6;
            valaszokSzama = 6;
        }
        else if (kitoltes.valasz_tipus_kod == 'szamok-1-5') {
            max = 5;
            valaszokSzama = 5;
        }

        if (!isDefined(partnerSzerintiAdatokNyers[kerdesId])) {
            partnerSzerintiAdatokNyers[kerdesId] = {
                max: max,
                tipus: kitoltes.valasz_tipus_kod,
                kerdes_id: kerdesId,
                valaszok: tombInic(valaszokSzama, 0),
                ertekek: [],
                regio_ertekek: []
            };

        }

        /*partnerSzerintiAdatokNyers[kerdesId].valaszok[kitoltes.valasz_sorszam-1]++;*/

        /*Partner összegés*/
        if (!isDefined(partnerSzerintiAdatokNyers[kerdesId].ertekek[honap])) {
            partnerSzerintiAdatokNyers[kerdesId].ertekek[honap] = {
                osszes: 0,
                kedvezo: 0,
                szamlalo: 0,
                nevezo: 0
            }
        }

        /*Régió összegés*/
        if (!isDefined(partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok])) {
            partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok] = [];
        }
        if (!isDefined(partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap])) {
            partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap] = [];
        }
        if (!isDefined(partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][[kitoltes.fk_telephelyek]])) {
            partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][kitoltes.fk_telephelyek] = {
                telephely: kitoltes.fk_telephelyek,
                osszes: 0,
                kedvezo: 0,
                szamlalo: 0,
                nevezo: 0
            };
        }

        if (kitoltes.valasz_tipus_kod == 'igen_nem' && kitoltes.valasz_sorszam == '2') {
            partnerSzerintiAdatokNyers[kerdesId].ertekek[honap]['kedvezo']++;
            partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][kitoltes.fk_telephelyek]['kedvezo']++;
        }
        partnerSzerintiAdatokNyers[kerdesId].ertekek[honap]['szamlalo'] += parseInt(kitoltes.valasz_sorszam);
        partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][kitoltes.fk_telephelyek]['szamlalo'] += parseInt(kitoltes.valasz_sorszam);
        partnerSzerintiAdatokNyers[kerdesId].ertekek[honap]['nevezo']++;
        partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][kitoltes.fk_telephelyek]['nevezo']++;
        partnerSzerintiAdatokNyers[kerdesId].ertekek[honap]['osszes']++;
        partnerSzerintiAdatokNyers[kerdesId].regio_ertekek[kitoltes.fk_regiok][honap][kitoltes.fk_telephelyek]['osszes']++;
    }



    partnerSzerintiAdatok = {};
    $.each(partnerSzerintiAdatokNyers, function (ind, adat) {

        var kerdesTipus = adat.tipus;
        var adatErtekek = adat.ertekek;
        var max = adat.max;
        /*Partner összegés*/
        for (var i in adatErtekek) {

            var adatErtek = adatErtekek[i];
            var honap = i;
            var ertek = null;
            var atlag = adatErtek.szamlalo / adatErtek.nevezo;

            if (kerdesTipus == 'igen_nem') {
                ertek = adatErtek.kedvezo / adatErtek.osszes;
            } else {
                ertek = (atlag / max) * 100;
            }


            if (!isDefined(ERTEKEK[honap])) {
                ERTEKEK[honap] = { honap: honap, ertek: [ertek] };
            } else {
                ERTEKEK[honap].ertek.push(ertek);
            }
        }

        /*Régió összegés*/
        var adatRegioErtekek = adat.regio_ertekek;
        for (var regio in adatRegioErtekek) {
            var osszesitettErtek = 0;
            var darab = 0;
            for (var honap in adatRegioErtekek[regio]) {
                for (var telephely in adatRegioErtekek[regio][honap]) {

                    var adatErtek = adatRegioErtekek[regio][honap][telephely];

                    var ertek = null;
                    var atlag = adatErtek.szamlalo / adatErtek.nevezo;

                    if (kerdesTipus == 'igen_nem') {
                        ertek = (adatErtek.kedvezo / adatErtek.osszes) * 100;
                    } else {
                        ertek = (atlag / max) * 100;
                    }
                    osszesitettErtek += ertek;
                    darab++;

                    /*Telephelyre összegzés*/
                    if (!isDefined(TELEPHELY_ERTEKEK[telephely])) {
                        TELEPHELY_ERTEKEK[telephely] = [];
                    }

                    if (!isDefined(TELEPHELY_ERTEKEK[telephely][honap])) {
                        TELEPHELY_ERTEKEK[telephely][honap] = { honap: honap, regio_id: regio, ertek: [ertek] };
                    } else {
                        TELEPHELY_ERTEKEK[telephely][honap].ertek.push(ertek);
                    }
                }

                var honapErtek = osszesitettErtek / darab;

                /*Régióra összegzés*/
                if (!isDefined(REGIO_ERTEKEK[regio])) {
                    REGIO_ERTEKEK[regio] = [];
                }

                if (!isDefined(REGIO_ERTEKEK[regio][honap])) {
                    REGIO_ERTEKEK[regio][honap] = { honap: honap, ertek: [honapErtek] };
                } else {
                    REGIO_ERTEKEK[regio][honap].ertek.push(honapErtek);
                }
            }
        }
    });
}

/*function ertekOsszegzes() {

    var grafikonAdatok = {
        "szoveg":'',
        "tipus": 'szamok-0-10',
        "nps": true,
        "lehetseges_valaszok": ['-1','0','1'],
        "lebontasok": [],
        "data": []
    };

    grafikonAdatok["data"] = [
        {label: '-1', data: []},
        {label: '1', data: []},
        {label: '0', data: []}
    ];

    for(var i in ERTEKEK) {
        var belsoErtek = ERTEKEK[i].ertek;
        grafikonAdatok["lebontasok"].push(i);
        var nevezo = belsoErtek.length;
        var szamlalo = 0;
        for(var j in belsoErtek){
            szamlalo += belsoErtek[j];
        }
        var atlag = szamlalo / nevezo;
        var inverz = 100 - atlag;

        if(atlag == Infinity) { atlag = 0; }
        if(atlag == Infinity) { inverz = 100; }

        
        grafikonAdatok["data"][2].data.push(inverz);
        grafikonAdatok["data"][1].data.push(atlag);
        grafikonAdatok["data"][0].data.push(0);
    }

    var lebontasokSzama = grafikonAdatok.lebontasok.length;

    var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
    drawDasboardColumnChart("nps_partner_column_chart", grafikonAdatok.lebontasok, grafikonAdatok.data, szinek);


}*/

function regioErtekOsszegzes() {

    for (var regioId in REGIO_ERTEKEK) {

        /*A sparse array miatt itt ugrani kell*/
        if (regioId != 'null') {

            /*Régiók lementése, telephelyes lebontásnál szükség van rá*/
            GRAF_REGIOK.push(regioId);

            var regioNev = findInArray(REGIOK, 'id', regioId).nev;

            var grafikonAdatok = {
                "szoveg": '',
                "tipus": 'szamok-0-10',
                "nps": true,
                "lehetseges_valaszok": ['-1', '0', '1'],
                "lebontasok": [],
                "data": [],
            };

            grafikonAdatok["data"] = [
                { label: '-1', data: [] },
                { label: '1', data: [] },
                { label: '0', data: [] }
            ];


            for (var i in HONAPOK) {
                var honap = HONAPOK[i];
                grafikonAdatok["lebontasok"].push(honap);
                var regio_ertek = REGIO_ERTEKEK[regioId][honap];
                if (isDefined(regio_ertek)) {
                    var belsoErtek = regio_ertek.ertek;
                    var nevezo = belsoErtek.length;
                    var szamlalo = 0;
                    for (var j in belsoErtek) {
                        szamlalo += belsoErtek[j];
                    }
                    var atlag = szamlalo / nevezo;
                    var inverz = 100 - atlag;

                    if (atlag == Infinity) { atlag = 0; }
                    if (atlag == Infinity) { inverz = 100; }

                    grafikonAdatok["data"][2].data.push(inverz);
                    grafikonAdatok["data"][1].data.push(atlag);
                    grafikonAdatok["data"][0].data.push(0);
                } else {
                    grafikonAdatok["data"][2].data.push(100);
                    grafikonAdatok["data"][1].data.push(0);
                    grafikonAdatok["data"][0].data.push(0);
                }
            }




            var lebontasokSzama = grafikonAdatok.lebontasok.length;

            var width50 = $('#nps_trend_holder').width();
            var width100 = $('#partner_eredmenyek_holder').width();
            var height = $('#nps_trend_holder').height();
            /*height = Math.ceil(height*0.75);*/


            var cim_template = '<h3 id="regio_teljesitmeny_cim_' + regioId + '" class="text-center">[[$t.regio_visszajelzes_cim]]</h3>';
            var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="regio_teljesitmeny_' + regioId + '" height="' + height + '" width="' + width50 + '"></canvas></div>';
            var trend = '<div id="teljesitmeny_trend_holder_' + regioId + '" class="holder-50">' + canvas + '</div>';
            var html = cim_template + '<div class="holder-row" style="margin-bottom: 50px">' + trend + '</div>';
            $('#visszajelzesek_blokk').append(html);

            var cim = $("#regio_teljesitmeny_cim_" + regioId).html().replace('#regio#', regioNev);
            $("#regio_teljesitmeny_cim_" + regioId).html(cim);

            var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
            drawDasboardColumnChart("regio_teljesitmeny_" + regioId, grafikonAdatok.lebontasok, grafikonAdatok.data, szinek);
        }
    }

    telephelyErtekOsszegzes();

}

function telephelyErtekOsszegzes() {

    var regiokraBontas = [];

    for (var telephelyId in TELEPHELY_ERTEKEK) {
        var regioId = null;
        /*A sparse array miatt itt ugrani kell*/
        if (telephelyId != 'null') {
            for (var i in HONAPOK) {
                var honap = HONAPOK[i];
                var atlag = 0;

                if (isDefined(TELEPHELY_ERTEKEK[telephelyId][honap])) {
                    var belsoErtek = TELEPHELY_ERTEKEK[telephelyId][honap].ertek;
                    regioId = TELEPHELY_ERTEKEK[telephelyId][honap].regio_id;

                    var nevezo = belsoErtek.length;
                    var szamlalo = 0;
                    for (var j in belsoErtek) {
                        szamlalo += belsoErtek[j];
                    }
                    atlag = szamlalo / nevezo;

                    if (atlag == Infinity) { atlag = 0; }

                }

                if (regioId != 'null' && regioId != null) {
                    if (!isDefined(regiokraBontas[regioId])) {
                        regiokraBontas[regioId] = {
                            "szoveg": '',
                            "tipus": 'egyedi_valaszok',
                            "nps": true,
                            "lehetseges_valaszok": [],
                            "lebontasok": HONAPOK,
                            "data": []
                        };
                    }

                    var telephely = findInArray(TELEPHELYEK, 'id', telephelyId);

                    if (isDefined(telephely)) {
                        if (!isDefined(regiokraBontas[regioId]["data"][telephelyId])) {
                            regiokraBontas[regioId]["lehetseges_valaszok"].push(telephely.nev);
                            regiokraBontas[regioId]["data"][telephelyId] = { label: telephely.nev, data: tombInic(HONAPOK.length, 0) };
                        }

                        /*regiokraBontas[regioId]["data"][telephelyId].data.push(atlag);*/
                        regiokraBontas[regioId]["data"][telephelyId].data[i] = atlag;
                    }
                }
            }

        }
    }
    var vannakRegiok = 0;
    /*Grafikonok megjelenítése*/
    for (var regio in regiokraBontas) {
        if (regiokraBontas[regio].data.length > 0 || isAdmin()) {

            vannakRegiok++;

            var lebontasokSzama = regiokraBontas[regio]["lebontasok"].length;

            var width50 = $('#nps_trend_holder').width();
            var height = $('#nps_trend_holder').height();

            var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="regio_telephelyek_teljesitmeny_' + regio + '" height="' + height + '" width="' + width50 + '"></canvas></div>';
            var trend = '<div id="teljesitmeny_telephely_trend_holder_' + regio + '" class="holder-50">' + canvas + '</div>';;
            $('#teljesitmeny_trend_holder_' + regio).parent().append(trend);

            var szinek = szinGeneralas('egyedi_valaszok', regiokraBontas[regio].lehetseges_valaszok.length, 'line');
            x = regiokraBontas[regio].data;
            drawLineChart("regio_telephelyek_teljesitmeny_" + regio, regiokraBontas[regio].lebontasok, objectToArrayReorg(regiokraBontas[regio].data), szinek, false, false, 'egyedi_valaszok', true, false, false);
        } else {
            $('#teljesitmeny_trend_holder_' + regio).remove();
            $('#regio_teljesitmeny_cim_' + regio).remove();
        }
    }
}

/*Kitöltések visszajelzése grafikon inicializálás*/
function kitoltekGrafikonok(mod) {

    disableInput($('#partner_select_input'), true);

    if (mod == 'partner') {
        var data = {
            "idopont_tol": computeDates('elozo_nyolc_honap').kezdet,
            "idopont_ig": computeDates('elozo_nyolc_honap').veg,
            "partner_id": parseInt($('#partner_select_input').val()[0]),
            "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS)
        };

        var resultText = {};

        postApi('jelentesek_kitoltesek_szama_dashboard', data, null, resultText, null, function (result) {
            kitoltesekPartnerFeldolgozas(result);
        });
    } else if (mod == 'telephely') {
        if (TELEPHELYEK.length > 0 || isAdmin()) {
            var data = {
                "idopont_tol": computeDates('ez_a_honap').kezdet,
                "idopont_ig": computeDates('ez_a_honap').veg,
                "partner_id": parseInt($('#partner_select_input').val()[0]),
                "telephely_idk": JSON.stringify(FELHASZNALO_TELEPHELYEK_IDS)
            };

            var resultText = {};

            postApi('jelentesek_kitoltesek_szama_dashboard', data, null, resultText, null, function (result) {
                kitoltesekTelephelyFeldolgozas(result);
            });
        }

    }

}

function kitoltesekTelephelyFeldolgozas(kitoltesek) {
    var osszesKitoltesAHonapban = kitoltesek.kitoltesek_szama[0]["kitoltesek_szama"];
    var partnerKitoltesek = [];

    var telephelyKitoltesek = kitoltesek.kitoltesek_szama_telephelyenkent;
    var maxKitoltes = null;
    for (var i in telephelyKitoltesek) {
        if (maxKitoltes == null || parseInt(maxKitoltes) < parseInt(telephelyKitoltesek[i].kitoltesek_szama)) {
            maxKitoltes = parseInt(telephelyKitoltesek[i].kitoltesek_szama);
        }
    }

    var grafikonAdatok = {
        "szoveg": '',
        "tipus": 'szamok-0-10',
        "nps": true,
        "lehetseges_valaszok": ['-1', '0', '1'],
        "lebontasok": [],
        "data": [],
    };

    grafikonAdatok["data"] = [
        { label: '-1', data: [] },
        { label: '1', data: [] },
        { label: '0', data: [] }
    ];

    var partnerTelephelyei = filterArray(TELEPHELYEK, 'fk_partner', $('#partner_select_input').val()[0]);

    for (var i in partnerTelephelyei) {
        var telephely = partnerTelephelyei[i];
        grafikonAdatok['lebontasok'].push(telephely.nev);
        var kitoltes = findInArray(telephelyKitoltesek, 'fk_telephelyek', telephely.id);

        var arany = 0;
        var inverz = maxKitoltes;
        if (isDefined(kitoltes)) {
            arany = parseInt(kitoltes.kitoltesek_szama);
            var inverz = maxKitoltes - arany;
        }



        grafikonAdatok['data'][0].data.push(0);
        grafikonAdatok['data'][1].data.push(arany);
        grafikonAdatok['data'][2].data.push(inverz);
    }


    var width50 = $('#nps_trend_holder').width();
    var height = $('#nps_trend_holder').height();
    /*height = Math.ceil(height*0.75);*/


    var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="telephely_kitoltesek" height="' + height + '" width="' + width50 + '"></canvas></div>';
    var trend = '<div id="telephely_kitoltesek_holder">' + canvas + '</div>';;
    $('.kitoltes_holder_telepulesenkent').append(trend);

    console.log({ grafikonAdatok });
    var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
    drawDasboardColumnChart("telephely_kitoltesek", grafikonAdatok.lebontasok, objectToArrayReorg(grafikonAdatok.data), szinek, true, true);

    disableInput($('#partner_select_input'), false);

    /*összesítő táblázat*/
    if (hasRight('tomeges_kikuldes')) {
        call_ajax_jelentesek_sel_kikuldes_statisztika(true);
    }


}

function kitoltesekPartnerFeldolgozas(kitoltesek) {
    grafikonAdatok = {
        "szoveg": '',
        "tipus": 'szamok-0-10',
        "nps": true,
        "lehetseges_valaszok": ['1'],
        "lebontasok": [],
        "data": [{ label: '1', data: [] }]
    };

    for (var i in kitoltesek.kitoltesek_szama_havonta) {
        var honap = toGlobalDateFormat(kitoltesek.kitoltesek_szama_havonta[i].ev + '/' + kitoltesek.kitoltesek_szama_havonta[i].honap);
        grafikonAdatok["lebontasok"].push(honap);
        grafikonAdatok["data"][0].data.push(kitoltesek.kitoltesek_szama_havonta[i].kitoltesek_szama);
    }


    var width50 = $('#nps_trend_holder').width();
    var height = $('#nps_trend_holder').height();



    if (TELEPHELYEK.length == 0 && !isAdmin()) {
        $('#telephely_kitoltesek_cim').html('');
    }

    var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="partner_kitoltesek" height="' + height + '" width="' + width50 + '"></canvas></div>';
    var trend = '<div id="partner_kitoltesek_holder">' + canvas + '</div>';;
    /* $('#kitoltes_holder').append(trend);*/

    $('#kitoltes_holder').append(`
        <div class="holder-row" style="margin-bottom: 50px;display:flex;justify-content: center;flex-wrap:wrap">
            <div class="holder-50-header"><h3 id="partner_kitoltesek_cim">[[$t.partner_kitoltesek_cim]]</h3>${trend}</div>
            <div class="holder-50-header kitoltes_holder_telepulesenkent"><h3 id="telephely_kitoltesek_cim" class="mt-4">[[$t.telephely_kitoltesek_cim]]</h3></div>
        </div>`);

    var partner_kitoltesek_cim = $('#partner_kitoltesek_cim').html().replace('#partner#', PARTNER.nev);
    $('#partner_kitoltesek_cim').html(partner_kitoltesek_cim);

    var telephely_kitoltesek_cim = $('#telephely_kitoltesek_cim').html().replace('#partner#', PARTNER.nev);
    $('#telephely_kitoltesek_cim').html(telephely_kitoltesek_cim);

    var lebontasokSzama = grafikonAdatok.lebontasok.length;
    szinek = [{ color: '#fff', background_color: 'rgba(142,188,2,0.3)' }];
    drawLineChart('partner_kitoltesek', grafikonAdatok.lebontasok, grafikonAdatok.data, szinek, false, false, 'dashboard_trend_value', true, 1, false);


    kitoltekGrafikonok('telephely');
}

function partnerErtekek(kitoltesek) {

    disableInput($('#partner_select_input'), true);

    /*Végigmegyünk a nyers válaszokon*/
    var kivalasztottPartnerId = $('#partner_select_input').val()[0]
        ;
    var partnerAdatok = [];
    for (var i in kitoltesek) {
        var valasz = kitoltesek[i];
        var telephelyId = valasz.fk_telephelyek;
        var telephely = TELEPHELYEK[telephelyId];
        var partnerId = telephely.fk_partner;

        /*Csak a kiválasztott partnerre vagyunk kíváncsiak*/
        if (partnerId == kivalasztottPartnerId) {
            var honap = toGlobalDateFormat(valasz.ev + '/' + valasz.honap);
            var valaszSorszam = valasz.valasz_sorszam;
            var tipus = valasz.valasz_tipus_kod;
            var kerdesId = valasz.kerdes_id;

            /*A kedvező érték sorszáma*/
            var max = 0;
            if (tipus.slice(0, 8) == 'ikonok-5') {
                max = 5;
            } else if (tipus.slice(0, 8) == 'ikonok-4') {
                max = 4;
            } else if (tipus == 'szamok-1-10') {
                max = 10;
            } else if (tipus == 'szamok-1-6') {
                max = 6;
            } else if (tipus == 'szamok-1-5') {
                max = 5;
            } else if (tipus == 'igen_nem') {
                max = 2;
            }

            /*Adatok összegyűjtése - 1. lépés*/
            /*Pl.:
            partnerAdatok
                2018/12     1.kérdés    kedvező: 10, összes: 23,  max:5
                            2.kérdés    kedvező: 23, összes: 40, max: 10
                2019/1      1.kérdés    kedvező: 6, összes: 50, max: 5
                            2.kérdés    kedvező: 2, összes: 10, max: 10
                            ...
            */
            if (!isDefined(partnerAdatok[honap])) {
                partnerAdatok[honap] = [];
            }

            if (!isDefined(partnerAdatok[honap][kerdesId])) {
                partnerAdatok[honap][kerdesId] = {
                    'kedvezo': (valaszSorszam == max) ? 1 : 0,
                    'osszes': 1,
                    'valasz_sorszamok_osszege': parseInt(valaszSorszam),
                    'max': max,
                    'tipus': tipus
                };
            } else {
                if (valaszSorszam == max) {
                    partnerAdatok[honap][kerdesId]['kedvezo'] += 1;
                }
                partnerAdatok[honap][kerdesId]['valasz_sorszamok_osszege'] += parseInt(valaszSorszam);
                partnerAdatok[honap][kerdesId]['osszes'] += 1;
            }
        }
    }

    /*Adatok összegyűjtése - 2. lépés*/
    /*
    partnerAdatokHavonta
        2018/12: osszeg: (10/23)*100 + (23/40)*100, db: 2
        ...
    Másik verzió súlyozott átlaggal:
    partnerAdatokHavontaSulyozva

    */

    var partnerAdatokHavonta = [];
    var partnerAdatokHavontaSulyozva = [];
    for (var honap in partnerAdatok) {
        if (isDefined(honap)) {
            if (!isDefined(partnerAdatokHavonta[honap])) {
                partnerAdatokHavonta[honap] = {
                    'osszeg': 0,
                    'db': 0
                }
            }

            var nyersAdatok = partnerAdatok[honap];
            for (var kerdesId in partnerAdatok[honap]) {
                var adat = partnerAdatok[honap][kerdesId];
                var adatTipus = adat.tipus;

                var ertek = 0;
                if (adatTipus == 'igen_nem') {
                    ertek = (adat.kedvezo / adat.osszes) * 100;
                } else if (adatTipus.slice(0, 8) == 'szamok-1' || adatTipus.slice(0, 8) == 'ikonok-5' || adatTipus.slice(0, 8) == 'ikonok-4') {

                    ertek = ((adat.valasz_sorszamok_osszege / adat.osszes) / adat.max) * 100

                }

                /*Összegzés ezen a szinten:
                    A partnernek az adott hónapban a kérdésekre adott válaszok értékének összege
                    és azok darabszáma.
                */
                partnerAdatokHavonta[honap]['osszeg'] += ertek;
                partnerAdatokHavonta[honap]['db'] += 1;
            }
        }
    }

    /*Adatok összegzése - 3.lépés
        Itt kapjuk meg a grafikonban megjelenítendő értéket
    */

    /*Ez amiatt kell, mert ha nincs NPS kérdés, akkor ez a tömb itt még nincs előtöltve*/
    var vannakHonapok = HONAPOK.length > 0;
    var partnerAdatokOsszesen = [];
    HONAPOK = [];
    for (var honap in partnerAdatokHavonta) {
        HONAPOK.push(toGlobalDateFormat(honap));
        /*if(!vannakHonapok) {
            HONAPOK.push(toGlobalDateFormat(honap));
        }*/
        var haviAdat = partnerAdatokHavonta[honap];
        var ertek = haviAdat.osszeg / haviAdat.db;

        partnerAdatokOsszesen[honap] = Math.round(ertek.toFixed(2));
    }
    console.log('partnerAdatok', partnerAdatok);
    console.log('partnerAdatokHavonta', partnerAdatokHavonta);
    console.log('partnerAdatokOsszesen', partnerAdatokOsszesen);

    /*Grafikonra átszabni az adatokat*/
    var grafikonAdatok = {
        "szoveg": '',
        "tipus": 'szamok-0-10',
        "nps": true,
        "lehetseges_valaszok": ['-1', '0', '1'],
        "lebontasok": HONAPOK,
        "data": []
    };

    grafikonAdatok["data"] = [
        { label: '-1', data: [] },
        { label: '1', data: [] },
        { label: '0', data: [] }
    ];

    /*for(var honap in partnerAdatokOsszesen) {*/
    for (var i in HONAPOK) {
        var honap = HONAPOK[i];
        var adat = isDefined(partnerAdatokOsszesen[honap]) ? partnerAdatokOsszesen[honap] : 0;
        /*grafikonAdatok["lebontasok"].push(honap);*/

        var atlag = adat;
        var inverz = 100 - atlag;

        grafikonAdatok["data"][2].data.push(inverz);
        grafikonAdatok["data"][1].data.push(atlag);
        grafikonAdatok["data"][0].data.push(0);
    }

    var lebontasokSzama = grafikonAdatok.lebontasok.length;
    var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
    drawDasboardColumnChart("nps_partner_column_chart", grafikonAdatok.lebontasok, grafikonAdatok.data, szinek);

    /*Láncolás*/
    regioErtekek(kitoltesek);
}

/*Értékes kérdések összegzése régiókra*/
function regioErtekek(kitoltesek) {
    KITOLTESEK = kitoltesek;

    /*Végigmegyünk a nyers válaszokon*/
    var kivalasztottPartnerId = $('#partner_select_input').val()[0];

    var regioAdatok = [];
    for (var i in kitoltesek) {
        var valasz = kitoltesek[i];
        var telephelyId = valasz.fk_telephelyek;
        var telephely = TELEPHELYEK[telephelyId];
        var partnerId = telephely.fk_partner;

        var regioId = valasz.fk_regiok;

        /*Csak a kiválasztott partnerre vagyunk kíváncsiak és csak akkor, ha a régió id nem null*/
        if (partnerId == kivalasztottPartnerId && regioId != null && regioId != 'null') {

            var honap = valasz.ev + '.' + (parseInt(valasz.honap) < 10 ? '0' + valasz.honap : valasz.honap);
            if (act_lang_formatum != 'YYYY.mm.dd') {
                honap = (parseInt(valasz.honap) < 10 ? '0' + valasz.honap : valasz.honap) + '.' + valasz.ev;
            }

            var valaszSorszam = valasz.valasz_sorszam;
            var tipus = valasz.valasz_tipus_kod;
            var kerdesId = valasz.kerdes_id;

            /*A kedvező érték sorszáma*/
            var max = 0;
            if (tipus.slice(0, 8) == 'ikonok-5') {
                max = 5;
            } else if (tipus.slice(0, 8) == 'ikonok-4') {
                max = 4;
            } else if (tipus == 'szamok-1-10') {
                max = 10;
            } else if (tipus == 'szamok-1-6') {
                max = 6;
            } else if (tipus == 'szamok-1-5') {
                max = 5;
            } else if (tipus == 'igen_nem') {
                max = 2;
            }

            /*Adatok összegyűjtése - 1. lépés*/
            /*Pl.:
            regioAdatok
                Affidea OEP 2018/12     1.kérdés    kedvező: 10, összes: 23,  max:5
                                        2.kérdés    kedvező: 23, összes: 40, max: 10
                            2019/1      1.kérdés    kedvező: 6, összes: 50, max: 5
                                        2.kérdés    kedvező: 2, összes: 10, max: 10
                Affidea Privát          ...
                            ...
            */
            if (!isDefined(regioAdatok[regioId])) {
                regioAdatok[regioId] = [];
            }

            if (!isDefined(regioAdatok[regioId][honap])) {
                regioAdatok[regioId][honap] = [];
            }

            if (!isDefined(regioAdatok[regioId][honap][kerdesId])) {
                regioAdatok[regioId][honap][kerdesId] = {
                    'kedvezo': (valaszSorszam == max) ? 1 : 0,
                    'osszes': 1,
                    'valasz_sorszamok_osszege': parseInt(valaszSorszam),
                    'max': max,
                    'tipus': tipus
                };
            } else {
                if (valaszSorszam == max) {
                    regioAdatok[regioId][honap][kerdesId]['kedvezo'] += 1;
                }
                regioAdatok[regioId][honap][kerdesId]['valasz_sorszamok_osszege'] += parseInt(valaszSorszam);
                regioAdatok[regioId][honap][kerdesId]['osszes'] += 1;
            }
        }
    }


    /*Adatok összegyűjtése - 2. lépés*/
    /*
    regioAdatokHavonta
        Affidea OEP         2018/12: osszeg: (10/23)*100 + (23/40)*100, db: 2
        Affidea Privát      ...
    */

    var regioAdatokHavonta = [];
    for (var regioId in regioAdatok) {
        regioAdatokHavonta[regioId] = [];

        var nyersAdatok = regioAdatok[regioId];

        for (var honap in nyersAdatok) {
            if (!isDefined(regioAdatokHavonta[regioId][honap])) {
                regioAdatokHavonta[regioId][honap] = {
                    'osszeg': 0,
                    'db': 0
                }
            }

            for (var kerdesId in nyersAdatok[honap]) {
                var adat = nyersAdatok[honap][kerdesId];
                var adatTipus = adat.tipus;

                var ertek = 0;
                if (adatTipus == 'igen_nem') {
                    ertek = (adat.kedvezo / adat.osszes) * 100;
                } else if (adatTipus.slice(0, 8) == 'szamok-1' || adatTipus.slice(0, 8) == 'ikonok-5' || adatTipus.slice(0, 8) == 'ikonok-4') {

                    ertek = ((adat.valasz_sorszamok_osszege / adat.osszes) / adat.max) * 100

                }

                /*Összegzés ezen a szinten:
                    A régiók az adott hónapban a kérdésekre adott válaszok értékének összege
                    és azok darabszáma.
                */
                regioAdatokHavonta[regioId][honap]['osszeg'] += ertek;
                regioAdatokHavonta[regioId][honap]['db'] += 1;
            }
        }
    }



    /*Adatok összegzése - 3.lépés
        Itt kapjuk meg a grafikonban megjelenítendő értéket
    */
    var regioAdatokOsszesen = [];
    for (regioId in regioAdatokHavonta) {
        regioAdatokOsszesen[regioId] = [];
        for (var honap in regioAdatokHavonta[regioId]) {
            var haviAdat = regioAdatokHavonta[regioId][honap];
            var ertek = haviAdat.osszeg / haviAdat.db;

            regioAdatokOsszesen[regioId][honap] = ertek.toFixed(2);
        }
    }


    /*Grafikonok létrehozása*/
    for (var regioId in regioAdatokOsszesen) {

        var regioNev = REGIOK[regioId].nev;

        var grafikonAdatok = {
            "szoveg": '',
            "tipus": 'szamok-0-10',
            "nps": true,
            "lehetseges_valaszok": ['-1', '0', '1'],
            "lebontasok": HONAPOK,
            "data": [],
        };

        grafikonAdatok["data"] = [
            { label: '-1', data: [] },
            { label: '1', data: [] },
            { label: '0', data: [] }
        ];

        for (var i in HONAPOK) {
            var honap = HONAPOK[i];

            var atlag = isDefined(regioAdatokOsszesen[regioId][honap]) ? regioAdatokOsszesen[regioId][honap] : 0;;
            var inverz = 100 - atlag;

            grafikonAdatok["data"][2].data.push(inverz);
            grafikonAdatok["data"][1].data.push(atlag);
            grafikonAdatok["data"][0].data.push(0);

        }

        var lebontasokSzama = grafikonAdatok.lebontasok.length;

        var width50 = $('#nps_trend_holder').width();
        var width100 = $('#partner_eredmenyek_holder').width();
        var height = $('#nps_trend_holder').height();
        /*height = Math.ceil(height*0.75);*/


        var cim_template = '<h3 id="regio_teljesitmeny_cim_' + regioId + '" class="text-center">[[$t.regio_visszajelzes_cim]]</h3>';
        var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="regio_teljesitmeny_' + regioId + '" height="' + height + '" width="' + width50 + '"></canvas></div>';
        var trend = '<div id="teljesitmeny_trend_holder_' + regioId + '" class="holder-50">' + canvas + '</div>';
        var html = cim_template + '<div class="holder-row" style="margin-bottom: 50px">' + trend + '</div>';
        $('#visszajelzesek_blokk').append(html);

        var cim = $("#regio_teljesitmeny_cim_" + regioId).html().replace('#regio#', regioNev);
        $("#regio_teljesitmeny_cim_" + regioId).html(cim);

        var szinek = szinGeneralas('dashboradColumn', grafikonAdatok.lehetseges_valaszok.length);
        drawDasboardColumnChart("regio_teljesitmeny_" + regioId, grafikonAdatok.lebontasok, grafikonAdatok.data, szinek);
    }

    /*Láncolás*/
    telephelyErtekek(kitoltesek);
}

function telephelyErtekek(kitoltesek) {

    /*Végigmegyünk a nyers válaszokon*/
    var kivalasztottPartnerId = $('#partner_select_input').val()[0];

    var telephelyAdatok = [];
    for (var i in kitoltesek) {
        var valasz = kitoltesek[i];
        var telephelyId = valasz.fk_telephelyek;
        var telephely = TELEPHELYEK[telephelyId];
        var partnerId = telephely.fk_partner;

        var regioId = valasz.fk_regiok;

        /*Csak a kiválasztott partnerre vagyunk kíváncsiak és csak akkor, ha a régió id nem null*/
        if (partnerId == kivalasztottPartnerId && regioId != null && regioId != 'null') {
            var honap = valasz.ev + '.' + (parseInt(valasz.honap) < 10 ? '0' + valasz.honap : valasz.honap);
            if (act_lang_formatum != 'YYYY.mm.dd') {
                honap = (parseInt(valasz.honap) < 10 ? '0' + valasz.honap : valasz.honap) + '.' + valasz.ev;
            }

            var valaszSorszam = valasz.valasz_sorszam;
            var tipus = valasz.valasz_tipus_kod;
            var kerdesId = valasz.kerdes_id;

            /*A kedvező érték sorszáma*/
            var max = 0;
            if (tipus.slice(0, 8) == 'ikonok-5') {
                max = 5;
            } else if (tipus.slice(0, 8) == 'ikonok-4') {
                max = 4;
            } else if (tipus == 'szamok-1-10') {
                max = 10;
            } else if (tipus == 'szamok-1-6') {
                max = 6;
            } else if (tipus == 'szamok-1-5') {
                max = 5;
            } else if (tipus == 'igen_nem') {
                max = 2;
            }

            /*Adatok összegyűjtése - 1. lépés*/
            /*Pl.:
            telephelyAdatok
                Affidea OEP     1.telephely     2018/12     1.kérdés    kedvező: 10, összes: 23,  max:5
                                                            2.kérdés    kedvező: 23, összes: 40, max: 10
                                                2019/1      1.kérdés    kedvező: 6, összes: 50, max: 5
                                2.telephely     2018/12     ...
                Affidea Privát  3.telephely     ...
                ...
            */
            if (!isDefined(telephelyAdatok[regioId])) {
                telephelyAdatok[regioId] = [];
            }

            if (!isDefined(telephelyAdatok[regioId][telephelyId])) {
                telephelyAdatok[regioId][telephelyId] = [];
            }

            if (!isDefined(telephelyAdatok[regioId][telephelyId][honap])) {
                telephelyAdatok[regioId][telephelyId][honap] = [];
            }

            if (!isDefined(telephelyAdatok[regioId][telephelyId][honap][kerdesId])) {
                telephelyAdatok[regioId][telephelyId][honap][kerdesId] = {
                    'kedvezo': (valaszSorszam == max) ? 1 : 0,
                    'osszes': 1,
                    'valasz_sorszamok_osszege': parseInt(valaszSorszam),
                    'max': max,
                    'tipus': tipus
                };
            } else {
                if (valaszSorszam == max) {
                    telephelyAdatok[regioId][telephelyId][honap][kerdesId]['kedvezo'] += 1;
                }
                telephelyAdatok[regioId][telephelyId][honap][kerdesId]['valasz_sorszamok_osszege'] += parseInt(valaszSorszam);
                telephelyAdatok[regioId][telephelyId][honap][kerdesId]['osszes'] += 1;
            }

        }

    }


    /*Adatok összegyűjtése - 2. lépés*/
    /*
    telephelyAdatokHavonta
        Affidea OEP         1.telephely         2018/12: osszeg: (10/23)*100 + (23/40)*100, db: 2
                            2.telephely         ...
        Affidea Privát      ...
    */

    var telephelyAdatokHavonta = [];
    for (var regioId in telephelyAdatok) {
        telephelyAdatokHavonta[regioId] = [];

        var nyersAdatok = telephelyAdatok[regioId];

        for (var telephelyId in nyersAdatok) {
            telephelyAdatokHavonta[regioId][telephelyId] = [];
            for (var honap in nyersAdatok[telephelyId]) {
                if (!isDefined(telephelyAdatokHavonta[regioId][telephelyId][honap])) {
                    telephelyAdatokHavonta[regioId][telephelyId][honap] = {
                        'osszeg': 0,
                        'db': 0
                    }
                }

                for (var kerdesId in nyersAdatok[telephelyId][honap]) {
                    var adat = nyersAdatok[telephelyId][honap][kerdesId];
                    var adatTipus = adat.tipus;

                    var ertek = 0;
                    if (adatTipus == 'igen_nem') {
                        ertek = (adat.kedvezo / adat.osszes) * 100;
                    } else if (adatTipus.slice(0, 8) == 'szamok-1' || adatTipus.slice(0, 8) == 'ikonok-5' || adatTipus.slice(0, 8) == 'ikonok-4') {

                        ertek = ((adat.valasz_sorszamok_osszege / adat.osszes) / adat.max) * 100

                    }

                    /*Összegzés ezen a szinten:
                        A régiók az adott hónapban a kérdésekre adott válaszok értékének összege
                        és azok darabszáma.
                    */
                    telephelyAdatokHavonta[regioId][telephelyId][honap]['osszeg'] += ertek;
                    telephelyAdatokHavonta[regioId][telephelyId][honap]['db'] += 1;
                }
            }
        }
    }

    /*Adatok összegzése - 3.lépés
        Itt kapjuk meg a grafikonban megjelenítendő értéket
    */
    var telephelyAdatokOsszesen = [];
    for (regioId in telephelyAdatokHavonta) {
        telephelyAdatokOsszesen[regioId] = [];
        for (var telephelyId in telephelyAdatokHavonta[regioId]) {
            telephelyAdatokOsszesen[regioId][telephelyId] = [];
            for (var honap in telephelyAdatokHavonta[regioId][telephelyId]) {
                var haviAdat = telephelyAdatokHavonta[regioId][telephelyId][honap];
                var ertek = haviAdat.osszeg / haviAdat.db;

                telephelyAdatokOsszesen[regioId][telephelyId][honap] = ertek.toFixed(2);
            }
        }
    }


    /*Grafikonok létrehozása*/
    for (var regioId in telephelyAdatokOsszesen) {

        var grafikonAdatok = {
            "szoveg": '',
            "tipus": 'szamok-0-10',
            "nps": true,
            "lehetseges_valaszok": [],
            "lebontasok": HONAPOK,
            "data": [],
        };

        for (var i in HONAPOK) {
            var honap = HONAPOK[i];
            for (var telephelyId in telephelyAdatokOsszesen[regioId]) {

                var telephelyNev = TELEPHELYEK[telephelyId].nev;

                if (!isDefined(grafikonAdatok["data"][telephelyId])) {
                    grafikonAdatok["lehetseges_valaszok"].push(telephelyNev);
                    grafikonAdatok["data"][telephelyId] = { label: telephelyNev, data: [] };
                }

                var atlag = isDefined(telephelyAdatokOsszesen[regioId][telephelyId][honap]) ? telephelyAdatokOsszesen[regioId][telephelyId][honap] : 0;
                grafikonAdatok["data"][telephelyId]['data'].push(atlag);
            }
        }

        var lebontasokSzama = grafikonAdatok["lebontasok"].length;

        var width50 = $('#nps_trend_holder').width();
        var height = $('#nps_trend_holder').height();

        var canvas = '<div style="margin:auto;height:' + height + 'px; width:' + width50 + 'px"><canvas id="regio_telephelyek_teljesitmeny_' + regioId + '" height="' + height + '" width="' + width50 + '"></canvas></div>';
        var trend = '<div id="teljesitmeny_telephely_trend_holder_' + regioId + '" class="holder-50">' + canvas + '</div>';;
        $('#teljesitmeny_trend_holder_' + regioId).parent().append(trend);

        var szinek = szinGeneralas('egyedi_valaszok', grafikonAdatok.lehetseges_valaszok.length, 'line');
        drawLineChart("regio_telephelyek_teljesitmeny_" + regioId, objectToArrayReorg(grafikonAdatok.lebontasok), objectToArrayReorg(grafikonAdatok.data), szinek, false, false, 'egyedi_valaszok', true, false, false);


    }

    kitoltekGrafikonok('partner');

}

function osszesitoTablazat(data) {

    var exportBtn = buttonHtml({
        name: "[[$t.export]]",
        id: 'btn_riport_export_osszesitett',
        type: 'print',
        addClasses: 'btn-main ml-2 export-btn',
        visibility: function () {
            return 1;
        },
        callback: function () {
            $('#btn_riport_export_osszesitett').parent().parent().find('.buttons-excel').trigger('click');
        },
        onCustomAjaxDone: function (event, result, trigger) {
        }
    });

    var oszlopValaszto = "";
    oszlopValaszto += "<div class='mr-3 d-inline-block'>" + checkboxHtml({
        id: 'chk_kikuldes_db',
        addClass: 'cf-jog-chk mr-2 osszesitett-chk',
        checked: true,
        label: '[[$t.kikuldott_db]]'
    }) + '</div>';
    oszlopValaszto += "<div class='mr-3 d-inline-block'>" + checkboxHtml({
        id: 'chk_valasz_db',
        addClass: 'cf-jog-chk mr-2 osszesitett-chk',
        checked: true,
        label: '[[$t.valaszok_db]]'
    }) + '</div>';
    oszlopValaszto += "<div class='mr-3 d-inline-block'>" + checkboxHtml({
        id: 'chk_valasz_arany',
        addClass: 'cf-jog-chk mr-2 osszesitett-chk',
        checked: true,
        label: '[[$t.valaszadasi_arany]]'
    }) + '</div>';

    var datum_valaszto = "<div class='datum_holder'>";
    datum_valaszto += datepickerHtml({
        id: 'kezdo_datum_input',
        label: '[[$t.kezdo_honap]]',
        monthOnly: true
    });
    datum_valaszto += datepickerHtml({
        id: 'veg_datum_input',
        label: '[[$t.veg_honap]]',
        monthOnly: true
    });
    datum_valaszto += "</div>";

    $('#tabla-blokk-osszesites').html('<h2 class="table_name">[[$t.kikuldes_osszesitesek]]</h2><div class="lathatosag-holder mb-5">' + oszlopValaszto + exportBtn + datum_valaszto + '</div><div class="table-recreate"></div>');




    initDatepicker({ id: 'kezdo_datum_input', monthOnly: true, defaultDate: moment().add(-2, 'months').format('YYYY.MM.DD') });
    initDatepicker({ id: 'veg_datum_input', monthOnly: true, defaultDate: 'today' });



    $('#kezdo_datum_input, #veg_datum_input').on('change.datetimepicker', function (w) {
        var kezdo = $("#kezdo_datum_input").datetimepicker('viewDate')._d;
        var vegso = $("#veg_datum_input").datetimepicker('viewDate')._d;
        if (kezdo == null || vegso == null) {
            gi_alert('[[$t.kezdo_es_veg_honap_kell]]');
        } else if ($(this)[0].id == 'kezdo_datum_input' && kezdo > vegso) {
            gi_alert('[[$t.kezdo_nagyobb_mint_veg_honap]]');
            $("#kezdo_datum_input").datetimepicker('date', moment(vegso));
        } else if ($(this)[0].id == 'veg_datum_input' && vegso < kezdo) {
            gi_alert('[[$t.veg_kisebb_mint_kezdo_honap]]');
            $("#veg_datum_input").datetimepicker('date', moment(kezdo));
        } else {
            call_ajax_jelentesek_sel_kikuldes_statisztika();
        }
    });

    drawOsszesitoTablazat(result);

    $('#btn_riport_export_osszesitett').on('click', function () {
        console.log('dd');
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    $('#osszesitett_wrapper .dataTables_length, #osszesitett_wrapper .pagination, #osszesitett_wrapper .dataTables_info').addClass('d-none');
}

function call_ajax_jelentesek_sel_kikuldes_statisztika(init = false) {

    var kezdet = $('#kezdo_datum_input').length > 0 ? computeDates('sajat+').kezdet : computeDates('elozo_harom_honap').kezdet;
    var veg = $('#veg_datum_input').length > 0 ? computeDates('sajat+').veg : computeDates('ma').veg;
    var data = {
        "idopont_tol": kezdet,
        "idopont_ig": veg,
        "partner_id": parseInt($('#partner_select_input').val()[0])
    };

    var resultText = {};
    if (!init) {
        $('#loader-wrapper').removeClass('vhide');
    }

    postApi('jelentesek_sel_kikuldes_statisztika', data, null, resultText, null, function (result) {
        $('#loader-wrapper').addClass('vhide');
        if (init) {
            osszesitoTablazat(result);
        } else {
            drawOsszesitoTablazat(result);
        }

    });
}

function drawOsszesitoTablazat(adatok) {
    $('#tabla-blokk-osszesites .table-recreate').html('<table id="osszesitett"></table>');

    /*1. Hónapok legyűjtése*/
    var honapok = [];

    var kezdet = getDate($("#kezdo_datum_input").datetimepicker('viewDate')._d);
    var veg = getDate($("#veg_datum_input").datetimepicker('viewDate')._d);

    var ev = kezdet.year;
    var honap = kezdet.month;
    var end = false;
    while (!end) {
        honapok.push({
            ev: ev,
            honap: honap
        });

        if (ev == veg.year && honap == veg.month) {
            end = true;
        }

        honap++;
        if (honap > 12) {
            honap = 1;
            ev++;
        }
    }

    honapok.reverse();

    /*2. Fejléc meghatározása */
    /*Miket választott ki a felhasználó*/
    var valasztottOszlopok = [];
    var vanKikuldes = false;
    var vanValaszszam = false;
    var vanArany = false;
    if ($('#chk_kikuldes_db').is(':checked')) {
        valasztottOszlopok.push('[[$t.kikuldott_db]]');
        vanKikuldes = true;
    }
    if ($('#chk_valasz_db').is(':checked')) {
        valasztottOszlopok.push('[[$t.valaszok_db]]');
        vanValaszszam = true;
    }
    if ($('#chk_valasz_arany').is(':checked')) {
        valasztottOszlopok.push('[[$t.valaszadasi_arany]]');
        vanArany = true;
    }

    var fejlec = [{
        headName: '',
        colName: 'valasz' + 0,
        canOrder: false,
        canFilter: false
    }];

    var ind = 0;
    for (var i in honapok) {
        var offset = 0;
        for (var j in valasztottOszlopok) {
            fejlec.push({
                headName: valasztottOszlopok[j] + " " + honapok[i].ev + '.' + honapok[i].honap,
                colName: 'valasz' + parseInt(+i + 1 + ind + offset),
                canOrder: false,
                even: i % 2 == 0
            });
            ++offset;
        }
        ind += valasztottOszlopok.length - 1;
    }

    /*3. Sorok meghatározása + összesítő sor*/
    var osszesitoSor = tombInic(honapok.length * 3, 0);
    osszesitoSor[0] = '[[$t.osszegzes]]';

    /*Előfeldolgozás*/
    var sorArr = [];
    console.warn(adatok);
    for (var i in adatok) {
        /*Eszköz meghatározása*/
        var eszkozId = adatok[i].eszkoz_id;
        var eszkoz = findInArray(ESZKOZOK, 'id', eszkozId);

        if (!isDefined(sorArr[eszkozId])) {
            console.log(adatok[i], eszkoz);
            sorArr[eszkozId] = {
                'eszkoz': eszkoz.nev,
                'adat_sor': tombInic(fejlec.length - 1, '0')
            };
        }

        var honapInd = 0;
        var ind = 1;
        for (var j in honapok) {
            if (honapok[j].ev + '.' + honapok[j].honap == adatok[i].ev + '.' + adatok[i].ho) {
                honapInd = j * 3;

                break;
            }
        }

        var offset = 0;
        /*Kiküldések száma*/
        /*Összesítésbe MINDEN belekerül*/
        osszesitoSor[+honapInd + 1] += adatok[i].kikuldve;
        sorArr[eszkozId].adat_sor[honapInd] = adatok[i].kikuldve;

        /*Válaszok száma*/
        osszesitoSor[+honapInd + 2] += adatok[i].bekuldve;
        sorArr[eszkozId].adat_sor[+honapInd + 1] = adatok[i].bekuldve;

        /*Arány*/
        osszesitoSor[+honapInd + 3] = '%';
        sorArr[eszkozId].adat_sor[+honapInd + 2] = adatok[i].arany + ' %';

    }

    /*Tábla sorok kialakítása*/
    var sorok = [];

    for (var i in sorArr) {
        var sor = {};
        sor['valasz0'] = sorArr[i].eszkoz;
        var ind = 1;
        for (var j in sorArr[i].adat_sor) {
            if (((+j + 1) % 3 == 0) && vanArany) {
                sor['valasz' + ind] = sorArr[i].adat_sor[j];
                ind++
            } else if (((+j + 1) % 3 == 2) && vanValaszszam) {
                sor['valasz' + ind] = sorArr[i].adat_sor[j];
                ind++
            } else if (((+j + 1) % 3 == 1) && vanKikuldes) {
                sor['valasz' + ind] = sorArr[i].adat_sor[j];
                ind++
            }
        }
        sorok.push(sor);
    }
    console.log(sorok);
    /*Válasz arányok kiszámolása, ha szükséges*/

    if (vanArany) {
        for (var i = 1; i < (honapok.length) + 1; ++i) {
            var num = ((osszesitoSor[(i * 3) - 1] / osszesitoSor[(i * 3) - 2]) * 100).toFixed(1);
            console.log(((osszesitoSor[(i * 3) - 1] / osszesitoSor[(i * 3) - 2]) * 100).toFixed(1));
            num = $.isNumeric(num) ? num : '';
            osszesitoSor[i * 3] = num + ' %';
        }
    }

    console.log(osszesitoSor);
    /*Végleges összesítő sor*/
    var osszesites = [];
    for (var i = 1; i < osszesitoSor.length; ++i) {
        if ((i % 3 == 0) && vanArany) {
            osszesites.push(osszesitoSor[i]);
        } else if ((i % 3 == 2) && vanValaszszam) {
            osszesites.push(osszesitoSor[i]);
        } else if ((i % 3 == 1) && vanKikuldes) {
            osszesites.push(osszesitoSor[i]);
        }
    }



    /*4. Tábla összeállítás*/

    osszegzes = dataTable($('#osszesitett'), {
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]' + ' ' + 'partnerNev' + '[[$t.dashboard_osszesitett]]',
            sumFooter: {
                hasSumFooter: true,
                exportSumFooter: osszesites,
                type: 'dashboard_osszegzes'
            },
            pageLength: 1000
        },
        data: function (callback, element) {
            callback({ data: sorok });
        },
        columns: fejlec,
    });

    $('#osszesitett_wrapper .dt-buttons .buttons-excel').css('display', 'none');

    $('#osszesitett_wrapper .dataTables_length, #osszesitett_wrapper .pagination, #osszesitett_wrapper .dataTables_info').addClass('d-none');

    $('#loader-wrapper').addClass('vhide');

}