var existing_langs = ["ad" ,  "ae" ,  "af" ,  "ag" ,  "ai" ,  "al" ,  "am" ,  "an" ,  "ao" ,  "aq" ,  "ar" ,  "as" ,  "at" ,  "au" ,  "aw" ,  "az" ,  "ba" ,  "bb" ,  "bd" ,  "be" ,  "bf" ,  "bg" ,  "bh" ,  "bi" ,  "bj" ,  "bm" ,  "bn" ,  "bo" ,  "br" ,  "bs" ,  "bt" ,  "bv" ,  "bw" ,  "by" ,  "bz" ,  "ca" ,  "cc" ,  "cd" ,  "cf" ,  "cg" ,  "ch" ,  "ci" ,  "ck" ,  "cl" ,  "cm" ,  "cn" ,  "co" ,  "cr" ,  "cu" ,  "cv" ,  "cx" ,  "cy" ,  "cz" ,  "de" ,  "dj" ,  "dk" ,  "dm" ,  "do" ,  "dz" ,  "ec" ,  "ee" ,  "eg" ,  "eh" ,  "er" ,  "es" ,  "et" ,  "fi" ,  "fj" ,  "fk" ,  "fm" ,  "fo" ,  "fr" ,  "ga" ,  "gd" ,  "ge" ,  "gf" ,  "gh" ,  "gi" ,  "gl" ,  "gm" ,  "gn" ,  "gp" ,  "gq" ,  "gr" ,  "gs" ,  "gt" ,  "gu" ,  "gw" ,  "gy" ,  "hk" ,  "hm" ,  "hn" ,  "hr" ,  "ht" ,  "hu" ,  "id" ,  "ie" ,  "il" ,  "in" ,  "io" ,  "iq" ,  "ir" ,  "is" ,  "it" ,  "jm" ,  "jo" ,  "jp" ,  "ke" ,  "kg" ,  "kh" ,  "ki" ,  "km" ,  "kn" ,  "kp" ,  "kr" ,  "kw" ,  "ky" ,  "kz" ,  "la" ,  "lb" ,  "lc" ,  "li" ,  "lk" ,  "lr" ,  "ls" ,  "lt" ,  "lu" ,  "lv" ,  "ly" ,  "ma" ,  "mc" ,  "md" ,  "me" ,  "mg" ,  "mh" ,  "mk" ,  "ml" ,  "mm" ,  "mn" ,  "mo" ,  "mp" ,  "mq" ,  "mr" ,  "ms" ,  "mt" ,  "mu" ,  "mv" ,  "mw" ,  "mx" ,  "my" ,  "mz" ,  "na" ,  "nc" ,  "ne" ,  "nf" ,  "ng" ,  "ni" ,  "nl" ,  "no" ,  "no" ,  "np" ,  "nr" ,  "nu" ,  "nz" ,  "om" ,  "pa" ,  "pe" ,  "pf" ,  "pg" ,  "ph" ,  "pk" ,  "pl" ,  "pm" ,  "pn" ,  "pr" ,  "pt" ,  "pw" ,  "py" ,  "qa" ,  "re" ,  "ro" ,  "rs" ,  "ru" ,  "rw" ,  "sa" ,  "sb" ,  "sc" ,  "sd" ,  "se" ,  "sg" ,  "sh" ,  "si" ,  "sj" ,  "sk" ,  "sl" ,  "sm" ,  "sn" ,  "so" ,  "sr" ,  "ss" ,  "st" ,  "sv" ,  "sy" ,  "sz" ,  "tc" ,  "td" ,  "tf" ,  "tg" ,  "th" ,  "tj" ,  "tk" ,  "tl" ,  "tm" ,  "tn" ,  "to" ,  "tp" ,  "tr" ,  "tt" ,  "tv" ,  "tw" ,  "ty" ,  "tz" ,  "ua" ,  "ug" ,  "uk" ,  "um" ,  "us" ,  "uy" ,  "uz" ,  "va" ,  "vc" ,  "ve" ,  "vg" ,  "vi" ,  "vn" ,  "vu" ,  "wf" ,  "ws" ,  "ye" ,  "za" ,  "zm" ,  "zr" ,  "zw" ];

$(document).ready(function() {


    $('[data-link]').on('click', function() {
        $('[data-link]').removeClass('active');
        $(this).addClass('active');
    });

    $('a[href^="tel:"]').attr('href', function(_,v){
        return v.replace(/\(0\)|\s+/g,'')
    });

    /*Mobile menu control*/
    $('#ceedback-navbar-open').on('click', function (){
        $('#ceedback-navbar').addClass('visible');
    });
    $('#ceedback-navbar-close').on('click', function (){
        $('#ceedback-navbar').removeClass('visible');
    });


    var lang_selector = filterSelectHtml({
                    id: 'nyelv_valaszto',
                    placeholder: '[[$t.nyelv]]',
                    name: 'eszkoz_select_input',
                    maxOptions: 1,
                    addclass: 'form',
                    isLangSelect: true
                },
                filterSelectValues(nyelv_lista , 'lang_name', 'lang_code')
            );

    $('#lang-selector').html(lang_selector);
    $('#nyelv_valaszto').selectpicker();

    $('#nyelv_valaszto').selectpicker('val', act_lang);

    $('#nyelv_valaszto').on('change', function(){
        var lang = $(this).val();
        if(lang == '') {
            $('#nyelv_valaszto').selectpicker('val', act_lang);
        } else if(lang != act_lang) {
            var path = window.location.pathname.replace('/'+act_lang+'/', '');
            page_forward('/' + lang + '/' + path);
        }
    });

    var html = "";
    for(var i in nyelv_lista) {
        var code = langCodeConvert(nyelv_lista[i].lang_code);
        html += '<li><a href="/'+nyelv_lista[i].lang_code+'/home">'+code.toUpperCase()+'</a></li>'
    }

    $('#home-langs .lang').html(langCodeConvert(act_lang));

    $('#home-langs-list').html(html);

    $(document).on('click', '#kapcsolat_form .btn-kapcsolat', function (e) { 
        e.preventDefault();
        var form = $('#kapcsolat_form');
        var valid = validateForm(form);

        if(!$('#kapcsolat_form-confirm').is(':checked')) {
            valid = false;
            gi_alert('[[$t.fogadd_el_az_adatvedelmit]]'); 
        }

        if(valid) {
            grecaptcha.execute();
        } 

    });


    $(document).on('click', '.btn_dt_new', function(e){
        var img = $(this).find('img');
        if(img.hasClass('minus')) {
            $(this).find('img').attr('src', '[[$p.new_button_icon.png]]');

        } else {
            $(this).find('img').attr('src', '[[$p.minus_icon.png]]');
        }
        img.toggleClass('minus');
        $(this).toggleClass('minus');
        
    });


	if(!hasRight('login')) {
		$('body').addClass('login-background');
		$('#main-content').addClass('full-content');
	}

    stopLoader();

    $('a').on('click', function(e) {
        if($(this).attr('href') == '#') {
            e.preventDefault();
        } else if(!$(this).hasClass('newtab') && !e.ctrlKey) {
            startLoader();
        }
    });

    var active_page = window.location.pathname;
    $('.side-nav-block').removeClass('active');
    if(isDefined(active_page)){
        $('#side-nav a[href="' + active_page + '"] .side-nav-block').addClass('active');
        $('#side-nav a[href="' + active_page + '"] .side-nav-block').closest('.menu-group').addClass('open');
    }

    /*Mobil nézetben csukva jelenik meg a sidebar.
    Itt nincs szükség a main-content csúszós animációjára*/
    if($(window).width() <= 768) {
        toggleClasses($('#wrapper'),null,null,'side-nav-hidden');
        toggleClasses($('#side-nav'),null,null,'side-nav-hidden');
    } 

    $('#side-nav-toggle').on('click', function() {
        toggle_sidebar(1,true);
    });

    /*$('#side-nav').removeClass("d-none");*/

    /* editor zaszlocska */
    set_editor_flag(act_lang);

    set_language_dropdown($('#language'));

    /*input golobalis kezeles*/
    $('#main-content').on('change','input',  function() {
        if($(this).hasClass('is-invalid')){
            clearValidation(this);
        }
    });

    $('#main-content').on('change','select',  function() {
        if($(this).hasClass('is-invalid')){
            clearValidation(this);
        }
    });

    $('#main-content').on('click','.cf-options li',  function() {
        if($(this).parent().parent().hasClass('is-invalid')){
            clearValidation($(this).parent().parent());
        }
    });

    /* jelszo toggler*/
    $('#main-content').on('click','.password-group .input-group-prepend',  function() {
        if($(this).closest('.input-group').find('input').attr('type') == 'password'){
            $(this).closest('.input-group').find('input').attr('type','text');
            $(this).find('i').addClass('fa-eye-slash').removeClass('fa-eye');
        }else{
            $(this).closest('.input-group').find('input').attr('type','password');
            $(this).find('i').addClass('fa-eye').removeClass('fa-eye-slash');
        }
    });

    /*menu jog kezeles globalisan
    kell egy data-right abban az ertek refferencia a jogra es mellete van egy ugyan ilyen class
    */
    $('body [data-right]').each(function(){
        var right = $(this).attr('data-right');
        if(right == "" || hasRight(right)){
            $(this).show();
        }else{
            $(this).remove();
        }
    });

    /*ne lehessen kivagni, masolni, beilleszteni*/
    $(document).on( "cut copy paste", '.no-paste', function(e) {
        e.preventDefault();
    });

    /*enter-re az input ajaxot hivjon*/
    $(document).keypress(function(e) {
        if(e.which == 13) {
            if($(e.target).is('input')){
                var form = $(e.target).closest('form');
                /*vagy egy gomb van a formon vagy egy submit gomb akkor azt hivja*/
                if(form.length != 0){
                    if(form.find('button').length == 1){
                        form.find('button').trigger('click');
                    }else if(form.find('button.submit').length == 1){
                        form.find('button.submit').trigger('click');
                    }
                }
            }
        }
    });

    /*keepalive*/
    if(hasRight('login')){
        setInterval(function(){
            postApi('auth_keepalive',{},null);
        },180*1000);
    }

    /*gyorsitotar torles*/
    if(hasRight('dev_funkciok')){
        handleCacheClear('dev_gyorsitotar_del');
        handleCacheClear('dev_json_gyorsitotar_del');
        handleCacheClear('szovegek_cache_del');
    }


    /*Felhasználó kijelentkeztetése */
    $('#logout-button').click(function(){
        postApi('auth_kijelentkezes',{},this);
    });

    $('#logout-button').on('custom_ajax_done',function(event,result,trigger){
        page_forward('/' + act_lang + '/bejelentkezes/');
    });

    /*Custom selectek működéséhez*/
    $(document).on('click','.cf-select', function (e) {
        e.stopPropagation();

        if($(this).hasClass('active')) {
            $(this).each(function () {
                $(this).removeClass('active').next('ul.cf-options').hide();
            });
        } else {
            $(this).toggleClass('active').next('ul.cf-options').toggle();
        }

    });


    $(document).on('click','.cf-options li', function (e) {
        e.stopPropagation();
        $(this).parent().prev('.cf-select').find('span').text($(this).text());
        $(this).parent().prev('.cf-select').removeClass('active');
        $(this).parent().prev().prev('.select-hidden').data('key',$(this).attr('rel'));
        $(this).val($(this).attr('rel'));
        $(this).parent().hide();
        $(this).parent().find('li').removeClass('selected');
        $(this).addClass('selected');

    });


    $(document).click(function () {
        $('.cf-select').removeClass('active');
        $('.cf-options').hide();
    });

    $('#side-nav-toggle').on('custom_ajax_done',function(event,result,trigger){
        if(result[0] == 'OK') {
            menu_state = menu_state == 1 ? 0 : 1;
        }
         
    });

    $('.menu-group-header').on('click', function() {
        var group = $(this).parent('.menu-group');
        var details = $(this).children('.menu-group-blocks');

        if(group.hasClass('open')) {
            group.removeClass('open');
        } else {
            animateCSS(details,'slideInDown');
            group.addClass('open');
        }
    });

    /*Kérdőív előnézet ablakkal kapcsolatos dolgok*/

    
	/*itt vezerelme globalisan a select becsukast*/
	$(window).on('resize',function(){		
		$('.bootstrap-select.show .selectpicker').selectpicker('toggle');		
    });
    
    $(document).on('shown.bs.collapse', function(event){
        event.target.scrollIntoView({behavior: 'smooth'});
    });

    $(document).on('click', 'a.contact', function() {
        stopLoader();
    });
});

function langCodeConvert(langCode) {
    switch(langCode) {
        case 'hu': return'HUN'; 
        case 'en': return 'ENG'; 
        case 'si': return 'SLO'; 
        case 'fr': return 'FRA'; 
        default: return langCode;
    }
}

/*Ajax a menü állapotának elmentésére*/
function ajax_call_auth_set_menu_state(state){
	var data = {
		"nyitva": state
    };
    
    resultText = {};

	postApi('auth_set_menu_state',data,$('#side-nav-toggle'),resultText);

}

function handleCacheClear(ajax){
    $('#' + ajax).click(function(e){
        e.preventDefault();
        var faSync = $(this).find('.fa-sync-alt');
        faSync.addClass('fa-pulse');
        postApi(ajax,{},this,null,null,function(d){
            faSync.removeClass('fa-pulse');
            page_reload();
        });
    });
}



/*Oldalsó menü eltüntetése és megjelenítése*/
function toggle_sidebar(isAnimated, stateChange) {

    /*Menü állapotának megváltoztatása és elmentése*/
    if(stateChange) {
        ajax_call_auth_set_menu_state(menu_state == 1 ? 0 : 1);
    }

    if(isAnimated || isMobileView()) {
        $('#wrapper').addClass('animate');

        $('#side-nav').toggleClass('side-nav-hidden');
        $('#wrapper').toggleClass('side-nav-hidden');
        toggleClasses($('#side-nav'), 'sideNavOut', 'sideNavIn', $('#side-nav').hasClass('side-nav-hidden') ? 'sideNavOut' : 'sideNavIn');
    } else {
        $('#wrapper').removeClass('animate');
        $('#side-nav').removeClass('sideNavOut');
        $('#side-nav').removeClass('sideNavIn');
        
        $('#side-nav').toggleClass('side-nav-hidden');
        $('#wrapper').toggleClass('side-nav-hidden');
    }
}

/*van-e joga */
function hasRight(right){
    return isDefined(felhasznalo_jogai) && felhasznalo_jogai.indexOf(right) != -1 ? true : false;
}

function set_editor_flag(nyelvkod){
    var flags = {
        'hu': '[[$p.flag_hu.png]]',
        'en': '[[$p.flag_gb.png]]',
        'de': '[[$p.flag_de.png]]'
    };
    if(flags[nyelvkod] !== undefined){
        $('.editor-flag-icon').attr('src', flags[nyelvkod]);
    }
}
function set_language_dropdown(elem,activeOnly){
    $(elem).html('');
    for(var i in nyelv_lista){
        if(activeOnly == true && nyelv_lista[i].active != 1){ continue; }
        $(elem).append('<option value="'+nyelv_lista[i].lang_code+'">'+nyelv_lista[i].lang_name+'</option>');
    }
}

function ckeditor_install(id){
    return CKEDITOR.replace(id,
        {'toolbar': [
            { name: 'document', items: [ 'Preview' ] },
            { name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
            { name: 'editing', items: [ 'Find', 'Replace', '-', 'SelectAll', '-', 'Scayt' ] },
            { name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
            { name: 'links', items: [ 'Link', 'Unlink' ] },
            { name: 'insert', items: [ 'Image', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'Iframe' ] },
            '/',
            { name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat' ] },
            { name: 'styles', items: [ 'Styles', 'Format', 'Font', 'FontSize' ] },
            { name: 'colors', items: [ 'TextColor', 'BGColor' ] },
            { name: 'tools', items: [ 'Maximize', 'ShowBlocks', 'Source' ] }
        ],
        extraPlugins: 'uploadimage',
        imageUploadUrl: '/' + act_lang + '/ajax/uploads_pic_upload_ck/',
        filebrowserImageUploadUrl: '/' + act_lang + '/ajax/uploads_pic_upload_ck/'
    });
    /*tinymce.init({
        selector: '#'+id
      });*/
}

function page_reload(){
    startLoader();
    location.reload ? location.reload() : location.href = location.href;
}

function page_forward(href){
    startLoader();
    location.href = href;
}

function loader_on(container){
    if(container.find('.loader').length == 0){
        container.prepend('<div class="loader"><span><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><span class="sr-only">[[$t.ujratoltes]]</span></span></div>');
    }
}

function loader_off(container){
    container.find('.loader').remove();
}

function setCookie(name,value,days) {
    var expires = "";
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + (value || "")  + expires + "; path=/";
}

function getCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function eraseCookie(name) {
    document.cookie = name+'=; Max-Age=-99999999;';
}

/*Két állapot között tud léptetni*/
function toggleClasses(elem,class1,class2,initial) {
    if(isDefined(class1) && class1 != '' && isDefined(class2) && class2 != '') {
        if(elem.hasClass(class1)) {
            elem.removeClass(class1);
            elem.addClass(class2);
        } else if(elem.hasClass(class2)) {
            elem.removeClass(class2);
            elem.addClass(class1);
        }
    }

    if(isDefined(initial) && initial != '' && (!elem.hasClass(class1) && !elem.hasClass(class2))) {
        elem.addClass(initial);
    }


}

function startLoader() {
    $('#loader-wrapper').removeClass('vhide');
}

function stopLoader() {
    $('#loader-wrapper').addClass('vhide');
}

function isMobileView() {
    return ($(window).width() <= 768);
}

function get_jog_valtozasok() {

    var arr = [];

    /*Akiket hozzá kell adni*/
    var innerArr = $('.cf-jog').toArray();
    for (var i in innerArr) {
        var kod = innerArr[i].dataset.kod;
        if( $('.gj-'+kod).find('input').is(':checked') && !$('.gj-'+kod).hasClass('gj-orig')) {
            var obj = {
                "elemi_jog_kod": kod,
                "hozzaadas": true
            };

            if(arr.length == 0 || $.grep(arr, function(n,i) { return n.elemi_jog_kod == kod}).length == 0) {
                arr.push(obj);
            }
            
        }
    }

    /*Akiket el kell venni*/
    innerArr = $('.gj-orig').toArray();
    for (var i in innerArr) {
        var kod = innerArr[i].dataset.kod;
        if( !$('.gj-'+kod).find('input').is(':checked')) {
            var obj = {
                "elemi_jog_kod": kod,
                "hozzaadas": false
            };

            if(arr.length == 0 || $.grep(arr, function(n,i) { return n.elemi_jog_kod == kod}).length == 0) {
                arr.push(obj);
            }

        }
    }

    return arr;
}

/*Kép url-ek kinyerese*/
function get_img_urls(img_url){
    var img_urls = {};

    if(img_url !== undefined && img_url !== null){
        img_urls.orig = '/out/upload/' + img_url;
        img_urls.small = '/out/upload/small_' + img_url;
    }
    else{
        img_urls.orig = img_urls.small = '[[$p.default.jpg]]';
    }
    return img_urls;
}

/*Animációk*/
function animateCSS(elem,class_param,callback){
	$(elem).addClass('animated '+class_param);
	$(elem).one('animationend oAnimationEnd mozAnimationEnd webkitAnimationEnd', function(){
		$(elem).removeClass('animated '+class_param);
		if(callback != undefined){
			callback();
		}
    });

    if(detectIE()) {
        setTimeout(function() {
            if(callback != undefined){
                console.log('cb');
                callback();
            }
        }, 1500);
    }
}

/*Kiszámolja a megadott fogalmakhoz a dátumokat*
function computeDates(type) {
    var date = new Date();
    var ma = getDate(date);

    var ret = {};

    switch(type) {
        case 'ma':

            ret.kezdet = ma.year + '.' + (ma.month<10 ? '0' : '') + ma.month + '.' +(ma.day<10 ? '0' : '') + ma.day + ' 00:00:00';
            ret.veg = ma.now;
            ret.most = ma.now;
        break;
        case 'tegnap': 
            var ydate = new Date();
            ydate.setDate(date.getDate() - 1);

            var tegnap = getDate(ydate);

            ret.kezdet = tegnap.year + '.' + (tegnap.month<10 ? '0' : '') + tegnap.month + '.' +(tegnap.day<10 ? '0' : '') + tegnap.day + ' 00:00:00';
            ret.veg = tegnap.year + '.' + (tegnap.month<10 ? '0' : '') + tegnap.month + '.' +(tegnap.day<10 ? '0' : '') + tegnap.day + ' 23:59:59';
            ret.most = ma.now;
        break;
        case 'het':
            var first = date.getDate() - date.getDay() + 1; 
            var last = first + 6; 
        
            var firstday = new Date(date.setDate(first));
            var lastday = new Date(date.setDate(last));

            var hetfo = getDate(firstday);
            var vasarnap = getDate(lastday);

            ret.kezdet = hetfo.year + '.' + (hetfo.month<10 ? '0' : '') + hetfo.month + '.' +(hetfo.day<10 ? '0' : '') + hetfo.day + ' 00:00:00';
            ret.veg = vasarnap.year + '.' + (vasarnap.month<10 ? '0' : '') + vasarnap.month + '.' +(vasarnap.day<10 ? '0' : '') + vasarnap.day + ' 23:59:59';
            ret.most = ma.now;

        break;
        case 'sajat':
            var kezdet = getDate($("#kezdo_datum_input").datetimepicker('viewDate')._d);
            var veg = getDate($("#veg_datum_input").datetimepicker('viewDate')._d);
            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet.day + ' ' + (kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute + ':' + (kezdet.second<10 ? '0' : '') + kezdet.second;
            ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg.day<10 ? '0' : '') + veg.day + ' ' + (veg.hour<10 ? '0' : '') + veg.hour + ':' + (veg.minute<10 ? '0' : '') + veg.minute + ':' + (veg.second<10 ? '0' : '') + veg.second;
            ret.most = ma.now;
        break;
        case 'sajat+':
            var kezdet = getDate($("#kezdo_datum_input").datetimepicker('viewDate')._d);
            var veg = getDate($("#veg_datum_input").datetimepicker('viewDate')._d);
            console.log(kezdet);
            kezdet_elso = moment().startOf('month', kezdet.month).date();
            veg_utolso = moment().endOf('month', kezdet.month).date();
            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet_elso + ' ' + (kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute + ':' + (kezdet.second<10 ? '0' : '') + kezdet.second;
            ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg_utolso<10 ? '0' : '') + veg_utolso + ' ' + '23:59:59';
            ret.most = ma.now;
        break;
        default:
            var kezdet = new Date(1,0);
            var veg = new Date(3000,0);
            ret.kezdet = kezdet.year + '.' + (kezdet.month<10 ? '0' : '') + kezdet.month + '.' +(kezdet.day<10 ? '0' : '') + kezdet.day + ' ' + (kezdet.hour<10 ? '0' : '') + kezdet.hour + ':' + (kezdet.minute<10 ? '0' : '') + kezdet.minute + ':' + (kezdet.second<10 ? '0' : '') + kezdet.second;
            ret.veg = veg.year + '.' + (veg.month<10 ? '0' : '') + veg.month + '.' +(veg.day<10 ? '0' : '') + veg.day + ' ' + (veg.hour<10 ? '0' : '') + veg.hour + ':' + (veg.minute<10 ? '0' : '') + veg.minute + ':' + (veg.second<10 ? '0' : '') + veg.second;
            ret.most = ma.now;
        break;
    } 

    return ret;
}*/

/*Stringgé alakítja a dátumot*/
function getDate(date) {
    var ret =  {
        year : date.getFullYear(),
        month : date.getMonth()+1,
        day : date.getDate(),
        hour : date.getHours(),
        minute : date.getMinutes(),
        second : date.getSeconds(),
    };

    ret.now =  ret.year + '.' + (ret.month<10 ? '0' : '') + ret.month + '.' +(ret.day<10 ? '0' : '') + ret.day + ' ' + (ret.hour<10 ? '0' : '') + ret.hour +':'+ (ret.minute<10 ? '0' : '')+ret.minute+':'+(ret.second<10 ? '0' : '')+ret.second;

    return ret;
}

/*optimalizaltabb mint a filter*/
function findInArray(arr, kod, ertek) {
    for(var i in arr){
        if(arr[i][kod] == ertek){
            return arr[i];
        }
    }
    return undefined;
}

function findInArray2(arr, kod, belsoArr) {
    for(var i in arr){
        if($.inArray(arr[i][kod],belsoArr) > -1){
            return arr[i];
        }
    }
    return undefined;
}

function filterArray(arr, kod, ertek) {
    return arr.filter(function(elem){
        return elem[kod] == ertek;
    });
}

function filterArray2(arr, kod, belsoArr) {
    return arr.filter(function(elem) {
        return $.inArray(elem[kod],belsoArr) > -1;
    });
}

function filterArray2_2(arr, kod, belsoArr) {
    return arr.filter(function(elem) {
        return $.inArray(elem[kod],belsoArr) > -1 
                || 
                (
                    $.isArray(elem[kod])
                    &&
                    concatArraysUnique(elem[kod],belsoArr).length > 0
                );
    });
}

var concatArraysUnique = function (thisArray, otherArray) {
    if(!$.isArray(thisArray)) {
        return [];
    }
    var ret = $.map(thisArray, function(el){
        return $.inArray(el, otherArray) < 0 ? null : el;
    });

    return ret;
};

function findInArraySlice(arr, kod, s, ertek) {
    var ret = arr.filter(function(elem){
        return elem[kod].slice(0,s) == ertek;
    });

    return isDefined(ret) ? ret[0] : undefined;
}

function devLog(input, label) {
    if(!isDefined(label)) {label = '';}
    if(srv == "dev") {
        /*console.log(label);
        console.log(input);*/
    }
    
}

function uniqueByField(array, property) {
    var seged = [];
    var ret = [];
    for(var i in array) {
        if($.inArray(array[i][property], seged) < 0) {
            ret.push(array[i]);
            seged.push(array[i][property]);
        }
    }
    return ret;

}

function nvlToString(value) {
    return (value == undefined || value == null) ? '' : value;
}



function inValues(elem, values) {
    for(var i in values) {
        if(elem == values[i]) {
            return true;;
        }
    }
    return false;;
}

var findIndex = function(arr, fn) {
    return arr.reduce(function(carry, item, idx) {
        if(fn(item, idx)) {
            return idx;
        }

        return carry;
    } , -1);
};


function langSelectorRearrange(data, active) {
    var hasLang = findInArray(tmp_langs, 'lang_code', data.nyelv_kod);
    if(isDefined(hasLang)) {
        for(var i in tmp_langs) {
            if(tmp_langs[i].lang_code == data.nyelv_kod) {
                tmp_langs[i].active = active;
            }
        }
    } else {
        tmp_langs.push({
            lang_code: data.nyelv_kod,
            lang_name: data.nyelv_nev,
            active: active
        });
    } 

    var lang_selector = filterSelectHtml({
            id: 'nyelv_valaszto',
            placeholder: '[[$t.nyelv]]',
            name: 'eszkoz_select_input',
            maxOptions: 1,
            addclass: 'form',
            isLangSelect: true
        },
        filterSelectValues(tmp_langs , 'lang_name', 'lang_code')
    );

    $('#lang-selector').html(lang_selector);
    $('#nyelv_valaszto').selectpicker();
    $('#nyelv_valaszto').selectpicker('val', act_lang);

    $('#nyelv_valaszto').on('change', function(){
        var lang = $(this).val();
        if(lang == '') {
            $('#nyelv_valaszto').selectpicker('val', act_lang);
        } else if(lang != act_lang) {
            var path = window.location.pathname.replace('/'+act_lang+'/', '');
            page_forward('/' + lang + '/' + path);
        }
        
    });
}

function ajax_call_kapcsolat(token){;
	var data = {
		"nev": $('#kapcsolat_form_name').val(),
        "email": $('#kapcsolat_form_email').val(),
        'cegnev': $('#kapcsolat_form_company_name').val().length < 1 ? '-' : $('#kapcsolat_form_company_name').val(),
        "telefon": $('#kapcsolat_form_telefon').val(),
        "uzenet": $('#kapcsolat_form_message').val(),
        "mit_ker": $('[name="requestType"]:checked').val()!= undefined ? $('[name="requestType"]:checked').val() : 'contact_default',
        "captcha": token
	};

	var resultText = {
		email_vagy_telefon_kotelezo: '[[$t.email_vagy_telefon_kotelezo]]',
	};

    postApi('kapcsolat',data,$('#btn_kapcsolat_uzenet'),resultText,null,function(result){
        
    });

	grecaptcha.reset();
    gi_alert('[[$t.uzenet_elkuldve]]');
    gtag('event', 'conversion', {'send_to': _gt+'/efPHCJa8m74DEITnz7Qo'});
    console.log('dd', _gt+'/efPHCJa8m74DEITnz7Qo');
}

function formatDate(dateString, useFormat=false) {
    if(dateString == null) return '';
    var dateSplit = dateString.split(' ');
    var datum = '';
    if(useFormat) {
        datum = moment(dateSplit[0], act_lang_formatum.toUpperCase());
    } else {
        datum = moment(dateSplit[0]);
    }
        
    return datum.format( act_lang_formatum.toUpperCase()) + ' ' + (isDefined(dateSplit[1]) ? dateSplit[1] : '');
}


function toGlobalDateFormat(str) {
    var strSplit = str.split('/');

    var honap = '';
    if(isDefined(strSplit[1])) {
        honap = (parseInt(strSplit[1]) < 10 ? '0'+strSplit[1] : strSplit[1]);
    } 




    if(act_lang_formatum == 'YYYY.mm.dd') {
        return strSplit[0] + (honap.length > 0 ? '.' + honap : '');
    } else {
        return (honap.length > 0 ? honap + '.' : '') +strSplit[0];
    }
}

/*Objectből tömböt csinál úgy, hogy az objektumban lévő key lesz a tömbben az index*/
function objectToArray(obj) {
    var ret = [];
    for(var i in obj) {
         ret[i] = obj[i];
    }

    return ret;
}

/*Átkerült ide a jelentesek.js-ből, mert a datatables is használja már*/
function szarmaztatottErtekSzamitas(tipus,sor,nps,ces,grafikonIndex) {
    if(grafikonIndex == undefined) { grafikonIndex = null; }
    if(nps) {
        var osszes = parseInt(sor[0]) + parseInt(sor[1]) + parseInt(sor[2]);
        var promoters = (parseInt(sor[0]) / osszes);
        var detractors = (parseInt(sor[2]) / osszes);

        if(osszes == 0) {
            return 'N/A';
        } else {
            return ((promoters - detractors)*100).toFixed(1) +'%';
        }
    }else if(ces){
        var osszes = parseInt(sor[0]) + parseInt(sor[1]) + parseInt(sor[2]);
        var promoters = (parseInt(sor[0]) / osszes);
        var detractors = (parseInt(sor[2]) / osszes);

        if(osszes == 0) {
            return 'N/A';
        } else {
            return ((promoters - detractors)*100).toFixed(1) +'%';
        }
    }
    
        /*2021.06.17 - új algoritmus
            1-10 skála esetén: 
            (n10+n9*(1-1/(10-1))+n8*(1-2/(10-1))+n7*(1-3/10-1))+n6*(1-4/(10-1))*n5*(1-5/(10-1))+n4*(1-6/(10-1))+n3*(1-7/(10-1))+n2*(1-8/(10-1))+n1*0))/(n10+n9+n8+n7+n6+n5+n4+n3+n2+n1)
         */
    else if (tipus == 'szamok-1-10' 
    || tipus == 'szamok-0-10' 
    || tipus == "ertekek-5" 
    || tipus.slice(0,8) == 'ikonok-5' 
    || tipus.slice(0,8) == 'ikonok-4' 
    || tipus == 'szamok-1-5' 
    || tipus == 'szamok-1-6') {
        var max = 1;

        if(tipus == 'szamok-1-10') { max = 10; }
        else if(tipus.slice(0,8) == 'ikonok-5') { max = 5; }
        else if(tipus.slice(0,8) == 'ikonok-4') { max = 4; }
        else if (tipus == 'szamok-1-6') { max = 6; }
        else if (tipus == 'szamok-1-5') { max = 5; }
        else if (tipus == 'szamok-0-10') { max = 11; }
        else if (tipus == "ertekek-5") { max = 5; }
        var html = '';
        var html2 = '';
        var step = 0;
        var szamlalo = 0;
        var nevezo = 0;
        for(var i in sor) {
            var Ni = grafikonIndex != null ? parseInt(sor[i].data[grafikonIndex]) : parseInt(sor[i]);

            szamlalo += Ni * (1 - (step/(max-1)));
            html += Ni+'*(1-('+step+'/'+(max-1)+')) + ';
            nevezo += Ni;
            html2 += Ni + ' + ';

            step++;
        }

        var ertek = (szamlalo / nevezo) * 100;
        ertek = ertek.toFixed(1);
        
        if(!$.isNumeric(ertek)) {
            ertek = 'N/A';
        } else {
            ertek += '%';
        }

        return ertek;
    }
    else if(tipus == 'igen_nem') {
        var osszes = parseInt(sor[0]) + parseInt(sor[1]);
        var kedvezo = parseInt(sor[0]);

        if(osszes == 0) {
            return 'N/A';
        } else {
            return Math.round((kedvezo / osszes).toFixed(2)*100) + '%';
        }
    }

    return null;

}

function detectIE() {
     
    try {
 
        var isIE = /*@cc_on!@*/false || !!document.documentMode;
 
        if ( ! isIE ) {
            if ( navigator.userAgent.indexOf("MSIE") > 0 ) {
                return true;    
            } else {
                return false;
            }
        }
 
        return true;
 
    } catch(e) {
 
        var error = e.toString();
 
        console.log(error);
    }
}