/* v1 */
/* ajax feltoltes esetre ne keljen ujra irni majd az egeszet*/
var ajaxDebugResult = {};
var ajaxDebug = false;
function callAjax(method, api, data, dataType, contentType, headers, processData, crossDomain, domain, beforeSend, onSuccess, onError, onAlways, type) {

    var api_url = "/" + act_lang + "/ajax";
    var url = '';
    var xhrFields = {};

    /*crossDomain mode*/
    if (crossDomain) {
        url = domain;
        xhrFields = {
          withCredentials: true
        };
    } else if (isDefined(type) && type == 'webservice') {
        url = "/webszerviz";
        xhrFields = {
            withCredentials: true
        };
    } else if(isDefined(type) && type == 'module') {
        url = "/"+act_lang;
        xhrFields = {
            withCredentials: true
        };
    }
     else if (window.location.origin !== api_url) {
        crossDomain = true;
        url = api_url;
        xhrFields = {
            withCredentials: true
        };
    } 
    $.ajax({
        method: method,
        url: url + "/" + api + "/",
        data: data,
        dataType: dataType,
        contentType: contentType,
        headers:headers,
        processData: processData,
        crossDomain: crossDomain,
        xhrFields: xhrFields,
        beforeSend: beforeSend,
        timeout:0
    })
    .fail(onError)
    .always(onAlways)
	.done(onSuccess);
}

function callApi(method, api, data, element, resultText, triggerParam, onSuccess, isWebservice) {
    var calltype = 'normal';
    var holder = $(element);
    /*ez akkor van ha nincs elemhez kotve a hivas ilyenkor kb a fele se kell az ellenorzeseknek*/
    if (!isDefined(element) || element == null) {
        calltype = 'not_bound';
    }else if($(element).hasClass('ajax')){
        calltype = 'ajax';
    }else if($(element).closest('form').length != 0){
        calltype = 'form';
        holder = $(element).closest('form');
    }
    else if($(element).closest('td.edit-input').length != 0){
		calltype = 'table_input';
		holder = $(element).closest('td.edit-input');
	}
    else if($(element).closest('table').length != 0){
        calltype = 'table';
        holder = $(element).closest('table');
    }

    /*ha van kozelezo mezo akkor ne menjen tovabb*/
    if((calltype == 'form' || calltype == 'table_input') && !checkRequiredInput(holder)){
        return;
    }

    var beforeSend = function(jqXHR, settings) {
        if (calltype != 'not_bound') {
            if (holder.hasClass('animation-load')) {
                jqXHR.abort();
            } else {
                /*input block*/
                inputAnimationHandler(element, true);
            }
        }
    };

    var onError = function(result, textStatus, errorThrown) {
    };

    var onAlways = function(result, textStatus, errorThrown) {
        
        /*input ujraengedelyezes*/
        if(!isDefined(result[0]) || result[0] != 'OK' || !holder.hasClass('hold-disable')){
            inputAnimationHandler(element, false);
        }
    };

    var innerOnSuccess = function(rawResult, textStatus, errorThrown) {
        /*szoveg cimke forditas*/
        result = commonResultHandler(calltype, holder, rawResult, resultText, triggerParam, element);

		/*debug funkcio*/
        if(ajaxDebug || hasRight('dev_funkciok')){
            ajaxDebugResult[$.now()] ={
                ajaxName: api,
                calltype : calltype,
                CallParameters : data,
                RawResult : rawResult,
                ProcessedResult : result
            };
        }

        if (calltype != 'not_bound') {
            $(element).trigger('custom_ajax_done', [result, triggerParam]);            
        }

        if (isDefined(onSuccess) && onSuccess !== null) {
            onSuccess(result);
        }
    };

    callAjax(method, api, data, 'json', 'application/x-www-form-urlencoded; charset=UTF-8', {}, true, false, null, beforeSend, innerOnSuccess, onError, onAlways, isWebservice);
}

function getApi(api, data, element, resultText, triggerParam, onSuccess) {
    callApi('GET', api, data, element, resultText, triggerParam, onSuccess);
}

function postApi(api, data, element, resultText, triggerParam, onSuccess, isWebservice) {
    callApi('POST', api, data, element, resultText, triggerParam, onSuccess, isWebservice);
}

async function apiFetch({endpoint, formData}) {
    var myHeaders = new Headers();
    
    var requestOptions = {
      method: 'POST',
      headers: myHeaders,
      body: formData,
      credentials: "include",
      redirect: 'follow'
    };
    
    return await fetch(window.location.origin + "/" + act_lang + "/" + "ajax/" + endpoint, requestOptions);
}