<?php

    // idozona beallitasa
    date_default_timezone_set('Europe/Budapest');
    $home_page_style = $g['module'] == 'home' || 
    $g['module'] == 'kapcsolat' || 
    $g['module'] == 'adatvedelmi-nyilatkozat' || 
    $g['module'] == 'impresszum' ||
    $g['module'] == 'bejelentkezes' ||  
    $g['module'] == 'elfelejtett-jelszo' ;

    $is_kerdoiv = $g['module'] == 'kerdoiv' || $g['module'] == 'kerdoiv-elonezet' || $g['module'] == 'kerdoiv-mobil';

    // includables listajanak letrehozasa
    if($home_page_style) {
        $g['index_includables_js'] = array(
            'jquery-3.3.1.min.js',
            'bootstrap-3.4.1-dist\js\bootstrap.min.js',
            'bootstrap-select-1.13.5/js/bootstrap-select.min.js'
        );
        $g['index_includables_css'] = array(
            'bootstrap-3.4.1-dist/css/bootstrap.min.css',
            'bootstrap-select-1.13.5/css/bootstrap-select.min.css',
            'fontawesome-free-5.5.0-web/css/all.min.css',
            'animate.min.css',
            'slavko_flags/css/flags.css'
        );
    } else {
        $g['index_includables_js'] = array(
            'jquery-3.3.1.min.js',
            'bootstrap-4.1.3-dist/js/bootstrap.bundle.min.js',
            'bootstrap-select-1.13.5/js/bootstrap-select.min.js',
            'dtpicker/js/moment.js'
        );
        $g['index_includables_css'] = array(
            'bootstrap-4.1.3-dist/css/bootstrap.min.css',
            'bootstrap-select-1.13.5/css/bootstrap-select.min.css',
            'fontawesome-free-5.5.0-web/css/all.min.css',
            'animate.min.css',
            'slavko_flags/css/flags.css'
        );
    }

    // rendszerparameterek atadasa a feluletnek
    \GI\Functions::add_rendszerparameter_to_te('ga_kovetokod');

    $g['te']->add('global_kezdo_datum', $g['db_db']->get_one_rendszerparameter('global_kezdo_datum')[0]['ertek']);

    // valaszthato partnerek listajanak atadasa a feluletnek
    if (UserFunctions::is_logged_in()) {
        $valaszthato_partnerek = $g['db_db']->valaszthato_partnerek_sel($_SESSION['user']['id']);
    } else {
        $valaszthato_partnerek = [];
    }
    $g['te']->add('valaszthato_partnerek',json_encode($valaszthato_partnerek));

    // beloginolt felhasznalo neve
    $g['te']->add('felhasznalo_neve',\UserFunctions::hasGlobalOrPartnerRightAfterLogin('login') ? $_SESSION['user']['nev'] : '');

    // meglevo jogok atadasa a feluletnek
    sort($g['jogok']);
    $g['te']->add('felhasznalo_jogai',json_encode($g['jogok']));
    $felhasznalo_jogai_szovegek = $g['db_db']->elemi_jog_szovegek_sel();
    $felhasznalo_jogai_szovegek = array_combine(array_column($felhasznalo_jogai_szovegek, 'kod'), array_column($felhasznalo_jogai_szovegek, 'nev'));
    foreach ($g['jogok'] as $jog) {
        if (!array_key_exists($jog, $felhasznalo_jogai_szovegek)) {
            unset($felhasznalo_jogai_szovegek[$jog]);
        }
    }
    $g['te']->add('felhasznalo_jogai_szovegek',json_encode($felhasznalo_jogai_szovegek));

    $g['te']->add('mas_neveben_vagyunk_bejelentkezve',(int)isset($_SESSION['old_user']));
    $g['te']->add('logged_in',\UserFunctions::hasGlobalOrPartnerRightAfterLogin('login') ? 1 : 0);
    $g['te']->add('home_page_style', $home_page_style ? 1 : 0);
    $g['te']->add('is_kerdoiv', $is_kerdoiv ? 1 : 0);

    // nyelv listanak az atadasa a feluletnek
    $lang_list = $g['db_db']->get_lang_list();
    $g['te']->add('nyelv_lista',json_encode($lang_list));

    // az alapertelmezett nyelv atadasa a feluletnek
    $g['te']->add('alapertelmezett_nyelv', GI_DEFAULT_LANG);

    // google reCaptcha site key atadasa a feluletnek
    $g['te']->add('recaptcha_site_key', CAPTCHA_SITE_KEY);

    // menu state atadasa a feluletnek
    $g['te']->add('menu_state', $_SESSION['menu_state'] ?? 1);


    $nyelvFormatum = $g['db_db']->get_formatum_of_lang($g['lang'])[0]['formatum'];
    $g['te']->add('act_lang_formatum', $nyelvFormatum);