<?php

    namespace A;

    class telephelyek_hozzarendelese_regiokhoz extends \GI\Ajax{

        public $rights_required = array(
            'telephelyek_hozzarendelese_regiokhoz'
        );

        public $parameters = array(
            'regio_sn' => 'ex-regiok-id',
            'telephelystruktura' => 'telephelystruktura'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'regio', 'telephelyek_hozzarendelese_regiokhoz', $params['regio_sn'])){
                return ['HI', 'right_error'];
            }

            // partner sn lekerdezese regio sn-bol
            $partner_sn = $g['db_db']->get_partner_sn_of_regio($params['regio_sn'])[0]['id'];

            // telephelystruktura ellenorzese
            $telephelystruktura = json_decode($params['telephelystruktura'], true);
            $telephelyek = array_column($g['db_db']->get_telephelyek_id_of_partner($partner_sn), 'id');
            foreach ($telephelystruktura as $telephely) {
                if (!in_array($telephely['telephely_sn'], $telephelyek)) {
                    return ['HI', 'nem_ok_telephely_sn', $telephely['telephely_sn']];
                }
            }

            // hozzaadasok es torlesek elvegzese
            foreach ($telephelystruktura as $telephely) {
                if ($telephely['hozzaadas']) {
                    $g['db_db']->add_telephely_to_regio($params['regio_sn'], $telephely['telephely_sn'], $_SESSION['user']['id']);
                } else {
                    $g['db_db']->del_telephely_from_regio($params['regio_sn'], $telephely['telephely_sn']);
                }
            }

        }

    }
