<?php

    namespace A;

    class migralas_5_affidea_ge extends \GI\Ajax{

        public $rights_required = array(
            'dev_funkciok'
        );

        public $parameters = array(

        );

        public function ajax($params) {


            global $g;

            mb_internal_encoding('UTF-8');
            set_time_limit(600);

            // alap adatok: VALTOZO
            $partner_sn = 1;
            $kerdoiv_sn = 5;
            $telephely_orszag = 139;
            $telephely_irszam = 1111;
            $telephely_telepules = 'Budapest';
            $telephely_cim = 'Affidea u. 12';
            $telephely_email = 'affidea@affidea.hu';
            $telephely_telefon = '06201112222';

            //csv beolvasasa
            // VALTOZIK
            $fileHandle = fopen(GI_PATH_CACHE . "affidea_ge3.csv", "r");
            $csv = [];
            while (($row = fgetcsv($fileHandle, 0, ",")) !== false) {
                $csv []= $row;
            }
            // return $csv;

            // telephelyek letrehozasa
            $telephelyek = array_column($csv, 1);
            unset($telephelyek[0], $telephelyek[1]);
            $telephelyek = array_filter($telephelyek);
            $telephelyek = array_unique($telephelyek);
            $telephelyek = array_values($telephelyek);

            foreach ($telephelyek as $telephely) {
                $cnt = $g['db_db']->direct_call('
                    select count(*) as cnt from telephelyek where nev = ?
                ', [
                    $telephely
                ])[0]['cnt'];

                if ($cnt == '0') {
                    $g['db_db']->direct_call('
                        insert into telephelyek
                        (`nev`, `fk_partnerek`, `fk_orszag`, `iranyitoszam`, `telepules`, `cim`, `email`, `telefon`, `fk_users_creator`)
                        values (?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ', [
                        $telephely, $partner_sn, $telephely_orszag, $telephely_irszam, $telephely_telepules, $telephely_cim, $telephely_email, $telephely_telefon, 57
                    ]);

                    do {
                        $eszkoz_azonosito = mt_rand(10000, 99999) . '-' . mt_rand(10000, 99999);
                    } while(\GI\Functions::validate($eszkoz_azonosito,'nex-eszkozok-eszkoz_azonosito') !== true);

                    $jelentes_telephely_id = $g['db_db']->direct_call('
                            select id from telephelyek where nev = ?
                        ',
                        [
                            $telephely
                    ])[0]['id'];

                    $g['db_db']->direct_call('
                            insert into eszkozok
                            (`nev`, `eszkoz_azonosito`, `fk_telephelyek`, `fk_kerdoivek`, `fk_users_creator`)
                            values (?, ?, ?, ?, ?)
                        ',
                        [
                            $telephely,
                            $eszkoz_azonosito,
                            $jelentes_telephely_id,
                            $kerdoiv_sn,
                            57
                    ]);

                }

            }

            $a_eszkozok = $g['db_db']->direct_call('select id, nev from eszkozok', []);
            $a_eszkozok = array_combine(array_column($a_eszkozok, 'nev'), array_column($a_eszkozok, 'id'));

            $a_telephelyek = $g['db_db']->direct_call('select id, nev from telephelyek', []);
            $a_telephelyek = array_combine(array_column($a_telephelyek, 'nev'), array_column($a_telephelyek, 'id'));

            // jelentesek migralasa
            unset($csv[0], $csv[1]);
            $csv = array_values($csv);
            $jelentes_fejek = [];
            $jelentes_tetelek = [];
            $jelentes_fej_id = $g['db_db']->direct_call('select max(id) as id from jelentesek_fej', [])[0]['id'] + 1;
            // $stopper = 1;
            foreach ($csv as $kitoltes) {
                // if ($stopper >= 100) {
                    // break;
                // }
                $jelentes_created_at = $kitoltes[0];
                $jelentes_eszkoz_id = $a_eszkozok[$kitoltes[1]];
                $jelentes_telephely_id = $a_telephelyek[$kitoltes[1]];

                $jelentes_fejek = array_merge($jelentes_fejek, [
                    $jelentes_fej_id, $jelentes_eszkoz_id, $kerdoiv_sn, $jelentes_telephely_id, $partner_sn, 0, $jelentes_created_at
                ]);

                // VALTOZIK
                $kerdes_idk = [
                    2 => 30,
                    3 => 31,
                    4 => 32,
                    5 => 33,
                    6 => 34,
                    7 => 35,
                    8 => 36,
                    9 => 37,
                    10 => 38,
                    11 => 39,
                    12 => 2,
                    13 => 40,
                    14 => 41,
                    15 => 42,
                    16 => 43,
                    17 => 44,
                ];
                // VALTOZIK
                for ($i = 2; $i < 18; $i++) {
                    if ($kitoltes[$i] != 'N/A') {
                        switch ($i) {
                            // VALTOZIK
                            case 2:
                                // VALTOZIK
                                $kapcsolotabla = [
                                    'GE dolgozó' => 1,
                                    'Affidea ügyfél' => 2
                                ];
                                $valasz_sorszam = $kapcsolotabla[$kitoltes[$i]];
                                $valasz_ertek = null;
                                break;
                            case 3:
                                // VALTOZIK
                                $kapcsolotabla = [
                                    'Foglalkozás-egészségügyi vizsgálat' => 1,
                                    'Szakorvosi vizsgálat' => 2
                                ];
                                $valasz_sorszam = $kapcsolotabla[$kitoltes[$i]];
                                $valasz_ertek = null;
                                break;
                            case 7:
                                // VALTOZIK
                                $kapcsolotabla = [
                                    'Azonnal a beleegyező nyilatkozatok kitöltése után' => 1,
                                    '10-15 percet kellett várnom' => 2,
                                    '20-40 percet kellett várnom' => 3,
                                    'Több, mint 1 órát kellett várnom' => 4
                                ];
                                $valasz_sorszam = $kapcsolotabla[$kitoltes[$i]];
                                $valasz_ertek = null;
                                break;
                            case 11:
                                // VALTOZIK
                                $kapcsolotabla = [
                                    'MRI' => 1,
                                    'CT' => 2,
                                    'Röntgen' => 3,
                                    'Ultrahang' => 4,
                                    'Mammográfia' => 5,
                                    'Járóbeteg szakellátás' => 6,
                                    'Csontsűrűség mérés' => 7,
                                ];
                                $valasz_sorszam = $kapcsolotabla[$kitoltes[$i]];
                                $valasz_ertek = null;
                                break;
                            case 15:
                                // VALTOZIK
                                $kapcsolotabla = [
                                    'Azonnal a beleegyező nyilatkozatok kitöltése után' => 1,
                                    '10-15 percet kellett várakoznom' => 2,
                                    '30-40 percet kellett várakoznom' => 3,
                                    'Több mint 1 órát kellett várakoznom' => 4
                                ];
                                $valasz_sorszam = $kapcsolotabla[$kitoltes[$i]];
                                $valasz_ertek = null;
                                break;
                            case 12:
                                $valasz_sorszam = $kitoltes[$i] + 1;
                                $valasz_ertek = null;
                                break;
                            case 16:
                                $valasz_sorszam = (int)$kitoltes[$i] === 1 ? 1 : 2;
                                $valasz_ertek = null;
                                break;
                            case 10:
                            case 17:
                                $valasz_sorszam = 1;
                                $valasz_ertek = $kitoltes[$i];
                                break;
                            default:
                                $valasz_sorszam = $kitoltes[$i];
                                $valasz_ertek = null;
                                break;
                        }

                        $jelentes_tetelek = array_merge($jelentes_tetelek, [
                            $jelentes_fej_id, $kerdes_idk[$i], $kerdes_idk[$i], $valasz_sorszam, $valasz_ertek, $jelentes_created_at
                        ]);
                    }
                }
                $jelentes_fej_id++;
                // $stopper++;
            }

            $g['db_db']->direct_call('
                insert into jelentesek_fej
                (`id`, `fk_eszkozok`, `fk_kerdoivek`, `fk_telephelyek`, `fk_partnerek`, `ervenytelen`, `created_at`)
                values (?, ?, ?, ?, ?, ?, ?)' . str_repeat(', (?, ?, ?, ?, ?, ?, ?)', (count($jelentes_fejek) / 7) - 1)
                , $jelentes_fejek
            );

            $g['db_db']->direct_call('
                insert into jelentesek_tetel
                (`fk_jelentesek_fej`, `fk_kerdoivek_kerdesek`, `kerdes_azonosito`, `valasz_sorszam`, `valasz_ertek`, `created_at`)
                values (?, ?, ?, ?, ?, ?)' . str_repeat(', (?, ?, ?, ?, ?, ?)', (count($jelentes_tetelek) / 6) - 1)
                , $jelentes_tetelek
            );
        }

    }
