<?php

namespace A;

        require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class kikuldesi_statisztika_sel extends \GI\Ajax
{
    public $rights_required = [
        'tomeges_kikuldes'
    ];

    public $parameters = [
        'echo' => 'int',
        'idopont_tol' => 'valasz_ertek',
        'idopont_ig' => 'valasz_ertek',
        'ismerv-tipus_reszletez' => 'valasz_ertek',
        'csatorna_reszletez' => 'valasz_ertek',
        'ismerv-tipus_kulon' => 'valasz_ertek',
        'csatorna_kulon' => 'valasz_ertek',
       'kerdes_idk' => 'valasz_ertek',
       'beolvasas_idk' => 'beolvasas_id_arr',
        'eszkoz_idk' => 'eszkoz_id_arr',
        'partner_nev' => 'lang_text',
        'kerdoiv_idk' => 'eszkoz_id_arr',
      //  'partner_id' => 'ex_partnerek_id',
        'ismerv_idk' => 'eszkoz_id_arr',
        'ismerv_sorrend' => 'eszkoz_id_arr',
        'ismerv_sorrend_szoveggel' => 'valasz_ertek'
        //'ismerv_ertekek' => 'ismerv_ertekek_arr',
       // 'trend_tipus' => 'trend_tipus'
    ];

    public function ajax($params)
    {

        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => [
                    'argb' => 'FFFFFF',
                ]
            ],
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => [
                    'argb' => 'FFA0A0A0',
                ]
            ],
        ];

        $styleArrayCenter = [
            'font' => [
                'bold' => true,
                'color' => [
                    'argb' => 'FFFFFF',
                ]
            ],
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => [
                    'argb' => 'FFA0A0A0',
                ]
            ],
        ];

        $styleArrayBodyRight = [
          
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            ]
            
        ];
    
        $styleArray2 = [
            'font' => [
                'bold' => true,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            
        ];

        $styleHeader = [
            'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
            
        ];

        global $g;

        //$beolvasas_idk = json_decode($params['beolvasas_idk'], true);
        //$beolvasas_idk = '(' . implode(", ", $beolvasas_idk) . ')';

        $ismerv_idk = json_decode($params['ismerv_idk'], true);
        $beolvasas_idk = json_decode($params['beolvasas_idk'], true);
        $eszkoz_idk = json_decode($params['eszkoz_idk'], true);
        $ismerv_sorrend = json_decode($params['ismerv_sorrend'], true);
        $kerdoiv_idk = json_decode($params['kerdoiv_idk'], true);


        $ismerv_sorrend_szoveggel = json_decode($params['ismerv_sorrend_szoveggel'], true);

        $selectExpand = "";
        $groupByExpand = "";
        $whereExpand = "";
        $joinExpand = "";

        for($i = 1; $i <= count($ismerv_sorrend); $i++) {
            $selectExpand .= ",bsi".$i.".ismerv as ismerv" . $i;
            $groupByExpand .= ",bsi".$i.".ismerv";
            $whereExpand .= " and bsi".$i.".fk_ismervek IN (".$ismerv_sorrend[$i-1].") ";
            $joinExpand .= "\n left join beolvasas_sorok_ismervek bsi".$i."
            on bsi".$i.".fk_beolvasas_sorok = bs.id ";
        }

        $adatok = $g['db_db']->kikuldesi_statisztika_sel(
           // $params['partner_id'],
            //$params['ismerv_id'],
            $params['idopont_tol'],
            $params['idopont_ig'],
            
            [
                'beolvasas_idk' => $this->strArrToSelect($beolvasas_idk),
                'eszkoz_idk' => $this->strArrToSelect($eszkoz_idk),
                'kerdoiv_idk' => $this->strArrToSelect($kerdoiv_idk),
                'ismerv_idk' => $this->strArrToSelect($ismerv_idk),
                'select_expand' => $selectExpand,
                "group_by_expand" => $groupByExpand,
                "where_expand" => $whereExpand,
                "join_expand" => $joinExpand

            //    'ismerv_ertekek' => $this->strArrToSelect($ismerv_ertekek)
            ]
            
        );


        $filenames = [];
        $eszkozok = [];
        foreach($eszkoz_idk as $eszkoz_id) {
            $eszkoz = $g["db_db"]->get_eszkoz(
                $eszkoz_id
            );
            $eszkozok[$eszkoz_id] = $eszkoz[0]["nev"];
        }
        
        $out = [
            'echo' => $params['echo'],
            'data' => $adatok
        ];

        $tableRows = 0;

        $spreadsheet = new Spreadsheet();
        $activeWorksheet = $spreadsheet->getActiveSheet();
        $activeWorksheet->setCellValue('A2', "Kiküldési statisztika");
       // $activeWorksheet->setCellValue('A4', "Kérdőív:");
       // $activeWorksheet->setCellValue('B4', "Mind");
        $activeWorksheet->setCellValue('A4', "Csatorna:");
        $activeWorksheet->setCellValue('B4', implode("; ", $eszkozok) . ($params["csatorna_reszletez"] == "true" ? " részletez" : ""));
        $activeWorksheet->setCellValue('A5', "Ismérv típus");
        $activeWorksheet->setCellValue('B5', implode("; ", $ismerv_sorrend_szoveggel) . ($params["ismerv-tipus_reszletez"] == "true" ? " részletez" : ""));
        $activeWorksheet->setCellValue('A6', "Időszak");
        $activeWorksheet->setCellValue('B6', $params['idopont_tol'] . " - " . $params['idopont_ig']);

        $activeWorksheet->getStyle('A2:A6')->applyFromArray($styleArray2);
        $activeWorksheet->getStyle('A2:B6')->applyFromArray($styleHeader);




        $honapok = [];
        foreach($adatok as $adatSor) {
            $honapAzon = $adatSor["ev"] . "-" . $adatSor["honap"];
            if (!in_array($honapAzon, $honapok)) {
                array_push($honapok, $honapAzon);
            }
        }

        $spreadsheet->getDefaultStyle()->getNumberFormat()->setFormatCode('# ##0');

        
        $oszlopIndex = 3;
        $fejlecSorok = [NULL];
        foreach($honapok as $honapEgyseg) {
            $ev = explode("-", $honapEgyseg)[0];
            $honap = explode("-", $honapEgyseg)[1];
            array_push($fejlecSorok, "Kiküldött tételek " . $ev . ". " . $honap . ".");
            array_push($fejlecSorok, "Beérkezett tételek " . $ev . ". " . $honap . ".");
            array_push($fejlecSorok, "Válaszadási arány " . $ev . ". " . $honap . ".");

            $activeWorksheet->getStyle($this->numToChar($oszlopIndex) . ":" . $this->numToChar($oszlopIndex))->getNumberFormat()->setFormatCode(
                \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
            );
            $activeWorksheet->getStyle($this->numToChar($oszlopIndex) . ":" . $this->numToChar($oszlopIndex))->getNumberFormat()->setFormatCode('0.0%');
            $oszlopIndex += 3;
        }

        // main table start
        $mainSzamok = [
            
        ];

        foreach($adatok as $adatSor) {
            $azon = $adatSor["ev"] . "-" . $adatSor["honap"];
            $mainSzamok[$adatSor["fk_eszkozok"]][$azon . "-ki"] += $adatSor["kikuldott"];
            $mainSzamok[$adatSor["fk_eszkozok"]][$azon . "-be"] += $adatSor["beerkezett"];
            $mainSzamok[$adatSor["fk_eszkozok"]][$azon . "-arany"] = $mainSzamok[$adatSor["fk_eszkozok"]][$azon . "-be"] / $mainSzamok[$adatSor["fk_eszkozok"]][$azon . "-ki"];

            $mainSzamok["osszesen"][$azon . "-ki"] += $adatSor["kikuldott"];
            $mainSzamok["osszesen"][$azon . "-be"] += $adatSor["beerkezett"];
            $mainSzamok["osszesen"][$azon . "-arany"] = $mainSzamok["osszesen"][$azon . "-be"] / $mainSzamok["osszesen"][$azon . "-ki"];
        }

        $mainTable = 
        [
            $fejlecSorok
        ];


        array_push($eszkoz_idk, "osszesen");
        foreach($eszkoz_idk as $eszkoz_id) {
            if ($eszkoz_id == "osszesen") {
                $eszkoz_sor = ["Összesen:"];
            } else {
                $eszkoz_sor = [$eszkozok[$eszkoz_id]];
            }
            foreach($honapok as $honapEgyseg) {
                $ev = explode("-", $honapEgyseg)[0];
                $honap = explode("-", $honapEgyseg)[1];
                $azon = $ev . "-" . $honap;

                if ($mainSzamok[$eszkoz_id][$azon . "-ki"] == 0 || empty($mainSzamok[$eszkoz_id][$azon . "-ki"])) {
                    $mainSzamok[$eszkoz_id][$azon . "-ki"] = "N/A";
                }
                if ($mainSzamok[$eszkoz_id][$azon . "-be"] == 0 || empty($mainSzamok[$eszkoz_id][$azon . "-be"])) {
                    $mainSzamok[$eszkoz_id][$azon . "-be"] = "N/A";
                }
                if ($mainSzamok[$eszkoz_id][$azon . "-arany"] == 0 || empty($mainSzamok[$eszkoz_id][$azon . "-arany"])) {
                    $mainSzamok[$eszkoz_id][$azon . "-arany"] = "N/A";
                }

                array_push($eszkoz_sor, $mainSzamok[$eszkoz_id][$azon . "-ki"], $mainSzamok[$eszkoz_id][$azon . "-be"], $mainSzamok[$eszkoz_id][$azon . "-arany"]);
            }
            array_push($mainTable, $eszkoz_sor);
        }


        if ($params["csatorna_kulon"] != "true") {
            $tableRows += count($mainTable);

            $activeWorksheet->fromArray(
                $mainTable,  // The data to set
                NULL,        // Array values with this value will not be set
                'A11',         // Top left coordinate of the worksheet range where
                    true       //    we want to set these values (default is A1)
            );



            $activeWorksheet->getStyle(('B11') . ":" . $this->numToChar(count($mainTable[0])-1) . "11")->applyFromArray($styleArrayCenter);
            $activeWorksheet->getStyle("A11")->applyFromArray($styleArray);

            $activeWorksheet->getStyle(('A' . (10 + count($mainTable))) . ":" . ($this->numToChar(count($mainTable[0])-1)) . (10 + count($mainTable)) )->applyFromArray($styleArray2);
            $activeWorksheet->getStyle('B12' . ":" . ($this->numToChar(count($mainTable[0])-1)) . (10 + count($mainTable)) )->applyFromArray($styleArrayBodyRight);
        }

        // main table end

        // ismerv table start
        $csatornaIterate = $params["csatorna_reszletez"] == "true" ? (count($eszkoz_idk)-1) : 1;
         for($csatornaIndex = 0; $csatornaIndex < $csatornaIterate; $csatornaIndex++) {
            $upperLevel_ismerv_ertekek = [null, null];
            for($ismerv_table_level = 1; $ismerv_table_level <= count($ismerv_sorrend); $ismerv_table_level++) {
                $iterates = $params["ismerv-tipus_reszletez"] == "true" ? count($upperLevel_ismerv_ertekek)-1 : 1;
                for($upperLevelIndex = 0; $upperLevelIndex < $iterates; $upperLevelIndex++) {
                
                        
                    $ismervAzon = "ismerv" . $ismerv_table_level;
                    $ismerv_ertekek = [];
                    foreach($adatok as $adatSor) {
                        if (!in_array($adatSor[$ismervAzon], $ismerv_ertekek)) {
                            array_push($ismerv_ertekek, $adatSor[$ismervAzon]);
                        }
                    }

                    $ismervSzamok = [];
                    if ($params["csatorna_reszletez"] != "true") {
                        $fejlecSorok[0] = implode("; ", $eszkozok);
                    } else {
                        $fejlecSorok[0] = $eszkozok[$eszkoz_idk[$csatornaIndex]];
                    }
                    $ismervTable = [$fejlecSorok];
                    foreach($adatok as $adatSor) {
                        if (($params["csatorna_reszletez"] == "true" && $adatSor["fk_eszkozok"] == $eszkoz_idk[$csatornaIndex]) || $params["csatorna_reszletez"] == "false") {                       

                            $azon = $adatSor["ev"] . "-" . $adatSor["honap"];
                            $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-ki"] += $adatSor["kikuldott"];
                            $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-be"] += $adatSor["beerkezett"];
                            $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-upperLevelIsmerv"] = $adatSor["ismerv" . ($ismerv_table_level -1)];
                            $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-eszkoz"] = $adatSor["fk_eszkozok"];
                            $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-arany"] = $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-be"] / $ismervSzamok[$adatSor[$ismervAzon]][$azon . "-ki"];

                        if (($params["ismerv-tipus_reszletez"] == "true" && $adatSor["ismerv" . ($ismerv_table_level -1)] == $upperLevel_ismerv_ertekek[$upperLevelIndex]) || $params["ismerv-tipus_reszletez"] == "false") {
                            $ismervSzamok["osszesen"][$azon . "-ki"] += $adatSor["kikuldott"];
                            $ismervSzamok["osszesen"][$azon . "-be"] += $adatSor["beerkezett"];
                            $ismervSzamok["osszesen"][$azon . "-upperLevelIsmerv"] += $adatSor["ismerv" . ($ismerv_table_level -1)];
                            $ismervSzamok["osszesen"][$azon . "-eszkoz"] = $adatSor["fk_eszkozok"];
                            $ismervSzamok["osszesen"][$azon . "-arany"] = $ismervSzamok["osszesen"][$azon . "-be"] / $ismervSzamok["osszesen"][$azon . "-ki"];
                        }
                        }
                        
                    }


                    array_push($ismerv_ertekek, "osszesen");
                    foreach($ismerv_ertekek as $ismerv_ertek) {
                        $reszletezMatch = $params["ismerv-tipus_reszletez"] == "true" ? false : true;
                        $ismerv_sor = [$ismerv_ertek];
                        if ($ismerv_sor[0] == "osszesen" && $params["ismerv-tipus_reszletez"] == "true") {
                            $ismerv_sor[0] = $upperLevel_ismerv_ertekek[$upperLevelIndex] . " Összesen:";
                        } else if ($ismerv_sor[0] == "osszesen") {
                            $ismerv_sor[0] = "Összesen:";
                        }
                        foreach($honapok as $honapEgyseg) {
                            $ev = explode("-", $honapEgyseg)[0];
                            $honap = explode("-", $honapEgyseg)[1];
                            $azon = $ev . "-" . $honap;

                            if (($params["csatorna_reszletez"] == "true" && $ismervSzamok[$ismerv_ertek][$azon . "-eszkoz"] == $eszkoz_idk[$csatornaIndex]) || $params["csatorna_reszletez"] == "false") {
                                if ($params["ismerv-tipus_reszletez"] == "true" && $upperLevel_ismerv_ertekek[$upperLevelIndex] == $ismervSzamok[$ismerv_ertek][$azon . "-upperLevelIsmerv"] || $ismerv_ertek == "osszesen" || $params["ismerv-tipus_reszletez"] == "false") {
                                    if ($ismervSzamok[$ismerv_ertek][$azon . "-ki"] == null) $ismervSzamok[$ismerv_ertek][$azon . "-ki"] = 0;
                                    if ($ismervSzamok[$ismerv_ertek][$azon . "-be"] == null) $ismervSzamok[$ismerv_ertek][$azon . "-be"] = 0;
                                    if ($ismervSzamok[$ismerv_ertek][$azon . "-arany"] == null) $ismervSzamok[$ismerv_ertek][$azon . "-arany"] = 0;
                                    $reszletezMatch = true;
                                    
                                    array_push($ismerv_sor, $ismervSzamok[$ismerv_ertek][$azon . "-ki"], $ismervSzamok[$ismerv_ertek][$azon . "-be"], $ismervSzamok[$ismerv_ertek][$azon . "-arany"]);
                                } else {
                                    $reszletezMatch = true;

                                    array_push($ismerv_sor, "N/A", "N/A", "N/A");
                                }
                           } else {
                            $reszletezMatch = true;

                                array_push($ismerv_sor, "N/A", "N/A", "N/A");
                            }
                        }

                        if ($reszletezMatch) {
                            if (($params["csatorna_kulon"] == "true" || $params["ismerv-tipus_reszletez"] == "true") && count(array_unique($ismerv_sor)) <= 2 && array_unique($ismerv_sor)[1] === "N/A") continue;
                            array_push($ismervTable, $ismerv_sor);
                        }
                    }


                    
                

                    $activeWorksheet->fromArray(
                        $ismervTable,  // The data to set
                        NULL,        // Array values with this value will not be set
                        'A' . ((11 + $tableRows) +2),        // Top left coordinate of the worksheet range where
                        true          //    we want to set these values (default is A1)
                    );

                    $activeWorksheet->getStyle(('B' . ((11 + $tableRows) +2)) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +2))->applyFromArray($styleArrayCenter);
                    $activeWorksheet->getStyle(('A' . ((11 + $tableRows) +2)))->applyFromArray($styleArray);
                    
                    $activeWorksheet->getStyle(('A' . (((11 + $tableRows) +2) + count($ismervTable) -1)) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +2 + count($ismervTable) -1) )->applyFromArray($styleArray2);
                    $activeWorksheet->getStyle(('B' . ((11 + $tableRows) +2)) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +2 + count($ismervTable) -1))->applyFromArray($styleArrayBodyRight);

                    
                    $tableRows += count($ismervTable) +2;

                        // ISMERV TABLE VEGE
                        if ($params["ismerv-tipus_kulon"] == "true") {
                            if ($params["csatorna_kulon"] == "true") {
                                $activeWorksheet->setCellValue('B4', $eszkozok[$eszkoz_idk[$csatornaIndex]]);
                            }
                            $writer = new Xlsx($spreadsheet);
                            $timestamp = (strpos($params["idopont_tol"], "1999") !== false  ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];

                            $filename = 'kikuldesi'.$params["partner_nev"].$timestamp.$upperLevel_ismerv_ertekek[$upperLevelIndex] . ($params["csatorna_kulon"] == "true" ? '-'.$eszkozok[$eszkoz_idk[$csatornaIndex]] : "").'.xlsx';
                            $writer->save($filename);
                            array_push($filenames, $filename);
                            $tableRows = 0;
                            $activeWorksheet->removeRow(10, 500);
                        }
                    }
                    
                    $upperLevel_ismerv_ertekek = $ismerv_ertekek;
                    
                    
                }
                // CSATORNA VÉGE
                if ($params["csatorna_kulon"] == "true" && $params["ismerv-tipus_kulon"] != "true") {
                    $activeWorksheet->setCellValue('B4', $eszkozok[$eszkoz_idk[$csatornaIndex]]);
                    $writer = new Xlsx($spreadsheet);
                    $timestamp = (strpos($params["idopont_tol"], "1999") !== false  ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
                    $filename = 'kikuldesi'.$params["partner_nev"].$timestamp.$eszkozok[$eszkoz_idk[$csatornaIndex]].'.xlsx';
                    $writer->save($filename);
                    array_push($filenames, $filename);
                    $tableRows = 0;
                    $activeWorksheet->removeRow(10, 500);
                }
             
        }
   
        // ismerv table end

        
        foreach(range('A','ZZ') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)
                ->setWidth(25, 'pt');;
        }



        $writer = new Xlsx($spreadsheet);
        $timestamp = (strpos($params["idopont_tol"], "1999") !== false ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
        $writer->save('kikuldesi'.$params["partner_nev"].$timestamp.'.xlsx');

        if ($params["csatorna_kulon"] == "true" || $params["ismerv-tipus_kulon"] == "true") {
            $timestamp = (strpos($params["idopont_tol"], "1999") !== false ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
            unlink('kikuldesi'.$params["partner_nev"].$timestamp.'.zip');

            $zip = new \ZipArchive();
            $zipname = 'kikuldesi'.$params["partner_nev"].$timestamp.'.zip';

            if ($zip->open($zipname, \ZipArchive::CREATE) === TRUE) {
                foreach ($filenames as $filename) {
                    if(file_exists($filename)) {
                        $zip->addFile($filename);
                    } else {
                    }
                }
                $zip->close();
                return 'kikuldesi'.$params["partner_nev"].$timestamp.'.zip';
        }
    }

    return 'kikuldesi'.$params["partner_nev"].$timestamp.'.xlsx';
}

    private function strArrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '("' . implode('","', $arr) . '")';
    }

    private function numToChar($n) {
        $alphabet = range('A', 'Z');
        $result = '';
    
        do {
            $remainder = $n % 26;
            $result = $alphabet[$remainder] . $result;
            $n = intval($n / 26) - 1;
        } while ($n >= 0);
    
        return $result;
    }
}