<?php

    namespace A;

    use EE_API_URL;
    use EE_API_KEY;

    use ElasticEmailClient\ElasticClient;
    use ElasticEmailClient\ApiConfiguration;

    class kikuldes_stat extends \GI\Ajax
    {
        public $rights_required = [
            'tomeges_kikuldes'
        ];

        public $parameters = [
            'beolvasas_id' => 'ex-beolvasas-id'
        ];

        public function ajax($params)
        {
            global $g;

            $response = $this->callCurl(
                EE_API_URL . 'channel/list?apiKey=' . EE_API_KEY . '&search=' . 'ceedback-' . $g['srv'] . '-' . $params['beolvasas_id'] . '_'
            );

            if ($response === false) {
                return ['HI', 'no_stat'];
            }

            $response = json_decode($response, true);

            if (empty($response['data'])) {
                return ['HI', 'no_stat'];
            }

            return $response['data'][0];            
        }

        public function callCurl($url)
        {
            $ch = curl_init();
          
            curl_setopt($ch, CURLOPT_AUTOREFERER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); 
          
            $data = curl_exec($ch);
            curl_close($ch);
          
            return $data;
        }
    }
