<?php
    namespace A;

    use EE_API_URL;
    use EE_API_KEY;
    use EE_FROM;
    use EE_FROM_NAME;

    use ElasticEmailClient\ElasticClient;
    use ElasticEmailClient\ApiConfiguration;

    class kikuldes extends \GI\Ajax
    {
        public $rights_required = [
            'tomeges_kikuldes'
        ];

        public $parameters = [
            'beolvasas_id' => 'ex-beolvasas-id'
        ];

        public function ajax($params)
        {
            global $g;

            require_once GI_PATH_SITE_AJAX . 'email_sablonok_elonezet.php';

            $beolvasasId = $params['beolvasas_id'];

            $beolv = $g['db_db']->get_beolvasas(
                $params['beolvasas_id']
            )[0];

            if (!is_null($beolv['kikuldve'])) {
                return ['HI', 'mar_kikuldve'];
            }

            if (empty($beolv['fk_email_sablonok'])) {
                return ['HI', 'nincs_sablon'];
            }

            $eszkoz = $g['db_db']->get_beolvasas_eszkoz(
                $params['beolvasas_id']
            );

            if (empty($eszkoz)) {
                return ['HI', 'nincs_eszkoz'];
            }

            $eszkoz = $eszkoz[0];

            if ($eszkoz['online'] === '0') {
                return ['HI', 'nem_online'];
            }

            $beolvasasSorok = $g['db_db']->beolvasas_sorok_sel(
                $params['beolvasas_id']
            );

            $kuldoNevEsEmail = $g['db_db']->get_kuldo_adat_of_partner_beolvasas(
                $params['beolvasas_id']
            )[0]; 
       
            $emailSablon = $g['db_db']->email_sablon_sel_id(
                $beolv['fk_email_sablonok']
            )[0];

            $client;
            if ($emailSablon['sablon_tipus'] == 'EMAIL') {

                // create channel
                $configuration = new ApiConfiguration([
                    'apiUrl' => EE_API_URL,
                    'apiKey' => EE_API_KEY
                ]);
                $configuration->setTimeout(5.0);

                $client = new ElasticClient($configuration);

                $dateToday = date('Y-m-d');

                $tryNum = 0;
                do {
                    try {
                        $client->Channel->Add(
                            $dateToday . '-ceedback-' . $g['srv'] . '-' . $params['beolvasas_id'] . '_'
                        );

                        $retry = false;
                    } catch (\RuntimeException $ex) {
                        $retry = true;
                    }

                    $tryNum++;
                } while ($tryNum < 5 && $retry);

                if ($retry) {
                    return ['HI', 'timeout'];
                }
            }

            if ($emailSablon['sablon_tipus'] == 'SMS') {
                    
                $numbers = [];
                $urls = [];

                foreach ($beolvasasSorok as $row) {
                    $sorId = \GI\Functions::num_encrypt($row['id']);
                    $url = GI_DOMAIN . 'hu/kerdoiv/' . $eszkoz['eszkoz_azonosito'] . '/' . $sorId;

                    $numbers[] = $row['user_email']; // use actual phone field
                    $urls[] = $url;
                }

                    $params = [
                    'to'       => implode(',', $numbers),
                    'from'     => 'Test',
                    'message'  => str_replace('[url]', '[%1%]', $emailSablon['alt_text']),
                    'param1'   => implode('|', $urls),
                    'format'   => 'json',
                ];
                
                if (\UserFunctions::hasGlobalRight($_SESSION['user']['id'], 'sms')) {
                    $token = "iuidwmOTd8ejloo8bcf08FcPkGcxvpK9ozNJ3N22";
                    $response = $this->sms_send($params, $token);
                    $response = json_decode($response);
                    if (isset($response->error)) {
                        return ['HI', 'sms_hiba'];
                    }
                    
                    $g['db_db']->kikuldve_beallitasa(
                        $beolvasasId
                    );
                }
            
            } else {

                foreach ($beolvasasSorok as $sor) {

                    $sorId = \GI\Functions::num_encrypt($sor['id']);
                    $url = GI_DOMAIN . 'hu/kerdoiv/' . $eszkoz['eszkoz_azonosito'] . '/' . $sorId;



                        $emailBody = \A\email_sablonok_elonezet::getEmailBody($beolv['fk_email_sablonok'], $url);
                        $emailBodyAlt = str_replace('[url]', $url, $emailSablon['alt_text']);

                        $tryNum = 0;
                        do {
                            try {
                                $client->Email->Send(
                                    $emailSablon['targy'],
                                    $kuldoNevEsEmail['email_kuldo_email_cime'],
                                    $kuldoNevEsEmail['email_kuldo_neve'],
                                    null,
                                    null,
                                    null,
                                    null,
                                    null,
                                    null,
                                    [
                                        $sor['user_email'],
                                    ],
                                    [],
                                    [],
                                    [],
                                    [],
                                    [],
                                    null,
                                    null,
                                    $dateToday . '-ceedback-' . $g['srv'] . '-' . $params['beolvasas_id'] . '_',
                                    $emailBody,
                                    $emailBodyAlt,
                                    'utf-8',
                                    null,
                                    null,
                                    0,
                                    null,
                                    [],
                                    [],
                                    null,
                                    [],
                                    null,
                                    null,
                                    false,
                                    [],
                                    "true",
                                    "true",
                                    null,
                                    null,
                                    null,
                                    null,
                                    null,
                                    null
                                );

                                $retry = false;
                            } catch (\RuntimeException $ex) {
                                $retry = true;
                            }
                            $tryNum++;
                        } while($tryNum < 10 && $retry);
                    }


                    $g['db_db']->kikuldve_beallitasa(
                        $beolvasasId
                    );
            }
            
            return;
        }

        private function sms_send($params, $token, $backup = false)
        {
            static $content;

            if ($backup == true) {
                $url = 'https://api2.smsapi.com/sms.do';
            } else {
                $url = 'https://api.smsapi.com/sms.do';
            }

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $params);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_HTTPHEADER, array(
                "Authorization: Bearer $token"
            ));

            $content = curl_exec($c);
            $http_status = curl_getinfo($c, CURLINFO_HTTP_CODE);

            if ($http_status != 200 && $backup == false) {
                $backup = true;
                sms_send($params, $token, true);
            }

            /*echo $content;*/

            curl_close($c);
            return $content;
        }
    }