<?php

    namespace A;

    class jelentesek_sel_szurokerdes_szerint extends \GI\Ajax{

        public $rights_required = array(
            'jelentesek_megtekintese'
        );

        public $parameters = array(
            'echo' => 'int',
            'idopont_tol' => 'idopont_o',
            'idopont_ig' => 'idopont',
            'kerdoiv_idk' => 'kerdoiv_id_arr',
            'partner_idk' => 'partner_id_arr',
            'telephely_idk' => 'telephely_id_arr',
            'eszkoz_idk' => 'eszkoz_id_arr',
            'kerdes_id' => 'ex-kerdoivek_kerdesek-id',
            'szurokerdes_id' => 'ex-kerdoivek_kerdesek-id'
        );

        public function ajax($params){

            global $g;

            $kerdoiv_idk = json_decode($params['kerdoiv_idk'], true);
            $partner_idk = json_decode($params['partner_idk'], true);
            $telephely_idk = json_decode($params['telephely_idk'], true);
            $eszkoz_idk = json_decode($params['eszkoz_idk'], true);

            $jelentesek = [];

            $jelentesek = $g['db_db']->jelentesek_sel_szurokerdes_szerint(
                    $params['kerdes_id'],
                    $params['szurokerdes_id'],
                    $params['idopont_ig'],
                    $params['idopont_tol'],
                    $this->arrEmptyToNullToSelect($kerdoiv_idk),
                    $this->arrEmptyToNullToSelect($partner_idk),
                    $this->arrEmptyToNullToSelect($telephely_idk),
                    $this->arrEmptyToNullToSelect($eszkoz_idk),
                    [
                        'kerdoiv_idk' => $this->arrToSelect($kerdoiv_idk),
                        'partner_idk' => $this->arrToSelect($partner_idk),
                        'telephely_idk' => $this->arrToSelect($telephely_idk),
                        'eszkoz_idk' => $this->arrToSelect($eszkoz_idk),
                    ]
                );

            $out = [
                'echo' => $params['echo'],
                'data' => $jelentesek
            ];

            return $out;

        }

        private function arrToSelect(array $arr) {
            return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
        }

        private function varEmptyToNullToSelect($var) {
            return empty($var) ? null : $var;
        }

        private function arrEmptyToNullToSelect(array $arr) {
            return empty($arr) ? null : 1;
        }

    }
