<?php

    namespace A;

    class jelentesek_sel_kikuldes_statisztika extends \GI\Ajax{

        public $rights_required = array(
            'jelentesek_megtekintese'
        );

        public $parameters = array(
            'idopont_tol' => 'idopont',
            'idopont_ig' => 'idopont',
            'partner_id' => 'ex-partnerek-id'
        );

        public function ajax($params){

            global $g;

            $kikuldve = $g['db_db']->kikuldes_darabszam_eszkozonkent_havonta(
                $params['partner_id'],
                $params['idopont_tol'],
                $params['idopont_ig'],
            );

            if (empty($kikuldve)) {
                return ['ures'];
            }

            $eszkozok = array_column($kikuldve, 'eszkoz_id');
             /*jaguarnál többszörös válasz megadás esetén egyszer számolja a beküldést*/
             $bekuldes_f = in_array("530", $eszkozok);
            $eszkozok = '(' . implode(', ', $eszkozok) . ')';

            if($bekuldes_f){
                $bekuldve = $g['db_db']->jelentesek_kitoltesek_szama_havonta_eszkozonkent_felhasznalonkent(
                    $params['idopont_tol'],
                    $params['idopont_ig'],
                    [
                        'eszkoz_idk' => $eszkozok
                    ]
                );
            }else{
                $bekuldve = $g['db_db']->jelentesek_kitoltesek_szama_havonta_eszkozonkent(
            $params['idopont_tol'],
            $params['idopont_ig'],
            [
                'eszkoz_idk' => $eszkozok
            ]
        );

            }

       $bekuldve = array_combine(
                array_map(function ($var) {
                    return $var['ev'] . '-' . $var['ho'] . '-' . $var['eszkoz_id'];
                }, $bekuldve),
                $bekuldve
            );

            foreach ($kikuldve as &$ki) {
                $key = $ki['ev'] . '-' . $ki['ho'] . '-' . $ki['eszkoz_id'];
                if (isset($bekuldve[$key])) {
                    $ki['bekuldve'] = intval($bekuldve[$key]['darab']);
                } else {
                    $ki['bekuldve'] = 0;
                }

                $ki['kikuldve'] = intval($ki['darab']);
                unset($ki['darab']);

                $ki['arany'] = round($ki['bekuldve'] / $ki['kikuldve'] * 100, 1);
            }
            unset($ki);

            return $kikuldve;
        }
    }
