<?php

namespace A;

class jelentesek_sel_ismerv_trend extends \GI\Ajax{

    public $rights_required = array(
        'jelentesek_megtekintese'
    );

    public $parameters = array(
        'echo' => 'int',
        'idopont_tol' => 'idopont_o',
        'idopont_ig' => 'idopont',
        'kerdes_id' => 'ex-kerdoivek_kerdesek-id',
        'beolvasas_idk' => 'beolvasas_id_arr',
        'ismerv_id' => 'ex-ismervek-id',
        'ismerv_ertekek' => 'ismerv_ertekek_arr',
        'trend_tipus' => 'trend_tipus'
    );

    public function ajax($params){

        global $g;

        $ismerv_ertekek = json_decode($params['ismerv_ertekek'], true);
        $beolvasas_idk = json_decode($params['beolvasas_idk'], true);

        if ($params['trend_tipus'] === 'het')
        {
            $tarolt = 'jelentesek_sel_ismerv_trend_het';
        }
        elseif ($params['trend_tipus'] === 'honap')
        {
            $tarolt = 'jelentesek_sel_ismerv_trend_honap';
        }
        elseif ($params['trend_tipus'] === 'negyedev')
        {
            $tarolt = 'jelentesek_sel_ismerv_trend_negyedev';
        }
        elseif ($params['trend_tipus'] === 'ev')
        {
            $tarolt = 'jelentesek_sel_ismerv_trend_ev';
        }

        $jelentesek = $g['db_db']->$tarolt(
            $params['kerdes_id'],
            $params['ismerv_id'],
            $params['idopont_ig'],
            $params['idopont_tol'],
            $this->arrEmptyToNullToSelect($ismerv_ertekek),
            [
                'beolvasas_idk' => $this->strArrToSelect($beolvasas_idk),
                'ismerv_ertekek' => $this->strArrToSelect($ismerv_ertekek)
            ]
        );

        $out = [
            'echo' => $params['echo'],
            'data' => $jelentesek
        ];

        return $out;

    }

    private function arrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
    }

    private function strArrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '("' . implode('","', $arr) . '")';
    }

    private function varEmptyToNullToSelect($var) {
        return empty($var) ? null : $var;
    }

    private function arrEmptyToNullToSelect(array $arr) {
        return empty($arr) ? null : 1;
    }

}
