<?php

    namespace A;

    class figyelesek_sel extends \GI\Ajax
    {
        public $rights_required = [
            'figyelesek_manage'
        ];

        public $parameters = [
            'echo' => 'int'
        ];

        public function ajax($params)
        {
            global $g;

            $kerdoivek = \UserFunctions::kezelheto_entitasok(
                $_SESSION['user']['id'],
                'kerdoiv',
                'figyelesek_manage'
            );

            $kerdoivNevek = array_combine(
                array_column($kerdoivek, 'id'),
                array_column($kerdoivek, 'nev')
            );

            if (empty($kerdoivek)) {
                return [
                    'echo' => $params['echo'],
                    'data' => []
                ];
            }

            $idk = implode(', ', array_column($kerdoivek, 'id'));

            $figyelesek = $g['db_db']->figyelesek_sel(
                [
                    'kerdoiv_idk' => $idk
                ]
            );

            foreach ($figyelesek as $k => $figyeles) {
                $figyelesek[$k]['kerdoiv_nev'] = $kerdoivNevek[$figyeles['fk_kerdoivek']];
            }

            $out = [
                'echo' => $params['echo'],
                'data' => $figyelesek
            ];

            return $out;
        }
    }
