<?php

    namespace A;

    class felhasznalok_global_jog_add extends \GI\Ajax{

        public $rights_required = array(
            'felhasznalok_global_jog_kezelese'
        );

        public $parameters = array(
            'felhasznalo_sn' => 'ex-users-id',
            'jogstruktura' => 'jogstruktura'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'felhasznalo', 'felhasznalok_global_jog_kezelese', $params['felhasznalo_sn'])){
                return ['HI', 'right_error'];
            }

            // ellenorizni hogy a jogstrukturaban jo elemi jogok vannak-e
            $jogstruktura = json_decode($params['jogstruktura'], true);
            foreach ($jogstruktura as $jog) {
                if (!in_array($jog['elemi_jog_kod'], $g['jogok'])) {
                    return ['HI', 'nem_letezo_elemi_jog', $jog['elemi_jog_kod']];
                }

                //ellenorizni hogy van-e ilyen globalis joga a csavonak
                if (
                    $g['db_db']->user_has_global_right($_SESSION['user']['id'], $jog['elemi_jog_kod'])[0]['cnt'] < 1
                ) {
                    return ['HI', 'nincs_ilyen_globalis_jogom', $jog['elemi_jog_kod']];
                }
            }

            // hozzaadasok es torlesek elvegzese
            foreach ($jogstruktura as $jog) {
                if ($jog['hozzaadas']) {
                    $g['db_db']->add_jog_to_felhasznalo($params['felhasznalo_sn'], $jog['elemi_jog_kod'], $_SESSION['user']['id']);
                } else {
                    $g['db_db']->del_jog_from_felhasznalo($params['felhasznalo_sn'], $jog['elemi_jog_kod']);
                    $g['db_db']->del_jog_from_felhasznalo_jogcsoportjai($params['felhasznalo_sn'], $jog['elemi_jog_kod']);
                }
            }

        }

    }
