<?php

    namespace A;

    class eszkozok_new extends \GI\Ajax{

        public $rights_required = array(
            'eszkozok_letrehozasa'
        );

        public $parameters = array(
            'nev' => 'eszkoz_nev',
            'telephely_sn' => 'ex-telephelyek-id',
            'online' => 'boolint'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            $partner = \UserFunctions::getPartnerOfTelephely($params['telephely_sn']);
            $partner_sn = $partner[0]['id'];
            if(!\UserFunctions::kezelheto_entitas_e(
                $_SESSION['user']['id'],
                'partner',
                'eszkozok_letrehozasa',
                $partner_sn
            )){
                return ['HI', 'right_error'];
            }

            do {
                $eszkoz_azonosito = mt_rand(10000, 99999) . '-' . mt_rand(10000, 99999);
            } while(\GI\Functions::validate($eszkoz_azonosito,'nex-eszkozok-eszkoz_azonosito') !== true);

            // eszkoz letrehozas
            $g['db_db']->eszkozok_new(
                $params['nev'],
                $eszkoz_azonosito,
                $params['telephely_sn'],
                $params['online'],
                $_SESSION['user']['id']
            );

            return $eszkoz_azonosito;

        }

    }
