<?php

    namespace A;

    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
    use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

    class eszkozok_import extends \GI\Ajax{

        public $rights_required = array(
            'eszkoz_import'
        );

        public $parameters = array(

        );

        public function ajax($params){

            global $g;

            if (!isset($_FILES['file']['tmp_name'])) {
                return ['HI', 'nincs_fajl'];
            }

            if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
                return ['HI', 'hibas_feltoltes'];
            }

            $filename = $_FILES['file']['tmp_name'];

            $spreadsheet = IOFactory::load($filename);

            $sheet = $spreadsheet->getSheet(0);

            $ujEszkozok = [];
            $i = 2;
            while (!empty($name = $sheet->getCell("A$i")->getValue())) {
                $telephelyName = $sheet->getCell("B$i")->getValue();
                $online = $sheet->getCell("C$i")->getValue();
                $active = $sheet->getCell("D$i")->getValue();
                $ujEszkozok []= [
                    'nev' => $name,
                    'telephely_nev' => $telephelyName,
                    'online' => $online,
                    'active' => $active
                ];
                ++$i;
            }

            $res = [];
            foreach ($ujEszkozok as $k => $eszkoz) {

                do {
                    $eszkoz_azonosito = mt_rand(10000, 99999) . '-' . mt_rand(10000, 99999);
                } while(\GI\Functions::validate($eszkoz_azonosito,'nex-eszkozok-eszkoz_azonosito') !== true);

                try {
                    // eszkoz letrehozas
                    $g['db_db']->import_eszkoz_new(
                        $eszkoz['nev'],
                        $eszkoz_azonosito,
                        $eszkoz['telephely_nev'],
                        $eszkoz['online'],
                        $_SESSION['user']['id'],
                        $eszkoz['active']
                    );
                    $res[$k] = 1;
                } catch (\Exception $ex) {
                    $res[$k] = 0;
                }

            }

            return ['OK', $res];

        }

    }
