<?php

    namespace A;

    class auth_bejelentkezes extends \GI\Ajax{

        public $rights_required = array(

        );

        public $parameters = array(
            'email' => 'email',
			'password' => 'password',
            'captcha' => 'captcha'
        );

        public function ajax($params){

            global $g;

            if (\UserFunctions::hasGlobalOrPartnerRightAfterLogin('login')) {
                return ['HI', 'mar_be_van_jelentkezve'];
            }

            $login = $g['db_db']->check_login_adatok($params['email'],hash('sha512', $params['password']));

            if ($login) {

                if ($login[0]['kitiltva'] === '1') {
                    return ['HI', 'kitiltva'];
                }

                if ($login[0]['probalkozasok_szama'] !== '0') {
                    $g['db_db']->probalkozasok_szama_alap($params['email']);
                }

                if (!\UserFunctions::hasGlobalRight($login[0]['id'], 'login')) {
                    return ['HI', 'missing_rights'];
                }

                $g['db_db']->felhasznalo_naplozas($login[0]['id'],$login[0]['nev'],'1');

                $_SESSION['user'] = [];
                $_SESSION['user']['id'] = $login[0]['id'];
                $_SESSION['user']['nev'] = $login[0]['nev'];

            } else {

                $user = $g['db_db']->get_user_from_email($params['email']);

                if (!$user) {
                    return ['HI', 'hibas_adatok'];
                }

                if ($user[0]['kitiltva'] === '1') {
                    return ['HI', 'kitiltva'];
                }

                $g['db_db']->probalkozasok_szama_novel($params['email']);

                $probalkozasokSzama = $g['db_db']->probalkozasok_szama_sel($params['email'])[0]['probalkozasok_szama'];

                $maxProbalkozasokSzama = (int)$g['db_db']->get_one_rendszerparameter('max_login_probalkozas')[0]['ertek'];

                if ($probalkozasokSzama >= $maxProbalkozasokSzama) {
                    $g['db_db']->user_kitiltasa($params['email']);
                    return ['HI', 'kitiltva'];
                }

                return ['HI', 'hibas_adatok'];
            }
        }
    }
