<?php

	namespace GI;

	class MenuGroup{
	
		private $text;
		private $image;
		private $menuElements;
		private $menuElementGroups;
		
		function __construct($text, $image = '', $link = '', $popup = ''){
			$this->text = $text;
			if(empty($this->image)){
				$this->image = $image;
			}
			else{
				global $time;
				$this->image = \GI\Functions::get_full_url().substr($image,0,strrpos($image,'.')).'_'.$time.strrchr($image,'.');
			}
			$this->link = $link;
			$this->popup = $popup;	
			$this->menuElements = array();
			$this->menuElementGroups = array();
		}
		
		function addMenuElement(MenuElement $menuElement){
			$this->menuElements []= $menuElement;
		}
		
		function addMenuElementGroup(MenuGroup $menuElementGroup){
			$this->menuElementGroups []= $menuElementGroup;
		}
		
		function getMenuGroupArray(){
			$menugroup = array();
			$menugroup['text'] = $this->text;
			$menugroup['image'] = $this->image;
			$menugroup['link'] = $this->link;
			$menugroup['popup'] = $this->popup;
			$menugroup['menuElements'] = array();
			$menugroupnum = 0;
			foreach($this->menuElements as $me){
				if($me->getIsMenuGroup()){
					$menugroup['menuElements'] []= $this->menuElementGroups[$menugroupnum]->getMenuGroupArray();
					$menugroupnum++;
				}
				else{
					$menugroup['menuElements'] []= array(
						'text' => $me->getText(),
						'link' => $me->getLink(),
						'popup' => $me->getPopup(),
						'image' => $me->getImage()
					);
				}
			}
			$menugroup['hasSubMenu'] = false;
			foreach($menugroup['menuElements'] as $me){
				if(isset($me['menuElements'])){
					$menugroup['hasSubMenu'] = true;
					break;
				}
			}
			return $menugroup;
		}
	
	}