<?php
 header("Access-Control-Allow-Origin: *");
 session_set_cookie_params(["SameSite" => "None"]); //none, lax, strict
 session_set_cookie_params(["Secure" => "true"]); //none, lax, strict

    // session elinditasa
    session_start();

    // oldal futtatasanak kezdetenek lementese
    $time = time();

    // rendszerben hasznalt utvonal konstansok letrehozasa
    $dirs_to_create = [
        'GI_PATH_LOGS' => '../logs/',
        'GI_PATH_CACHE' => '../cache/',
        'GI_PATH_GENGINE' => '../gengine3.5/',
        'GI_PATH_SITE' => '../site/',
        'GI_PATH_SITE_AJAX' => '../site/ajax/',
        'GI_PATH_SITE_MODULES' => '../site/modules/',
        'GI_PATH_SITE_IMAGES' => '../site/images/',
        'GI_PATH_INDEX' => '../site/index/',
        'GI_PATH_INDEX_CSS' => '../site/index/css/',
        'GI_PATH_INDEX_JS' => '../site/index/js/',
        'GI_PATH_UTIL' => '../site/util/',
        'GI_PATH_OTHER' => '../site/other/',
        'GI_PATH_OUT' => 'out/',
        'GI_PATH_OUT_JS' => 'out/js/',
        'GI_PATH_OUT_CSS' => 'out/css/',
        'GI_PATH_OUT_IMAGES' => 'out/images/',
        'GI_PATH_INCLUDABLES' => 'includables/',
        'GI_PATH_JSON_SEMA_FAJLOK' => '../site/util/json_schemas/',
        'GI_PATH_WEBSERVICES' => '../site/webservices/'
    ];
    foreach ($dirs_to_create as $const=>$dir) {
        define($const, $dir);
    }

    // require files
    require_once GI_PATH_GENGINE.'gi_functions.php';
    require_once GI_PATH_UTIL.'datatypes.php';
    require_once GI_PATH_UTIL.'userfunctions.php';
    require_once GI_PATH_UTIL.'database.php';
    require_once GI_PATH_GENGINE.'gi_templateengine.php';

    // global variable init
    $g = [];

    // kornyezet beallitasa
    $g['srv'] = trim(file_get_contents(GI_PATH_CACHE.'srv.txt'));

    // config letrehozasa
    $configFile = 'config.php';
    $dbConfigFile = 'db_connections.php';
    $system = trim(file_get_contents(GI_PATH_CACHE.'system.txt'));
    if ($system !== 'ceedback') {
        $configFile = "config_{$system}.php";
        $dbConfigFile = "db_connections_{$system}.php";
    }

    $g['config'] = array_merge_recursive(require_once GI_PATH_UTIL.$configFile, require_once GI_PATH_UTIL.$dbConfigFile);
    foreach ($g['config'][$g['srv']] as $k=>$v) {
        define($k, $v);
    }
    unset($g['config']);

    $date = date('Y-m-d');

    // Set error log file dynamically
    ini_set('error_log', GI_PATH_LOGS . "/error-{$date}.log");

    // Enable error reporting (optional but recommended)
    error_reporting(E_ALL);
    ini_set('log_errors', '1');

    // error reporting beallitasa
   // error_reporting(GI_ERROR_REPORTING);

    // request url lementese
    $g['request_uri'] = $_SERVER['REQUEST_URI'];

    // nem talalt kepek eseten ne toltse be az oldalt
    if (preg_match('/\.\w{3,5}$/', $g['request_uri'])) {
        http_response_code(404);
        exit;
    }

    // a nyelv ignoralasa az urlben
    $modu = explode('/', trim($g['request_uri'], '/'));
    $modu = $modu[1] ?? '';

    // installed torlese dev eseten, ha nem ajax
    if (
        DELETE_INSTALLED_ON_DEV
        && file_exists(GI_PATH_CACHE.'installed.txt')
        && !in_array($modu, ['ajax'])
    ) {
        unlink(GI_PATH_CACHE.'installed.txt');
    }

    // installalas
    require_once GI_PATH_GENGINE.'gi_install.php';

    // GI VERSION meghatarozasa
    define('GI_VERSION', file_get_contents(GI_PATH_CACHE.'installed.txt'));

    // adatbazishoz csatlakozni
    $g['db_db'] = new DataBase('db');

    // nyelv lista lekerdezese
    $g['langs'] = \UserFunctions::get_lang_code_list();

    //webszervizek kezelese
    $webszerviz_nevek = [
        'eszkoz-install',
        'kerdoiv-sel',
        'jelentes-new',
        'email',
        'jelentes-new-online',
        'vezerles-sel',
        'automata'
    ];

    preg_match('#(?:/webszerviz/|/)([-a-z]+)/?#', $g['request_uri'], $matches);
    if (isset($matches[1]) && in_array($matches[1], $webszerviz_nevek)) {
        $wsnev = $matches[1];
        require_once GI_PATH_WEBSERVICES . $matches[1] . '.php';
        exit;
    }
    //webszervizek kezelese vege

    // url feldolgozasa

    // GET parametereket nem nézzük
    $g['request_uri'] = preg_replace('/\?.*$/', '', $g['request_uri']);

    $tmp = explode('/', trim($g['request_uri'], '/'));

    // nyelv lekerdezese
    $g['lang'] = isset($tmp[0]) ? $tmp[0] : '';

    // ha nincs nyelv menjunk a def oldalra a def nyelvvel
    if ($g['lang'] === '') {
        \GI\Functions::go(GI_DEFAULT_MODULE, GI_DEFAULT_LANG);
    }

    // ha nincs ilyen nyelv adatbazisban, szinten menjunk def oldalra def nyelvvel
    if (!in_array($g['lang'], $g['langs'])) {
        \GI\Functions::go(GI_DEFAULT_MODULE, GI_DEFAULT_LANG);
    }

    // modul es parameterek meghatarozasa
    $g['module'] = isset($tmp[1]) ? $tmp[1] : '';
    $g['parameters'] = array_map('urldecode', array_slice($tmp, 2));

    // ha nincs modul meghatarozva
    if (empty($g['module'])) {
        if (GI_LOAD_DEFAULT_WHEN_EMPTY) {
            $g['module'] = GI_DEFAULT_MODULE;
        } else {
            \GI\Functions::go(GI_DEFAULT_MODULE);
        }
    }

    // jogok lekerdezese
    $g['jogok'] = [];
    if (isset($_SESSION['user']['id'])) {
        $global_rights = array_column(
            $g['db_db']->sel_global_rights_of_user($_SESSION['user']['id']),
            'kod'
        );
        $partner_rights = array_column(
            $g['db_db']->sel_partner_rights_of_user($_SESSION['user']['id']),
            'kod'
        );
        $g['jogok'] = array_unique(array_merge($global_rights, $partner_rights));
    }

    // template engine inicializalasa
    $g['te'] = new \GI\TemplateEngine();

    // includables init
    $g['index_includables_js'] = [];
    $g['index_includables_css'] = [];

    // frame index engine
    require_once GI_PATH_INDEX.'/engine.php';

    // ajax
    if ($g['module']==='ajax') {
        require_once GI_PATH_GENGINE.'gi_ajax.php';
        $response = [];
        if (!isset($g['parameters'][0])) {
            $response = ['err','no_param'];
        } elseif (!file_exists(GI_PATH_SITE_AJAX.$g['parameters'][0].'.php')) {
            $response = ['err','no_ajax'];
        } else {
            $response = \GI\Functions::call_ajax($g['parameters'][0], $_POST);
        }
        exit(json_encode($response));
    }

    if (isset($_SESSION['user']['forgotten']) && $_SESSION['user']['forgotten'] && $g['module']!=='jelszo-megadasa') {
        \GI\Functions::go('jelszo-megadasa');
    }

    //if module doesnt exist
    if (!file_exists(GI_PATH_SITE_MODULES.$g['module'])) {
        \GI\Functions::go(GI_DEFAULT_MODULE);
    }

    //load module config
    $g['module_config'] = require_once GI_PATH_SITE_MODULES.$g['module'].'/config.php';

    //module check url parameters
    $tmp = false;
    foreach ($g['module_config']['url_parameters'] as $parameter_possibility) {
        if (count($parameter_possibility)===0 && count($g['parameters'])===0) {
            $tmp = true;
            break;
        }
        if (count($parameter_possibility)!==count($g['parameters'])) {
            continue;
        }
        $tmp = true;
        foreach ($parameter_possibility as $k=>$parameter) {
            if (\GI\Functions::validate($g['parameters'][$k], $parameter)!==true) {
                $tmp = false;
                break;
            }
        }
        if ($tmp) {
            break;
        }
    }

    if (!$tmp) {
        \GI\Functions::go(GI_DEFAULT_MODULE);
    }

    //modul login required
    if (!empty(array_diff($g['module_config']['rights_required'], $g['jogok']))) {
        \GI\Functions::go(GI_DEFAULT_MODULE);
    }

    //add general variables to template engine
    $g['te']->add('srv', $g['srv']);
    $g['te']->add('system', $system);
    

    //add images to template engine
    $tmp = array_diff(scandir(GI_PATH_SITE_MODULES), ['.','..']);
    foreach ($tmp as $mod) {
        $g['te']->add('u.'.$mod, \GI\Functions::get_full_url().$mod.'/');
    }

    //includables -> add path before files
    array_walk($g['index_includables_js'], ['\GI\Functions','includables_fix']);
    array_walk($g['index_includables_css'], ['\GI\Functions','includables_fix']);
    array_walk($g['module_config']['includables_js'], ['\GI\Functions','includables_fix']);
    array_walk($g['module_config']['includables_css'], ['\GI\Functions','includables_fix']);

    //add index css files dinamically to the includable css files
    $tmp = array_diff(scandir(GI_PATH_INDEX_CSS), ['.','..']);
    foreach ($tmp as $csss) {
        $g['index_includables_css'] []= \GI\Functions::get_full_url().GI_PATH_OUT_CSS.'index_'.substr($csss, 0, -4).'_'.$g['lang'].'_'.GI_VERSION.'.css';
    }

    //add index js files dinamically to the includable js files
    $tmp = array_diff(scandir(GI_PATH_INDEX_JS), ['.','..']);
    foreach ($tmp as $jss) {
        $g['index_includables_js'] []= \GI\Functions::get_full_url().GI_PATH_OUT_JS.'index_'.substr($jss, 0, -3).'_'.$g['lang'].'_'.GI_VERSION.'.js';
    }

    //add variables to template engine
    $g['te']->add('f.module_script', \GI\Functions::get_full_url().GI_PATH_OUT_JS.$g['module'].'_'.$g['lang'].'_'.GI_VERSION.'.js');
    $g['te']->add('f.module_style', \GI\Functions::get_full_url().GI_PATH_OUT_CSS.$g['module'].'_'.$g['lang'].'_'.GI_VERSION.'.css');
    $g['te']->add('index_includables_css', $g['index_includables_css']);
    $g['te']->add('index_includables_js', $g['index_includables_js']);
    $g['te']->add('module_includables_css', $g['module_config']['includables_css']);
    $g['te']->add('module_includables_js', $g['module_config']['includables_js']);

    //domain odaadasa a kliens oldalnak
    $g['te']->add('act_version', GI_VERSION);
    $g['te']->add('act_domain', \GI\Functions::get_full_url());
    $g['te']->add('u.act_domain', \GI\Functions::get_full_url());
    //act_lang
    $g['te']->add('act_lang', $g['lang']);
    //alapertelmezett nyelv odaadasa
    $g['te']->add('default_lang', GI_DEFAULT_LANG);
    //nyelvek odaadasa
    $g['te']->add('act_module', $g['module']);
    //rendszer GA Tracking ID atadasa
    $g['te']->add('ga_tracking_id', GI_GA_TRACKING_ID);

    //add images to template engine
    $tmp = array_diff(scandir(GI_PATH_OUT_IMAGES), ['.','..']);
    foreach ($tmp as $pic) {
        $pic_without_time = substr($pic, 0, strrpos($pic, '_')).strrchr($pic, '.');
        $g['te']->add('p.'.$pic_without_time, \GI\Functions::get_full_url().GI_PATH_OUT_IMAGES.$pic);
    }

    $g['te']->add('loadtime', (string)microtime(true)-$time);

    //module engine
    require_once GI_PATH_SITE_MODULES.$g['module'].'/engine.php';

    //module script php
    ob_start();
    require_once GI_PATH_SITE_MODULES.$g['module'].'/script.php.js';
    $module_script_php = $g['te']->render(ob_get_clean(), substr($g['srv'], 0, 3)!=='dev' || GI_FORCE_MINIFY);

    //index script php
    ob_start();
    require_once GI_PATH_INDEX.'script.php.js';
    $index_script_php = $g['te']->render(ob_get_clean(), substr($g['srv'], 0, 3)!=='dev' || GI_FORCE_MINIFY);
    $g['te']->add('f.index_script_php', $index_script_php);

    $g['te']->add('f.module_script_php', $module_script_php);

    //install
    require_once GI_PATH_GENGINE.'gi_cache.php';

    require_once GI_PATH_CACHE.'cache_'.$g['module'].'_'.$g['lang'].'_'.GI_VERSION.'.php';