<?php

    namespace GI;

    abstract class Ajax{

        public $parameters;

        public function validate_parameters($params){
            $response = array('err'=>array());
            foreach($this->parameters as $param=>$datatype){
                if (substr($datatype, -4) == '_cbe') {
					if (isset($params[$param]) && $params[$param] === '') {
						continue;
					} else {
						$datatype = substr($datatype, 0, -4);
					}
				}
				if(!array_key_exists($param,$params)){
                    $response['err'][]= array('field' => $param, 'msg' => 'no_param');
                    continue;
                }
                else{
					$check = \GI\Functions::validate($params[$param],$datatype);
                    if($check !== true){
                        $response['err'][]= array('field' => $param, 'msg' => $check);
                        continue;
                    }
                }
            }
            if(empty($response['err'])){
                $response = true;
            }
            return $response;
        }

        abstract public function ajax($params);

    }
